/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.badlogic.gdx.graphics.Color;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.game.phase.PhaseType;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.util.TextBounds;
import forge.util.Utils;
import java.util.HashMap;
import java.util.Map;

public class VPhaseIndicator
extends FContainer {
    public static final FSkinFont BASE_FONT = FSkinFont.get(11);
    public static final float PADDING_X = Utils.scale(1.0f);
    public static final float PADDING_Y = Utils.scale(2.0f);
    private final Map<PhaseType, PhaseLabel> phaseLabels = new HashMap<PhaseType, PhaseLabel>();
    private FSkinFont font;

    public VPhaseIndicator() {
        this.addPhaseLabel("UP", PhaseType.UPKEEP);
        this.addPhaseLabel("DR", PhaseType.DRAW);
        this.addPhaseLabel("M1", PhaseType.MAIN1);
        this.addPhaseLabel("BC", PhaseType.COMBAT_BEGIN);
        this.addPhaseLabel("DA", PhaseType.COMBAT_DECLARE_ATTACKERS);
        this.addPhaseLabel("DB", PhaseType.COMBAT_DECLARE_BLOCKERS);
        this.addPhaseLabel("FS", PhaseType.COMBAT_FIRST_STRIKE_DAMAGE);
        this.addPhaseLabel("CD", PhaseType.COMBAT_DAMAGE);
        this.addPhaseLabel("EC", PhaseType.COMBAT_END);
        this.addPhaseLabel("M2", PhaseType.MAIN2);
        this.addPhaseLabel("ET", PhaseType.END_OF_TURN);
        this.addPhaseLabel("CL", PhaseType.CLEANUP);
    }

    private void addPhaseLabel(String caption, PhaseType phaseType) {
        this.phaseLabels.put(phaseType, this.add(new PhaseLabel(caption, phaseType)));
    }

    public PhaseLabel getLabel(PhaseType phaseType) {
        return this.phaseLabels.get((Object)phaseType);
    }

    public void resetPhaseButtons() {
        for (PhaseLabel lbl : this.phaseLabels.values()) {
            lbl.setActive(false);
        }
    }

    public void resetFont() {
        this.font = BASE_FONT;
    }

    public float getPreferredHeight(float width) {
        float w = width / (float)this.phaseLabels.size();
        this.resetFont();
        return this._getPreferredHeight(w -= 2.0f * PADDING_X);
    }

    private float _getPreferredHeight(float w) {
        TextBounds bounds = null;
        for (PhaseLabel lbl : this.phaseLabels.values()) {
            bounds = this.font.getBounds(lbl.caption);
            if (!(bounds.width > w)) continue;
            if (!this.font.canShrink()) break;
            this.font = this.font.shrink();
            return this._getPreferredHeight(w);
        }
        return bounds.height + 2.0f * PADDING_Y;
    }

    @Override
    protected void doLayout(float width, float height) {
        if (width > height) {
            float x = 0.0f;
            float w = width / (float)this.phaseLabels.size();
            float h2 = height;
            for (FDisplayObject lbl : this.getChildren()) {
                lbl.setBounds(x, 0.0f, w, h2);
                x += w;
            }
        } else {
            float padding = Utils.scale(1.0f);
            float y = 0.0f;
            float w = width - 2.0f * padding;
            float h3 = height / (float)this.phaseLabels.size();
            for (FDisplayObject lbl : this.getChildren()) {
                lbl.setBounds(padding, y + padding, w, h3 - 2.0f * padding);
                y += h3;
            }
        }
    }

    public class PhaseLabel
    extends FDisplayObject {
        private final String caption;
        private final PhaseType phaseType;
        private boolean stopAtPhase = false;
        private boolean active = false;

        public PhaseLabel(String caption0, PhaseType phaseType0) {
            this.caption = caption0;
            this.phaseType = phaseType0;
        }

        public boolean getActive() {
            return this.active;
        }

        public void setActive(boolean active0) {
            this.active = active0;
        }

        public PhaseType getPhaseType() {
            return this.phaseType;
        }

        public boolean getStopAtPhase() {
            return this.stopAtPhase;
        }

        public void setStopAtPhase(boolean stopAtPhase0) {
            this.stopAtPhase = stopAtPhase0;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            this.stopAtPhase = !this.stopAtPhase;
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            float x = PADDING_X;
            float w = this.getWidth() - 2.0f * PADDING_X;
            float h2 = this.getHeight();
            FSkinColor backColor = this.active && this.stopAtPhase ? (Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_PHASE_ACTIVE_ENABLED) : FSkinColor.get(FSkinColor.Colors.CLR_PHASE_ACTIVE_ENABLED)) : (!this.active && this.stopAtPhase ? (Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_PHASE_INACTIVE_ENABLED) : FSkinColor.get(FSkinColor.Colors.CLR_PHASE_INACTIVE_ENABLED)) : (this.active && !this.stopAtPhase ? (Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_PHASE_ACTIVE_DISABLED) : FSkinColor.get(FSkinColor.Colors.CLR_PHASE_ACTIVE_DISABLED)) : (Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_PHASE_INACTIVE_DISABLED) : FSkinColor.get(FSkinColor.Colors.CLR_PHASE_INACTIVE_DISABLED))));
            g2.fillRect(this.isHovered() ? backColor.brighter() : backColor, x, 0.0f, w, h2);
            g2.drawText(this.caption, this.isHovered() && VPhaseIndicator.this.font.canIncrease() ? VPhaseIndicator.this.font.increase() : VPhaseIndicator.this.font, Color.BLACK, x, 0.0f, w, h2, false, 1, true);
        }
    }
}

