/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FDropDown;
import forge.model.FModel;
import forge.screens.match.MatchController;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.util.Utils;
import java.util.List;

public class VLog
extends FDropDown {
    private static final float PADDING = Utils.scale(5.0f);
    private static final FSkinFont FONT = FSkinFont.get(11);

    private static FSkinColor getAltRowColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ZEBRA);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ZEBRA);
    }

    private static FSkinColor getRowColor() {
        return VLog.getAltRowColor().darker();
    }

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    @Override
    protected boolean autoHide() {
        return true;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.fillRect(VLog.getRowColor(), 0.0f, 0.0f, w, h2);
    }

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        this.clear();
        GameLogEntryType logVerbosityFilter = GameLogEntryType.valueOf(FModel.getPreferences().getPref(ForgePreferences.FPref.DEV_LOG_ENTRY_TYPE));
        List<GameLogEntry> logEntrys = MatchController.instance.getGameView().getGameLog().getLogEntries(logVerbosityFilter);
        float width = maxWidth - this.getMenuTab().screenPos.x;
        float minWidth = 4.0f * Utils.AVG_FINGER_WIDTH;
        if (width < minWidth) {
            width = minWidth;
        }
        float y = 1.0f;
        if (logEntrys.isEmpty()) {
            LogEntryDisplay logEntryDisplay = this.add(new LogEntryDisplay("[Empty]", false));
            float height = logEntryDisplay.getMinHeight(width);
            logEntryDisplay.setBounds(0.0f, y, width, height);
            y += height;
        } else {
            boolean isAltRow = false;
            for (int i = logEntrys.size() - 1; i >= 0; --i) {
                LogEntryDisplay logEntryDisplay = this.add(new LogEntryDisplay(logEntrys.get((int)i).message, isAltRow));
                float height = logEntryDisplay.getMinHeight(width);
                logEntryDisplay.setBounds(0.0f, y, width, height);
                isAltRow = !isAltRow;
                y += height;
            }
        }
        return new FScrollPane.ScrollBounds(width, y + 1.0f);
    }

    @Override
    protected void setScrollPositionsAfterLayout(float scrollLeft0, float scrollTop0) {
        super.setScrollPositionsAfterLayout(0.0f, this.getMaxScrollTop());
    }

    private class LogEntryDisplay
    extends FDisplayObject {
        private final String text;
        private final boolean isAltRow;
        private final TextRenderer renderer = new TextRenderer(true);

        private LogEntryDisplay(String text0, boolean isAltRow0) {
            this.text = text0;
            this.isAltRow = isAltRow0;
        }

        private float getMinHeight(float width) {
            float height = this.renderer.getWrappedBounds((String)this.text, (FSkinFont)FONT, (float)(width -= 2.0f * PADDING)).height;
            return Math.round(height += 2.0f * PADDING);
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            if (this.isAltRow) {
                g2.fillRect(VLog.getAltRowColor(), 0.0f, 0.0f, w, h2);
            }
            this.renderer.drawText(g2, this.text, FONT, VLog.getForeColor(), PADDING, PADDING, w - 2.0f * PADDING, h2, 0.0f, h2, true, 8, false);
        }
    }
}

