/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.screens.match.MatchScreen;
import forge.screens.match.views.VCardDisplayArea;
import forge.screens.match.views.VManaPool;
import forge.toolbox.FCardPanel;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import java.util.Arrays;

public abstract class VDisplayArea
extends FScrollPane {
    private FDisplayObject selectedChild;
    private int selectedIndex = -1;

    public VDisplayArea() {
        this.setVisible(false);
    }

    public abstract int getCount();

    public abstract void update();

    public void setNextSelected(int val) {
        if (this.getChildCount() < 1) {
            this.selectedIndex = -1;
            return;
        }
        if (this.selectedIndex == -1) {
            ++this.selectedIndex;
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(false);
            }
            this.selectedChild = this.getChildAt(this.selectedIndex);
            this.selectedChild.setHovered(true);
            this.scrollIntoView(this.selectedChild);
            MatchScreen.setPotentialListener(Arrays.asList(this.selectedChild));
            return;
        }
        if (this.selectedIndex + val < this.getChildCount()) {
            this.selectedIndex += val;
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(false);
            }
            this.selectedChild = this.getChildAt(this.selectedIndex);
            this.selectedChild.setHovered(true);
            this.scrollIntoView(this.selectedChild);
            MatchScreen.setPotentialListener(Arrays.asList(this.selectedChild));
        }
    }

    public void setPreviousSelected(int val) {
        if (this.getChildCount() < 1) {
            this.selectedIndex = -1;
            return;
        }
        if (this.selectedIndex - val > -1) {
            this.selectedIndex -= val;
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(false);
            }
            this.selectedChild = this.getChildAt(this.selectedIndex);
            this.selectedChild.setHovered(true);
            this.scrollIntoView(this.selectedChild);
            MatchScreen.setPotentialListener(Arrays.asList(this.selectedChild));
        }
    }

    public void tapChild() {
        if (this.selectedChild instanceof FCardPanel) {
            VCardDisplayArea.CardAreaPanel.get(((FCardPanel)this.selectedChild).getCard()).selectCard(false);
        } else if (this.selectedChild instanceof VManaPool.ManaLabel) {
            ((VManaPool.ManaLabel)this.selectedChild).activate();
        }
    }

    public void showZoom() {
        if (this.selectedChild instanceof FCardPanel) {
            VCardDisplayArea.CardAreaPanel.get(((FCardPanel)this.selectedChild).getCard()).showZoom();
        }
    }
}

