/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.game.card.CardView;
import forge.game.zone.ZoneType;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.screens.match.MatchController;
import forge.screens.match.views.VDisplayArea;
import forge.toolbox.FCardPanel;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.util.ThreadUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VCardDisplayArea
extends VDisplayArea
implements CardZoom.ActivateHandler {
    private static final float CARD_STACK_OFFSET = 0.2f;
    protected final List<CardView> orderedCards = new ArrayList<CardView>();
    protected final List<CardAreaPanel> cardPanels = new ArrayList<CardAreaPanel>();
    private boolean rotateCards180;

    public Iterable<CardView> getOrderedCards() {
        return this.orderedCards;
    }

    public Iterable<CardAreaPanel> getCardPanels() {
        return this.cardPanels;
    }

    @Override
    public int getCount() {
        return this.cardPanels.size();
    }

    @Override
    public void setRotate180(boolean b0) {
        this.rotateCards180 = b0;
    }

    protected void refreshCardPanels(Iterable<CardView> model) {
        this.clear();
        CardAreaPanel newCardPanel = null;
        if (model != null) {
            for (CardView card : model) {
                CardAreaPanel cardPanel = CardAreaPanel.get(card);
                this.addCardPanelToDisplayArea(cardPanel);
                this.cardPanels.add(cardPanel);
                if (newCardPanel != null || this.orderedCards.contains(card)) continue;
                newCardPanel = cardPanel;
            }
        }
        if (this.isVisible()) {
            this.revalidate();
            if (newCardPanel != null) {
                this.scrollIntoView(newCardPanel);
            }
        }
    }

    @Override
    public void setVisible(boolean b0) {
        if (this.isVisible() == b0) {
            return;
        }
        super.setVisible(b0);
        if (b0) {
            for (CardAreaPanel pnl : this.cardPanels) {
                pnl.displayArea = this;
            }
            this.revalidate();
        }
    }

    private void addCardPanelToDisplayArea(CardAreaPanel cardPanel) {
        do {
            List<CardAreaPanel> attachedPanels;
            if (!(attachedPanels = cardPanel.getAttachedPanels()).isEmpty()) {
                for (int i = attachedPanels.size() - 1; i >= 0; --i) {
                    this.addCardPanelToDisplayArea(attachedPanels.get(i));
                }
            }
            if (this.isVisible()) {
                cardPanel.displayArea = this;
            }
            this.add(cardPanel);
        } while ((cardPanel = cardPanel.getNextPanelInStack()) != null);
    }

    public final void removeCardPanel(CardAreaPanel fromPanel) {
        FThreads.assertExecutedByEdt(true);
        this.cardPanels.remove(fromPanel);
        this.remove(fromPanel);
    }

    protected void clearChildren() {
        super.clear();
    }

    @Override
    public void clear() {
        super.clear();
        if (!this.cardPanels.isEmpty()) {
            for (CardAreaPanel panel : this.cardPanels) {
                if (panel.displayArea != null && panel.displayArea != this && ((CardAreaPanel)panel).displayArea.cardPanels.contains(panel)) continue;
                panel.reset();
            }
            this.cardPanels.clear();
        }
    }

    private int addCards(CardAreaPanel cardPanel, float x, float y, float cardWidth, float cardHeight) {
        int totalCount = 0;
        List<CardAreaPanel> attachedPanels = cardPanel.getAttachedPanels();
        if (!attachedPanels.isEmpty()) {
            for (int i = attachedPanels.size() - 1; i >= 0; --i) {
                int count = this.addCards(attachedPanels.get(i), x, y, cardWidth, cardHeight);
                x += (float)count * cardWidth * 0.2f;
                totalCount += count;
            }
        }
        this.orderedCards.add(cardPanel.getCard());
        cardPanel.setBounds(x, y, cardWidth, cardHeight);
        if (cardPanel.getNextPanelInStack() != null) {
            totalCount += this.addCards(cardPanel.getNextPanelInStack(), x += cardWidth * 0.2f, y, cardWidth, cardHeight);
        }
        return totalCount + 1;
    }

    protected float getCardWidth(float cardHeight) {
        return (cardHeight - 2.0f * FCardPanel.PADDING) / 1.4f + 2.0f * FCardPanel.PADDING;
    }

    protected float getCardHeight(float cardWidth) {
        return (cardWidth - 2.0f * FCardPanel.PADDING) * 1.4f + 2.0f * FCardPanel.PADDING;
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        this.orderedCards.clear();
        float x = 0.0f;
        float y = 0.0f;
        float cardHeight = visibleHeight;
        float cardWidth = this.getCardWidth(cardHeight);
        for (CardAreaPanel cardPanel : this.cardPanels) {
            int count = this.addCards(cardPanel, x, y, cardWidth, cardHeight);
            x += cardWidth + (float)(count - 1) * cardWidth * 0.2f;
        }
        return new FScrollPane.ScrollBounds(x, visibleHeight);
    }

    @Override
    protected void startClip(Graphics g2) {
        float h2 = this.getHeight();
        g2.startClip(0.0f, -h2, this.getWidth(), 3.0f * h2);
    }

    @Override
    public String getActivateAction(int index) {
        if (!GuiBase.isNetworkplay()) {
            return MatchController.instance.getGameController().getActivateDescription(this.orderedCards.get(index));
        }
        return "Activate | Cast | Play (if allowed)";
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < this.orderedCards.size()) {
            CardAreaPanel cardPanel = CardAreaPanel.get(this.orderedCards.get(index));
            this.scrollIntoView(cardPanel);
        }
    }

    @Override
    public void activate(int index) {
        CardAreaPanel cardPanel = CardAreaPanel.get(this.orderedCards.get(index));
        ThreadUtil.invokeInGameThread(() -> cardPanel.selectCard(false));
    }

    public static class CardAreaPanel
    extends FCardPanel {
        private static final Map<Integer, CardAreaPanel> allCardPanels = new HashMap<Integer, CardAreaPanel>();
        private VCardDisplayArea displayArea;
        private CardAreaPanel attachedToPanel;
        private final List<CardAreaPanel> attachedPanels = new ArrayList<CardAreaPanel>();
        private CardAreaPanel nextPanelInStack;
        private CardAreaPanel prevPanelInStack;

        public static CardAreaPanel get(CardView card0) {
            CardAreaPanel cardPanel = allCardPanels.get(card0.getId());
            if (cardPanel == null || cardPanel.getCard() != card0) {
                cardPanel = new CardAreaPanel(card0);
                allCardPanels.put(card0.getId(), cardPanel);
            }
            return cardPanel;
        }

        public static void resetForNewGame() {
            for (CardAreaPanel cardPanel : allCardPanels.values()) {
                cardPanel.displayArea = null;
                cardPanel.attachedToPanel = null;
                cardPanel.attachedPanels.clear();
                cardPanel.prevPanelInStack = null;
                cardPanel.nextPanelInStack = null;
            }
            allCardPanels.clear();
        }

        private CardAreaPanel(CardView card0) {
            super(card0);
        }

        public VCardDisplayArea getDisplayArea() {
            return this.displayArea;
        }

        public CardAreaPanel getAttachedToPanel() {
            return this.attachedToPanel;
        }

        public void setAttachedToPanel(CardAreaPanel attachedToPanel0) {
            this.attachedToPanel = attachedToPanel0;
        }

        public List<CardAreaPanel> getAttachedPanels() {
            return this.attachedPanels;
        }

        public CardAreaPanel getNextPanelInStack() {
            return this.nextPanelInStack;
        }

        public void setNextPanelInStack(CardAreaPanel nextPanelInStack0) {
            this.nextPanelInStack = nextPanelInStack0;
        }

        public CardAreaPanel getPrevPanelInStack() {
            return this.prevPanelInStack;
        }

        public void setPrevPanelInStack(CardAreaPanel prevPanelInStack0) {
            this.prevPanelInStack = prevPanelInStack0;
        }

        @Override
        protected CardRenderer.CardStackPosition getStackPosition() {
            if (this.nextPanelInStack == null && this.attachedToPanel == null) {
                return CardRenderer.CardStackPosition.Top;
            }
            if (this.isTapped()) {
                return CardRenderer.CardStackPosition.Top;
            }
            return CardRenderer.CardStackPosition.BehindHorz;
        }

        public void updateCard(CardView card) {
            this.setTapped(card.isTapped());
            this.attachedPanels.clear();
            if (card.hasAnyCardAttachments()) {
                Iterable<CardView> enchants = card.getAllAttachedCards();
                for (CardView e : enchants) {
                    CardAreaPanel cardE = CardAreaPanel.get(e);
                    if (cardE == null) continue;
                    this.attachedPanels.add(cardE);
                }
            }
            if (card.getAttachedTo() != null) {
                if (card != card.getAttachedTo().getAttachedTo()) {
                    this.setAttachedToPanel(CardAreaPanel.get(card.getAttachedTo()));
                } else {
                    this.attachedPanels.remove(CardAreaPanel.get(card.getAttachedTo()));
                    this.setAttachedToPanel(null);
                }
            } else {
                this.setAttachedToPanel(null);
            }
        }

        public void reset() {
            if (!this.attachedPanels.isEmpty()) {
                this.attachedPanels.clear();
            }
            if (this.nextPanelInStack != null) {
                this.nextPanelInStack.reset();
                this.nextPanelInStack = null;
            }
            this.attachedToPanel = null;
            this.prevPanelInStack = null;
            this.displayArea = null;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (count > 1) {
                return false;
            }
            if (this.renderedCardContains(x, y)) {
                ThreadUtil.invokeInGameThread(() -> {
                    if (GuiBase.getInterface().isRunningOnDesktop() && Forge.mouseButtonID == 1) {
                        FThreads.invokeInEdtLater(this::showZoom);
                    } else if (!this.selectCard(false)) {
                        FThreads.invokeInEdtLater(this::showZoom);
                    }
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean flick(float x, float y) {
            if (this.renderedCardContains(x, y)) {
                ThreadUtil.invokeInGameThread(() -> this.selectCard(true));
                return true;
            }
            return false;
        }

        public boolean selectCard(boolean selectEntireStack) {
            if (!this.getCard().getController().equals(MatchController.instance.getCurrentPlayer()) && ZoneType.Hand.equals((Object)this.getCard().getZone())) {
                if (this.getCard().mayPlayerLook(MatchController.instance.getCurrentPlayer())) {
                    if (!this.getCard().getMayPlayPlayers(MatchController.instance.getCurrentPlayer())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (MatchController.instance.getGameController().selectCard(this.getCard(), this.getOtherCardsToSelect(selectEntireStack), null)) {
                Gdx.graphics.requestRendering();
                return true;
            }
            if (this.prevPanelInStack != null && this.prevPanelInStack.selectCard(selectEntireStack)) {
                Gdx.graphics.requestRendering();
                return true;
            }
            for (CardAreaPanel panel : this.attachedPanels) {
                if (!panel.selectCard(selectEntireStack)) continue;
                Gdx.graphics.requestRendering();
                return true;
            }
            return false;
        }

        @Override
        public boolean longPress(float x, float y) {
            if (this.renderedCardContains(x, y)) {
                this.showZoom();
                return true;
            }
            return false;
        }

        public void showZoom() {
            if (this.displayArea == null) {
                return;
            }
            List<CardView> cards = this.displayArea.orderedCards;
            CardZoom.show(cards, cards.indexOf(this.getCard()), (CardZoom.ActivateHandler)this.displayArea);
        }

        public void buildCardPanelList(List<? super FCardPanel> list) {
            if (!this.attachedPanels.isEmpty()) {
                for (int i = this.attachedPanels.size() - 1; i >= 0; --i) {
                    this.attachedPanels.get(i).buildCardPanelList(list);
                }
            }
            list.add(this);
            if (this.nextPanelInStack != null) {
                this.nextPanelInStack.buildCardPanelList(list);
            }
        }

        private List<CardView> getOtherCardsToSelect(boolean selectOtherCardsInStack) {
            if (!selectOtherCardsInStack) {
                return null;
            }
            if (this.prevPanelInStack == null && this.nextPanelInStack == null) {
                return null;
            }
            ArrayList<CardView> cards = new ArrayList<CardView>();
            CardAreaPanel panel = this.nextPanelInStack;
            while (panel != null) {
                cards.add(panel.getCard());
                panel = panel.nextPanelInStack;
            }
            panel = this.prevPanelInStack;
            while (panel != null) {
                cards.add(panel.getCard());
                panel = panel.prevPanelInStack;
            }
            return cards;
        }

        public static Vector2 getTargetingArrowOrigin(FDisplayObject cardDisplay, boolean isTapped) {
            float h2;
            Vector2 origin = new Vector2(cardDisplay.screenPos.x, cardDisplay.screenPos.y);
            float left = PADDING;
            float top = PADDING;
            float w = cardDisplay.getWidth() - 2.0f * PADDING;
            if (w == (h2 = cardDisplay.getHeight() - 2.0f * PADDING)) {
                w = h2 / 1.4f;
            }
            if (isTapped) {
                top += h2 - w;
                float temp = w;
                w = h2;
                h2 = temp;
            }
            origin.x += left + w * 0.15f;
            origin.y += top + h2 * 0.5f;
            return origin;
        }

        public Vector2 getTargetingArrowOrigin() {
            if (this.displayArea == null || !this.displayArea.isVisible()) {
                return null;
            }
            return CardAreaPanel.getTargetingArrowOrigin(this, this.isTapped());
        }

        @Override
        protected float getTappedAngle() {
            if (this.displayArea != null && this.displayArea.rotateCards180) {
                return -super.getTappedAngle();
            }
            return super.getTappedAngle();
        }

        @Override
        public void draw(Graphics g2) {
            if (this.displayArea != null && this.displayArea.rotateCards180) {
                float h2;
                float padding;
                float x = padding = this.getPadding();
                float y = padding;
                float w = this.getWidth() - 2.0f * padding;
                if (w == (h2 = this.getHeight() - 2.0f * padding)) {
                    w = h2 / 1.4f;
                }
                g2.startRotateTransform(x + w / 2.0f, y + h2 / 2.0f, 180.0f);
                super.draw(g2);
                g2.endTransform();
            } else {
                super.draw(g2);
            }
        }
    }
}

