/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.game.combat.CombatView;
import forge.game.player.PlayerView;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.MatchController;
import forge.screens.match.MatchScreen;
import forge.util.Utils;
import forge.util.collect.FCollection;
import java.util.Map;
import java.util.Set;

public class TargetingOverlay {
    private static final float BORDER_THICKNESS = Utils.scale(1.0f);
    private static final float ARROW_THICKNESS = Utils.scale(5.0f);
    private static final float ARROW_SIZE = 3.0f * ARROW_THICKNESS;
    private static FSkinColor friendColor;
    private static FSkinColor foeAtkColor;
    private static FSkinColor foeDefColor;

    public static void updateColors() {
        FSkinColor fSkinColor = friendColor = Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_NORMAL_TARGETING_ARROW) : FSkinColor.get(FSkinColor.Colors.CLR_NORMAL_TARGETING_ARROW);
        if (friendColor.getAlpha() == 0.0f) {
            friendColor = Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE).alphaColor(0.6f) : FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE).alphaColor(0.6f);
        }
        FSkinColor fSkinColor2 = foeDefColor = Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_COMBAT_TARGETING_ARROW) : FSkinColor.get(FSkinColor.Colors.CLR_COMBAT_TARGETING_ARROW);
        if (foeDefColor.getAlpha() == 0.0f) {
            foeDefColor = FSkinColor.getStandardColor(new Color(1.0f, 0.0f, 0.0f, 0.6f));
        }
        FSkinColor fSkinColor3 = foeAtkColor = Forge.isMobileAdventureMode ? FSkinColor.get(FSkinColor.Colors.ADV_CLR_PWATTK_TARGETING_ARROW) : FSkinColor.get(FSkinColor.Colors.CLR_PWATTK_TARGETING_ARROW);
        if (foeAtkColor.getAlpha() == 0.0f) {
            foeAtkColor = FSkinColor.getStandardColor(new Color(1.0f, 0.5411765f, 0.003921569f, 0.6f));
        }
    }

    private TargetingOverlay() {
    }

    public static void assembleArrows(Graphics g2, CardView c, Map<Integer, Vector2> endpoints, CombatView combat, Set<PlayerView> playerViewSet) {
        CardView attachedTo = c.getAttachedTo();
        Iterable<CardView> attachedCards = c.getAttachedCards();
        CardView paired = c.getPairedWith();
        if (null != attachedTo && attachedTo.getController() != null && !attachedTo.getController().equals(c.getController())) {
            TargetingOverlay.drawArrow(g2, endpoints.get(attachedTo.getId()), endpoints.get(c.getId()), ArcConnection.Friends);
        }
        if (null != attachedTo && c == attachedTo.getAttachedTo()) {
            TargetingOverlay.drawArrow(g2, endpoints.get(attachedTo.getId()), endpoints.get(c.getId()), ArcConnection.Friends);
        }
        if (null != attachedCards) {
            for (CardView enc : attachedCards) {
                if (enc.getController() == null || enc.getController().equals(c.getController())) continue;
                TargetingOverlay.drawArrow(g2, endpoints.get(c.getId()), endpoints.get(enc.getId()), ArcConnection.Friends);
            }
        }
        if (null != paired) {
            TargetingOverlay.drawArrow(g2, endpoints.get(paired.getId()), endpoints.get(c.getId()), ArcConnection.Friends);
        }
        if (null != combat) {
            GameEntityView defender = combat.getDefender(c);
            if (defender instanceof CardView) {
                TargetingOverlay.drawArrow(g2, endpoints.get(defender.getId()), endpoints.get(c.getId()), ArcConnection.FoesAttacking);
            }
            for (CardView pwAttacker : combat.getAttackersOf(c)) {
                TargetingOverlay.drawArrow(g2, endpoints.get(c.getId()), endpoints.get(pwAttacker.getId()), ArcConnection.FoesAttacking);
            }
            for (CardView attackingCard : combat.getAttackers()) {
                FCollection<CardView> cards = combat.getPlannedBlockers(attackingCard);
                if (cards == null) continue;
                for (CardView blockingCard : cards) {
                    if (!attackingCard.equals(c) && !blockingCard.equals(c)) continue;
                    TargetingOverlay.drawArrow(g2, endpoints.get(attackingCard.getId()), endpoints.get(blockingCard.getId()), ArcConnection.FoesBlocking);
                }
                if (playerViewSet == null) continue;
                for (PlayerView p : playerViewSet) {
                    if (!combat.getAttackersOf(p).contains(attackingCard)) continue;
                    MatchController.getView();
                    Vector2 vPlayer = MatchScreen.getPlayerPanel(p).getAvatar().getTargetingArrowOrigin();
                    TargetingOverlay.drawArrow(g2, endpoints.get(attackingCard.getId()), vPlayer, ArcConnection.FoesAttacking);
                }
            }
        }
    }

    public static void drawArrow(Graphics g2, Vector2 start, Vector2 end, ArcConnection connects) {
        if (start == null || end == null) {
            return;
        }
        FSkinColor color = foeDefColor;
        switch (connects) {
            case Friends: 
            case FriendsStackTargeting: {
                color = friendColor;
                break;
            }
            case FoesAttacking: {
                color = foeAtkColor;
                break;
            }
            case FoesBlocking: 
            case FoesStackTargeting: {
                color = foeDefColor;
            }
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_USE_LASER_ARROWS)) {
            g2.drawLineArrow(Utils.scale(3.0f), color, start.x, start.y, end.x, end.y);
        } else {
            g2.drawArrow(BORDER_THICKNESS, ARROW_THICKNESS, ARROW_SIZE, color, start.x, start.y, end.x, end.y);
        }
    }

    public static enum ArcConnection {
        Friends,
        FoesAttacking,
        FoesBlocking,
        FriendsStackTargeting,
        FoesStackTargeting;

    }
}

