/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.google.common.collect.Maps;
import forge.Forge;
import forge.Graphics;
import forge.adventure.scene.GameScene;
import forge.animation.AbilityEffect;
import forge.animation.ForgeAnimation;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinTexture;
import forge.card.CardImageRenderer;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.combat.CombatView;
import forge.game.phase.PhaseType;
import forge.game.player.PlayerView;
import forge.game.spellability.StackItemView;
import forge.game.zone.ZoneType;
import forge.gui.GuiBase;
import forge.interfaces.IGameController;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FDropDown;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuBar;
import forge.menu.FMenuItem;
import forge.menu.FMenuTab;
import forge.model.FModel;
import forge.player.PlayerZoneUpdate;
import forge.screens.FScreen;
import forge.screens.match.MatchController;
import forge.screens.match.TargetingOverlay;
import forge.screens.match.views.VAvatar;
import forge.screens.match.views.VCardDisplayArea;
import forge.screens.match.views.VDevMenu;
import forge.screens.match.views.VField;
import forge.screens.match.views.VGameMenu;
import forge.screens.match.views.VLog;
import forge.screens.match.views.VManaPool;
import forge.screens.match.views.VPhaseIndicator;
import forge.screens.match.views.VPlayerPanel;
import forge.screens.match.views.VPlayers;
import forge.screens.match.views.VPrompt;
import forge.screens.match.views.VReveal;
import forge.screens.match.views.VStack;
import forge.screens.match.winlose.ViewWinLose;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.toolbox.FCardPanel;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.Localizer;
import forge.util.Utils;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class MatchScreen
extends FScreen {
    private static final Map<PlayerView, VPlayerPanel> playerPanels = Maps.newHashMap();
    private List<VPlayerPanel> playerPanelsList;
    private final VGameMenu gameMenu;
    private final VPlayers players;
    private final VReveal revealed;
    private final VLog log;
    private final VStack stack;
    private final VDevMenu devMenu;
    private final FieldScroller scroller;
    private final VPrompt bottomPlayerPrompt;
    private final VPrompt topPlayerPrompt;
    private VPlayerPanel bottomPlayerPanel;
    private VPlayerPanel topPlayerPanel;
    private AbilityEffect activeEffect;
    private BGAnimation bgAnimation;
    private ViewWinLose viewWinLose = null;
    private static List<FDisplayObject> potentialListener;
    private int selectedPlayer;
    private String daytime = null;
    private Float time = null;
    FSkinTexture currentBG = this.getBG();

    public static FSkinColor getBorderColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_BORDERS);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_BORDERS);
    }

    public MatchScreen(List<VPlayerPanel> playerPanels0) {
        super(new FMenuBar());
        this.scroller = this.add(new FieldScroller());
        int humanCount = 0;
        playerPanels.clear();
        for (VPlayerPanel playerPanel : playerPanels0) {
            playerPanels.put(playerPanel.getPlayer(), this.scroller.add(playerPanel));
            playerPanel.setFlipped(true);
            if (playerPanel.getPlayer().isAI()) continue;
            ++humanCount;
        }
        this.bottomPlayerPanel = playerPanels0.get(0);
        this.bottomPlayerPanel.setFlipped(false);
        this.topPlayerPanel = playerPanels0.get(1);
        this.playerPanelsList = playerPanels0;
        this.playerPanelsList.remove(this.bottomPlayerPanel);
        this.playerPanelsList.add(this.bottomPlayerPanel);
        this.selectedPlayer = this.playerPanelsList.size() - 1;
        this.bottomPlayerPrompt = this.add(new VPrompt("", "", e -> this.getGameController().selectButtonOk(), e -> this.getGameController().selectButtonCancel()));
        if (humanCount < 2 || MatchController.instance.hotSeatMode() || GuiBase.isNetworkplay()) {
            this.topPlayerPrompt = null;
        } else {
            this.topPlayerPrompt = this.add(new VPrompt("", "", e -> this.getGameController().selectButtonOk(), e -> this.getGameController().selectButtonCancel()));
            this.topPlayerPrompt.setRotate180(true);
            this.topPlayerPanel.setRotate180(true);
            this.getHeader().setRotate90(true);
        }
        this.gameMenu = new VGameMenu();
        this.gameMenu.setDropDownContainer(this);
        this.players = new VPlayers();
        this.players.setDropDownContainer(this);
        this.revealed = new VReveal();
        this.revealed.setDropDownContainer(this);
        this.log = new VLog();
        this.log.setDropDownContainer(this);
        this.devMenu = new VDevMenu();
        this.devMenu.setDropDownContainer(this);
        this.stack = new VStack();
        this.stack.setDropDownContainer(this);
        FMenuBar menuBar = (FMenuBar)this.getHeader();
        if (this.topPlayerPrompt == null) {
            menuBar.addTab("", this.revealed, true);
            menuBar.addTab(Forge.getLocalizer().getMessage("lblGame", new Object[0]), this.gameMenu);
            menuBar.addTab(Forge.getLocalizer().getMessage("lblPlayers", new Object[0]) + " (" + playerPanels.size() + ")", this.players);
            menuBar.addTab(Forge.getLocalizer().getMessage("lblLog", new Object[0]), this.log);
            menuBar.addTab(Forge.getLocalizer().getMessage("lblDev", new Object[0]), this.devMenu);
            menuBar.addTab(Forge.getLocalizer().getMessage("lblStack", new Object[0]) + " (0)", this.stack);
        } else {
            menuBar.addTab("\u2022 \u2022 \u2022", new PlayerSpecificMenu(true));
            this.stack.setRotate90(true);
            menuBar.addTab(Forge.getLocalizer().getMessage("lblStack", new Object[0]) + " (0)", this.stack);
            menuBar.addTab("\u2022 \u2022 \u2022", new PlayerSpecificMenu(false));
            this.gameMenu.setMenuTab(new HiddenMenuTab(this.gameMenu));
            this.players.setMenuTab(new HiddenMenuTab(this.players));
            this.log.setMenuTab(new HiddenMenuTab(this.log));
            this.devMenu.setMenuTab(new HiddenMenuTab(this.devMenu));
        }
    }

    private boolean is4Player() {
        return playerPanels.keySet().size() == 4;
    }

    private boolean is3Player() {
        return playerPanels.keySet().size() == 3;
    }

    private IGameController getGameController() {
        return MatchController.instance.getGameController();
    }

    @Override
    public void onActivate() {
        if (this.topPlayerPrompt == null) {
            this.devMenu.getMenuTab().setVisible(ForgePreferences.DEV_MODE);
        }
    }

    public boolean isTopHumanPlayerActive() {
        return this.topPlayerPrompt != null && this.topPlayerPanel.getPlayer() == MatchController.instance.getCurrentPlayer();
    }

    public VPrompt getActivePrompt() {
        if (this.isTopHumanPlayerActive()) {
            return this.topPlayerPrompt;
        }
        return this.bottomPlayerPrompt;
    }

    public VPrompt getPrompt(PlayerView playerView) {
        if (this.topPlayerPrompt == null || this.bottomPlayerPanel.getPlayer() == playerView) {
            return this.bottomPlayerPrompt;
        }
        return this.topPlayerPrompt;
    }

    public VLog getLog() {
        return this.log;
    }

    public VStack getStack() {
        return this.stack;
    }

    public VPlayerPanel getTopPlayerPanel() {
        return this.topPlayerPanel;
    }

    public void setViewWinLose(ViewWinLose viewWinLose) {
        this.viewWinLose = viewWinLose;
    }

    public ViewWinLose getViewWinLose() {
        return this.viewWinLose;
    }

    public VPlayerPanel getBottomPlayerPanel() {
        return this.bottomPlayerPanel;
    }

    public static Map<PlayerView, VPlayerPanel> getPlayerPanels() {
        return playerPanels;
    }

    public List<VPlayerPanel> getPlayerPanelsList() {
        return this.playerPanelsList;
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        MatchController.writeMatchPreferences();
        SoundSystem.instance.setBackgroundMusic(MusicPlaylist.MENUS);
        super.onClose(canCloseCallback);
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float scrollerWidth = width;
        if (this.topPlayerPrompt != null) {
            this.topPlayerPrompt.setBounds(0.0f, 0.0f, width, VPrompt.HEIGHT);
            float menuBarWidth = this.getHeader().getHeight();
            float menuBarHeight = height - 2.0f * VPrompt.HEIGHT;
            this.getHeader().setBounds(width - menuBarHeight, height - VPrompt.HEIGHT, menuBarHeight, menuBarWidth);
            startY = VPrompt.HEIGHT;
            scrollerWidth -= menuBarWidth;
        }
        this.scroller.setBounds(0.0f, startY, scrollerWidth, height - VPrompt.HEIGHT - startY);
        this.bottomPlayerPrompt.setBounds(0.0f, height - VPrompt.HEIGHT, width, VPrompt.HEIGHT);
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    @Override
    public Rectangle getDropDownBoundary() {
        if (this.topPlayerPrompt == null) {
            return new Rectangle(0.0f, 0.0f, this.getWidth(), this.getHeight() - VPrompt.HEIGHT);
        }
        return new Rectangle(0.0f, VPrompt.HEIGHT, this.scroller.getWidth(), this.getHeight() - 2.0f * VPrompt.HEIGHT);
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        GameView game = MatchController.instance.getGameView();
        if (game == null) {
            return;
        }
        if (this.gameMenu != null && this.gameMenu.getChildCount() > 1) {
            if (this.viewWinLose == null) {
                this.gameMenu.getChildAt(0).setEnabled(!game.isMulligan());
                this.gameMenu.getChildAt(1).setEnabled(!game.isMulligan());
                if (!Forge.isMobileAdventureMode) {
                    this.gameMenu.getChildAt(2).setEnabled(!game.isMulligan());
                    this.gameMenu.getChildAt(3).setEnabled(false);
                }
            } else {
                this.gameMenu.getChildAt(0).setEnabled(false);
                this.gameMenu.getChildAt(1).setEnabled(false);
                if (!Forge.isMobileAdventureMode) {
                    this.gameMenu.getChildAt(2).setEnabled(false);
                    this.gameMenu.getChildAt(3).setEnabled(true);
                }
            }
        }
        if (this.devMenu != null && this.devMenu.isVisible()) {
            try {
                this.devMenu.getChildAt(2).setEnabled(game.getPlayers().size() == 2 && game.getStack().size() == 0 && !GuiBase.isNetworkplay() && game.getPhase().isMain() && !game.getPlayerTurn().isAI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.activeEffect != null) {
            this.activeEffect.draw(g2, 10.0f, 10.0f, 100.0f, 100.0f);
        }
        if (game.getNeedsPhaseRedrawn()) {
            VPhaseIndicator.PhaseLabel phaseLabel;
            this.resetAllPhaseButtons();
            if (game.getPlayerTurn() != null && game.getPhase() != null && (phaseLabel = MatchScreen.getPlayerPanel(game.getPlayerTurn()).getPhaseIndicator().getLabel(game.getPhase())) != null) {
                phaseLabel.setActive(true);
                game.clearNeedsPhaseRedrawn();
            }
        }
        this.drawArcs(g2);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_MAGNIFIER) && Forge.magnify && Forge.magnifyToggle && Forge.isLandscapeMode() && (!GuiBase.isAndroid() || Forge.hasGamepad()) && !CardZoom.isOpen() && potentialListener != null) {
            for (FDisplayObject object : potentialListener) {
                if (object == null) continue;
                if (object instanceof FCardPanel) {
                    FCardPanel cardPanel = (FCardPanel)object;
                    try {
                        float cardX;
                        if (!cardPanel.isHovered()) continue;
                        VPlayerPanel vPlayerPanel = MatchScreen.getPlayerPanel(cardPanel.getCard().getController());
                        if (vPlayerPanel == null) {
                            vPlayerPanel = MatchScreen.getPlayerPanel(cardPanel.getCard().getOwner());
                        }
                        if (vPlayerPanel == null) continue;
                        float cardW = this.getHeight() * 0.45f;
                        float cardH = 1.4f * cardW;
                        float f = !ZoneType.Battlefield.equals((Object)cardPanel.getCard().getZone()) ? cardPanel.screenPos.x - cardW : (cardX = cardPanel.screenPos.x + (cardPanel.isTapped() ? cardPanel.getWidth() : cardPanel.getWidth() / 1.4f));
                        if (vPlayerPanel.getSelectedTab() != null && vPlayerPanel.getSelectedTab().isVisible() && cardX > vPlayerPanel.getSelectedTab().getDisplayArea().getLeft()) {
                            cardX = cardPanel.screenPos.x - cardW;
                        }
                        if (cardX + cardW > this.scroller.getWidth() + this.scroller.getLeft()) {
                            cardX = cardPanel.screenPos.x - cardW;
                        }
                        if (vPlayerPanel.getCommandZone() != null && vPlayerPanel.getCommandZone().isVisible() && cardX > vPlayerPanel.getCommandZone().screenPos.x) {
                            cardX = cardPanel.screenPos.x - cardW;
                        }
                        float cardY = cardPanel.screenPos.y - cardH + cardPanel.getHeight();
                        if (vPlayerPanel.getPlayer() == this.bottomPlayerPanel.getPlayer()) {
                            cardY = this.bottomPlayerPrompt.screenPos.y - cardH;
                        } else if (cardY < vPlayerPanel.getField().screenPos.y && vPlayerPanel.getPlayer() != this.bottomPlayerPanel.getPlayer() && (cardY = vPlayerPanel.getField().screenPos.y) + cardH > this.bottomPlayerPrompt.screenPos.y) {
                            cardY = this.bottomPlayerPrompt.screenPos.y - cardH;
                        }
                        if (Forge.magnifyShowDetails) {
                            CardImageRenderer.drawDetails(g2, cardPanel.getCard(), MatchController.instance.getGameView(), false, cardX, cardY, cardW, cardH);
                            continue;
                        }
                        CardRenderer.drawCard(g2, cardPanel.getCard(), cardX, cardY, cardW, cardH, CardRenderer.CardStackPosition.Top, false, false, false, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(object instanceof VStack.StackInstanceDisplay)) continue;
                try {
                    CardView cardView = ((VStack.StackInstanceDisplay)object).stackInstance.getSourceCard();
                    if (!object.isHovered() || cardView == null || !this.getStack().isVisible()) continue;
                    float cardW = this.getHeight() * 0.45f;
                    float cardH = 1.4f * cardW;
                    float cardX = object.screenPos.x - cardW - Utils.scale(4.0f);
                    float cardY = object.screenPos.y - Utils.scale(2.0f);
                    if (cardY < this.topPlayerPanel.getField().screenPos.y) {
                        cardY = this.topPlayerPanel.getField().screenPos.y;
                    }
                    if (cardY + cardH > this.bottomPlayerPrompt.screenPos.y) {
                        cardY = this.bottomPlayerPrompt.screenPos.y - cardH;
                    }
                    if (Forge.magnifyShowDetails) {
                        CardImageRenderer.drawDetails(g2, cardView, MatchController.instance.getGameView(), false, cardX, cardY, cardW, cardH);
                        continue;
                    }
                    CardRenderer.drawCard(g2, cardView, cardX, cardY, cardW, cardH, CardRenderer.CardStackPosition.Top, false, false, false, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void drawArcs(Graphics g2) {
        HashMap<Integer, Vector2> endpoints = new HashMap<Integer, Vector2>();
        HashSet<CardView> cardsonBattlefield = new HashSet<CardView>();
        HashSet<PlayerView> playerViewSet = new HashSet<PlayerView>();
        GameView game = MatchController.instance.getGameView();
        try {
            for (PlayerView p : game.getPlayers()) {
                if (p == null || !this.playerPanelsList.contains(MatchScreen.getPlayerPanel(p))) continue;
                playerViewSet.add(p);
                if (p.getBattlefield() == null) continue;
                for (CardView c : p.getBattlefield()) {
                    endpoints.put(c.getId(), VCardDisplayArea.CardAreaPanel.get(c).getTargetingArrowOrigin());
                    cardsonBattlefield.add(c);
                }
            }
            CombatView combat = game.getCombat();
            for (CardView c : cardsonBattlefield) {
                TargetingOverlay.assembleArrows(g2, c, endpoints, combat, this.is4Player() || this.is3Player() ? playerViewSet : null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (Forge.hasGamepad() && ((FMenuBar)this.getHeader()).isShowingMenu(false) && (keyCode == 111 || keyCode == 66)) {
            return false;
        }
        switch (keyCode) {
            case 20: {
                if (((FMenuBar)this.getHeader()).isShowingMenu(true)) break;
                try {
                    VPlayerPanel.InfoTab selected = this.selectedPlayerPanel().getSelectedTab();
                    if (selected != null && selected.getDisplayArea().isVisible()) {
                        this.selectedPlayerPanel().getSelectedTab().getDisplayArea().setNextSelected(2);
                    } else {
                        VField.FieldRow row;
                        MatchScreen.nullPotentialListener();
                        VField.FieldRow fieldRow = row = this.selectedPlayerPanel() != this.getBottomPlayerPanel() ? this.selectedPlayerPanel().getField().getRow2() : this.selectedPlayerPanel().getField().getRow1();
                        if (this.selectedPlayerPanel().getSelectedRow() == row) {
                            this.selectedPlayerPanel().getSelectedRow().unselectCurrent();
                            this.selectedPlayerPanel().switchRow();
                            this.selectedPlayerPanel().getSelectedRow().selectCurrent();
                        } else {
                            this.selectedPlayerPanel().getSelectedRow().selectCurrent();
                        }
                    }
                    this.revalidate(true);
                }
                catch (Exception selected) {}
                break;
            }
            case 22: {
                if (((FMenuBar)this.getHeader()).isShowingMenu(true)) break;
                try {
                    VPlayerPanel.InfoTab selected = this.selectedPlayerPanel().getSelectedTab();
                    if (selected != null && selected.getDisplayArea().isVisible()) {
                        this.selectedPlayerPanel().getSelectedTab().getDisplayArea().setNextSelected(1);
                    } else {
                        this.selectedPlayerPanel().getSelectedRow().setNextSelected(1);
                    }
                    this.revalidate(true);
                }
                catch (Exception selected) {}
                break;
            }
            case 19: {
                if (((FMenuBar)this.getHeader()).isShowingMenu(true)) break;
                try {
                    VPlayerPanel.InfoTab selected = this.selectedPlayerPanel().getSelectedTab();
                    if (selected != null && selected.getDisplayArea().isVisible()) {
                        this.selectedPlayerPanel().getSelectedTab().getDisplayArea().setPreviousSelected(2);
                    } else {
                        VField.FieldRow row;
                        MatchScreen.nullPotentialListener();
                        VField.FieldRow fieldRow = row = this.selectedPlayerPanel() != this.getBottomPlayerPanel() ? this.selectedPlayerPanel().getField().getRow1() : this.selectedPlayerPanel().getField().getRow2();
                        if (this.selectedPlayerPanel().getSelectedRow() == row) {
                            this.selectedPlayerPanel().getSelectedRow().unselectCurrent();
                            this.selectedPlayerPanel().switchRow();
                            this.selectedPlayerPanel().getSelectedRow().selectCurrent();
                        } else {
                            this.selectedPlayerPanel().getSelectedRow().selectCurrent();
                        }
                    }
                    this.revalidate(true);
                }
                catch (Exception selected) {}
                break;
            }
            case 21: {
                if (((FMenuBar)this.getHeader()).isShowingMenu(true)) break;
                try {
                    VPlayerPanel.InfoTab selected = this.selectedPlayerPanel().getSelectedTab();
                    if (selected != null && selected.getDisplayArea().isVisible()) {
                        this.selectedPlayerPanel().getSelectedTab().getDisplayArea().setPreviousSelected(1);
                    } else {
                        this.selectedPlayerPanel().getSelectedRow().setPreviousSelected(1);
                    }
                    this.revalidate(true);
                }
                catch (Exception selected) {}
                break;
            }
            case 100: {
                if (((FMenuBar)this.getHeader()).isShowingMenu(true)) break;
                try {
                    VPlayerPanel.InfoTab selected = this.selectedPlayerPanel().getSelectedTab();
                    if (selected != null && selected.getDisplayArea().isVisible()) {
                        this.selectedPlayerPanel().getSelectedTab().getDisplayArea().showZoom();
                        break;
                    }
                    this.selectedPlayerPanel().getSelectedRow().showZoom();
                }
                catch (Exception selected) {}
                break;
            }
            case 96: {
                if (((FMenuBar)this.getHeader()).isShowingMenu(true)) break;
                try {
                    VPlayerPanel.InfoTab selected = this.selectedPlayerPanel().getSelectedTab();
                    if (selected != null && selected.getDisplayArea().isVisible()) {
                        this.selectedPlayerPanel().getSelectedTab().getDisplayArea().tapChild();
                        break;
                    }
                    this.selectedPlayerPanel().getSelectedRow().tapChild();
                }
                catch (Exception selected) {}
                break;
            }
            case 102: {
                if (!Forge.hasGamepad()) break;
                this.selectedPlayerPanel().hideSelectedTab();
                --this.selectedPlayer;
                if (this.selectedPlayer < 0) {
                    this.selectedPlayer = this.playerPanelsList.size() - 1;
                }
                this.selectedPlayerPanel().closeSelectedTab();
                this.selectedPlayerPanel().getSelectedRow().unselectCurrent();
                break;
            }
            case 62: 
            case 66: {
                if (this.getActivePrompt().getBtnOk().trigger()) {
                    return true;
                }
                return this.getActivePrompt().getBtnCancel().trigger();
            }
            case 111: {
                if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALLOW_ESC_TO_END_TURN) && !Forge.hasGamepad()) {
                    String string = this.getActivePrompt().getBtnCancel().getText();
                    Forge.getLocalizer();
                    if (string.equals(Localizer.getInstance().getMessage("lblEndTurn", new Object[0]))) {
                        return false;
                    }
                }
                return this.getActivePrompt().getBtnCancel().trigger();
            }
            case 4: {
                return true;
            }
            case 29: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown() && !GuiBase.getInterface().isRunningOnDesktop() && !Forge.hasGamepad()) break;
                this.getGameController().alphaStrike();
                return true;
            }
            case 33: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown() && !GuiBase.getInterface().isRunningOnDesktop()) break;
                this.getGameController().passPriorityUntilEndOfTurn();
                return true;
            }
            case 45: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                MatchController.instance.concede();
                return true;
            }
            case 54: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown() && !Forge.hasGamepad()) break;
                this.getGameController().undoLastAction();
                return true;
            }
            case 53: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown() && !GuiBase.getInterface().isRunningOnDesktop()) break;
                MatchController gui = MatchController.instance;
                IGameController controller = MatchController.instance.getGameController();
                GameView gameView = MatchController.instance.getGameView();
                FCollectionView<StackItemView> stack = MatchController.instance.getGameView().getStack();
                if (stack.isEmpty()) {
                    return false;
                }
                StackItemView stackInstance = stack.getLast();
                if (!stackInstance.isAbility()) {
                    return false;
                }
                int triggerID = stackInstance.getSourceTrigger();
                if (gui.shouldAlwaysAcceptTrigger(triggerID)) {
                    gui.setShouldAlwaysAskTrigger(triggerID);
                } else {
                    gui.setShouldAlwaysAcceptTrigger(triggerID);
                    if (stackInstance.equals(gameView.peekStack())) {
                        controller.selectButtonOk();
                    }
                }
                String key = stackInstance.getKey();
                gui.setShouldAutoYield(key, true);
                if (!stackInstance.equals(gameView.peekStack())) break;
                controller.passPriority();
                break;
            }
            case 42: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown() && !GuiBase.getInterface().isRunningOnDesktop()) break;
                MatchController gui = MatchController.instance;
                IGameController controller = MatchController.instance.getGameController();
                GameView gameView = MatchController.instance.getGameView();
                FCollectionView<StackItemView> stack = MatchController.instance.getGameView().getStack();
                if (stack.isEmpty()) {
                    return false;
                }
                StackItemView stackInstance = stack.getLast();
                if (!stackInstance.isAbility()) {
                    return false;
                }
                int triggerID = stackInstance.getSourceTrigger();
                if (gui.shouldAlwaysDeclineTrigger(triggerID)) {
                    gui.setShouldAlwaysAskTrigger(triggerID);
                } else {
                    gui.setShouldAlwaysDeclineTrigger(triggerID);
                    if (stackInstance.equals(gameView.peekStack())) {
                        controller.selectButtonCancel();
                    }
                }
                String key = stackInstance.getKey();
                gui.setShouldAutoYield(key, true);
                if (!stackInstance.equals(gameView.peekStack())) break;
                controller.passPriority();
            }
        }
        return super.keyDown(keyCode);
    }

    @Override
    public void showMenu() {
    }

    public boolean stopAtPhase(PlayerView turn, PhaseType phase) {
        VPhaseIndicator.PhaseLabel label = MatchScreen.getPlayerPanel(turn).getPhaseIndicator().getLabel(phase);
        return label == null || label.getStopAtPhase();
    }

    public void resetAllPhaseButtons() {
        for (VPlayerPanel panel : MatchScreen.getPlayerPanels().values()) {
            panel.getPhaseIndicator().resetPhaseButtons();
        }
    }

    public static VPlayerPanel getPlayerPanel(PlayerView playerView) {
        return MatchScreen.getPlayerPanels().get(playerView);
    }

    public void highlightCard(CardView c) {
        for (VPlayerPanel playerPanel : MatchScreen.getPlayerPanels().values()) {
            for (FCardPanel fCardPanel : playerPanel.getField().getCardPanels()) {
                if (!fCardPanel.getCard().equals(c)) continue;
                fCardPanel.setHighlighted(true);
                return;
            }
        }
    }

    public void clearCardHighlights() {
        for (VPlayerPanel playerPanel : MatchScreen.getPlayerPanels().values()) {
            for (FCardPanel fCardPanel : playerPanel.getField().getCardPanels()) {
                fCardPanel.setHighlighted(false);
            }
        }
    }

    public void resetFields() {
        VCardDisplayArea.CardAreaPanel.resetForNewGame();
        for (VPlayerPanel playerPanel : MatchScreen.getPlayerPanels().values()) {
            for (VCardDisplayArea.CardAreaPanel p : playerPanel.getField().getCardPanels()) {
                p.reset();
            }
            playerPanel.getZoneTab(ZoneType.Hand).getDisplayArea().clear();
            playerPanel.getZoneTab(ZoneType.Library).getDisplayArea().clear();
            playerPanel.getZoneTab(ZoneType.Graveyard).getDisplayArea().clear();
            playerPanel.getZoneTab(ZoneType.Exile).getDisplayArea().clear();
        }
    }

    public void forceRevalidate() {
        for (VPlayerPanel playerPanel : MatchScreen.getPlayerPanels().values()) {
            playerPanel.revalidate(true);
        }
    }

    public void updateZones(Iterable<PlayerZoneUpdate> zonesToUpdate) {
        for (PlayerZoneUpdate update : zonesToUpdate) {
            PlayerView owner = update.getPlayer();
            VPlayerPanel panel = MatchScreen.getPlayerPanel(owner);
            for (ZoneType zone : update.getZones()) {
                panel.updateZone(zone);
            }
        }
    }

    public Iterable<PlayerZoneUpdate> tempShowZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        return zonesToUpdate;
    }

    public void hideZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
    }

    public void updateSingleCard(CardView card) {
        VCardDisplayArea.CardAreaPanel pnl = VCardDisplayArea.CardAreaPanel.get(card);
        if (pnl == null) {
            return;
        }
        ZoneType zone = card.getZone();
        if (zone != null && zone == ZoneType.Battlefield) {
            pnl.updateCard(card);
        } else {
            pnl.setTapped(false);
            pnl.getAttachedPanels().clear();
            pnl.setAttachedToPanel(null);
            pnl.setPrevPanelInStack(null);
            pnl.setNextPanelInStack(null);
        }
    }

    FSkinTexture getBG() {
        if (Forge.isMobileAdventureMode) {
            switch (GameScene.instance().getAdventurePlayerLocation(false, true)) {
                case "green": {
                    return FSkinTexture.ADV_BG_FOREST;
                }
                case "black": {
                    return FSkinTexture.ADV_BG_SWAMP;
                }
                case "red": {
                    return FSkinTexture.ADV_BG_MOUNTAIN;
                }
                case "blue": {
                    return FSkinTexture.ADV_BG_ISLAND;
                }
                case "white": {
                    return FSkinTexture.ADV_BG_PLAINS;
                }
                case "waste": {
                    return FSkinTexture.ADV_BG_WASTE;
                }
                case "cave": {
                    return FSkinTexture.ADV_BG_CAVE;
                }
                case "dungeon": {
                    return FSkinTexture.ADV_BG_DUNGEON;
                }
                case "castle": {
                    return FSkinTexture.ADV_BG_CASTLE;
                }
            }
            return FSkinTexture.ADV_BG_COMMON;
        }
        return FSkinTexture.BG_MATCH;
    }

    private String getPlaneName() {
        return MatchController.instance.getGameView().getPlanarPlayer().getCurrentPlaneName();
    }

    private boolean hasActivePlane() {
        if (MatchController.instance.getGameView() != null && MatchController.instance.getGameView().getPlanarPlayer() != null) {
            return !MatchController.instance.getGameView().getPlanarPlayer().getCurrentPlaneName().isEmpty();
        }
        return false;
    }

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        MatchScreen.setPotentialListener(listeners);
        super.buildTouchListeners(screenX, screenY, listeners);
    }

    public VPlayerPanel selectedPlayerPanel() {
        if (this.selectedPlayer >= this.playerPanelsList.size()) {
            this.selectedPlayer = this.playerPanelsList.size() - 1;
        }
        if (this.playerPanelsList.isEmpty()) {
            return null;
        }
        return this.playerPanelsList.get(this.selectedPlayer);
    }

    public static void setPotentialListener(List<FDisplayObject> listener) {
        if (potentialListener != null) {
            for (FDisplayObject f : potentialListener) {
                f.setHovered(false);
            }
        }
        potentialListener = listener;
    }

    public static void nullPotentialListener() {
        if (potentialListener != null) {
            for (FDisplayObject f : potentialListener) {
                f.setHovered(false);
            }
        }
        potentialListener = null;
    }

    private class FieldScroller
    extends FScrollPane {
        private float extraHeight = 0.0f;
        private String plane = "";
        private String imageName = "";
        List<VPlayerPanel> losers = new ArrayList<VPlayerPanel>();

        private FieldScroller() {
        }

        @Override
        public void drawBackground(Graphics g2) {
            float bgFullWidth;
            super.drawBackground(g2);
            if (!(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MATCH_IMAGE_VISIBLE) || Forge.isMobileAdventureMode || MatchScreen.this.hasActivePlane())) {
                return;
            }
            boolean isGameFast = MatchController.instance.isGameFast();
            float midField = MatchScreen.this.topPlayerPanel.getBottom();
            float promptHeight = !Forge.isLandscapeMode() || MatchScreen.this.bottomPlayerPrompt == null ? 0.0f : MatchScreen.this.bottomPlayerPrompt.getHeight() / 1.3f;
            float x = MatchScreen.this.topPlayerPanel.getField().getLeft();
            float y = midField - MatchScreen.this.topPlayerPanel.getField().getHeight() - promptHeight;
            float w = this.getWidth() - x;
            int multiplier = playerPanels.keySet().size() - 1;
            float bgHeight = midField + MatchScreen.this.bottomPlayerPanel.getField().getHeight() * (float)multiplier - y;
            if (MatchScreen.this.bgAnimation == null) {
                MatchScreen.this.bgAnimation = new BGAnimation();
            }
            FSkinTexture matchBG = MatchScreen.this.currentBG;
            if (!Forge.isMobileAdventureMode) {
                if (MatchScreen.this.hasActivePlane()) {
                    String t2;
                    String dt;
                    this.imageName = MatchScreen.this.getPlaneName().replace(" ", "_").replace("'", "").replace("-", "").replace("!", "");
                    if (!this.plane.equals(this.imageName)) {
                        this.plane = this.imageName;
                        MatchScreen.this.bgAnimation.progress = 0.0f;
                    }
                    String string = dt = MatchController.instance.getDayTime() == null ? "" : MatchController.instance.getDayTime();
                    String string2 = MatchScreen.this.time == null ? "" : (t2 = MatchScreen.this.time.floatValue() > 0.0f ? "Day" : "Night");
                    if (!dt.equalsIgnoreCase(t2)) {
                        MatchScreen.this.bgAnimation.progress = 0.0f;
                    }
                    matchBG = FSkinTexture.GENERIC_PLANE.load(this.imageName) ? FSkinTexture.GENERIC_PLANE : (MatchScreen.this.daytime == null ? FSkinTexture.BG_MATCH : (MatchScreen.this.daytime.equals("Day") ? FSkinTexture.BG_MATCH_DAY : FSkinTexture.BG_MATCH_NIGHT));
                } else if (MatchScreen.this.daytime == null) {
                    matchBG = FSkinTexture.BG_MATCH;
                } else {
                    FSkinTexture fSkinTexture = matchBG = MatchScreen.this.daytime.equals("Day") ? FSkinTexture.BG_MATCH_DAY : FSkinTexture.BG_MATCH_NIGHT;
                }
            }
            if ((bgFullWidth = bgHeight * matchBG.getWidth() / matchBG.getHeight()) < w) {
                float scaledbgHeight = w * (bgHeight / bgFullWidth);
                bgFullWidth = w;
                bgHeight = scaledbgHeight;
            }
            if (MatchScreen.this.daytime != MatchController.instance.getDayTime() || MatchScreen.this.hasActivePlane()) {
                MatchScreen.this.bgAnimation.start();
                MatchScreen.this.bgAnimation.drawBackground(g2, matchBG, x + (w - bgFullWidth) / 2.0f, y, bgFullWidth, bgHeight, MatchScreen.this.hasActivePlane(), MatchController.instance.getDayTime() != null);
            } else {
                MatchScreen.this.bgAnimation.progress = 0.0f;
                if (MatchController.instance.getDayTime() == null) {
                    g2.drawImage(matchBG, x + (w - bgFullWidth) / 2.0f, y, bgFullWidth, bgHeight);
                } else if (MatchScreen.this.hasActivePlane() || Forge.isMobileAdventureMode) {
                    g2.drawNightDay(matchBG, x + (w - bgFullWidth) / 2.0f, y, bgFullWidth, bgHeight, MatchScreen.this.time, !Forge.isMobileAdventureMode, 0.0f);
                } else {
                    g2.drawRipple(matchBG, x + (w - bgFullWidth) / 2.0f, y, bgFullWidth, bgHeight, Float.valueOf(0.0f));
                }
            }
        }

        @Override
        public void drawOverlay(Graphics g2) {
            if (Forge.isLandscapeMode()) {
                if (MatchScreen.this.playerPanelsList.size() > 2) {
                    for (Object playerPanel : MatchScreen.this.playerPanelsList) {
                        if (!((VPlayerPanel)playerPanel).getPlayer().getHasLost()) continue;
                        this.losers.add((VPlayerPanel)playerPanel);
                    }
                }
                if (!this.losers.isEmpty()) {
                    float height = 0.0f;
                    for (VPlayerPanel p : this.losers) {
                        if (MatchScreen.this.playerPanelsList.size() <= 2) continue;
                        height = p.getAvatar().getHeight();
                        p.setVisible(false);
                        MatchScreen.this.playerPanelsList.remove(p);
                        System.out.println("Removed panel: " + p.getPlayer().toString());
                    }
                    this.losers.clear();
                    if (MatchScreen.this.playerPanelsList.size() == 2) {
                        for (VPlayerPanel playerPanel : MatchScreen.this.playerPanelsList) {
                            float size = playerPanel.getAvatar().getWidth() * 2.0f;
                            playerPanel.getAvatar().setSize(size, size);
                            playerPanel.revalidate(true);
                            System.out.println("Panel Resized: " + playerPanel.getPlayer().toString());
                        }
                    }
                    this.zoom(0.0f, 0.0f, height);
                }
            }
            float x = 0.0f;
            float w = this.getWidth();
            if (!Forge.isLandscapeMode()) {
                for (VPlayerPanel playerPanel : MatchScreen.this.playerPanelsList) {
                    float midField = playerPanel.getTop();
                    float y = midField - playerPanel.getField().getHeight();
                    if (playerPanel.getSelectedTab() == null) {
                        y += 1.0f;
                    }
                    g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, y, w, y);
                }
            }
            for (VPlayerPanel playerPanel : MatchScreen.this.playerPanelsList) {
                float midField = playerPanel.getTop();
                float y = midField - 0.5f;
                g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, y, w, y);
            }
            if (!Forge.isLandscapeMode()) {
                float y = MatchScreen.this.bottomPlayerPanel.getTop() + MatchScreen.this.bottomPlayerPanel.getField().getHeight();
                g2.drawLine(1.0f, MatchScreen.getBorderColor(), x, y, w, y);
            }
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float totalHeight = visibleHeight + this.extraHeight;
            float avatarHeight = VAvatar.HEIGHT;
            if (MatchScreen.this.is4Player() || MatchScreen.this.is3Player()) {
                avatarHeight *= 0.5f;
            }
            float playerCount = MatchScreen.getPlayerPanels().keySet().size();
            if (Forge.isLandscapeMode() && playerCount == 2.0f) {
                float topPlayerPanelHeight;
                float bottomPlayerPanelHeight = topPlayerPanelHeight = totalHeight / 2.0f;
                MatchScreen.this.topPlayerPanel.setBounds(0.0f, 0.0f, visibleWidth, topPlayerPanelHeight);
                MatchScreen.this.bottomPlayerPanel.setBounds(0.0f, totalHeight - bottomPlayerPanelHeight, visibleWidth, bottomPlayerPanelHeight);
            } else {
                float cardRowsHeight = totalHeight - playerCount * avatarHeight;
                float totalCardRows = 0.0f;
                for (VPlayerPanel playerPanel : MatchScreen.this.playerPanelsList) {
                    if (playerPanel.getSelectedTab() != null) {
                        totalCardRows += 1.0f;
                    }
                    totalCardRows += 2.0f;
                }
                float y = 0.0f;
                for (VPlayerPanel playerPanel : MatchScreen.this.playerPanelsList) {
                    float panelHeight = playerPanel.getSelectedTab() != null ? cardRowsHeight * 3.0f / totalCardRows : cardRowsHeight * 2.0f / totalCardRows;
                    playerPanel.setBounds(0.0f, y, visibleWidth, panelHeight += avatarHeight);
                    y += panelHeight;
                }
            }
            return new FScrollPane.ScrollBounds(visibleWidth, totalHeight);
        }

        @Override
        public boolean zoom(float x, float y, float amount) {
            float staticHeight = 2.0f * VAvatar.HEIGHT;
            float oldScrollHeight = this.getScrollHeight() - staticHeight;
            float oldScrollTop = this.getScrollTop();
            y += oldScrollTop - VAvatar.HEIGHT;
            HashMap<FScrollPane, Pair<Float, Float>> horzScrollPanes = new HashMap<FScrollPane, Pair<Float, Float>>();
            this.backupHorzScrollPanes(MatchScreen.this.topPlayerPanel, x, horzScrollPanes);
            this.backupHorzScrollPanes(MatchScreen.this.bottomPlayerPanel, x, horzScrollPanes);
            float zoom = oldScrollHeight / (this.getHeight() - staticHeight);
            this.extraHeight += amount * zoom;
            if (this.extraHeight < 0.0f) {
                this.extraHeight = 0.0f;
            }
            this.revalidate();
            float newScrollHeight = this.getScrollHeight() - staticHeight;
            float ratio = newScrollHeight / oldScrollHeight;
            float yAfter = y * ratio;
            this.setScrollTop(oldScrollTop + yAfter - y);
            float startX = x;
            for (Map.Entry entry : horzScrollPanes.entrySet()) {
                FScrollPane horzScrollPane = (FScrollPane)entry.getKey();
                float oldScrollLeft = ((Float)((Pair)entry.getValue()).getLeft()).floatValue();
                x = startX + oldScrollLeft;
                float xAfter = x * ratio;
                horzScrollPane.setScrollLeft(oldScrollLeft + xAfter - x);
            }
            return true;
        }

        private void backupHorzScrollPanes(VPlayerPanel playerPanel, float x, Map<FScrollPane, Pair<Float, Float>> horzScrollPanes) {
            this.backupHorzScrollPane(playerPanel.getField().getRow1(), x, horzScrollPanes);
            this.backupHorzScrollPane(playerPanel.getField().getRow2(), x, horzScrollPanes);
            for (VPlayerPanel.InfoTab tab : playerPanel.getTabs()) {
                if (tab.getDisplayArea() instanceof VManaPool) continue;
                this.backupHorzScrollPane(tab.getDisplayArea(), x, horzScrollPanes);
            }
            this.backupHorzScrollPane(playerPanel.getCommandZone(), x, horzScrollPanes);
        }

        private void backupHorzScrollPane(FScrollPane scrollPane, float x, Map<FScrollPane, Pair<Float, Float>> horzScrollPanes) {
            horzScrollPanes.put(scrollPane, Pair.of(Float.valueOf(scrollPane.getScrollLeft()), Float.valueOf(scrollPane.getScrollWidth())));
        }
    }

    private class BGAnimation
    extends ForgeAnimation {
        private static final float DURATION = 1.4f;
        private float progress = 0.0f;
        private boolean recomputed = false;

        private BGAnimation() {
        }

        private void drawBackground(Graphics g2, FImage image, float x, float y, float w, float h2, boolean darkoverlay, boolean daynightTransition) {
            float percentage = this.progress / 1.4f;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (MatchController.instance.getGameView().isMatchOver()) {
                percentage = 1.0f;
            }
            if (Forge.isMobileAdventureMode) {
                if (percentage < 1.0f) {
                    g2.drawNightDay(image, x, y, w, h2, MatchScreen.this.time, false, 0.0f);
                }
                if (MatchController.instance.getGameView().getGame().isDay()) {
                    g2.setAlphaComposite(percentage);
                    g2.drawNightDay(image, x, y, w, h2, Float.valueOf(100.0f), false, 0.0f);
                    g2.setAlphaComposite(oldAlpha);
                } else if (MatchController.instance.getGameView().getGame().isNight()) {
                    g2.setAlphaComposite(percentage);
                    g2.drawNightDay(image, x, y, w, h2, Float.valueOf(-100.0f), false, 0.0f);
                    g2.setAlphaComposite(oldAlpha);
                }
            } else if (!daynightTransition) {
                g2.setAlphaComposite(percentage);
                if (image instanceof FSkinTexture) {
                    g2.drawRipple(image, x, y, w, h2, Float.valueOf(1.0f - percentage));
                } else {
                    g2.drawGrayTransitionImage(image, x, y, w, h2, 1.0f - percentage);
                }
                g2.setAlphaComposite(oldAlpha);
            } else if (MatchScreen.this.hasActivePlane()) {
                String dt;
                String string = dt = MatchController.instance.getDayTime() == null ? "" : MatchController.instance.getDayTime();
                if (percentage < 1.0f) {
                    g2.drawRipple(image, x, y, w, h2, Float.valueOf(1.0f - percentage));
                }
                if ("Day".equalsIgnoreCase(dt)) {
                    g2.setAlphaComposite(percentage);
                    g2.drawNightDay(image, x, y, w, h2, Float.valueOf(100.0f), true, 1.0f - percentage);
                    g2.setAlphaComposite(oldAlpha);
                } else if ("Night".equalsIgnoreCase(dt)) {
                    g2.setAlphaComposite(percentage);
                    g2.drawNightDay(image, x, y, w, h2, Float.valueOf(-100.0f), true, 1.0f - percentage);
                    g2.setAlphaComposite(oldAlpha);
                }
            } else {
                FSkinTexture matchBG;
                FSkinTexture fSkinTexture = MatchController.instance.getDayTime() == null ? FSkinTexture.BG_MATCH : (matchBG = MatchController.instance.getDayTime().equals("Day") ? FSkinTexture.BG_MATCH_DAY : FSkinTexture.BG_MATCH_NIGHT);
                if (!this.recomputed) {
                    float midField = MatchScreen.this.topPlayerPanel.getBottom();
                    float promptHeight = !Forge.isLandscapeMode() || MatchScreen.this.bottomPlayerPrompt == null ? 0.0f : MatchScreen.this.bottomPlayerPrompt.getHeight() / 1.3f;
                    float xx = MatchScreen.this.topPlayerPanel.getField().getLeft();
                    float yy = midField - MatchScreen.this.topPlayerPanel.getField().getHeight() - promptHeight;
                    float ww = MatchScreen.this.getWidth() - xx;
                    int multiplier = playerPanels.keySet().size() - 1;
                    float bgHeight = midField + MatchScreen.this.bottomPlayerPanel.getField().getHeight() * (float)multiplier - yy;
                    float bgFullWidth = bgHeight * matchBG.getWidth() / matchBG.getHeight();
                    if (bgFullWidth < ww) {
                        float scaledbgHeight = ww * (bgHeight / bgFullWidth);
                        bgFullWidth = ww;
                        bgHeight = scaledbgHeight;
                    }
                    g2.drawRipple(matchBG, xx + (ww - bgFullWidth) / 2.0f, yy, bgFullWidth, bgHeight, Float.valueOf(1.0f - percentage));
                    if (percentage == 1.0f) {
                        this.recomputed = true;
                    }
                } else {
                    g2.drawRipple(matchBG, x, y, w, h2, Float.valueOf(1.0f - percentage));
                }
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < 1.4f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            MatchScreen.this.daytime = MatchController.instance.getDayTime();
            if (MatchController.instance.getGameView().getGame().isDay()) {
                MatchScreen.this.time = Float.valueOf(100.0f);
            }
            if (MatchController.instance.getGameView().getGame().isNight()) {
                MatchScreen.this.time = Float.valueOf(-100.0f);
            }
        }
    }

    private class PlayerSpecificMenu
    extends FDropDownMenu {
        private PlayerSpecificMenu(boolean forTopPlayer) {
            this.setRotate180(forTopPlayer);
        }

        @Override
        protected void updateSizeAndPosition() {
            Rectangle menuTabPos = this.getMenuTab().screenPos;
            FScreen screen = Forge.getCurrentScreen();
            float maxWidth = screen.getWidth() - menuTabPos.width;
            float maxHeight = screen.getHeight() / 2.0f;
            this.paneSize = this.updateAndGetPaneSize(maxWidth, maxHeight);
            this.paneSize = new FScrollPane.ScrollBounds(Math.round(this.paneSize.getWidth()), Math.round(this.paneSize.getHeight()));
            float x = maxWidth - this.paneSize.getWidth();
            float y = this.getRotate180() ? menuTabPos.y + FMenuTab.PADDING : menuTabPos.y + menuTabPos.height - this.paneSize.getHeight() - FMenuTab.PADDING + 1.0f;
            this.setBounds(Math.round(x), Math.round(y), this.paneSize.getWidth(), this.paneSize.getHeight());
        }

        @Override
        protected void buildMenu() {
            if (MatchScreen.this.isTopHumanPlayerActive() == this.getRotate180()) {
                this.addItem(new MenuItem(Forge.getLocalizer().getMessage("lblGame", new Object[0]), MatchScreen.this.gameMenu));
                this.addItem(new MenuItem(Forge.getLocalizer().getMessage("lblPlayers", new Object[0]) + " (" + playerPanels.size() + ")", MatchScreen.this.players));
                this.addItem(new MenuItem(Forge.getLocalizer().getMessage("lblLog", new Object[0]), MatchScreen.this.log));
                if (ForgePreferences.DEV_MODE) {
                    this.addItem(new MenuItem(Forge.getLocalizer().getMessage("lblDev", new Object[0]), MatchScreen.this.devMenu));
                }
            } else {
                FMenuItem item = new FMenuItem(Forge.getLocalizer().getMessage("lblMustWaitPriority", new Object[0]), null);
                item.setEnabled(false);
                this.addItem(item);
            }
        }

        private class MenuItem
        extends FMenuItem {
            private MenuItem(String text0, FDropDown dropDown) {
                super(text0, e -> {
                    dropDown.setRotate180(PlayerSpecificMenu.this.getRotate180());
                    Rectangle menuScreenPos = forge$screens$match$MatchScreen$PlayerSpecificMenu$this.screenPos;
                    if (dropDown.getRotate180()) {
                        dropDown.getMenuTab().screenPos.setPosition(menuScreenPos.x + menuScreenPos.width, menuScreenPos.y);
                    } else {
                        dropDown.getMenuTab().screenPos.setPosition(menuScreenPos.x + menuScreenPos.width, menuScreenPos.y + menuScreenPos.height);
                    }
                    dropDown.show();
                });
            }
        }
    }

    private class HiddenMenuTab
    extends FMenuTab {
        private HiddenMenuTab(FDropDown dropDown0) {
            super(null, null, dropDown0, -1, false);
            this.setVisible(false);
        }

        @Override
        public void setText(String text0) {
        }
    }
}

