/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.Forge;
import forge.Graphics;
import forge.LobbyPlayer;
import forge.adventure.scene.DuelScene;
import forge.adventure.util.Config;
import forge.ai.GameState;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.FSkinImageInterface;
import forge.assets.FTextureRegionImage;
import forge.assets.ImageCache;
import forge.card.CardAvatarImage;
import forge.card.GameEntityPicker;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.FSideboardDialog;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.game.phase.PhaseType;
import forge.game.player.DelayedReveal;
import forge.game.player.IHasIcon;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbilityView;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.AbstractGuiGame;
import forge.gamemodes.match.HostedMatch;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.screens.match.MatchScreen;
import forge.screens.match.views.VAssignCombatDamage;
import forge.screens.match.views.VAssignGenericAmount;
import forge.screens.match.views.VPhaseIndicator;
import forge.screens.match.views.VPlayerPanel;
import forge.screens.match.views.VPrompt;
import forge.screens.match.winlose.ViewWinLose;
import forge.toolbox.FButton;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FOptionPane;
import forge.trackable.TrackableCollection;
import forge.util.ITriggerEvent;
import forge.util.MessageUtil;
import forge.util.WaitCallback;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MatchController
extends AbstractGuiGame {
    public static final MatchController instance = new MatchController();
    private static HostedMatch hostedMatch;
    private static MatchScreen view;
    private static GameState phaseGameState;
    private final Map<PlayerView, VPlayerPanel.InfoTab> zonesToRestore = Maps.newHashMap();
    private final Map<PlayerView, VPlayerPanel.InfoTab> lastZonesToRestore = Maps.newHashMap();
    private PlayerView lastPlayer;

    private MatchController() {
    }

    private GameState getPhaseGameState() {
        return phaseGameState;
    }

    public static MatchScreen getView() {
        return view;
    }

    @Override
    protected void updateCurrentPlayer(PlayerView player) {
        for (PlayerView other : this.getLocalPlayers()) {
            if (other.equals(player)) continue;
            this.updatePromptForAwait(other);
        }
    }

    public static Deck getPlayerDeck(PlayerView playerView) {
        try {
            for (Player p : instance.getGameView().getGame().getPlayers()) {
                if (p.getView() != playerView) continue;
                return p.getRegisteredPlayer().getDeck();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static FImage getPlayerAvatar(PlayerView p) {
        String lp = p.getLobbyPlayerName();
        FImage avatar = Forge.getAssets().avatarImages().get(lp);
        if (avatar == null) {
            avatar = StringUtils.isEmpty(p.getAvatarCardImageKey()) ? new FTextureRegionImage(FSkin.getAvatars().get(p.getAvatarIndex())) : new CardAvatarImage(p.getAvatarCardImageKey());
        }
        return avatar;
    }

    public static FImage getPlayerSleeve(PlayerView p) {
        if (p == null) {
            return FSkinImage.UNKNOWN;
        }
        return new FTextureRegionImage(FSkin.getSleeves().get(p.getSleeveIndex()));
    }

    @Override
    public void refreshCardDetails(Iterable<CardView> cards) {
        for (VPlayerPanel pnl : view.getPlayerPanels().values()) {
            pnl.getField().update(true);
            pnl.getZoneTab(ZoneType.Flashback).update();
        }
    }

    @Override
    public void refreshField() {
        if (!GuiBase.isNetworkplay()) {
            return;
        }
        this.refreshCardDetails(null);
    }

    @Override
    public GameState getGamestate() {
        return this.getPhaseGameState();
    }

    public boolean hotSeatMode() {
        return FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.MATCH_HOT_SEAT_MODE);
    }

    @Override
    public void openView(TrackableCollection<PlayerView> myPlayers) {
        boolean noHumans = !this.hasLocalPlayers();
        FCollectionView<PlayerView> players = this.getGameView().getPlayers();
        if (players.size() == 2 && myPlayers != null && myPlayers.size() == 1 && myPlayers.get((PlayerView)false).equals(players.get((PlayerView)true))) {
            players = new FCollection<PlayerView>(new PlayerView[]{players.get((PlayerView)true), players.get((PlayerView)false)});
        }
        ArrayList<VPlayerPanel> playerPanels = new ArrayList<VPlayerPanel>();
        boolean init = false;
        Iterator iterator = players.iterator();
        while (iterator.hasNext()) {
            PlayerView p;
            boolean isLocal = this.isLocalPlayer(p = (PlayerView)iterator.next());
            VPlayerPanel playerPanel = new VPlayerPanel(p, isLocal || noHumans, players.size());
            if (isLocal && !init) {
                playerPanels.add(0, playerPanel);
                init = true;
                continue;
            }
            playerPanels.add(playerPanel);
        }
        view = new MatchScreen(playerPanels);
        if (GuiBase.isNetworkplay()) {
            view.resetFields();
        }
        this.clearSelectables();
        if (noHumans) {
            view.add(new FDisplayObject(){

                @Override
                public void draw(Graphics g2) {
                }

                @Override
                public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
                    if (screenY < view.getHeight() - VPrompt.HEIGHT) {
                        hostedMatch.pause();
                    }
                }
            });
        }
        MatchController.actuateMatchPreferences();
        this.updateDayTime(null);
        Forge.openScreen(view);
    }

    @Override
    public void showPromptMessage(PlayerView player, String message) {
        view.getPrompt(player).setMessage(message);
    }

    @Override
    public void showCardPromptMessage(PlayerView player, String message, CardView card) {
        view.getPrompt(player).setMessage(message, card);
    }

    @Override
    public void updateButtons(PlayerView owner, String label1, String label2, boolean enable1, boolean enable2, boolean focus1) {
        VPrompt prompt = view.getPrompt(owner);
        FButton btn1 = prompt.getBtnOk();
        FButton btn2 = prompt.getBtnCancel();
        btn1.setText(label1);
        btn2.setText(label2);
        btn1.setEnabled(enable1);
        btn2.setEnabled(enable2);
    }

    @Override
    public void flashIncorrectAction() {
    }

    @Override
    public void alertUser() {
    }

    @Override
    public void updatePhase(boolean saveState) {
        PhaseType ph = this.getGameView().getPhase();
        if (ph != null) {
            if (ph.isBefore(PhaseType.END_OF_TURN)) {
                this.lastPlayer = this.getGameView().getPlayerTurn();
            }
            view.resetAllPhaseButtons();
            if (this.lastPlayer != null && PhaseType.CLEANUP.equals((Object)ph)) {
                VPhaseIndicator.PhaseLabel phaseLabel = MatchScreen.getPlayerPanel(this.lastPlayer).getPhaseIndicator().getLabel(ph);
                if (phaseLabel != null) {
                    phaseLabel.setActive(true);
                }
                if (GuiBase.isNetworkplay()) {
                    this.getGameView().updateNeedsPhaseRedrawn(this.lastPlayer, PhaseType.CLEANUP);
                }
            } else if (this.getGameView().getPlayerTurn() != null) {
                VPhaseIndicator.PhaseLabel phaseLabel = MatchScreen.getPlayerPanel(this.getGameView().getPlayerTurn()).getPhaseIndicator().getLabel(ph);
                if (phaseLabel != null) {
                    phaseLabel.setActive(true);
                }
                if (GuiBase.isNetworkplay()) {
                    this.getGameView().updateNeedsPhaseRedrawn(this.getGameView().getPlayerTurn(), ph);
                }
            }
        }
        if (GuiBase.isNetworkplay()) {
            this.checkStack();
        }
        if (ph != null && saveState && ph.isMain()) {
            phaseGameState = new GameState(){

                @Override
                public IPaperCard getPaperCard(String cardName, String setCode, int artID) {
                    return FModel.getMagicDb().getCommonCards().getCard(cardName, setCode, artID);
                }
            };
            try {
                phaseGameState.initFromGame(this.getGameView().getGame());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkStack() {
        view.getStack().checkEmptyStack();
    }

    public void showWinlose() {
        if (view.getViewWinLose() != null) {
            view.getViewWinLose().setVisible(true);
        }
    }

    @Override
    public void updateTurn(PlayerView player) {
    }

    @Override
    public void updatePlayerControl() {
        if (this.getLocalPlayerCount() == 1) {
            PlayerView player = view.getTopPlayerPanel().getPlayer();
            if (player.getMindSlaveMaster() != null) {
                view.getTopPlayerPanel().setSelectedZone(ZoneType.Hand);
            } else {
                view.getTopPlayerPanel().setSelectedTab(null);
            }
        }
    }

    @Override
    public void disableOverlay() {
    }

    @Override
    public void enableOverlay() {
    }

    @Override
    public void finishGame() {
        if (Forge.isMobileAdventureMode && Config.instance().getSettingData().disableWinLose) {
            MatchController.writeMatchPreferences();
            if (this.getGameView().isMatchOver()) {
                Forge.setCursor(null, "0");
                DuelScene.instance().GameEnd();
                if (!DuelScene.instance().hasCallbackExit()) {
                    DuelScene.instance().exitDuelScene();
                }
                return;
            }
            try {
                MatchController.getHostedMatch().continueMatch();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return;
        }
        if (this.hasLocalPlayers() || this.getGameView().isMatchOver()) {
            view.setViewWinLose(new ViewWinLose(this.getGameView()));
            view.getViewWinLose().setVisible(true);
        }
    }

    @Override
    public void updateStack() {
        view.getStack().update();
    }

    @Override
    public void setPanelSelection(CardView c) {
    }

    @Override
    public SpellAbilityView getAbilityToPlay(CardView hostCard, List<SpellAbilityView> abilities, ITriggerEvent triggerEvent) {
        if (abilities.isEmpty()) {
            return null;
        }
        if (abilities.size() == 1) {
            return abilities.get(0);
        }
        return SGuiChoose.oneOrNone(Forge.getLocalizer().getMessage("lblChooseAbilityToPlay", new Object[0]), abilities);
    }

    @Override
    public void showCombat() {
    }

    @Override
    public void showManaPool(PlayerView player) {
        VPlayerPanel playerPanel = MatchScreen.getPlayerPanel(player);
        VPlayerPanel.InfoTab selectedTab = playerPanel.getSelectedTab();
        VPlayerPanel.InfoTab manaPoolTab = playerPanel.getManaPoolTab();
        if (!manaPoolTab.equals(selectedTab)) {
            this.zonesToRestore.put(player, selectedTab);
        }
        playerPanel.setSelectedTab(manaPoolTab);
    }

    @Override
    public void hideManaPool(PlayerView player) {
        VPlayerPanel playerPanel = MatchScreen.getPlayerPanel(player);
        boolean doRestore = this.zonesToRestore.containsKey(player);
        VPlayerPanel.InfoTab zoneToRestore = this.zonesToRestore.remove(player);
        if (!playerPanel.getManaPoolTab().equals(playerPanel.getSelectedTab()) || !doRestore) {
            return;
        }
        playerPanel.setSelectedTab(zoneToRestore);
    }

    @Override
    public PlayerZoneUpdates openZones(PlayerView controller, Collection<ZoneType> zones, Map<PlayerView, Object> playersWithTargetables, boolean backupLastZones) {
        PlayerZoneUpdates updates = new PlayerZoneUpdates();
        if (zones.size() == 1) {
            ZoneType zoneType = zones.iterator().next();
            switch (zoneType) {
                case Battlefield: 
                case Command: {
                    playersWithTargetables.clear();
                }
            }
            this.lastZonesToRestore.clear();
            boolean result = true;
            for (PlayerView player : playersWithTargetables.keySet()) {
                VPlayerPanel playerPanel = MatchScreen.getPlayerPanel(player);
                if (backupLastZones) {
                    this.lastZonesToRestore.put(player, playerPanel.getSelectedTab());
                }
                playersWithTargetables.put(player, playerPanel.getSelectedTab());
                VPlayerPanel.InfoTab zoneTab = playerPanel.getZoneTab(zoneType);
                updates.add(new PlayerZoneUpdate(player, zoneType));
                if (zoneTab == null) continue;
                playerPanel.setSelectedTab(zoneTab);
            }
        }
        return updates;
    }

    @Override
    public void restoreOldZones(PlayerView playerView, PlayerZoneUpdates playerZoneUpdates) {
        for (PlayerZoneUpdate playerZoneUpdate : playerZoneUpdates) {
            PlayerView player = playerZoneUpdate.getPlayer();
            ZoneType zone = null;
            Iterator<ZoneType> iterator = playerZoneUpdate.getZones().iterator();
            if (iterator.hasNext()) {
                ZoneType type;
                zone = type = iterator.next();
            }
            VPlayerPanel playerPanel = MatchScreen.getPlayerPanel(player);
            if (zone != null) continue;
            playerPanel.hideSelectedTab();
        }
        for (Map.Entry entry : this.lastZonesToRestore.entrySet()) {
            if (entry.getKey() == null || ((PlayerView)entry.getKey()).getHasLost()) continue;
            VPlayerPanel p = MatchScreen.getPlayerPanel((PlayerView)entry.getKey());
            p.setSelectedTab((VPlayerPanel.InfoTab)entry.getValue());
        }
    }

    @Override
    public Map<CardView, Integer> assignCombatDamage(final CardView attacker, final List<CardView> blockers, final int damage, final GameEntityView defender, final boolean overrideOrder, final boolean maySkip) {
        return (Map)new WaitCallback<Map<CardView, Integer>>(){

            @Override
            public void run() {
                VAssignCombatDamage v = new VAssignCombatDamage(attacker, blockers, damage, defender, overrideOrder, maySkip, this);
                v.show();
            }
        }.invokeAndWait();
    }

    @Override
    public Map<Object, Integer> assignGenericAmount(final CardView effectSource, final Map<Object, Integer> targets, final int amount, final boolean atLeastOne, final String amountLabel) {
        return (Map)new WaitCallback<Map<Object, Integer>>(){

            @Override
            public void run() {
                VAssignGenericAmount v = new VAssignGenericAmount(effectSource, targets, amount, atLeastOne, amountLabel, this);
                v.show();
            }
        }.invokeAndWait();
    }

    @Override
    public void updateManaPool(Iterable<PlayerView> manaPoolUpdate) {
        for (PlayerView p : manaPoolUpdate) {
            MatchScreen.getPlayerPanel(p).updateManaPool();
        }
    }

    @Override
    public void updateLives(Iterable<PlayerView> livesUpdate) {
        for (PlayerView p : livesUpdate) {
            MatchScreen.getPlayerPanel(p).updateLife();
        }
    }

    @Override
    public void updateShards(Iterable<PlayerView> livesUpdate) {
        for (PlayerView p : livesUpdate) {
            MatchScreen.getPlayerPanel(p).updateShards();
        }
    }

    @Override
    public void updateZones(Iterable<PlayerZoneUpdate> zonesToUpdate) {
        view.updateZones(zonesToUpdate);
    }

    @Override
    public Iterable<PlayerZoneUpdate> tempShowZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        return view.tempShowZones(controller, zonesToUpdate);
    }

    @Override
    public void hideZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        view.hideZones(controller, zonesToUpdate);
    }

    @Override
    public void updateCards(Iterable<CardView> cards) {
        for (CardView card : cards) {
            view.updateSingleCard(card);
        }
    }

    @Override
    public void setSelectables(Iterable<CardView> cards) {
        super.setSelectables(cards);
        FThreads.invokeInEdtNowOrLater(() -> {
            for (PlayerView p : this.getGameView().getPlayers()) {
                if (p.getCards(ZoneType.Battlefield) != null) {
                    this.updateCards(p.getCards(ZoneType.Battlefield));
                }
                if (p.getCards(ZoneType.Hand) == null) continue;
                this.updateCards(p.getCards(ZoneType.Hand));
            }
        });
    }

    @Override
    public void clearSelectables() {
        super.clearSelectables();
        FThreads.invokeInEdtNowOrLater(() -> {
            for (PlayerView p : this.getGameView().getPlayers()) {
                if (p.getCards(ZoneType.Battlefield) != null) {
                    this.updateCards(p.getCards(ZoneType.Battlefield));
                }
                if (p.getCards(ZoneType.Hand) == null) continue;
                this.updateCards(p.getCards(ZoneType.Hand));
            }
        });
    }

    @Override
    public void afterGameEnd() {
        super.afterGameEnd();
        Forge.back(true);
        if (Forge.disposeTextures) {
            ImageCache.disposeTextures();
        }
    }

    public void resetPlayerPanels() {
        if (view != null) {
            view.forceRevalidate();
        }
    }

    private static void actuateMatchPreferences() {
        ForgePreferences prefs = FModel.getPreferences();
        for (int i = 0; i < view.getPlayerPanelsList().size() - 1; ++i) {
            VPhaseIndicator fvAi = view.getPlayerPanelsList().get(i).getPhaseIndicator();
            fvAi.getLabel(PhaseType.UPKEEP).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_UPKEEP));
            fvAi.getLabel(PhaseType.DRAW).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_DRAW));
            fvAi.getLabel(PhaseType.MAIN1).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_MAIN1));
            fvAi.getLabel(PhaseType.COMBAT_BEGIN).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_BEGINCOMBAT));
            fvAi.getLabel(PhaseType.COMBAT_DECLARE_ATTACKERS).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_DECLAREATTACKERS));
            fvAi.getLabel(PhaseType.COMBAT_DECLARE_BLOCKERS).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_DECLAREBLOCKERS));
            fvAi.getLabel(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_FIRSTSTRIKE));
            fvAi.getLabel(PhaseType.COMBAT_DAMAGE).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_COMBATDAMAGE));
            fvAi.getLabel(PhaseType.COMBAT_END).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_ENDCOMBAT));
            fvAi.getLabel(PhaseType.MAIN2).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_MAIN2));
            fvAi.getLabel(PhaseType.END_OF_TURN).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_EOT));
            fvAi.getLabel(PhaseType.CLEANUP).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_CLEANUP));
        }
        VPhaseIndicator fvHuman = view.getBottomPlayerPanel().getPhaseIndicator();
        fvHuman.getLabel(PhaseType.UPKEEP).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_UPKEEP));
        fvHuman.getLabel(PhaseType.DRAW).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_DRAW));
        fvHuman.getLabel(PhaseType.MAIN1).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_MAIN1));
        fvHuman.getLabel(PhaseType.COMBAT_BEGIN).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_BEGINCOMBAT));
        fvHuman.getLabel(PhaseType.COMBAT_DECLARE_ATTACKERS).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_DECLAREATTACKERS));
        fvHuman.getLabel(PhaseType.COMBAT_DECLARE_BLOCKERS).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_DECLAREBLOCKERS));
        fvHuman.getLabel(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_FIRSTSTRIKE));
        fvHuman.getLabel(PhaseType.COMBAT_DAMAGE).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_COMBATDAMAGE));
        fvHuman.getLabel(PhaseType.COMBAT_END).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_ENDCOMBAT));
        fvHuman.getLabel(PhaseType.MAIN2).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_MAIN2));
        fvHuman.getLabel(PhaseType.END_OF_TURN).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_EOT));
        fvHuman.getLabel(PhaseType.CLEANUP).setStopAtPhase(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_CLEANUP));
    }

    public static void writeMatchPreferences() {
        ForgePreferences prefs = FModel.getPreferences();
        VPhaseIndicator fvAi = view.getTopPlayerPanel().getPhaseIndicator();
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_UPKEEP, String.valueOf(fvAi.getLabel(PhaseType.UPKEEP).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_DRAW, String.valueOf(fvAi.getLabel(PhaseType.DRAW).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_MAIN1, String.valueOf(fvAi.getLabel(PhaseType.MAIN1).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_BEGINCOMBAT, String.valueOf(fvAi.getLabel(PhaseType.COMBAT_BEGIN).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_DECLAREATTACKERS, String.valueOf(fvAi.getLabel(PhaseType.COMBAT_DECLARE_ATTACKERS).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_DECLAREBLOCKERS, String.valueOf(fvAi.getLabel(PhaseType.COMBAT_DECLARE_BLOCKERS).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_FIRSTSTRIKE, String.valueOf(fvAi.getLabel(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_COMBATDAMAGE, String.valueOf(fvAi.getLabel(PhaseType.COMBAT_DAMAGE).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_ENDCOMBAT, String.valueOf(fvAi.getLabel(PhaseType.COMBAT_END).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_MAIN2, String.valueOf(fvAi.getLabel(PhaseType.MAIN2).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_EOT, String.valueOf(fvAi.getLabel(PhaseType.END_OF_TURN).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_CLEANUP, String.valueOf(fvAi.getLabel(PhaseType.CLEANUP).getStopAtPhase()));
        VPhaseIndicator fvHuman = view.getBottomPlayerPanel().getPhaseIndicator();
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_UPKEEP, String.valueOf(fvHuman.getLabel(PhaseType.UPKEEP).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_DRAW, String.valueOf(fvHuman.getLabel(PhaseType.DRAW).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_MAIN1, String.valueOf(fvHuman.getLabel(PhaseType.MAIN1).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_BEGINCOMBAT, String.valueOf(fvHuman.getLabel(PhaseType.COMBAT_BEGIN).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_DECLAREATTACKERS, String.valueOf(fvHuman.getLabel(PhaseType.COMBAT_DECLARE_ATTACKERS).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_DECLAREBLOCKERS, String.valueOf(fvHuman.getLabel(PhaseType.COMBAT_DECLARE_BLOCKERS).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_FIRSTSTRIKE, String.valueOf(fvHuman.getLabel(PhaseType.COMBAT_FIRST_STRIKE_DAMAGE).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_COMBATDAMAGE, String.valueOf(fvHuman.getLabel(PhaseType.COMBAT_DAMAGE).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_ENDCOMBAT, String.valueOf(fvHuman.getLabel(PhaseType.COMBAT_END).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_MAIN2, String.valueOf(fvHuman.getLabel(PhaseType.MAIN2).getStopAtPhase()));
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_EOT, fvHuman.getLabel(PhaseType.END_OF_TURN).getStopAtPhase());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_CLEANUP, fvHuman.getLabel(PhaseType.CLEANUP).getStopAtPhase());
        prefs.save();
    }

    @Override
    public void message(String message, String title) {
        SOptionPane.showMessageDialog(message, title);
    }

    @Override
    public void showErrorDialog(String message, String title) {
        SOptionPane.showErrorDialog(message, title);
    }

    @Override
    public boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes) {
        return SOptionPane.showConfirmDialog(message, title, yesButtonText, noButtonText, defaultYes);
    }

    @Override
    public int showOptionDialog(String message, String title, FSkinProp icon, List<String> options, int defaultOption) {
        return SOptionPane.showOptionDialog(message, title, icon, options, defaultOption);
    }

    @Override
    public String showInputDialog(String message, String title, FSkinProp icon, String initialInput, List<String> inputOptions, boolean isNumeric) {
        return SOptionPane.showInputDialog(message, title, icon, initialInput, inputOptions, isNumeric);
    }

    @Override
    public boolean confirm(CardView c, String question, boolean defaultIsYes, List<String> options) {
        List<String> optionsToUse = options == null ? ImmutableList.of(Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0])) : options;
        return FOptionPane.showCardOptionDialog(c, question, "", SOptionPane.INFORMATION_ICON, optionsToUse, defaultIsYes ? 0 : 1) == 0;
    }

    @Override
    public <T> List<T> getChoices(String message, int min2, int max, List<T> choices, T selected, Function<T, String> display) {
        return GuiBase.getInterface().getChoices(message, min2, max, choices, selected, display);
    }

    @Override
    public <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices, CardView referenceCard, boolean sideboardingMode) {
        return GuiBase.getInterface().order(title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices);
    }

    @Override
    public List<PaperCard> sideboard(final CardPool sideboard, final CardPool main, final String message) {
        return (List)new WaitCallback<List<PaperCard>>(){

            @Override
            public void run() {
                FSideboardDialog sideboardDialog = new FSideboardDialog(sideboard, main, this, message);
                sideboardDialog.show();
            }
        }.invokeAndWait();
    }

    @Override
    public GameEntityView chooseSingleEntityForEffect(final String title, final List<? extends GameEntityView> optionList, DelayedReveal delayedReveal, final boolean isOptional) {
        if (delayedReveal == null || Iterables.isEmpty(delayedReveal.getCards())) {
            if (isOptional) {
                return SGuiChoose.oneOrNone(title, optionList);
            }
            return SGuiChoose.one(title, optionList);
        }
        final TrackableCollection<CardView> revealList = delayedReveal.getCards();
        final String revealListCaption = StringUtils.capitalize(MessageUtil.formatMessage("{player's} " + delayedReveal.getZone().getTranslatedName(), delayedReveal.getOwner(), (Object)delayedReveal.getOwner()));
        MatchController.getView();
        VPlayerPanel.InfoTab revealListTab = MatchScreen.getPlayerPanels().values().iterator().next().getZoneTab(delayedReveal.getZone());
        final FSkinImageInterface revealListImage = revealListTab != null ? revealListTab.getIcon() : null;
        return (GameEntityView)new WaitCallback<GameEntityView>(){

            @Override
            public void run() {
                GameEntityPicker picker = new GameEntityPicker(title, optionList, revealList, revealListCaption, revealListImage, isOptional, this);
                picker.show();
            }
        }.invokeAndWait();
    }

    @Override
    public List<GameEntityView> chooseEntitiesForEffect(String title, List<? extends GameEntityView> optionList, int min2, int max, DelayedReveal delayedReveal) {
        int m1 = max >= 0 ? optionList.size() - max : -1;
        int m22 = min2 >= 0 ? optionList.size() - min2 : -1;
        return SGuiChoose.order(title, Forge.getLocalizer().getMessage("lblSelected", new Object[0]), m1, m22, optionList, null);
    }

    @Override
    public List<CardView> manipulateCardList(String title, Iterable<CardView> cards, Iterable<CardView> manipulable, boolean toTop, boolean toBottom, boolean toAnywhere) {
        System.err.println("Not implemented yet - should never be called");
        return null;
    }

    @Override
    public void setCard(CardView card) {
    }

    @Override
    public void setPlayerAvatar(LobbyPlayer player, IHasIcon ihi) {
        Forge.getAssets().avatarImages().put(player.getName(), ImageCache.getIcon(ihi));
    }

    @Override
    public boolean isUiSetToSkipPhase(PlayerView playerTurn, PhaseType phase) {
        return !view.stopAtPhase(playerTurn, phase);
    }

    public static HostedMatch hostMatch() {
        hostedMatch = new HostedMatch();
        return hostedMatch;
    }

    public static HostedMatch getHostedMatch() {
        return hostedMatch;
    }
}

