/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.limited;

import forge.Forge;
import forge.assets.FSkinFont;
import forge.deck.DeckGroup;
import forge.deck.FDeckEditor;
import forge.deck.io.DeckPreferences;
import forge.gamemodes.limited.SealedCardPoolGenerator;
import forge.gui.FThreads;
import forge.screens.LaunchScreen;
import forge.screens.home.NewGameMenu;
import forge.screens.limited.LoadSealedScreen;
import forge.toolbox.FLabel;
import forge.toolbox.FTextArea;
import forge.util.ThreadUtil;
import forge.util.Utils;

public class NewSealedScreen
extends LaunchScreen {
    private static final float PADDING = Utils.scale(10.0f);
    private final FTextArea lblDesc = this.add(new FTextArea(false, Forge.getLocalizer().getMessage("lblSealedText2", new Object[0]) + "\n\n" + Forge.getLocalizer().getMessage("lblSealedText3", new Object[0]) + "\n\n" + Forge.getLocalizer().getMessage("lblSealedText4", new Object[0])));

    public NewSealedScreen() {
        super(null, NewGameMenu.getMenu());
        this.lblDesc.setFont(FSkinFont.get(12));
        this.lblDesc.setTextColor(FLabel.getInlineLabelColor());
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        float h2 = height - y - PADDING;
        this.lblDesc.setBounds(x, y, w, h2);
    }

    @Override
    protected void startMatch() {
        ThreadUtil.invokeInGameThread(() -> {
            DeckGroup sealed = SealedCardPoolGenerator.generateSealedDeck(false);
            if (sealed == null) {
                return;
            }
            FThreads.invokeInEdtLater(() -> {
                DeckPreferences.setSealedDeck(sealed.getName());
                Forge.openScreen(new FDeckEditor(FDeckEditor.EditorType.Sealed, sealed.getName(), false));
                Forge.setBackScreen(new LoadSealedScreen(), false);
            });
        });
    }
}

