/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.limited;

import forge.Forge;
import forge.assets.FSkinFont;
import forge.deck.FDeckEditor;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gui.FThreads;
import forge.gui.util.SGuiChoose;
import forge.screens.LaunchScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.NewGameMenu;
import forge.screens.limited.DraftingProcessScreen;
import forge.toolbox.FLabel;
import forge.toolbox.FTextArea;
import forge.util.ThreadUtil;
import forge.util.Utils;

public class NewDraftScreen
extends LaunchScreen {
    private static final float PADDING = Utils.scale(10.0f);
    private final FTextArea lblDesc = this.add(new FTextArea(false, Forge.getLocalizer().getMessage("lblDraftText1", new Object[0]) + "\n\n" + Forge.getLocalizer().getMessage("lblDraftText2", new Object[0]) + "\n\n" + Forge.getLocalizer().getMessage("lblDraftText3", new Object[0])));

    public NewDraftScreen() {
        super(null, NewGameMenu.getMenu());
        this.lblDesc.setFont(FSkinFont.get(12));
        this.lblDesc.setTextColor(FLabel.getInlineLabelColor());
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        float h2 = height - y - PADDING;
        this.lblDesc.setBounds(x, y, w, h2);
    }

    @Override
    protected void startMatch() {
        ThreadUtil.invokeInGameThread(() -> {
            LimitedPoolType poolType2 = SGuiChoose.oneOrNone(Forge.getLocalizer().getMessage("lblChooseDraftFormat", new Object[0]), LimitedPoolType.values(true));
            if (poolType2 == null) {
                return;
            }
            BoosterDraft draft = BoosterDraft.createDraft(poolType2);
            if (draft == null) {
                return;
            }
            FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewDraft", new Object[0]), true, () -> Forge.openScreen(new DraftingProcessScreen(draft, FDeckEditor.EditorType.Draft, null))));
        });
    }
}

