/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import forge.Forge;
import forge.animation.GifAnimation;
import forge.assets.FSkinFont;
import forge.localinstance.properties.ForgeConstants;
import forge.screens.LaunchScreen;
import forge.screens.home.NewGameMenu;
import forge.toolbox.FLabel;
import forge.toolbox.FTextArea;
import forge.util.Callback;
import forge.util.Utils;

public class AdventureScreen
extends LaunchScreen {
    private static final float PADDING = Utils.scale(10.0f);
    private boolean loaded = false;
    private static GifAnimation animation = null;
    private final FTextArea lblDesc = new FTextArea(false, Forge.getLocalizer().getMessage("lblAdventureDescription", new Object[0]), animation);

    public AdventureScreen() {
        super(null, NewGameMenu.getMenu());
        this.lblDesc.setFont(FSkinFont.get(12));
        this.lblDesc.setTextColor(FLabel.getInlineLabelColor());
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        float h2 = height - y - PADDING;
        this.lblDesc.setBounds(x, y, w, h2);
    }

    @Override
    public void onActivate() {
        if (!this.loaded) {
            this.loaded = true;
            this.add(this.lblDesc);
        }
        if (animation != null) {
            animation.start();
        }
        Forge.startContinuousRendering();
        super.onActivate();
    }

    @Override
    public void onSwitchAway(Callback<Boolean> canSwitchCallback) {
        if (animation != null) {
            animation.stop();
        }
        Forge.stopContinuousRendering();
        super.onSwitchAway(canSwitchCallback);
    }

    @Override
    protected void startMatch() {
        Forge.isMobileAdventureMode = true;
        Forge.switchToAdventure();
    }

    public static void preload() {
        String demo = ForgeConstants.EFFECTS_DIR + "demo.gif";
        if (Gdx.files.absolute(demo).exists()) {
            animation = new GifAnimation(demo, Animation.PlayMode.LOOP);
        }
    }

    public static void dispose() {
        if (animation != null) {
            animation.dispose();
        }
        animation = null;
    }
}

