/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.gauntlet;

import forge.Forge;
import forge.assets.FSkinFont;
import forge.deck.Deck;
import forge.deck.DeckType;
import forge.deck.FDeckChooser;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gamemodes.gauntlet.GauntletUtil;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.LaunchScreen;
import forge.screens.home.NewGameMenu;
import forge.toolbox.FLabel;
import forge.toolbox.FTextArea;
import forge.toolbox.GuiChoose;
import forge.toolbox.ListChooser;
import forge.util.Callback;
import forge.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NewGauntletScreen
extends LaunchScreen {
    private static final float PADDING = Utils.scale(10.0f);
    private final FTextArea lblDesc = this.add(new FTextArea(false, Forge.getLocalizer().getMessage("lblGauntletText1", new Object[0]) + "\n\n" + Forge.getLocalizer().getMessage("lblGauntletText2", new Object[0]) + "\n\n" + Forge.getLocalizer().getMessage("lblGauntletText3", new Object[0])));

    public NewGauntletScreen() {
        super(null, NewGameMenu.getMenu());
        this.lblDesc.setFont(FSkinFont.get(12));
        this.lblDesc.setTextColor(FLabel.getInlineLabelColor());
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        float h2 = height - y - PADDING;
        this.lblDesc.setBounds(x, y, w, h2);
    }

    @Override
    protected void startMatch() {
        GuiChoose.oneOrNone(Forge.getLocalizer().getMessage("lblSelectGauntletType", new Object[0]), new String[]{Forge.getLocalizer().getMessage("lblQuickGauntlet", new Object[0]), Forge.getLocalizer().getMessage("lblCustomGauntlet", new Object[0]), Forge.getLocalizer().getMessage("lblGauntletContest", new Object[0]), Forge.getLocalizer().getMessage("lblCommanderGauntlet", new Object[0])}, new Callback<String>(){

            @Override
            public void run(String result) {
                if (result == null) {
                    return;
                }
                if (Forge.getLocalizer().getMessage("lblQuickGauntlet", new Object[0]).equals(result)) {
                    NewGauntletScreen.this.createQuickGauntlet();
                } else if (Forge.getLocalizer().getMessage("lblCustomGauntlet", new Object[0]).equals(result)) {
                    NewGauntletScreen.this.createCustomGauntlet();
                } else if (Forge.getLocalizer().getMessage("lblCommanderGauntlet", new Object[0]).equals(result)) {
                    NewGauntletScreen.this.createCommandGauntlet();
                } else {
                    NewGauntletScreen.this.createGauntletContest();
                }
            }
        });
    }

    private void createCommandGauntlet() {
        GuiChoose.getInteger(Forge.getLocalizer().getMessage("lblHowManyOpponents", new Object[0]), 3, 50, new Callback<Integer>(){

            @Override
            public void run(final Integer numOpponents) {
                if (numOpponents == null) {
                    return;
                }
                ListChooser<DeckType> chooser = new ListChooser<DeckType>(Forge.getLocalizer().getMessage("lblChooseAllowedDeckTypeOpponents", new Object[0]), 0, 11, Arrays.asList(DeckType.COMMANDER_DECK, DeckType.PRECON_COMMANDER_DECK, DeckType.RANDOM_COMMANDER_DECK), null, new Callback<List<DeckType>>(){

                    @Override
                    public void run(final List<DeckType> allowedDeckTypes) {
                        if (allowedDeckTypes == null || allowedDeckTypes.isEmpty()) {
                            return;
                        }
                        FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectYourDeck", new Object[0]), GameType.Commander, false, new Callback<Deck>(){

                            @Override
                            public void run(Deck userDeck) {
                                if (userDeck == null) {
                                    return;
                                }
                                GauntletData gauntlet = GauntletUtil.createCommanderGauntlet(userDeck, numOpponents, allowedDeckTypes, null);
                                NewGauntletScreen.this.launchGauntlet(gauntlet);
                            }
                        });
                    }
                });
                chooser.show(null, false);
            }
        });
    }

    private void createQuickGauntlet() {
        GuiChoose.getInteger(Forge.getLocalizer().getMessage("lblHowManyOpponents", new Object[0]), 3, 50, new Callback<Integer>(){

            @Override
            public void run(final Integer numOpponents) {
                if (numOpponents == null) {
                    return;
                }
                ListChooser<DeckType> chooser = new ListChooser<DeckType>(Forge.getLocalizer().getMessage("lblChooseAllowedDeckTypeOpponents", new Object[0]), 0, 11, Arrays.asList(DeckType.CUSTOM_DECK, DeckType.PRECONSTRUCTED_DECK, DeckType.QUEST_OPPONENT_DECK, DeckType.COLOR_DECK, DeckType.STANDARD_COLOR_DECK, DeckType.STANDARD_CARDGEN_DECK, DeckType.MODERN_COLOR_DECK, DeckType.PIONEER_CARDGEN_DECK, DeckType.HISTORIC_CARDGEN_DECK, DeckType.MODERN_CARDGEN_DECK, DeckType.LEGACY_CARDGEN_DECK, DeckType.VINTAGE_CARDGEN_DECK, DeckType.PAUPER_CARDGEN_DECK, DeckType.THEME_DECK), null, new Callback<List<DeckType>>(){

                    @Override
                    public void run(final List<DeckType> allowedDeckTypes) {
                        if (allowedDeckTypes == null || allowedDeckTypes.isEmpty()) {
                            return;
                        }
                        FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectYourDeck", new Object[0]), GameType.Gauntlet, false, new Callback<Deck>(){

                            @Override
                            public void run(Deck userDeck) {
                                if (userDeck == null) {
                                    return;
                                }
                                GauntletData gauntlet = GauntletUtil.createQuickGauntlet(userDeck, numOpponents, allowedDeckTypes, null);
                                NewGauntletScreen.this.launchGauntlet(gauntlet);
                            }
                        });
                    }
                });
                chooser.show(null, false);
            }
        });
    }

    private void createCustomGauntlet() {
        GuiChoose.getInteger(Forge.getLocalizer().getMessage("lblHowManyOpponents", new Object[0]), 3, 50, new Callback<Integer>(){

            @Override
            public void run(Integer numOpponents) {
                if (numOpponents == null) {
                    return;
                }
                GauntletData gauntlet = new GauntletData();
                gauntlet.setDecks(new ArrayList<Deck>());
                NewGauntletScreen.this.promptForAiDeck(gauntlet, numOpponents);
            }
        });
    }

    private void promptForAiDeck(final GauntletData gauntlet, final int numOpponents) {
        final int opponentNum = gauntlet.getDecks().size() + 1;
        FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectDeckForOpponent", new Object[0]) + " " + opponentNum + " / " + numOpponents, GameType.Gauntlet, true, new Callback<Deck>(){

            @Override
            public void run(Deck aiDeck) {
                if (aiDeck == null) {
                    return;
                }
                gauntlet.getDecks().add(aiDeck);
                gauntlet.getEventNames().add(aiDeck.getName());
                if (opponentNum < numOpponents) {
                    NewGauntletScreen.this.promptForAiDeck(gauntlet, numOpponents);
                } else {
                    FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectYourDeck", new Object[0]), GameType.Gauntlet, false, new Callback<Deck>(){

                        @Override
                        public void run(Deck userDeck) {
                            if (userDeck == null) {
                                return;
                            }
                            gauntlet.setUserDeck(userDeck);
                            GauntletUtil.setDefaultGauntletName(gauntlet, "Custom_");
                            NewGauntletScreen.this.launchGauntlet(gauntlet);
                        }
                    });
                }
            }
        });
    }

    private void createGauntletContest() {
        File[] files = GauntletIO.getGauntletFilesLocked();
        ArrayList<GauntletData> contests = new ArrayList<GauntletData>();
        for (File f : files) {
            GauntletData gd = GauntletIO.loadGauntlet(f);
            if (gd == null) continue;
            contests.add(gd);
        }
        GuiChoose.oneOrNone(Forge.getLocalizer().getMessage("lblSelectGauntletContest", new Object[0]), contests, new Callback<GauntletData>(){

            @Override
            public void run(final GauntletData contest) {
                if (contest == null) {
                    return;
                }
                FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectYourDeck", new Object[0]), GameType.Gauntlet, false, new Callback<Deck>(){

                    @Override
                    public void run(Deck userDeck) {
                        if (userDeck == null) {
                            return;
                        }
                        GauntletData gauntlet = new GauntletData();
                        gauntlet.setDecks(new ArrayList<Deck>(contest.getDecks()));
                        gauntlet.setEventNames(new ArrayList<String>(contest.getEventNames()));
                        gauntlet.setUserDeck(userDeck);
                        GauntletUtil.setDefaultGauntletName(gauntlet, contest.getDisplayName() + "_");
                        NewGauntletScreen.this.launchGauntlet(gauntlet);
                    }
                });
            }
        });
    }

    private void launchGauntlet(GauntletData gauntlet) {
        RegisteredPlayer humanPlayer;
        if (gauntlet == null) {
            return;
        }
        FModel.setGauntletData(gauntlet);
        gauntlet.reset();
        ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
        if (gauntlet.isCommanderGauntlet()) {
            humanPlayer = RegisteredPlayer.forCommander(gauntlet.getUserDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
            players.add(RegisteredPlayer.forCommander(gauntlet.getDecks().get(gauntlet.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()));
        } else {
            humanPlayer = new RegisteredPlayer(gauntlet.getUserDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
            players.add(new RegisteredPlayer(gauntlet.getDecks().get(gauntlet.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()));
        }
        players.add(humanPlayer);
        gauntlet.startRound(players, humanPlayer);
    }
}

