/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.gauntlet;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.deck.Deck;
import forge.deck.FDeckChooser;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.gui.util.SOptionPane;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.LaunchScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.LoadGameMenu;
import forge.screens.home.NewGameMenu;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FButton;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.util.Callback;
import forge.util.ThreadUtil;
import forge.util.Utils;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LoadGauntletScreen
extends LaunchScreen {
    private static final float ITEM_HEIGHT = Utils.AVG_FINGER_HEIGHT;
    private static final float PADDING = Utils.AVG_FINGER_HEIGHT * 0.1f;
    private static final FSkinColor SEL_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    private final GauntletFileLister lstGauntlets = this.add(new GauntletFileLister());
    private final FButton btnNewGauntlet = this.add(new FButton(Forge.getLocalizer().getMessage("lblNewQuest", new Object[0])));
    private final FButton btnRenameGauntlet = this.add(new FButton(Forge.getLocalizer().getMessage("lblRename", new Object[0])));
    private final FButton btnDeleteGauntlet = this.add(new FButton(Forge.getLocalizer().getMessage("lblDelete", new Object[0])));

    public LoadGauntletScreen() {
        super(null, LoadGameMenu.getMenu());
        this.btnNewGauntlet.setFont(FSkinFont.get(16));
        this.btnNewGauntlet.setCommand(event -> NewGameMenu.NewGameScreen.Gauntlet.open());
        this.btnRenameGauntlet.setFont(this.btnNewGauntlet.getFont());
        this.btnRenameGauntlet.setCommand(event -> this.renameGauntlet(this.lstGauntlets.getSelectedGauntlet()));
        this.btnDeleteGauntlet.setFont(this.btnNewGauntlet.getFont());
        this.btnDeleteGauntlet.setCommand(event -> this.deleteGauntlet(this.lstGauntlets.getSelectedGauntlet()));
    }

    @Override
    public void onActivate() {
        File[] files = GauntletIO.getGauntletFilesUnlocked(null);
        ArrayList<GauntletData> data = new ArrayList<GauntletData>();
        for (File f : files) {
            GauntletData gd = GauntletIO.loadGauntlet(f);
            if (gd == null) continue;
            data.add(gd);
        }
        this.lstGauntlets.setGauntlets(data);
    }

    private void updateButtons() {
        boolean enabled = !this.lstGauntlets.isEmpty();
        this.btnRenameGauntlet.setEnabled(enabled);
        this.btnDeleteGauntlet.setEnabled(enabled);
        this.btnStart.setEnabled(enabled);
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float buttonWidth = (width - 2.0f * PADDING) / 3.0f;
        float buttonHeight = this.btnNewGauntlet.getAutoSizeBounds().height * 1.2f;
        float y = startY;
        this.lstGauntlets.setBounds(0.0f, y, width, height - y - buttonHeight - PADDING);
        float x = 0.0f;
        this.btnNewGauntlet.setBounds(x, y += this.lstGauntlets.getHeight() + PADDING, buttonWidth, buttonHeight);
        this.btnRenameGauntlet.setBounds(x += buttonWidth + PADDING, y, buttonWidth, buttonHeight);
        this.btnDeleteGauntlet.setBounds(x += buttonWidth + PADDING, y, buttonWidth, buttonHeight);
    }

    @Override
    protected void startMatch() {
        final GauntletData gauntlet = this.lstGauntlets.getSelectedGauntlet();
        if (gauntlet == null) {
            FOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblYouMustCreateAndSelectGauntlet", new Object[0]));
            return;
        }
        FModel.setGauntletData(gauntlet);
        Deck userDeck = gauntlet.getUserDeck();
        if (userDeck == null) {
            FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectGauntletDeck", new Object[0]), gauntlet.isCommanderGauntlet() ? GameType.CommanderGauntlet : GameType.Gauntlet, false, new Callback<Deck>(){

                @Override
                public void run(Deck result) {
                    if (result != null) {
                        gauntlet.setUserDeck(result);
                        GauntletIO.saveGauntlet(gauntlet);
                    }
                }
            });
            return;
        }
        LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, () -> {
            GauntletData gauntlet1 = FModel.getGauntletData();
            ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
            RegisteredPlayer humanPlayer = gauntlet1.isCommanderGauntlet() ? RegisteredPlayer.forCommander(gauntlet1.getUserDeck()).setPlayer(GamePlayerUtil.getGuiPlayer()) : new RegisteredPlayer(gauntlet1.getUserDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
            players.add(humanPlayer);
            players.add(gauntlet1.isCommanderGauntlet() ? RegisteredPlayer.forCommander(gauntlet1.getDecks().get(gauntlet1.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()) : new RegisteredPlayer(gauntlet1.getDecks().get(gauntlet1.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()));
            gauntlet1.startRound(players, humanPlayer);
        });
    }

    private void renameGauntlet(GauntletData gauntlet) {
        if (gauntlet == null) {
            return;
        }
        ThreadUtil.invokeInGameThread(() -> {
            String gauntletName;
            String oldGauntletName = gauntlet.getName();
            while (true) {
                if ((gauntletName = SOptionPane.showInputDialog(Forge.getLocalizer().getMessage("lblEnterNewGauntletGameName", new Object[0]), Forge.getLocalizer().getMessage("lblRenameGauntlet", new Object[0]), null, oldGauntletName)) == null) {
                    return;
                }
                if ((gauntletName = QuestUtil.cleanString(gauntletName)).equals(oldGauntletName)) {
                    return;
                }
                if (gauntletName.isEmpty()) {
                    SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblPleaseSpecifyGauntletName", new Object[0]));
                    continue;
                }
                boolean exists = false;
                for (GauntletData gauntletData : this.lstGauntlets) {
                    if (!gauntletData.getName().equalsIgnoreCase(gauntletName)) continue;
                    exists = true;
                    break;
                }
                if (!exists) break;
                SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblGauntletNameExistsPleasePickAnotherName", new Object[0]));
            }
            String newGauntletName = gauntletName;
            FThreads.invokeInEdtLater(() -> {
                gauntlet.rename(newGauntletName);
                this.lstGauntlets.refresh();
                this.lstGauntlets.setSelectedGauntlet(gauntlet);
            });
        });
    }

    private void deleteGauntlet(GauntletData gauntlet) {
        if (gauntlet == null) {
            return;
        }
        ThreadUtil.invokeInGameThread(() -> {
            if (!SOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblAreYouSuerDeleteGauntlet", gauntlet.getName()), Forge.getLocalizer().getMessage("lblDeleteGauntlet", new Object[0]), Forge.getLocalizer().getMessage("lblDelete", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]))) {
                return;
            }
            GauntletIO.getGauntletFile(gauntlet).delete();
            this.lstGauntlets.removeGauntlet(gauntlet);
        });
    }

    private class GauntletFileLister
    extends FList<GauntletData> {
        private int selectedIndex = 0;
        private List<GauntletData> gauntlets;

        private GauntletFileLister() {
            this.setListItemRenderer(new FList.ListItemRenderer<GauntletData>(){

                @Override
                public boolean tap(Integer index, GauntletData value, float x, float y, int count) {
                    if (count == 2) {
                        LoadGauntletScreen.this.startMatch();
                    } else {
                        GauntletFileLister.this.selectedIndex = index;
                    }
                    return true;
                }

                @Override
                public float getItemHeight() {
                    return ITEM_HEIGHT;
                }

                @Override
                public void drawValue(Graphics g2, Integer index, GauntletData value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                    float offset = SettingsScreen.getInsets(w) - FList.PADDING;
                    x += offset;
                    y += offset;
                    w -= 2.0f * offset;
                    float totalHeight = h2 -= 2.0f * offset;
                    String name = value.getName();
                    h2 = font.getMultiLineBounds((CharSequence)name).height + SettingsScreen.SETTING_PADDING;
                    int completed = value.getCompleted();
                    int opponents = value.getDecks().size();
                    NumberFormat percent = NumberFormat.getPercentInstance();
                    String progress = completed + " / " + opponents + " (" + percent.format((double)completed / (double)opponents) + ")";
                    float progressWidth = font.getBounds((CharSequence)progress).width + SettingsScreen.SETTING_PADDING;
                    g2.drawText(name, font, foreColor, x, y, w - progressWidth, h2, false, 8, false);
                    g2.drawText(progress, font, foreColor, x, y, w, h2, false, 16, false);
                    h2 = totalHeight - h2 + SettingsScreen.getInsets(w);
                    String timestamp = value.getTimestamp();
                    font = FSkinFont.get(12);
                    float timestampWidth = font.getBounds((CharSequence)timestamp).width + SettingsScreen.SETTING_PADDING;
                    g2.drawText(value.getUserDeck() == null ? "(none)" : value.getUserDeck().getName(), font, SettingsScreen.DESC_COLOR, x, y += (h2 += SettingsScreen.SETTING_PADDING), w - timestampWidth, h2, false, 8, false);
                    g2.drawText(timestamp, font, SettingsScreen.DESC_COLOR, x + w - timestampWidth + SettingsScreen.SETTING_PADDING, y, w, h2, false, 8, false);
                }
            });
        }

        @Override
        protected FSkinColor getItemFillColor(int index) {
            if (index == this.selectedIndex) {
                return SEL_COLOR;
            }
            return null;
        }

        public void setGauntlets(List<GauntletData> gauntlets0) {
            this.gauntlets = gauntlets0;
            this.refresh();
            this.setSelectedIndex(0);
            LoadGauntletScreen.this.updateButtons();
        }

        public void removeGauntlet(GauntletData gauntlet) {
            if (this.gauntlets == null) {
                return;
            }
            this.removeItem(gauntlet);
            this.gauntlets.remove(gauntlet);
            if (this.selectedIndex == this.gauntlets.size()) {
                --this.selectedIndex;
            }
            this.revalidate();
            LoadGauntletScreen.this.updateButtons();
        }

        public void refresh() {
            ArrayList<GauntletData> sorted = new ArrayList<GauntletData>(this.gauntlets);
            sorted.sort(Comparator.comparing(x -> x.getName().toLowerCase()));
            this.setListData(sorted);
        }

        public boolean setSelectedIndex(int i0) {
            if (i0 >= this.getCount()) {
                return false;
            }
            this.selectedIndex = i0;
            this.scrollIntoView(i0);
            return true;
        }

        public GauntletData getSelectedGauntlet() {
            if (this.selectedIndex == -1) {
                return null;
            }
            return (GauntletData)this.getItemAt(this.selectedIndex);
        }

        public boolean setSelectedGauntlet(GauntletData gauntlet) {
            for (int i = 0; i < this.getCount(); ++i) {
                if (this.getItemAt(i) != gauntlet) continue;
                this.selectedIndex = i;
                this.scrollIntoView(i);
                return true;
            }
            return false;
        }
    }
}

