/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.constructed;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.FTextureRegionImage;
import forge.screens.FScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.MyRandom;
import forge.util.Utils;
import java.util.List;
import java.util.Map;

public class SleevesSelector
extends FScreen {
    private static final float PADDING = Utils.scale(5.0f);
    private static final int COLUMNS = 5;
    private final int currentIndex;
    private final List<Integer> usedSleeves;
    private final Callback<Integer> callback;
    private final FScrollPane scroller = new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            int rowCount = 0;
            float x = PADDING;
            float y = PADDING;
            float labelSize = (visibleWidth - 6.0f * PADDING) / 5.0f;
            for (FDisplayObject lbl : SleevesSelector.this.scroller.getChildren()) {
                if (rowCount == 5) {
                    x = PADDING;
                    y += labelSize + PADDING;
                    rowCount = 0;
                }
                lbl.setBounds(x, y, labelSize, labelSize);
                x += labelSize + PADDING;
                ++rowCount;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y + labelSize + PADDING);
        }
    };

    public static int getRandomSleeves(List<Integer> usedSleeves) {
        int random = 0;
        while (usedSleeves.contains(random = MyRandom.getRandom().nextInt(FSkin.getSleeves().size()))) {
        }
        return random;
    }

    public static void show(String playerName, int currentIndex0, List<Integer> usedSleeves0, Callback<Integer> callback0) {
        SleevesSelector selector = new SleevesSelector(playerName, currentIndex0, usedSleeves0, callback0);
        Forge.openScreen(selector);
    }

    private SleevesSelector(String playerName, int currentIndex0, List<Integer> usedSleeves0, Callback<Integer> callback0) {
        super(Forge.getLocalizer().getMessage("lblSelectSleevesFroPlayer", playerName));
        this.currentIndex = currentIndex0;
        this.usedSleeves = usedSleeves0;
        this.callback = callback0;
        this.addSleevesLabel(FSkinImage.UNKNOWN, -1);
        Map<Integer, TextureRegion> sleeveMap = FSkin.getSleeves();
        this.addSleevesLabel(new FTextureRegionImage(sleeveMap.get(this.currentIndex)), this.currentIndex);
        for (Integer i : sleeveMap.keySet()) {
            if (this.currentIndex == i) continue;
            this.addSleevesLabel(new FTextureRegionImage(sleeveMap.get(i)), i);
        }
        this.add(this.scroller);
    }

    private void addSleevesLabel(FImage img, int index) {
        FLabel lbl = new FLabel.Builder().icon(img).iconScaleFactor(0.99f).align(1).iconInBackground(true).selectable(true).selected(this.currentIndex == index).build();
        if (index == -1) {
            lbl.setCommand(e -> {
                this.callback.run(SleevesSelector.getRandomSleeves(this.usedSleeves));
                Forge.back();
            });
        } else {
            lbl.setCommand(e -> {
                this.callback.run(index);
                Forge.back();
            });
        }
        this.scroller.add(lbl);
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.scroller.setBounds(0.0f, startY, width, height - startY);
    }
}

