/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.constructed;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import forge.Forge;
import forge.Graphics;
import forge.ai.AIOption;
import forge.assets.FSkin;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FTextureRegionImage;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckType;
import forge.deck.FDeckChooser;
import forge.deck.FVanguardChooser;
import forge.game.GameType;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.event.UpdateLobbyPlayerEvent;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.DeckManager;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.constructed.AvatarSelector;
import forge.screens.constructed.LobbyScreen;
import forge.screens.constructed.SleevesSelector;
import forge.toolbox.FComboBox;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTextField;
import forge.toolbox.FToggleSwitch;
import forge.util.Callback;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.NameGenerator;
import forge.util.TextUtil;
import forge.util.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PlayerPanel
extends FContainer {
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static final float PADDING = Utils.scale(5.0f);
    private static final FSkinFont LABEL_FONT = FSkinFont.get(14);
    private final LobbyScreen screen;
    private final int index;
    private final boolean allowNetworking;
    private boolean mayEdit = true;
    private boolean isReady;
    private boolean mayControl;
    private boolean mayRemove;
    private boolean useAiSimulation;
    private LobbySlotType type = LobbySlotType.LOCAL;
    private final FLabel nameRandomiser;
    private final FLabel avatarLabel = new FLabel.Builder().opaque(true).iconScaleFactor(0.99f).selectable().alphaComposite(1.0f).iconInBackground(true).build();
    private final FLabel sleeveLabel = new FLabel.Builder().opaque(true).iconScaleFactor(0.99f).selectable().alphaComposite(1.0f).iconInBackground(true).build();
    private int avatarIndex;
    private int sleeveIndex;
    private final FTextField txtPlayerName = new FTextField(Forge.getLocalizer().getMessage("lblPlayerName", new Object[0]));
    private final FToggleSwitch humanAiSwitch;
    private final FToggleSwitch devModeSwitch;
    private FComboBox<Object> cbTeam = new FComboBox();
    private FComboBox<Object> cbArchenemyTeam = new FComboBox();
    private final FLabel btnDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblLoadingDeck", new Object[0])).build();
    private final FLabel btnSchemeDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblSchemeDeckRandomGenerated", new Object[0])).build();
    private final FLabel btnCommanderDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblCommanderDeckRandomGenerated", new Object[0])).build();
    private final FLabel btnOathbreakDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblOathbreakerDeckRandomGenerated", new Object[0])).build();
    private final FLabel btnTinyLeadersDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblTinyLeadersDeckRandomGenerated", new Object[0])).build();
    private final FLabel btnBrawlDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblBrawlDeckRandomGenerated", new Object[0])).build();
    private final FLabel btnPlanarDeck = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblPlanarDeckRandomGenerated", new Object[0])).build();
    private final FLabel btnVanguardAvatar = new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblVanguardAvatarRandom", new Object[0])).build();
    private final FDeckChooser deckChooser;
    private final FDeckChooser lstSchemeDecks;
    private final FDeckChooser lstCommanderDecks;
    private final FDeckChooser lstOathbreakerDecks;
    private final FDeckChooser lstTinyLeadersDecks;
    private final FDeckChooser lstBrawlDecks;
    private final FDeckChooser lstPlanarDecks;
    private final FVanguardChooser lstVanguardAvatars;
    private final FEvent.FEventHandler humanAiSwitched = new FEvent.FEventHandler(){

        @Override
        public void handleEvent(FEvent e) {
            boolean toggled = PlayerPanel.this.humanAiSwitch.isToggled();
            if (PlayerPanel.this.allowNetworking) {
                PlayerPanel.this.setIsReady(toggled);
                PlayerPanel.this.screen.setReady(PlayerPanel.this.index, toggled);
            } else {
                PlayerPanel.this.type = toggled ? LobbySlotType.AI : LobbySlotType.LOCAL;
                PlayerPanel.this.onIsAiChanged(toggled);
                LobbySlot slot = PlayerPanel.this.screen.getLobby().getSlot(PlayerPanel.this.index);
                slot.setType(PlayerPanel.this.type);
                PlayerPanel.this.screen.update(PlayerPanel.this.index, PlayerPanel.this.type);
                PlayerPanel.this.setMayEdit(PlayerPanel.this.screen.getLobby().mayEdit(PlayerPanel.this.index));
                PlayerPanel.this.setAvatarIndex(slot.getAvatarIndex());
                PlayerPanel.this.setSleeveIndex(slot.getSleeveIndex());
                PlayerPanel.this.setPlayerName(slot.getName());
            }
        }
    };
    private final FEvent.FEventHandler devModeSwitched = new FEvent.FEventHandler(){

        @Override
        public void handleEvent(FEvent e) {
            boolean toggled = PlayerPanel.this.devModeSwitch.isToggled();
            prefs.setPref(ForgePreferences.FPref.DEV_MODE_ENABLED, String.valueOf(toggled));
            ForgePreferences.DEV_MODE = toggled;
            prefs.save();
            PlayerPanel.this.screen.setDevMode(PlayerPanel.this.index);
        }
    };
    private FEvent.FEventHandler nameChangedHandler = new FEvent.FEventHandler(){

        @Override
        public void handleEvent(FEvent e) {
            FDisplayObject source = e.getSource();
            if (source instanceof FTextField) {
                FTextField nField = (FTextField)source;
                String newName = nField.getText().trim();
                if (PlayerPanel.this.index == 0 && !StringUtils.isBlank(newName) && StringUtils.isAlphanumericSpace(newName) && prefs.getPref(ForgePreferences.FPref.PLAYER_NAME) != newName) {
                    prefs.setPref(ForgePreferences.FPref.PLAYER_NAME, newName);
                    prefs.save();
                    PlayerPanel.this.screen.getLobby().applyToSlot(PlayerPanel.this.index, UpdateLobbyPlayerEvent.nameUpdate(newName));
                    if (PlayerPanel.this.allowNetworking) {
                        PlayerPanel.this.screen.firePlayerChangeListener(PlayerPanel.this.index);
                    }
                }
            }
        }
    };
    private FEvent.FEventHandler avatarCommand = new FEvent.FEventHandler(){

        @Override
        public void handleEvent(FEvent e) {
            AvatarSelector.show(PlayerPanel.this.getPlayerName(), PlayerPanel.this.avatarIndex, PlayerPanel.this.screen.getUsedAvatars(), new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    PlayerPanel.this.setAvatarIndex(result);
                    if (PlayerPanel.this.index < 2) {
                        PlayerPanel.this.screen.updateAvatar(PlayerPanel.this.index, result);
                        PlayerPanel.this.screen.updateAvatarPrefs();
                    }
                    if (PlayerPanel.this.allowNetworking) {
                        PlayerPanel.this.screen.firePlayerChangeListener(PlayerPanel.this.index);
                    }
                }
            });
        }
    };
    private FEvent.FEventHandler sleeveCommand = new FEvent.FEventHandler(){

        @Override
        public void handleEvent(FEvent e) {
            SleevesSelector.show(PlayerPanel.this.getPlayerName(), PlayerPanel.this.sleeveIndex, PlayerPanel.this.screen.getUsedSleeves(), new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    PlayerPanel.this.setSleeveIndex(result);
                    if (PlayerPanel.this.index < 2) {
                        PlayerPanel.this.screen.updateSleeve(PlayerPanel.this.index, result);
                        PlayerPanel.this.screen.updateSleevePrefs();
                    }
                    if (PlayerPanel.this.allowNetworking) {
                        PlayerPanel.this.screen.firePlayerChangeListener(PlayerPanel.this.index);
                    }
                }
            });
        }
    };
    private FEvent.FEventHandler teamChangedHandler = new FEvent.FEventHandler(){

        @Override
        public void handleEvent(FEvent e) {
            FComboBox cb = (FComboBox)e.getSource();
            if (cb.getSelectedIndex() == -1) {
                return;
            }
            if (PlayerPanel.this.screen.hasVariant(GameType.Archenemy)) {
                String sel = (String)cb.getSelectedItem();
                if (sel.contains("Archenemy")) {
                    ((PlayerPanel)PlayerPanel.this).screen.lastArchenemy = PlayerPanel.this.index;
                    for (PlayerPanel pp : PlayerPanel.this.screen.getPlayerPanels()) {
                        int i = pp.index;
                        int team = i == ((PlayerPanel)PlayerPanel.this).screen.lastArchenemy ? 0 : 1;
                        pp.setArchenemyTeam(team);
                        pp.toggleIsPlayerArchenemy();
                    }
                }
            } else {
                PlayerPanel.this.screen.updatemyTeam(PlayerPanel.this.index, PlayerPanel.this.getTeam());
            }
        }
    };
    private static final ImmutableList<String> genderOptions;
    private static final ImmutableList<String> typeOptions;

    public PlayerPanel(LobbyScreen screen0, boolean allowNetworking0, int index0, LobbySlot slot, boolean mayEdit0, boolean mayControl0) {
        this.screen = screen0;
        this.allowNetworking = allowNetworking0;
        this.humanAiSwitch = this.allowNetworking ? new FToggleSwitch(Forge.getLocalizer().getMessage("lblNotReady", new Object[0]), Forge.getLocalizer().getMessage("lblReady", new Object[0])) : new FToggleSwitch(Forge.getLocalizer().getMessage("lblHuman", new Object[0]), Forge.getLocalizer().getMessage("lblAI", new Object[0]));
        this.index = index0;
        this.populateTeamsComboBoxes();
        this.setTeam(slot.getTeam());
        this.setIsArchenemy(slot.isArchenemy());
        this.setType(slot.getType());
        this.setPlayerName(slot.getName());
        this.setAvatarIndex(slot.getAvatarIndex());
        this.setSleeveIndex(slot.getSleeveIndex());
        this.devModeSwitch = new FToggleSwitch(Forge.getLocalizer().getMessage("lblNormal", new Object[0]), Forge.getLocalizer().getMessage("lblDevMode", new Object[0]));
        this.devModeSwitch.setVisible(this.isNetworkHost());
        this.cbTeam.setEnabled(true);
        this.btnDeck.setEnabled(false);
        boolean isAi = this.isAi();
        this.deckChooser = new FDeckChooser(GameType.Constructed, isAi, new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                PlayerPanel.this.btnDeck.setEnabled(PlayerPanel.this.mayEdit);
                PlayerPanel.this.btnDeck.setText(PlayerPanel.this.deckChooser.getSelectedDeckType().toString() + ":" + (Forge.isLandscapeMode() ? " " : "\n") + Lang.joinHomogenous(((DeckManager)e.getSource()).getSelectedItems(), DeckProxy::getName));
                if (PlayerPanel.this.allowNetworking && PlayerPanel.this.btnDeck.isEnabled() && PlayerPanel.this.humanAiSwitch.isToggled()) {
                    PlayerPanel.this.screen.updateMyDeck(PlayerPanel.this.index);
                }
            }
        });
        this.lstCommanderDecks = new FDeckChooser(GameType.Commander, isAi, new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                if (((DeckManager)e.getSource()).getSelectedItem() != null) {
                    PlayerPanel.this.btnCommanderDeck.setText(Forge.getLocalizer().getMessage("lblCommanderDeck", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((DeckProxy)((DeckManager)e.getSource()).getSelectedItem()).getName());
                    PlayerPanel.this.lstCommanderDecks.saveState();
                    if (PlayerPanel.this.allowNetworking && PlayerPanel.this.btnCommanderDeck.isEnabled() && PlayerPanel.this.humanAiSwitch.isToggled()) {
                        PlayerPanel.this.screen.updateMyDeck(PlayerPanel.this.index);
                    }
                } else {
                    PlayerPanel.this.btnCommanderDeck.setText(Forge.getLocalizer().getMessage("lblCommanderDeck", new Object[0]));
                }
            }
        });
        this.lstOathbreakerDecks = new FDeckChooser(GameType.Oathbreaker, isAi, new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                if (((DeckManager)e.getSource()).getSelectedItem() != null) {
                    PlayerPanel.this.btnOathbreakDeck.setText(Forge.getLocalizer().getMessage("lblOathbreakerDeck", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((DeckProxy)((DeckManager)e.getSource()).getSelectedItem()).getName());
                    PlayerPanel.this.lstOathbreakerDecks.saveState();
                    if (PlayerPanel.this.allowNetworking && PlayerPanel.this.btnOathbreakDeck.isEnabled() && PlayerPanel.this.humanAiSwitch.isToggled()) {
                        PlayerPanel.this.screen.updateMyDeck(PlayerPanel.this.index);
                    }
                } else {
                    PlayerPanel.this.btnOathbreakDeck.setText(Forge.getLocalizer().getMessage("lblOathbreakerDeck", new Object[0]));
                }
            }
        });
        this.lstTinyLeadersDecks = new FDeckChooser(GameType.TinyLeaders, isAi, new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                if (((DeckManager)e.getSource()).getSelectedItem() != null) {
                    PlayerPanel.this.btnTinyLeadersDeck.setText(Forge.getLocalizer().getMessage("lblTinyLeadersDeck", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((DeckProxy)((DeckManager)e.getSource()).getSelectedItem()).getName());
                    PlayerPanel.this.lstTinyLeadersDecks.saveState();
                    if (PlayerPanel.this.allowNetworking && PlayerPanel.this.btnTinyLeadersDeck.isEnabled() && PlayerPanel.this.humanAiSwitch.isToggled()) {
                        PlayerPanel.this.screen.updateMyDeck(PlayerPanel.this.index);
                    }
                } else {
                    PlayerPanel.this.btnTinyLeadersDeck.setText(Forge.getLocalizer().getMessage("lblTinyLeadersDeck", new Object[0]));
                }
            }
        });
        this.lstBrawlDecks = new FDeckChooser(GameType.Brawl, isAi, new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                if (((DeckManager)e.getSource()).getSelectedItem() != null) {
                    PlayerPanel.this.btnBrawlDeck.setText(Forge.getLocalizer().getMessage("lblBrawlDeck", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((DeckProxy)((DeckManager)e.getSource()).getSelectedItem()).getName());
                    PlayerPanel.this.lstBrawlDecks.saveState();
                    if (PlayerPanel.this.allowNetworking && PlayerPanel.this.btnBrawlDeck.isEnabled() && PlayerPanel.this.humanAiSwitch.isToggled()) {
                        PlayerPanel.this.screen.updateMyDeck(PlayerPanel.this.index);
                    }
                } else {
                    PlayerPanel.this.btnBrawlDeck.setText(Forge.getLocalizer().getMessage("lblBrawlDeck", new Object[0]));
                }
            }
        });
        this.lstSchemeDecks = new FDeckChooser(GameType.Archenemy, isAi, e -> {
            if (((DeckManager)e.getSource()).getSelectedItem() != null) {
                this.btnSchemeDeck.setText(Forge.getLocalizer().getMessage("lblSchemeDeck", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((DeckProxy)((DeckManager)e.getSource()).getSelectedItem()).getName());
                if (this.allowNetworking && this.btnSchemeDeck.isEnabled() && this.humanAiSwitch.isToggled()) {
                    this.screen.updateMyDeck(this.index);
                }
            } else {
                this.btnSchemeDeck.setText(Forge.getLocalizer().getMessage("lblSchemeDeck", new Object[0]));
            }
        });
        this.lstPlanarDecks = new FDeckChooser(GameType.Planechase, isAi, e -> {
            if (((DeckManager)e.getSource()).getSelectedItem() != null) {
                this.btnPlanarDeck.setText(Forge.getLocalizer().getMessage("lblPlanarDeck", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((DeckProxy)((DeckManager)e.getSource()).getSelectedItem()).getName());
                if (this.allowNetworking && this.btnPlanarDeck.isEnabled() && this.humanAiSwitch.isToggled()) {
                    this.screen.updateMyDeck(this.index);
                }
            } else {
                this.btnPlanarDeck.setText(Forge.getLocalizer().getMessage("lblPlanarDeck", new Object[0]));
            }
        });
        this.lstVanguardAvatars = new FVanguardChooser(isAi, e -> {
            this.btnVanguardAvatar.setText(Forge.getLocalizer().getMessage("lblVanguard", new Object[0]) + ":" + (Forge.isLandscapeMode() ? " " : "\n") + ((PaperCard)((CardManager)e.getSource()).getSelectedItem()).getName());
            if (this.allowNetworking && this.btnVanguardAvatar.isEnabled() && this.humanAiSwitch.isToggled()) {
                this.screen.updateMyDeck(this.index);
            }
        });
        this.createAvatar();
        this.add(this.avatarLabel);
        this.createSleeve();
        this.add(this.sleeveLabel);
        this.createNameEditor();
        this.add(this.newLabel(Forge.getLocalizer().getMessage("lblName", new Object[0]) + ":"));
        this.add(this.txtPlayerName);
        this.nameRandomiser = this.createNameRandomizer();
        this.add(this.nameRandomiser);
        this.humanAiSwitch.setChangedHandler(this.humanAiSwitched);
        this.add(this.humanAiSwitch);
        this.add(this.newLabel(Forge.getLocalizer().getMessage("lblTeam", new Object[0]) + ":"));
        this.cbTeam.setChangedHandler(this.teamChangedHandler);
        this.cbArchenemyTeam.setChangedHandler(this.teamChangedHandler);
        this.add(this.cbTeam);
        this.add(this.cbArchenemyTeam);
        if (this.isNetworkHost()) {
            this.devModeSwitch.setChangedHandler(this.devModeSwitched);
            this.add(this.devModeSwitch);
        }
        this.add(this.btnDeck);
        this.btnDeck.setCommand(e -> {
            this.deckChooser.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.deckChooser);
        });
        this.add(this.btnCommanderDeck);
        this.btnCommanderDeck.setCommand(e -> {
            this.lstCommanderDecks.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectCommanderDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstCommanderDecks);
        });
        this.add(this.btnOathbreakDeck);
        this.btnOathbreakDeck.setCommand(e -> {
            this.lstOathbreakerDecks.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectOathbreakerDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstOathbreakerDecks);
        });
        this.add(this.btnTinyLeadersDeck);
        this.btnTinyLeadersDeck.setCommand(e -> {
            this.lstTinyLeadersDecks.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectTinyLeadersDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstTinyLeadersDecks);
        });
        this.add(this.btnBrawlDeck);
        this.btnBrawlDeck.setCommand(e -> {
            this.lstBrawlDecks.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectBrawlDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstBrawlDecks);
        });
        this.add(this.btnSchemeDeck);
        this.btnSchemeDeck.setCommand(e -> {
            this.lstSchemeDecks.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectSchemeDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstSchemeDecks);
        });
        this.add(this.btnPlanarDeck);
        this.btnPlanarDeck.setCommand(e -> {
            this.lstPlanarDecks.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectPlanarDeckFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstPlanarDecks);
        });
        this.add(this.btnVanguardAvatar);
        this.btnVanguardAvatar.setCommand(e -> {
            this.lstVanguardAvatars.setHeaderCaption(Forge.getLocalizer().getMessage("lblSelectVanguardFor", new Object[0]).replace("%s", this.txtPlayerName.getText()));
            Forge.openScreen(this.lstVanguardAvatars);
        });
        if (this.mayEdit == mayEdit0) {
            this.updateVariantControlsVisibility();
        } else {
            this.setMayEdit(false);
        }
        this.setMayControl(mayControl0);
    }

    public void initialize(ForgePreferences.FPref savedStateSetting, ForgePreferences.FPref savedStateSettingCommander, ForgePreferences.FPref savedStateSettingOathbreaker, ForgePreferences.FPref savedStateSettingTinyLeader, ForgePreferences.FPref savedStateSettingBrawl, DeckType defaultDeckType) {
        Set<GameType> gameTypes = FModel.getPreferences().getGameType(ForgePreferences.FPref.UI_APPLIED_VARIANTS);
        if (gameTypes.contains((Object)GameType.Commander)) {
            this.lstCommanderDecks.initialize(savedStateSettingCommander, DeckType.COMMANDER_DECK);
            this.lstOathbreakerDecks.initialize(savedStateSettingOathbreaker, DeckType.OATHBREAKER_DECK);
            this.lstTinyLeadersDecks.initialize(savedStateSettingTinyLeader, DeckType.TINY_LEADERS_DECK);
            this.lstBrawlDecks.initialize(savedStateSettingBrawl, DeckType.BRAWL_DECK);
            this.deckChooser.initialize(savedStateSetting, defaultDeckType);
        } else if (gameTypes.contains((Object)GameType.Oathbreaker)) {
            this.lstOathbreakerDecks.initialize(savedStateSettingOathbreaker, DeckType.OATHBREAKER_DECK);
            this.lstCommanderDecks.initialize(savedStateSettingCommander, DeckType.COMMANDER_DECK);
            this.lstTinyLeadersDecks.initialize(savedStateSettingTinyLeader, DeckType.TINY_LEADERS_DECK);
            this.lstBrawlDecks.initialize(savedStateSettingBrawl, DeckType.BRAWL_DECK);
            this.deckChooser.initialize(savedStateSetting, defaultDeckType);
        } else if (gameTypes.contains((Object)GameType.TinyLeaders)) {
            this.lstTinyLeadersDecks.initialize(savedStateSettingTinyLeader, DeckType.TINY_LEADERS_DECK);
            this.lstOathbreakerDecks.initialize(savedStateSettingOathbreaker, DeckType.OATHBREAKER_DECK);
            this.lstCommanderDecks.initialize(savedStateSettingCommander, DeckType.COMMANDER_DECK);
            this.lstBrawlDecks.initialize(savedStateSettingBrawl, DeckType.BRAWL_DECK);
            this.deckChooser.initialize(savedStateSetting, defaultDeckType);
        } else if (gameTypes.contains((Object)GameType.Brawl)) {
            this.lstBrawlDecks.initialize(savedStateSettingBrawl, DeckType.BRAWL_DECK);
            this.lstTinyLeadersDecks.initialize(savedStateSettingTinyLeader, DeckType.TINY_LEADERS_DECK);
            this.lstOathbreakerDecks.initialize(savedStateSettingOathbreaker, DeckType.OATHBREAKER_DECK);
            this.lstCommanderDecks.initialize(savedStateSettingCommander, DeckType.COMMANDER_DECK);
            this.deckChooser.initialize(savedStateSetting, defaultDeckType);
        } else {
            this.deckChooser.initialize(savedStateSetting, defaultDeckType);
            this.lstCommanderDecks.initialize(savedStateSettingCommander, DeckType.COMMANDER_DECK);
            this.lstOathbreakerDecks.initialize(savedStateSettingOathbreaker, DeckType.OATHBREAKER_DECK);
            this.lstTinyLeadersDecks.initialize(savedStateSettingTinyLeader, DeckType.TINY_LEADERS_DECK);
            this.lstBrawlDecks.initialize(savedStateSettingBrawl, DeckType.BRAWL_DECK);
        }
        this.lstPlanarDecks.initialize(null, DeckType.RANDOM_DECK);
        this.lstSchemeDecks.initialize(null, DeckType.RANDOM_DECK);
    }

    @Override
    protected void doLayout(float width, float height) {
        float x = PADDING;
        float y = PADDING;
        float fieldHeight = this.txtPlayerName.getHeight();
        float avatarSize = 2.0f * fieldHeight + PADDING;
        float sleeveSize = 2.0f * fieldHeight + PADDING;
        float sleeveSizeW = sleeveSize / 4.0f * 3.0f;
        float dy = fieldHeight + PADDING;
        this.avatarLabel.setBounds(x, y, avatarSize, avatarSize);
        this.sleeveLabel.setBounds(x += avatarSize + PADDING, y, sleeveSizeW, sleeveSize);
        float w = width - (x += sleeveSizeW + PADDING) - fieldHeight - 2.0f * PADDING;
        this.txtPlayerName.setBounds(x, y, w, fieldHeight);
        this.nameRandomiser.setBounds(x += w + PADDING, y, fieldHeight, fieldHeight);
        if (Forge.isLandscapeMode()) {
            this.humanAiSwitch.setSize(this.humanAiSwitch.getAutoSizeWidth(fieldHeight), fieldHeight);
            x = width - this.humanAiSwitch.getWidth() - PADDING;
            this.humanAiSwitch.setPosition(x, y += dy);
            w = x - (avatarSize + sleeveSizeW + PADDING) - 3.0f * PADDING;
            x = avatarSize + sleeveSizeW + PADDING + 2.0f * PADDING;
            if (this.cbArchenemyTeam.isVisible()) {
                this.cbArchenemyTeam.setBounds(x, y, w, fieldHeight);
            } else {
                this.cbTeam.setBounds(x, y, w, fieldHeight);
            }
        } else {
            y += dy;
            w = x - (avatarSize + sleeveSizeW + PADDING) - 3.0f * PADDING;
            x = avatarSize + sleeveSizeW + PADDING + 2.0f * PADDING;
            if (this.cbArchenemyTeam.isVisible()) {
                this.cbArchenemyTeam.setBounds(x, y, w, fieldHeight);
            } else {
                this.cbTeam.setBounds(x, y, w, fieldHeight);
            }
            this.humanAiSwitch.setSize(this.humanAiSwitch.getAutoSizeWidth(fieldHeight), fieldHeight);
            x = width - this.humanAiSwitch.getWidth() - PADDING;
            this.humanAiSwitch.setPosition(x, y += dy);
        }
        if (this.devModeSwitch.isVisible()) {
            if (Forge.isLandscapeMode()) {
                y += dy;
            }
            this.devModeSwitch.setSize(this.devModeSwitch.getAutoSizeWidth(fieldHeight), fieldHeight);
            this.devModeSwitch.setPosition(0.0f, y);
        }
        if (Forge.isLandscapeMode()) {
            y += dy;
            x = PADDING;
            w = width - 2.0f * PADDING;
        } else if (this.devModeSwitch.isVisible()) {
            y += dy;
            x = PADDING;
            w = width - 2.0f * PADDING;
        } else {
            x = PADDING;
            w = width - 2.0f * PADDING - this.humanAiSwitch.getWidth();
        }
        if (this.btnCommanderDeck.isVisible()) {
            this.btnCommanderDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        } else if (this.btnOathbreakDeck.isVisible()) {
            this.btnOathbreakDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        } else if (this.btnTinyLeadersDeck.isVisible()) {
            this.btnTinyLeadersDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        } else if (this.btnBrawlDeck.isVisible()) {
            this.btnBrawlDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        } else if (this.btnDeck.isVisible()) {
            this.btnDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        }
        if (this.btnSchemeDeck.isVisible()) {
            this.btnSchemeDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        }
        if (this.btnPlanarDeck.isVisible()) {
            this.btnPlanarDeck.setBounds(x, y, w, fieldHeight);
            y += dy;
        }
        if (this.btnVanguardAvatar.isVisible()) {
            this.btnVanguardAvatar.setBounds(x, y, w, fieldHeight);
        }
    }

    public float getPreferredHeight() {
        int rows = 3;
        if (!this.btnDeck.isVisible() && Forge.isLandscapeMode()) {
            --rows;
        }
        if ((this.btnCommanderDeck.isVisible() || this.btnOathbreakDeck.isVisible() || this.btnTinyLeadersDeck.isVisible() || this.btnBrawlDeck.isVisible()) && Forge.isLandscapeMode()) {
            ++rows;
        }
        if (this.btnSchemeDeck.isVisible()) {
            ++rows;
        }
        if (this.btnPlanarDeck.isVisible()) {
            ++rows;
        }
        if (this.btnVanguardAvatar.isVisible()) {
            ++rows;
        }
        if (this.devModeSwitch.isVisible()) {
            ++rows;
        }
        return (float)rows * (this.txtPlayerName.getHeight() + PADDING) + PADDING;
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        float y = this.getHeight() - FList.LINE_THICKNESS / 2.0f;
        g2.drawLine(FList.LINE_THICKNESS, FList.getLineColor(), 0.0f, y, this.getWidth(), y);
    }

    private void onIsAiChanged(boolean isAi) {
        this.deckChooser.setIsAi(isAi);
        this.lstCommanderDecks.setIsAi(isAi);
        this.lstTinyLeadersDecks.setIsAi(isAi);
        this.lstBrawlDecks.setIsAi(isAi);
        this.lstPlanarDecks.setIsAi(isAi);
        this.lstSchemeDecks.setIsAi(isAi);
        this.lstVanguardAvatars.setIsAi(isAi);
    }

    public void setDeckSelectorButtonText(String text) {
        if (!Forge.isLandscapeMode()) {
            text = TextUtil.fastReplace(text, ": ", ":\n");
        }
        if (this.btnDeck.isVisible()) {
            this.btnDeck.setText(text);
        }
        if (this.btnCommanderDeck.isVisible()) {
            this.btnCommanderDeck.setText(text);
        }
        if (this.btnOathbreakDeck.isVisible()) {
            this.btnOathbreakDeck.setText(text);
        }
        if (this.btnTinyLeadersDeck.isVisible()) {
            this.btnTinyLeadersDeck.setText(text);
        }
        if (this.btnBrawlDeck.isVisible()) {
            this.btnBrawlDeck.setText(text);
        }
    }

    public void setVanguarAvatarName(String text) {
        if (!Forge.isLandscapeMode()) {
            text = TextUtil.fastReplace(text, ": ", ":\n");
        }
        this.btnVanguardAvatar.setText(text);
    }

    public void setSchemeDeckName(String text) {
        if (!Forge.isLandscapeMode()) {
            text = TextUtil.fastReplace(text, ": ", ":\n");
        }
        this.btnSchemeDeck.setText(text);
    }

    public void setPlanarDeckName(String text) {
        if (!Forge.isLandscapeMode()) {
            text = TextUtil.fastReplace(text, ": ", ":\n");
        }
        this.btnPlanarDeck.setText(text);
    }

    public void updateVariantControlsVisibility() {
        boolean isCommanderApplied = false;
        boolean isOathbreakerApplied = false;
        boolean isTinyLeadersApplied = false;
        boolean isBrawlApplied = false;
        boolean isPlanechaseApplied = false;
        boolean isVanguardApplied = false;
        boolean isArchenemyApplied = false;
        boolean archenemyVisiblity = false;
        boolean isDeckBuildingAllowed = this.mayEdit;
        boolean replacedbasicdeck = false;
        block10: for (GameType variant : this.screen.getLobby().getAppliedVariants()) {
            switch (variant) {
                case Archenemy: {
                    isArchenemyApplied = true;
                    if (!this.isArchenemy()) continue block10;
                    archenemyVisiblity = true;
                    continue block10;
                }
                case ArchenemyRumble: {
                    archenemyVisiblity = true;
                    continue block10;
                }
                case Commander: {
                    isCommanderApplied = true;
                    isDeckBuildingAllowed = false;
                    replacedbasicdeck = true;
                    continue block10;
                }
                case Oathbreaker: {
                    isOathbreakerApplied = true;
                    isDeckBuildingAllowed = false;
                    replacedbasicdeck = true;
                    continue block10;
                }
                case TinyLeaders: {
                    isTinyLeadersApplied = true;
                    isDeckBuildingAllowed = false;
                    replacedbasicdeck = true;
                    continue block10;
                }
                case Brawl: {
                    isBrawlApplied = true;
                    isDeckBuildingAllowed = false;
                    replacedbasicdeck = true;
                    continue block10;
                }
                case Planechase: {
                    isPlanechaseApplied = true;
                    continue block10;
                }
                case Vanguard: {
                    isVanguardApplied = true;
                    continue block10;
                }
            }
            if (!variant.isAutoGenerated()) continue;
            isDeckBuildingAllowed = false;
            replacedbasicdeck = true;
        }
        if (this.allowNetworking) {
            if (replacedbasicdeck) {
                this.btnDeck.setVisible(false);
            } else {
                this.btnDeck.setVisible(true);
                this.btnDeck.setEnabled(this.mayEdit);
            }
            if (isCommanderApplied) {
                this.btnCommanderDeck.setVisible(true);
                this.btnCommanderDeck.setEnabled(this.mayEdit);
            } else {
                this.btnCommanderDeck.setVisible(false);
            }
            if (isOathbreakerApplied) {
                this.btnOathbreakDeck.setVisible(true);
                this.btnOathbreakDeck.setEnabled(this.mayEdit);
            } else {
                this.btnOathbreakDeck.setVisible(false);
            }
            if (isTinyLeadersApplied) {
                this.btnTinyLeadersDeck.setVisible(true);
                this.btnTinyLeadersDeck.setEnabled(this.mayEdit);
            } else {
                this.btnTinyLeadersDeck.setVisible(false);
            }
            if (isBrawlApplied) {
                this.btnBrawlDeck.setVisible(true);
                this.btnBrawlDeck.setEnabled(this.mayEdit);
            } else {
                this.btnBrawlDeck.setVisible(false);
            }
            if (archenemyVisiblity) {
                this.btnSchemeDeck.setVisible(true);
                this.btnSchemeDeck.setEnabled(this.mayEdit);
            } else {
                this.btnSchemeDeck.setVisible(false);
            }
            if (!isArchenemyApplied) {
                this.cbTeam.setVisible(true);
                this.cbTeam.setEnabled(this.mayEdit);
                this.cbArchenemyTeam.setVisible(false);
            } else {
                this.cbTeam.setVisible(false);
                this.cbArchenemyTeam.setVisible(true);
                this.cbArchenemyTeam.setEnabled(this.mayEdit);
            }
            if (isPlanechaseApplied) {
                this.btnPlanarDeck.setVisible(true);
                this.btnPlanarDeck.setEnabled(this.mayEdit);
            } else {
                this.btnPlanarDeck.setVisible(false);
            }
            if (isVanguardApplied) {
                this.btnVanguardAvatar.setVisible(true);
                this.btnVanguardAvatar.setEnabled(this.mayEdit);
            } else {
                this.btnVanguardAvatar.setVisible(false);
            }
        } else {
            this.btnDeck.setVisible(isDeckBuildingAllowed);
            this.btnCommanderDeck.setVisible(isCommanderApplied && this.mayEdit);
            this.btnOathbreakDeck.setVisible(isOathbreakerApplied && this.mayEdit);
            this.btnTinyLeadersDeck.setVisible(isTinyLeadersApplied && this.mayEdit);
            this.btnBrawlDeck.setVisible(isBrawlApplied && this.mayEdit);
            this.btnSchemeDeck.setVisible(archenemyVisiblity && this.mayEdit);
            this.cbTeam.setVisible(!isArchenemyApplied);
            this.cbArchenemyTeam.setVisible(isArchenemyApplied);
            this.btnPlanarDeck.setVisible(isPlanechaseApplied && this.mayEdit);
            this.btnVanguardAvatar.setVisible(isVanguardApplied && this.mayEdit);
        }
    }

    public boolean isNetworkHost() {
        return this.allowNetworking && this.index == 0;
    }

    public boolean isAi() {
        return this.type == LobbySlotType.AI;
    }

    public boolean isArchenemy() {
        return this.cbArchenemyTeam.getSelectedIndex() == 0;
    }

    public void setIsArchenemy(boolean isArchenemy0) {
        this.cbArchenemyTeam.setSelectedIndex(isArchenemy0 ? 0 : 1);
    }

    private void populateTeamsComboBoxes() {
        this.cbArchenemyTeam.addItem(Forge.getLocalizer().getMessage("lblArchenemy", new Object[0]));
        this.cbArchenemyTeam.addItem(Forge.getLocalizer().getMessage("lblHeroes", new Object[0]));
        for (int i = 1; i <= 4; ++i) {
            this.cbTeam.addItem(Forge.getLocalizer().getMessage("lblTeam", new Object[0]) + " " + i);
        }
        this.cbTeam.setEnabled(this.mayEdit);
    }

    public void toggleIsPlayerArchenemy() {
        if (this.screen.hasVariant(GameType.Archenemy)) {
            this.setIsArchenemy(this.screen.lastArchenemy == this.index);
        } else {
            this.setIsArchenemy(this.screen.hasVariant(GameType.ArchenemyRumble));
        }
        this.screen.updateLayoutForVariants();
    }

    private FLabel createNameRandomizer() {
        FLabel newNameBtn = new FLabel.Builder().iconInBackground(false).icon(Forge.hdbuttons ? FSkinImage.HDEDIT : FSkinImage.EDIT).opaque(false).build();
        newNameBtn.setCommand(e -> this.getNewName(new Callback<String>(){

            @Override
            public void run(String newName) {
                if (newName == null) {
                    return;
                }
                PlayerPanel.this.txtPlayerName.setText(newName);
                if (PlayerPanel.this.index == 0) {
                    prefs.setPref(ForgePreferences.FPref.PLAYER_NAME, newName);
                    prefs.save();
                    PlayerPanel.this.screen.getLobby().applyToSlot(PlayerPanel.this.index, UpdateLobbyPlayerEvent.nameUpdate(newName));
                }
                if (PlayerPanel.this.allowNetworking) {
                    PlayerPanel.this.screen.firePlayerChangeListener(PlayerPanel.this.index);
                }
            }
        }));
        return newNameBtn;
    }

    private void createNameEditor() {
        String name;
        if (this.index == 0) {
            name = FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
            if (name.isEmpty()) {
                name = Forge.getLocalizer().getMessage("lblHuman", new Object[0]);
            }
        } else {
            name = NameGenerator.getRandomName("Any", "Any", this.screen.getPlayerNames());
        }
        this.txtPlayerName.setText(name);
        this.txtPlayerName.setFont(LABEL_FONT);
        this.txtPlayerName.setChangedHandler(this.nameChangedHandler);
    }

    private void createAvatar() {
        String[] currentPrefs = prefs.getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        if (this.index < currentPrefs.length) {
            this.setAvatarIndex(Integer.parseInt(currentPrefs[this.index]));
        } else {
            this.setAvatarIndex(AvatarSelector.getRandomAvatar(this.screen.getUsedAvatars()));
        }
        this.avatarLabel.setCommand(this.avatarCommand);
    }

    private void createSleeve() {
        String[] currentPrefs = prefs.getPref(ForgePreferences.FPref.UI_SLEEVES).split(",");
        if (this.index < currentPrefs.length) {
            this.setSleeveIndex(Integer.parseInt(currentPrefs[this.index]));
        } else {
            this.setSleeveIndex(SleevesSelector.getRandomSleeves(this.screen.getUsedSleeves()));
        }
        this.sleeveLabel.setCommand(this.sleeveCommand);
    }

    public void setAvatarIndex(int newAvatarIndex) {
        this.avatarIndex = newAvatarIndex;
        if (this.avatarIndex != -1) {
            this.avatarLabel.setIcon(new FTextureRegionImage(FSkin.getAvatars().get(newAvatarIndex)));
        } else {
            this.avatarLabel.setIcon(null);
        }
    }

    public void setSleeveIndex(int newSleeveIndex) {
        this.sleeveIndex = newSleeveIndex;
        if (this.sleeveIndex != -1) {
            this.sleeveLabel.setIcon(new FTextureRegionImage(FSkin.getSleeves().get(newSleeveIndex)));
        } else {
            this.sleeveLabel.setIcon(null);
        }
    }

    public int getAvatarIndex() {
        return this.avatarIndex;
    }

    public int getSleeveIndex() {
        return this.sleeveIndex;
    }

    public void setPlayerName(String string) {
        this.txtPlayerName.setText(string);
    }

    public String getPlayerName() {
        return this.txtPlayerName.getText();
    }

    public LobbySlotType getType() {
        return this.type;
    }

    public void setType(LobbySlotType type0) {
        if (this.type == type0) {
            return;
        }
        boolean wasAi = this.isAi();
        this.type = type0;
        switch (this.type) {
            case LOCAL: {
                this.humanAiSwitch.setToggled(false);
                break;
            }
            case AI: {
                this.humanAiSwitch.setToggled(true);
                break;
            }
            case OPEN: {
                this.isReady = false;
                this.humanAiSwitch.setToggled(false);
                break;
            }
            case REMOTE: {
                this.humanAiSwitch.setToggled(this.isReady);
            }
        }
        boolean isAi = this.isAi();
        if (isAi != wasAi && this.deckChooser != null) {
            this.onIsAiChanged(isAi);
        }
    }

    public Set<AIOption> getAiOptions() {
        return this.isSimulatedAi() ? ImmutableSet.of(AIOption.USE_SIMULATION) : Collections.emptySet();
    }

    private boolean isSimulatedAi() {
        return this.isAi() && this.useAiSimulation;
    }

    public void setUseAiSimulation(boolean useAiSimulation0) {
        this.useAiSimulation = useAiSimulation0;
    }

    public int getTeam() {
        return this.cbTeam.getSelectedIndex();
    }

    public void setTeam(int team0) {
        this.cbTeam.setSelectedIndex(team0);
    }

    public int getArchenemyTeam() {
        return this.cbTeam.getSelectedIndex();
    }

    public void setArchenemyTeam(int team0) {
        this.cbTeam.setSelectedIndex(team0);
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setIsReady(boolean isReady0) {
        if (this.isReady == isReady0) {
            return;
        }
        this.isReady = isReady0;
        if (this.allowNetworking) {
            this.humanAiSwitch.setToggled(this.isReady);
        }
    }

    public void setMayEdit(boolean mayEdit0) {
        if (this.mayEdit == mayEdit0) {
            return;
        }
        this.mayEdit = mayEdit0;
        this.avatarLabel.setEnabled(this.mayEdit);
        this.sleeveLabel.setEnabled(this.mayEdit);
        this.txtPlayerName.setEnabled(this.mayEdit);
        this.nameRandomiser.setEnabled(this.mayEdit);
        this.humanAiSwitch.setEnabled(this.mayEdit);
        this.cbTeam.setEnabled(this.mayEdit);
        if (this.devModeSwitch != null) {
            this.devModeSwitch.setEnabled(this.mayEdit);
        }
        if (this.allowNetworking) {
            this.btnDeck.setEnabled(this.mayEdit);
            this.btnCommanderDeck.setEnabled(this.mayEdit);
            this.btnOathbreakDeck.setEnabled(this.mayEdit);
            this.btnTinyLeadersDeck.setEnabled(this.mayEdit);
            this.btnBrawlDeck.setEnabled(this.mayEdit);
            this.btnSchemeDeck.setEnabled(this.mayEdit);
            this.btnPlanarDeck.setEnabled(this.mayEdit);
            this.cbArchenemyTeam.setEnabled(this.mayEdit);
        }
        this.updateVariantControlsVisibility();
        if (this.getHeight() > 0.0f) {
            this.screen.getPlayersScroll().revalidate();
        }
    }

    public void setMayControl(boolean mayControl0) {
        if (this.mayControl == mayControl0) {
            return;
        }
        this.mayControl = mayControl0;
    }

    public void setMayRemove(boolean mayRemove0) {
        if (this.mayRemove == mayRemove0) {
            return;
        }
        this.mayRemove = mayRemove0;
    }

    public FDeckChooser getDeckChooser() {
        return this.deckChooser;
    }

    public FDeckChooser getCommanderDeckChooser() {
        return this.lstCommanderDecks;
    }

    public FDeckChooser getOathbreakerDeckChooser() {
        return this.lstOathbreakerDecks;
    }

    public FDeckChooser getTinyLeadersDeckChooser() {
        return this.lstTinyLeadersDecks;
    }

    public FDeckChooser getBrawlDeckChooser() {
        return this.lstBrawlDecks;
    }

    public Deck getDeck() {
        return this.deckChooser.getDeck();
    }

    public Deck getCommanderDeck() {
        return this.lstCommanderDecks.getDeck();
    }

    public Deck getOathbreakerDeck() {
        return this.lstOathbreakerDecks.getDeck();
    }

    public Deck getTinyLeadersDeck() {
        return this.lstTinyLeadersDecks.getDeck();
    }

    public Deck getBrawlDeck() {
        return this.lstBrawlDecks.getDeck();
    }

    public Deck getSchemeDeck() {
        return this.lstSchemeDecks.getDeck();
    }

    public Deck getPlanarDeck() {
        return this.lstPlanarDecks.getDeck();
    }

    public PaperCard getVanguardAvatar() {
        return (PaperCard)this.lstVanguardAvatars.getLstVanguards().getSelectedItem();
    }

    private FLabel newLabel(String title) {
        return new FLabel.Builder().text(title).font(LABEL_FONT).align(16).build();
    }

    private void getNewName(final Callback<String> callback) {
        final String title = Forge.getLocalizer().getMessage("lblGetNewRandomName", new Object[0]);
        final String message = Forge.getLocalizer().getMessage("lbltypeofName", new Object[0]);
        final FSkinImage icon = FOptionPane.QUESTION_ICON;
        FOptionPane.showOptionDialog(message, title, icon, genderOptions, 2, new Callback<Integer>(){

            @Override
            public void run(final Integer genderIndex) {
                if (genderIndex == null || genderIndex < 0) {
                    callback.run(null);
                    return;
                }
                FOptionPane.showOptionDialog(message, title, icon, typeOptions, 2, new Callback<Integer>(){

                    @Override
                    public void run(Integer typeIndex) {
                        if (typeIndex == null || typeIndex < 0) {
                            callback.run(null);
                            return;
                        }
                        PlayerPanel.this.generateRandomName((String)genderOptions.get(genderIndex), (String)typeOptions.get(typeIndex), PlayerPanel.this.screen.getPlayerNames(), title, callback);
                    }
                });
            }
        });
    }

    private void generateRandomName(final String gender, final String type, final List<String> usedNames, final String title, final Callback<String> callback) {
        final String newName = NameGenerator.getRandomName(gender, type, usedNames);
        String confirmMsg = Forge.getLocalizer().getMessage("lblconfirmName", new Object[0]).replace("%s", newName);
        FOptionPane.showConfirmDialog(confirmMsg, title, Forge.getLocalizer().getMessage("lblUseThisName", new Object[0]), Forge.getLocalizer().getMessage("lblTryAgain", new Object[0]), true, new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                if (result.booleanValue()) {
                    callback.run(newName);
                } else {
                    PlayerPanel.this.generateRandomName(gender, type, usedNames, title, callback);
                }
            }
        });
    }

    public boolean isDevMode() {
        return this.devModeSwitch.isVisible() && this.devModeSwitch.isToggled();
    }

    public void setIsDevMode(boolean isDevMode) {
        if (this.devModeSwitch.isVisible()) {
            this.devModeSwitch.setToggled(isDevMode);
        }
    }

    static {
        Forge.getLocalizer();
        String string = Localizer.getInstance().getMessage("lblMale", new Object[0]);
        Forge.getLocalizer();
        String string2 = Localizer.getInstance().getMessage("lblFemale", new Object[0]);
        Forge.getLocalizer();
        genderOptions = ImmutableList.of(string, string2, Localizer.getInstance().getMessage("lblAny", new Object[0]));
        Forge.getLocalizer();
        String string3 = Localizer.getInstance().getMessage("lblFantasy", new Object[0]);
        Forge.getLocalizer();
        String string4 = Localizer.getInstance().getMessage("lblGeneric", new Object[0]);
        Forge.getLocalizer();
        typeOptions = ImmutableList.of(string3, string4, Localizer.getInstance().getMessage("lblAny", new Object[0]));
    }
}

