/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.constructed;

import com.badlogic.gdx.Gdx;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.ai.AIOption;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.ImageCache;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.DeckType;
import forge.deck.FDeckChooser;
import forge.game.GameType;
import forge.gamemodes.match.GameLobby;
import forge.gamemodes.match.LobbySlot;
import forge.gamemodes.match.LobbySlotType;
import forge.gamemodes.net.event.UpdateLobbyPlayerEvent;
import forge.gamemodes.net.server.FServerManager;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.interfaces.ILobbyView;
import forge.interfaces.IPlayerChangeListener;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.FScreen;
import forge.screens.LaunchScreen;
import forge.screens.LoadingOverlay;
import forge.screens.constructed.PlayerPanel;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class LobbyScreen
extends LaunchScreen
implements ILobbyView {
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static final float PADDING = Utils.scale(5.0f);
    public static final int MAX_PLAYERS = 4;
    private static final FSkinFont VARIANTS_FONT = FSkinFont.get(12);
    private GameLobby lobby;
    private IPlayerChangeListener playerChangeListener = null;
    private final FLabel lblPlayers = new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblPlayers", new Object[0]) + ":").font(VARIANTS_FONT).build();
    private final FComboBox<Integer> cbPlayerCount;
    private final Deck[] decks = new Deck[4];
    private final FLabel lblVariants = new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblVariants", new Object[0]) + ":").font(VARIANTS_FONT).build();
    private final FComboBox<Object> cbVariants = new FComboBox();
    private final FLabel lblGamesInMatch = new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblMatch", new Object[0]) + ":").font(VARIANTS_FONT).build();
    private final FComboBox<String> cbGamesInMatch = new FComboBox();
    private final List<PlayerPanel> playerPanels = new ArrayList<PlayerPanel>(4);
    private final FScrollPane playersScroll = new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float y = 0.0f;
            for (int i = 0; i < LobbyScreen.this.getNumPlayers(); ++i) {
                float height = ((PlayerPanel)LobbyScreen.this.playerPanels.get(i)).getPreferredHeight();
                ((PlayerPanel)LobbyScreen.this.playerPanels.get(i)).setBounds(0.0f, y, visibleWidth, height);
                y += height;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }

        @Override
        public void drawOnContainer(Graphics g2) {
            float y = LobbyScreen.this.playersScroll.getTop() - FList.LINE_THICKNESS / 2.0f;
            g2.drawLine(FList.LINE_THICKNESS, FList.getLineColor(), 0.0f, y, this.getWidth(), y);
        }
    };
    int lastArchenemy = 0;

    public LobbyScreen(String headerCaption, FPopupMenu menu, GameLobby lobby0) {
        super(headerCaption, menu);
        this.btnStart.setEnabled(false);
        this.add(this.lblPlayers);
        this.cbPlayerCount = this.add(new FComboBox());
        this.cbPlayerCount.setFont(VARIANTS_FONT);
        for (int i = 2; i <= 4; ++i) {
            this.cbPlayerCount.addItem(i);
        }
        this.cbPlayerCount.setSelectedItem(2);
        this.cbPlayerCount.setChangedHandler(event -> {
            int numPlayers = this.getNumPlayers();
            while (this.lobby.getNumberOfSlots() < this.getNumPlayers()) {
                this.lobby.addSlot();
            }
            while (this.lobby.getNumberOfSlots() > this.getNumPlayers()) {
                this.lobby.removeSlot(this.lobby.getNumberOfSlots() - 1);
            }
            for (int i = 0; i < 4; ++i) {
                if (i >= this.playerPanels.size()) continue;
                this.playerPanels.get(i).setVisible(i < numPlayers);
            }
            this.playersScroll.revalidate();
        });
        this.initLobby(lobby0);
        this.add(this.lblGamesInMatch);
        this.add(this.cbGamesInMatch);
        this.cbGamesInMatch.setFont(VARIANTS_FONT);
        this.cbGamesInMatch.addItem("1");
        this.cbGamesInMatch.addItem("3");
        this.cbGamesInMatch.addItem("5");
        this.cbGamesInMatch.setSelectedItem(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_MATCHES_PER_GAME));
        this.cbGamesInMatch.setChangedHandler(event -> FModel.getPreferences().setPref(ForgePreferences.FPref.UI_MATCHES_PER_GAME, this.cbGamesInMatch.getSelectedItem()));
        this.add(this.lblVariants);
        this.add(this.cbVariants);
        this.cbVariants.setFont(VARIANTS_FONT);
        this.cbVariants.addItem("(" + Forge.getLocalizer().getMessage("lblNone", new Object[0]) + ")");
        this.cbVariants.addItem((Object)GameType.Vanguard);
        this.cbVariants.addItem((Object)GameType.MomirBasic);
        this.cbVariants.addItem((Object)GameType.MoJhoSto);
        this.cbVariants.addItem((Object)GameType.Commander);
        this.cbVariants.addItem((Object)GameType.Oathbreaker);
        this.cbVariants.addItem((Object)GameType.TinyLeaders);
        this.cbVariants.addItem((Object)GameType.Brawl);
        this.cbVariants.addItem((Object)GameType.Planechase);
        this.cbVariants.addItem((Object)GameType.Archenemy);
        this.cbVariants.addItem((Object)GameType.ArchenemyRumble);
        this.cbVariants.addItem(Forge.getLocalizer().getMessage("lblMore", new Object[0]));
        this.cbVariants.setChangedHandler(event -> {
            if (this.cbVariants.getSelectedIndex() <= 0) {
                this.lobby.clearVariants();
                this.updateLayoutForVariants();
                HashSet<GameType> gameTypes = new HashSet<GameType>();
                FModel.getPreferences().setGameType(ForgePreferences.FPref.UI_APPLIED_VARIANTS, gameTypes);
                FModel.getPreferences().save();
            } else if (this.cbVariants.getSelectedIndex() == this.cbVariants.getItemCount() - 1) {
                Forge.openScreen(new MultiVariantSelect());
                this.updateVariantSelection();
            } else {
                this.lobby.clearVariants();
                this.lobby.applyVariant((GameType)((Object)((Object)this.cbVariants.getSelectedItem())));
                this.updateLayoutForVariants();
                HashSet<GameType> gameTypes = new HashSet<GameType>();
                for (GameType variant : this.lobby.getAppliedVariants()) {
                    gameTypes.add(variant);
                }
                FModel.getPreferences().setGameType(ForgePreferences.FPref.UI_APPLIED_VARIANTS, gameTypes);
                FModel.getPreferences().save();
            }
        });
        this.update(false);
        this.add(this.playersScroll);
        this.updatePlayersFromPrefs();
        FThreads.invokeInBackgroundThread(() -> {
            this.playerPanels.get(0).initialize(ForgePreferences.FPref.CONSTRUCTED_P1_DECK_STATE, ForgePreferences.FPref.COMMANDER_P1_DECK_STATE, ForgePreferences.FPref.OATHBREAKER_P1_DECK_STATE, ForgePreferences.FPref.TINY_LEADER_P1_DECK_STATE, ForgePreferences.FPref.BRAWL_P1_DECK_STATE, DeckType.PRECONSTRUCTED_DECK);
            this.playerPanels.get(1).initialize(ForgePreferences.FPref.CONSTRUCTED_P2_DECK_STATE, ForgePreferences.FPref.COMMANDER_P2_DECK_STATE, ForgePreferences.FPref.OATHBREAKER_P2_DECK_STATE, ForgePreferences.FPref.TINY_LEADER_P2_DECK_STATE, ForgePreferences.FPref.BRAWL_P2_DECK_STATE, DeckType.COLOR_DECK);
            try {
                if (this.getNumPlayers() > 2) {
                    this.playerPanels.get(2).initialize(ForgePreferences.FPref.CONSTRUCTED_P3_DECK_STATE, ForgePreferences.FPref.COMMANDER_P3_DECK_STATE, ForgePreferences.FPref.OATHBREAKER_P3_DECK_STATE, ForgePreferences.FPref.TINY_LEADER_P3_DECK_STATE, ForgePreferences.FPref.BRAWL_P3_DECK_STATE, DeckType.COLOR_DECK);
                }
                if (this.getNumPlayers() > 3) {
                    this.playerPanels.get(3).initialize(ForgePreferences.FPref.CONSTRUCTED_P4_DECK_STATE, ForgePreferences.FPref.COMMANDER_P4_DECK_STATE, ForgePreferences.FPref.OATHBREAKER_P3_DECK_STATE, ForgePreferences.FPref.TINY_LEADER_P4_DECK_STATE, ForgePreferences.FPref.BRAWL_P4_DECK_STATE, DeckType.COLOR_DECK);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FThreads.invokeInEdtLater(() -> {
                this.btnStart.setEnabled(this.lobby.hasControl());
                Set<GameType> gameTypes = FModel.getPreferences().getGameType(ForgePreferences.FPref.UI_APPLIED_VARIANTS);
                if (!gameTypes.isEmpty()) {
                    for (GameType gameType : gameTypes) {
                        this.lobby.applyVariant(gameType);
                    }
                    this.updateVariantSelection();
                    this.updateLayoutForVariants();
                }
            });
        });
        this.lblPlayers.setEnabled(true);
        this.cbPlayerCount.setEnabled(true);
    }

    public GameLobby getLobby() {
        return this.lobby;
    }

    protected void initLobby(GameLobby lobby0) {
        this.lobby = lobby0;
        this.lobby.setListener(this);
        boolean hasControl = this.lobby.hasControl();
        this.btnStart.setEnabled(hasControl);
        this.lblVariants.setEnabled(hasControl);
        this.cbVariants.setEnabled(hasControl);
        this.lblGamesInMatch.setEnabled(hasControl);
        this.cbGamesInMatch.setEnabled(hasControl);
        this.lblPlayers.setEnabled(hasControl);
        this.cbPlayerCount.setEnabled(hasControl);
        while (this.lobby.getNumberOfSlots() < this.getNumPlayers()) {
            this.lobby.addSlot();
        }
    }

    private void updateVariantSelection() {
        if (this.lobby == null) {
            this.cbVariants.setSelectedIndex(0);
            return;
        }
        Iterable<GameType> appliedVariants = this.lobby.getAppliedVariants();
        int size = Iterables.size(appliedVariants);
        if (size == 0) {
            this.cbVariants.setSelectedIndex(0);
        } else if (size == 1) {
            this.cbVariants.setSelectedItem((Object)appliedVariants.iterator().next());
        } else {
            StringBuilder text = new StringBuilder();
            for (GameType variantType : appliedVariants) {
                if (text.length() > 0) {
                    text.append(", ");
                }
                text.append(variantType.toString());
            }
            this.cbVariants.setText(text.toString());
        }
    }

    void updateLayoutForVariants() {
        for (int i = 0; i < this.cbPlayerCount.getSelectedItem(); ++i) {
            this.playerPanels.get(i).updateVariantControlsVisibility();
        }
        this.playersScroll.revalidate();
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float fieldHeight = this.cbPlayerCount.getHeight();
        if (Forge.isLandscapeMode()) {
            this.lblVariants.setBounds(x, y, this.lblVariants.getAutoSizeBounds().width + PADDING / 2.0f, fieldHeight);
            this.cbVariants.setBounds(x += this.lblVariants.getWidth(), y, width - (x + this.lblGamesInMatch.getAutoSizeBounds().width + PADDING / 2.0f + this.lblPlayers.getAutoSizeBounds().width + (Utils.AVG_FINGER_WIDTH + PADDING) * 2.0f), fieldHeight);
            this.lblPlayers.setBounds(x += this.cbVariants.getWidth(), y, this.lblPlayers.getAutoSizeBounds().width + PADDING / 2.0f, fieldHeight);
            this.cbPlayerCount.setBounds(x += this.lblPlayers.getWidth(), y, Utils.AVG_FINGER_WIDTH, fieldHeight);
            this.lblGamesInMatch.setBounds(x += this.cbPlayerCount.getWidth() + PADDING, y, this.lblGamesInMatch.getAutoSizeBounds().width + PADDING / 2.0f, fieldHeight);
            this.cbGamesInMatch.setBounds(x += this.lblGamesInMatch.getWidth(), y, Utils.AVG_FINGER_WIDTH, fieldHeight);
        } else {
            this.lblVariants.setBounds(x, y, this.lblVariants.getAutoSizeBounds().width + PADDING / 2.0f, fieldHeight);
            this.cbVariants.setBounds(x += this.lblVariants.getWidth(), y, width - x - PADDING, fieldHeight);
            x = PADDING;
            this.lblPlayers.setBounds(x, y += this.cbVariants.getHeight() + PADDING, this.lblPlayers.getAutoSizeBounds().width + PADDING / 2.0f, fieldHeight);
            this.cbPlayerCount.setBounds(x += this.lblPlayers.getWidth(), y, Utils.AVG_FINGER_WIDTH, fieldHeight);
            this.lblGamesInMatch.setBounds(x += this.cbPlayerCount.getWidth() + PADDING, y, this.lblGamesInMatch.getAutoSizeBounds().width + PADDING / 2.0f, fieldHeight);
            this.cbGamesInMatch.setBounds(x += this.lblGamesInMatch.getWidth(), y, Utils.AVG_FINGER_WIDTH, fieldHeight);
        }
        this.playersScroll.setBounds(0.0f, y += this.cbPlayerCount.getHeight() + PADDING, width, height - y);
    }

    GameType getCurrentGameMode() {
        return this.lobby.getGameType();
    }

    void setCurrentGameMode(GameType mode) {
        this.lobby.setGameType(mode);
        this.update(true);
    }

    public int getNumPlayers() {
        return this.cbPlayerCount.getSelectedItem();
    }

    public void setNumPlayers(int numPlayers) {
        this.cbPlayerCount.setSelectedItem(numPlayers);
    }

    @Override
    protected void startMatch() {
        for (int i = 0; i < this.getNumPlayers(); ++i) {
            if (!this.lobby.isAllowNetworking()) {
                this.updateDeck(i);
            }
            this.updateName(i, this.getPlayerName(i));
            if (i != 0 || !Forge.isMobileAdventureMode) continue;
            this.updateName(0, GamePlayerUtil.getGuiPlayer().getName());
        }
        FThreads.invokeInBackgroundThread(() -> {
            Runnable startGame = this.lobby.startGame();
            if (startGame != null) {
                Forge.setLoadingaMatch(true);
                FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, startGame));
            }
        });
    }

    void updateAvatarPrefs() {
        int pOneIndex = this.playerPanels.get(0).getAvatarIndex();
        int pTwoIndex = this.playerPanels.get(1).getAvatarIndex();
        prefs.setPref(ForgePreferences.FPref.UI_AVATARS, pOneIndex + "," + pTwoIndex);
        prefs.save();
    }

    void updateSleevePrefs() {
        int pOneIndex = this.playerPanels.get(0).getSleeveIndex();
        int pTwoIndex = this.playerPanels.get(1).getSleeveIndex();
        prefs.setPref(ForgePreferences.FPref.UI_SLEEVES, pOneIndex + "," + pTwoIndex);
        prefs.save();
    }

    private void updatePlayersFromPrefs() {
        String string;
        ForgePreferences prefs = FModel.getPreferences();
        String[] avatarPrefs = prefs.getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        for (int i = 0; i < avatarPrefs.length; ++i) {
            int avatarIndex = Integer.parseInt(avatarPrefs[i]);
            if (avatarIndex < 0) {
                int random = 0;
                List<Integer> usedAvatars = this.getUsedAvatars();
                while (usedAvatars.contains(random = MyRandom.getRandom().nextInt(GuiBase.getInterface().getAvatarCount()))) {
                }
                avatarIndex = random;
            }
            this.playerPanels.get(i).setAvatarIndex(avatarIndex);
        }
        String[] sleevePrefs = prefs.getPref(ForgePreferences.FPref.UI_SLEEVES).split(",");
        for (int i = 0; i < sleevePrefs.length; ++i) {
            int sleeveIndex = Integer.parseInt(sleevePrefs[i]);
            if (sleeveIndex < 0) {
                int random = 0;
                List<Integer> usedSleeves = this.getUsedSleeves();
                while (usedSleeves.contains(random = MyRandom.getRandom().nextInt(GuiBase.getInterface().getSleevesCount()))) {
                }
                sleeveIndex = random;
            }
            this.playerPanels.get(i).setSleeveIndex(sleeveIndex);
        }
        String prefName = prefs.getPref(ForgePreferences.FPref.PLAYER_NAME);
        if (StringUtils.isBlank(prefName)) {
            Forge.getLocalizer();
            string = Localizer.getInstance().getMessage("lblHuman", new Object[0]);
        } else {
            string = prefName;
        }
        this.playerPanels.get(0).setPlayerName(string);
    }

    List<Integer> getUsedAvatars() {
        List<Integer> usedAvatars = Arrays.asList(-1, -1, -1, -1, -1, -1, -1, -1);
        int i = 0;
        for (PlayerPanel pp : this.playerPanels) {
            usedAvatars.set(i++, pp.getAvatarIndex());
        }
        return usedAvatars;
    }

    List<Integer> getUsedSleeves() {
        List<Integer> usedSleeves = Arrays.asList(-1, -1, -1, -1, -1, -1, -1, -1);
        int i = 0;
        for (PlayerPanel pp : this.playerPanels) {
            usedSleeves.set(i++, pp.getSleeveIndex());
        }
        return usedSleeves;
    }

    List<String> getPlayerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PlayerPanel pp : this.playerPanels) {
            names.add(pp.getPlayerName());
        }
        return names;
    }

    public String getPlayerName(int i) {
        return this.playerPanels.get(i).getPlayerName();
    }

    public int getPlayerAvatar(int i) {
        return this.playerPanels.get(i).getAvatarIndex();
    }

    public int getPlayerSleeve(int i) {
        return this.playerPanels.get(i).getSleeveIndex();
    }

    public boolean isPlayerAI(int playernum) {
        return this.playerPanels.get(playernum).getType() == LobbySlotType.AI;
    }

    public boolean isPlayerArchenemy(int playernum) {
        return this.playerPanels.get(playernum).isArchenemy();
    }

    @Override
    public final void update(int slot, LobbySlotType type) {
        FDeckChooser deckChooser = this.playerPanels.get(slot).getDeckChooser();
        DeckType selectedDeckType = deckChooser.getSelectedDeckType();
        switch (selectedDeckType) {
            case STANDARD_CARDGEN_DECK: 
            case PIONEER_CARDGEN_DECK: 
            case HISTORIC_CARDGEN_DECK: 
            case MODERN_CARDGEN_DECK: 
            case LEGACY_CARDGEN_DECK: 
            case VINTAGE_CARDGEN_DECK: 
            case PAUPER_CARDGEN_DECK: 
            case COLOR_DECK: 
            case STANDARD_COLOR_DECK: 
            case MODERN_COLOR_DECK: {
                deckChooser.refreshDeckListForAI();
                break;
            }
        }
        FDeckChooser commanderDeckChooser = this.playerPanels.get(slot).getCommanderDeckChooser();
        selectedDeckType = commanderDeckChooser.getSelectedDeckType();
        switch (selectedDeckType) {
            case RANDOM_CARDGEN_COMMANDER_DECK: 
            case RANDOM_COMMANDER_DECK: {
                commanderDeckChooser.refreshDeckListForAI();
                break;
            }
        }
        FDeckChooser tinyLeaderDeckChooser = this.playerPanels.get(slot).getTinyLeadersDeckChooser();
        selectedDeckType = tinyLeaderDeckChooser.getSelectedDeckType();
        switch (selectedDeckType) {
            case RANDOM_CARDGEN_COMMANDER_DECK: 
            case RANDOM_COMMANDER_DECK: {
                tinyLeaderDeckChooser.refreshDeckListForAI();
                break;
            }
        }
        FDeckChooser brawlDeckChooser = this.playerPanels.get(slot).getBrawlDeckChooser();
        selectedDeckType = brawlDeckChooser.getSelectedDeckType();
        switch (selectedDeckType) {
            case RANDOM_CARDGEN_COMMANDER_DECK: 
            case RANDOM_COMMANDER_DECK: {
                brawlDeckChooser.refreshDeckListForAI();
                break;
            }
        }
    }

    @Override
    public void update(boolean fullUpdate) {
        int playerCount = this.lobby.getNumberOfSlots();
        this.updateVariantSelection();
        boolean allowNetworking = this.lobby.isAllowNetworking();
        GuiBase.setNetworkplay(allowNetworking);
        this.setStartButtonAvailability();
        for (int i = 0; i < this.cbPlayerCount.getSelectedItem(); ++i) {
            boolean hasPanel;
            boolean bl = hasPanel = i < this.playerPanels.size();
            if (i < playerCount) {
                boolean isNewPanel;
                PlayerPanel panel;
                LobbySlot slot = this.lobby.getSlot(i);
                if (hasPanel) {
                    panel = this.playerPanels.get(i);
                    isNewPanel = !panel.isVisible();
                } else {
                    panel = new PlayerPanel(this, allowNetworking, i, slot, this.lobby.mayEdit(i), this.lobby.hasControl());
                    if (i == 2) {
                        panel.initialize(ForgePreferences.FPref.CONSTRUCTED_P3_DECK_STATE, ForgePreferences.FPref.COMMANDER_P3_DECK_STATE, ForgePreferences.FPref.OATHBREAKER_P3_DECK_STATE, ForgePreferences.FPref.TINY_LEADER_P3_DECK_STATE, ForgePreferences.FPref.BRAWL_P3_DECK_STATE, DeckType.COLOR_DECK);
                    } else if (i == 3) {
                        panel.initialize(ForgePreferences.FPref.CONSTRUCTED_P4_DECK_STATE, ForgePreferences.FPref.COMMANDER_P4_DECK_STATE, ForgePreferences.FPref.OATHBREAKER_P4_DECK_STATE, ForgePreferences.FPref.TINY_LEADER_P4_DECK_STATE, ForgePreferences.FPref.BRAWL_P4_DECK_STATE, DeckType.COLOR_DECK);
                    }
                    this.playerPanels.add(panel);
                    this.playersScroll.add(panel);
                    isNewPanel = true;
                }
                if (i == 0) {
                    slot.setIsDevMode(slot.isDevMode());
                }
                LobbySlotType type = slot.getType();
                panel.setType(type);
                if (type != LobbySlotType.AI) {
                    panel.setPlayerName(slot.getName());
                    panel.setAvatarIndex(slot.getAvatarIndex());
                    panel.setSleeveIndex(slot.getSleeveIndex());
                } else {
                    if (panel.getPlayerName().isEmpty()) {
                        panel.setPlayerName(slot.getName());
                    }
                    slot.setAvatarIndex(panel.getAvatarIndex());
                    slot.setSleeveIndex(panel.getSleeveIndex());
                }
                panel.setTeam(slot.getTeam());
                panel.setIsReady(slot.isReady());
                panel.setIsDevMode(slot.isDevMode());
                panel.setIsArchenemy(slot.isArchenemy());
                panel.setUseAiSimulation(slot.getAiOptions().contains((Object)AIOption.USE_SIMULATION));
                panel.setMayEdit(this.lobby.mayEdit(i));
                panel.setMayControl(this.lobby.mayControl(i));
                panel.setMayRemove(this.lobby.mayRemove(i));
                if (allowNetworking) {
                    if (slot.getDeckName() != null) {
                        panel.setDeckSelectorButtonText(slot.getDeckName());
                    }
                    if (slot.getPlanarDeckName() != null) {
                        panel.setPlanarDeckName(slot.getPlanarDeckName());
                    }
                    if (slot.getSchemeDeckName() != null) {
                        panel.setSchemeDeckName(slot.getSchemeDeckName());
                    }
                    if (slot.getAvatarVanguard() != null) {
                        panel.setVanguarAvatarName(slot.getAvatarVanguard());
                    }
                }
                if (fullUpdate && (type == LobbySlotType.LOCAL || type == LobbySlotType.AI) && !allowNetworking) {
                    this.updateDeck(i);
                }
                if (isNewPanel) {
                    panel.setVisible(true);
                }
                if (Forge.gameInProgress && slot.getType() == LobbySlotType.LOCAL) {
                    ImageCache.preloadCache(this.decks[i]);
                }
                Gdx.graphics.requestRendering();
                continue;
            }
            if (!hasPanel) continue;
            this.playerPanels.get(i).setVisible(false);
        }
    }

    @Override
    public void setPlayerChangeListener(IPlayerChangeListener playerChangeListener0) {
        this.playerChangeListener = playerChangeListener0;
    }

    private void updateDeck(int playerIndex) {
        Deck deck;
        if (playerIndex >= this.getNumPlayers()) {
            return;
        }
        PlayerPanel playerPanel = this.playerPanels.get(playerIndex);
        String deckName = "";
        if (this.hasVariant(GameType.Commander)) {
            deck = playerPanel.getCommanderDeck();
            if (deck != null) {
                playerPanel.getCommanderDeckChooser().saveState();
                deckName = Forge.getLocalizer().getMessage("lblCommanderDeck", new Object[0]) + ": " + playerPanel.getCommanderDeckChooser().getDeck().getName();
            }
        } else if (this.hasVariant(GameType.Oathbreaker)) {
            deck = playerPanel.getOathbreakerDeck();
            if (deck != null) {
                playerPanel.getOathbreakerDeckChooser().saveState();
                deckName = Forge.getLocalizer().getMessage("lblOathbreakerDeck", new Object[0]) + ": " + playerPanel.getOathbreakerDeckChooser().getDeck().getName();
            }
        } else if (this.hasVariant(GameType.TinyLeaders)) {
            deck = playerPanel.getTinyLeadersDeck();
            if (deck != null) {
                playerPanel.getTinyLeadersDeckChooser().saveState();
                deckName = Forge.getLocalizer().getMessage("lblTinyLeadersDeck", new Object[0]) + ": " + playerPanel.getTinyLeadersDeckChooser().getDeck().getName();
            }
        } else if (this.hasVariant(GameType.Brawl)) {
            deck = playerPanel.getBrawlDeck();
            if (deck != null) {
                playerPanel.getBrawlDeckChooser().saveState();
                deckName = Forge.getLocalizer().getMessage("lblBrawlDeck", new Object[0]) + ": " + playerPanel.getBrawlDeckChooser().getDeck().getName();
            }
        } else {
            deck = playerPanel.getDeck();
            if (deck != null) {
                playerPanel.getDeckChooser().saveState();
                deckName = playerPanel.getDeckChooser().getSelectedDeckType().toString() + ": " + playerPanel.getDeckChooser().getDeck().getName();
            }
        }
        if (deck == null) {
            return;
        }
        Deck playerDeck = deck;
        String VanguardAvatar = null;
        String SchemeDeckName = null;
        String PlanarDeckname = null;
        if (this.hasVariant(GameType.Archenemy) || this.hasVariant(GameType.ArchenemyRumble)) {
            if (playerDeck == deck) {
                playerDeck = new Deck(deck);
            }
            playerDeck.putSection(DeckSection.Schemes, playerPanel.getSchemeDeck().get(DeckSection.Schemes));
            if (!playerPanel.getSchemeDeck().getName().isEmpty()) {
                SchemeDeckName = Forge.getLocalizer().getMessage("lblSchemeDeck", new Object[0]) + ": " + playerPanel.getSchemeDeck().getName();
                playerPanel.setSchemeDeckName(SchemeDeckName);
            }
        }
        if (this.hasVariant(GameType.Planechase)) {
            if (playerDeck == deck) {
                playerDeck = new Deck(deck);
            }
            playerDeck.putSection(DeckSection.Planes, playerPanel.getPlanarDeck().get(DeckSection.Planes));
            if (!playerPanel.getPlanarDeck().getName().isEmpty()) {
                PlanarDeckname = Forge.getLocalizer().getMessage("lblPlanarDeck", new Object[0]) + ": " + playerPanel.getPlanarDeck().getName();
                playerPanel.setPlanarDeckName(PlanarDeckname);
            }
        }
        if (this.hasVariant(GameType.Vanguard)) {
            if (playerDeck == deck) {
                playerDeck = new Deck(deck);
            }
            CardPool avatarPool = new CardPool();
            avatarPool.add(playerPanel.getVanguardAvatar());
            playerDeck.putSection(DeckSection.Avatar, avatarPool);
            VanguardAvatar = Forge.getLocalizer().getMessage("lblVanguard", new Object[0]) + ": " + playerPanel.getVanguardAvatar().getName();
            playerPanel.setVanguarAvatarName(VanguardAvatar);
        }
        this.decks[playerIndex] = playerDeck;
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(playerIndex, UpdateLobbyPlayerEvent.deckUpdate(playerDeck));
            this.playerChangeListener.update(playerIndex, UpdateLobbyPlayerEvent.setDeckSchemePlaneVanguard(TextUtil.fastReplace(deckName, " Generated Deck", ""), SchemeDeckName, PlanarDeckname, VanguardAvatar));
        }
    }

    private void updateName(int playerIndex, String name) {
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(playerIndex, UpdateLobbyPlayerEvent.nameUpdate(name));
        }
    }

    void updateAvatar(int index, int avatarIndex) {
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, UpdateLobbyPlayerEvent.avatarUpdate(avatarIndex));
        }
    }

    void updateSleeve(int index, int sleeveIndex) {
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, UpdateLobbyPlayerEvent.sleeveUpdate(sleeveIndex));
        }
    }

    void setReady(int index, boolean ready) {
        if (this.lobby.isAllowNetworking()) {
            this.updateDeck(index);
            this.fireReady(index, ready);
            return;
        }
        if (ready) {
            this.updateDeck(index);
            if (this.decks[index] == null) {
                FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("msgSelectAdeckBeforeReadying", new Object[0]));
                this.update(false);
                return;
            }
        }
        this.firePlayerChangeListener(index);
    }

    void setDevMode(int index) {
        int playerCount = this.lobby.getNumberOfSlots();
        for (int i = 0; i < playerCount; ++i) {
            PlayerPanel panel = this.playerPanels.get(i);
            panel.setIsReady(false);
            this.firePlayerChangeListener(i);
        }
    }

    void firePlayerChangeListener(int index) {
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, this.getSlot(index));
        }
    }

    void fireReady(int index, boolean ready) {
        this.playerPanels.get(index).setIsReady(ready);
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, UpdateLobbyPlayerEvent.isReadyUpdate(ready));
        }
    }

    void updatemyTeam(int index, int team) {
        if (this.playerChangeListener != null) {
            this.playerChangeListener.update(index, UpdateLobbyPlayerEvent.teamUpdate(team));
        }
    }

    void updateMyDeck(int index) {
        if (this.playerPanels.size() < 2) {
            return;
        }
        this.updateDeck(index);
    }

    public void removePlayer(int index) {
        this.lobby.removeSlot(index);
    }

    public boolean hasVariant(GameType variant) {
        return this.lobby.hasVariant(variant);
    }

    private UpdateLobbyPlayerEvent getSlot(int index) {
        PlayerPanel panel = this.playerPanels.get(index);
        return UpdateLobbyPlayerEvent.create(panel.getType(), panel.getPlayerName(), panel.getAvatarIndex(), panel.getSleeveIndex(), panel.getTeam(), panel.isArchenemy(), panel.isReady(), panel.isDevMode(), panel.getAiOptions());
    }

    public List<PlayerPanel> getPlayerPanels() {
        return this.playerPanels;
    }

    public FScrollPane getPlayersScroll() {
        return this.playersScroll;
    }

    public void setStartButtonAvailability() {
        if (this.lobby.isAllowNetworking() && FServerManager.getInstance() != null) {
            this.btnStart.setVisible(FServerManager.getInstance().isHosting());
        } else {
            this.btnStart.setVisible(true);
        }
    }

    private class MultiVariantSelect
    extends FScreen {
        private final FList<Variant> lstVariants;

        private MultiVariantSelect() {
            Forge.getLocalizer();
            super(Localizer.getInstance().getMessage("lblSelectVariants", new Object[0]));
            this.lstVariants = this.add(new FList());
            this.lstVariants.setListItemRenderer(new VariantRenderer());
            this.lstVariants.addItem(new Variant(GameType.Vanguard));
            this.lstVariants.addItem(new Variant(GameType.MomirBasic));
            this.lstVariants.addItem(new Variant(GameType.MoJhoSto));
            this.lstVariants.addItem(new Variant(GameType.Commander));
            this.lstVariants.addItem(new Variant(GameType.Oathbreaker));
            this.lstVariants.addItem(new Variant(GameType.TinyLeaders));
            this.lstVariants.addItem(new Variant(GameType.Brawl));
            this.lstVariants.addItem(new Variant(GameType.Planechase));
            this.lstVariants.addItem(new Variant(GameType.Archenemy));
            this.lstVariants.addItem(new Variant(GameType.ArchenemyRumble));
        }

        @Override
        protected void doLayout(float startY, float width, float height) {
            this.lstVariants.setBounds(0.0f, startY, width, height - startY);
        }

        private class VariantRenderer
        extends FList.ListItemRenderer<Variant> {
            private VariantRenderer() {
            }

            @Override
            public float getItemHeight() {
                return SettingsScreen.SETTING_HEIGHT;
            }

            @Override
            public boolean tap(Integer index, Variant value, float x, float y, int count) {
                value.toggle();
                return true;
            }

            @Override
            public void drawValue(Graphics g2, Integer index, Variant value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                float offset = SettingsScreen.getInsets(w) - FList.PADDING;
                String text = value.gameType.toString();
                float totalHeight = h2 -= 2.0f * offset;
                h2 = font.getMultiLineBounds((CharSequence)text).height + SettingsScreen.SETTING_PADDING;
                g2.drawText(text, font, foreColor, x += offset, y += offset, w -= 2.0f * offset, h2, false, 8, false);
                value.draw(g2, font, foreColor, x, y, w, h2);
                g2.drawText(value.gameType.getDescription(), SettingsScreen.DESC_FONT, SettingsScreen.DESC_COLOR, x, y + (h2 += SettingsScreen.SETTING_PADDING), w, totalHeight - h2 + SettingsScreen.getInsets(w), true, 8, false);
            }
        }

        private class Variant {
            private final GameType gameType;

            private Variant(GameType gameType0) {
                this.gameType = gameType0;
            }

            private void draw(Graphics g2, FSkinFont font, FSkinColor color, float x, float y, float w, float h2) {
                x += w - h2;
                w = h2;
                FCheckBox.drawCheckBox(g2, SettingsScreen.DESC_COLOR, color, LobbyScreen.this.lobby.hasVariant(this.gameType), x, y, w, h2);
            }

            private void toggle() {
                if (LobbyScreen.this.lobby.hasVariant(this.gameType)) {
                    LobbyScreen.this.lobby.removeVariant(this.gameType);
                } else {
                    LobbyScreen.this.lobby.applyVariant(this.gameType);
                }
                LobbyScreen.this.updateVariantSelection();
                LobbyScreen.this.updateLayoutForVariants();
                HashSet<GameType> gameTypes = new HashSet<GameType>();
                for (GameType variant : LobbyScreen.this.lobby.getAppliedVariants()) {
                    gameTypes.add(variant);
                }
                FModel.getPreferences().setGameType(ForgePreferences.FPref.UI_APPLIED_VARIANTS, gameTypes);
                FModel.getPreferences().save();
            }
        }
    }
}

