/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.achievements;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.assets.FBufferedImage;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.card.CardZoom;
import forge.item.IPaperCard;
import forge.localinstance.achievements.Achievement;
import forge.localinstance.achievements.AchievementCollection;
import forge.menu.FDropDown;
import forge.screens.FScreen;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import forge.util.Utils;

public class AchievementsScreen
extends FScreen {
    private static final float TROPHY_PADDING = 45.0f;
    private static final float PADDING = Utils.scale(5.0f);
    private static final float SELECTED_BORDER_THICKNESS = Utils.scale(1.0f);
    private static final int MIN_SHELVES = 4;
    private static final int TROPHIES_PER_SHELVE = 4;
    private static final FSkinFont NAME_FONT = FSkinFont.get(14);
    private static final FSkinFont DESC_FONT = FSkinFont.get(12);
    private static AchievementsScreen achievementsScreen;
    private final FComboBox<AchievementCollection> cbCollections = this.add(new FComboBox());
    private final TrophyCase trophyCase = this.add(new TrophyCase());

    private static FSkinColor getTextColor() {
        return FLabel.getDefaultTextColor();
    }

    private static FSkinColor getNotEarnedColor() {
        return AchievementsScreen.getTextColor().alphaColor(0.5f);
    }

    public static void show() {
        if (achievementsScreen == null) {
            achievementsScreen = new AchievementsScreen();
        }
        Forge.openScreen(achievementsScreen);
    }

    private AchievementsScreen() {
        super(Forge.getLocalizer().getMessage("lblAchievements", new Object[0]));
        AchievementCollection.buildComboBox(this.cbCollections);
        this.cbCollections.setSelectedIndex(0);
        this.cbCollections.setAlignment(1);
        this.cbCollections.setChangedHandler(e -> this.setAchievements(this.cbCollections.getSelectedItem()));
        this.setAchievements(this.cbCollections.getSelectedItem());
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        this.cbCollections.setBounds(x, y, width -= 2.0f * x, this.cbCollections.getHeight());
        this.trophyCase.setBounds(x, y += this.cbCollections.getHeight() + PADDING, width, height - PADDING - y);
    }

    @Override
    protected float doLandscapeLayout(float width, float height) {
        this.getHeader().setBounds(0.0f, 0.0f, 0.0f, 0.0f);
        this.doLayout(0.0f, width, height);
        return 0.0f;
    }

    private void setAchievements(AchievementCollection achievements0) {
        this.trophyCase.achievements = achievements0;
        this.trophyCase.selectedAchievement = null;
        this.trophyCase.shelfCount = (int)Math.ceil((double)achievements0.getCount() / 4.0);
        if (this.trophyCase.shelfCount < 4) {
            this.trophyCase.shelfCount = 4;
        }
        for (Achievement achievement : achievements0) {
            ((FBufferedImage)achievement.getImage()).getTexture();
        }
        this.trophyCase.revalidate();
    }

    private static class TrophyCase
    extends FScrollPane {
        private static final Color FORE_COLOR = new Color(0.9372549f, 0.8627451f, 0.5647059f, 1.0f);
        private AchievementCollection achievements;
        private int shelfCount;
        private float extraWidth = 0.0f;
        private Achievement selectedAchievement;

        private TrophyCase() {
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float scrollWidth = visibleWidth + this.extraWidth;
            float scale = scrollWidth / FSkinImage.TROPHY_CASE_TOP.getWidth();
            float scrollHeight = (FSkinImage.TROPHY_CASE_TOP.getHeight() + (float)this.shelfCount * FSkinImage.TROPHY_SHELF.getHeight()) * scale;
            return new FScrollPane.ScrollBounds(scrollWidth, scrollHeight);
        }

        private Achievement getAchievementAt(float x0, float y0) {
            float w = this.getScrollWidth();
            float scale = w / FSkinImage.TROPHY_CASE_TOP.getWidth();
            float shelfHeight = FSkinImage.TROPHY_SHELF.getHeight() * scale;
            float trophyWidth = (FSkinImage.COMMON_TROPHY.getWidth() + 45.0f) * scale;
            float trophyHeight = FSkinImage.COMMON_TROPHY.getHeight() * scale;
            float x = -this.getScrollLeft() + (w - 4.0f * trophyWidth) / 2.0f;
            float y = -this.getScrollTop() + FSkinImage.TROPHY_CASE_TOP.getHeight() * scale + (shelfHeight - trophyHeight - 37.0f * scale) / 2.0f;
            int trophyCount = 0;
            float startX = x;
            for (Achievement achievement : this.achievements) {
                if (trophyCount == 4) {
                    trophyCount = 0;
                    x = startX;
                    if ((y += shelfHeight) >= this.getHeight()) {
                        return null;
                    }
                }
                if (x <= x0 && x0 < x + trophyWidth && y <= y0 && y0 < y + shelfHeight) {
                    return achievement;
                }
                ++trophyCount;
                x += trophyWidth;
            }
            return null;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            Achievement achievement = this.getAchievementAt(x, y);
            if (count > 1 && this.showCard(achievement)) {
                return true;
            }
            if (achievement == this.selectedAchievement) {
                achievement = null;
            }
            this.selectedAchievement = achievement;
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            this.selectedAchievement = this.getAchievementAt(x, y);
            this.showCard(this.selectedAchievement);
            return true;
        }

        private boolean showCard(Achievement achievement) {
            IPaperCard pc;
            if (achievement != null && (pc = achievement.getPaperCard()) != null) {
                CardZoom.show(pc);
                return true;
            }
            return false;
        }

        @Override
        public boolean zoom(float x, float y, float amount) {
            this.selectedAchievement = null;
            float oldScrollLeft = this.getScrollLeft();
            float oldScrollTop = this.getScrollTop();
            float oldScrollWidth = this.getScrollWidth();
            float oldScrollHeight = this.getScrollHeight();
            x += oldScrollLeft;
            y += oldScrollTop;
            float zoom = oldScrollWidth / this.getWidth();
            this.extraWidth += amount * zoom;
            if (this.extraWidth < 0.0f) {
                this.extraWidth = 0.0f;
            }
            this.revalidate();
            float newScrollWidth = this.getScrollWidth();
            float xAfter = x * newScrollWidth / oldScrollWidth;
            this.setScrollLeft(oldScrollLeft + xAfter - x);
            float newScrollHeight = this.getScrollHeight();
            float yAfter = y * newScrollHeight / oldScrollHeight;
            this.setScrollTop(oldScrollTop + yAfter - y);
            return true;
        }

        @Override
        protected void drawBackground(Graphics g2) {
            float x = -this.getScrollLeft();
            float y = -this.getScrollTop();
            float w = this.getScrollWidth();
            float scale = w / FSkinImage.TROPHY_CASE_TOP.getWidth();
            float topHeight = FSkinImage.TROPHY_CASE_TOP.getHeight() * scale;
            float shelfHeight = FSkinImage.TROPHY_SHELF.getHeight() * scale;
            float trophyOffset = 45.0f * scale / 2.0f;
            float trophyImageWidth = FSkinImage.COMMON_TROPHY.getWidth() * scale;
            float trophyWidth = trophyImageWidth + 45.0f * scale;
            float trophyHeight = FSkinImage.COMMON_TROPHY.getHeight() * scale;
            float plateWidth = FSkinImage.TROPHY_PLATE.getWidth() * scale;
            float plateHeight = FSkinImage.TROPHY_PLATE.getHeight() * scale;
            float titleHeight = plateHeight * 0.55f;
            float subTitleHeight = plateHeight * 0.35f;
            FSkinFont titleFont = FSkinFont.forHeight(titleHeight);
            FSkinFont subTitleFont = FSkinFont.forHeight(subTitleHeight);
            float plateY = y + topHeight + shelfHeight - plateHeight;
            float trophyStartY = plateY - trophyHeight;
            float plateOffset = (trophyWidth - plateWidth) / 2.0f;
            if (y + topHeight > 0.0f) {
                g2.drawImage(FSkinImage.TROPHY_CASE_TOP, x, y, w, topHeight);
            }
            y += topHeight;
            for (int i = 0; i < this.shelfCount; ++i) {
                if (y + shelfHeight > 0.0f) {
                    g2.drawImage(FSkinImage.TROPHY_SHELF, x, y, w, shelfHeight);
                }
                if ((y += shelfHeight) >= this.getHeight()) break;
            }
            y = trophyStartY;
            int trophyCount = 0;
            float startX = x += (w - 4.0f * trophyWidth) / 2.0f;
            Rectangle selectRect = null;
            for (Achievement achievement : this.achievements) {
                if (trophyCount == 4) {
                    trophyCount = 0;
                    plateY += shelfHeight;
                    x = startX;
                    if ((y += shelfHeight) >= this.getHeight()) break;
                }
                if (plateY + plateHeight > 0.0f) {
                    g2.drawImage((FImage)achievement.getImage(), x + trophyOffset, y, trophyImageWidth, trophyHeight);
                    g2.drawImage(FSkinImage.TROPHY_PLATE, x + plateOffset, plateY, plateWidth, plateHeight);
                    g2.drawText(achievement.getDisplayName(), titleFont, FORE_COLOR, x + plateOffset + plateWidth * 0.075f, plateY + plateHeight * 0.05f, plateWidth * 0.85f, titleHeight, false, 1, true);
                    String subTitle = achievement.getSubTitle(false);
                    if (subTitle != null) {
                        g2.drawText(subTitle, subTitleFont, FORE_COLOR, x + plateOffset + plateWidth * 0.075f, plateY + plateHeight * 0.6f, plateWidth * 0.85f, subTitleHeight, false, 1, true);
                    }
                    if (achievement == this.selectedAchievement) {
                        float selY = y - shelfHeight + trophyHeight + plateHeight;
                        g2.drawRect(SELECTED_BORDER_THICKNESS, Color.GREEN, x, selY, trophyWidth, shelfHeight);
                        selectRect = new Rectangle(x, selY, trophyWidth, shelfHeight);
                    }
                }
                ++trophyCount;
                x += trophyWidth;
            }
            if (selectRect != null) {
                String subTitle = this.selectedAchievement.getSubTitle(true);
                String sharedDesc = this.selectedAchievement.getSharedDesc();
                String mythicDesc = this.selectedAchievement.getMythicDesc();
                String rareDesc = this.selectedAchievement.getRareDesc();
                String uncommonDesc = this.selectedAchievement.getUncommonDesc();
                String commonDesc = this.selectedAchievement.getCommonDesc();
                w = this.getWidth() - 2.0f * PADDING;
                float h2 = NAME_FONT.getLineHeight() + 2.5f * PADDING;
                if (subTitle != null) {
                    h2 += DESC_FONT.getLineHeight();
                }
                if (sharedDesc != null) {
                    h2 += DESC_FONT.getLineHeight();
                }
                if (mythicDesc != null) {
                    h2 += DESC_FONT.getLineHeight();
                }
                if (rareDesc != null) {
                    h2 += DESC_FONT.getLineHeight();
                }
                if (uncommonDesc != null) {
                    h2 += DESC_FONT.getLineHeight();
                }
                if (commonDesc != null) {
                    h2 += DESC_FONT.getLineHeight();
                }
                x = PADDING;
                y = selectRect.y + selectRect.height + PADDING;
                if (y + h2 > this.getHeight()) {
                    y = selectRect.y - PADDING > h2 ? selectRect.y - h2 - PADDING : this.getHeight() - h2;
                }
                g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, x, y, w, h2);
                g2.fillRect(FScreen.getTextureOverlayColor(), x, y, w, h2);
                g2.drawRect(SELECTED_BORDER_THICKNESS, FDropDown.getBorderColor(), x, y, w, h2);
                g2.drawText(this.selectedAchievement.getDisplayName(), NAME_FONT, AchievementsScreen.getTextColor(), x += PADDING, y += PADDING, w -= 2.0f * PADDING, h2 -= 2.0f * PADDING, false, 8, false);
                y += NAME_FONT.getLineHeight();
                if (subTitle != null) {
                    g2.drawText(subTitle, DESC_FONT, AchievementsScreen.getTextColor(), x, y, w, h2, false, 8, false);
                    y += DESC_FONT.getLineHeight();
                }
                y += PADDING;
                if (sharedDesc != null) {
                    g2.drawText(this.selectedAchievement.isSpecial() ? sharedDesc : sharedDesc + "...", DESC_FONT, AchievementsScreen.getTextColor(), x, y, w, h2, false, 8, false);
                    y += DESC_FONT.getLineHeight();
                }
                if (mythicDesc != null) {
                    g2.drawText(this.selectedAchievement.isSpecial() ? mythicDesc : "(" + Localizer.getInstance().getMessage("lblMythic", new Object[0]) + ") " + mythicDesc, DESC_FONT, this.selectedAchievement.earnedMythic() ? AchievementsScreen.getTextColor() : AchievementsScreen.getNotEarnedColor(), x, y, w, h2, false, 8, false);
                    y += DESC_FONT.getLineHeight();
                }
                if (rareDesc != null) {
                    g2.drawText("(" + Localizer.getInstance().getMessage("lblRare", new Object[0]) + ") " + rareDesc, DESC_FONT, this.selectedAchievement.earnedRare() ? AchievementsScreen.getTextColor() : AchievementsScreen.getNotEarnedColor(), x, y, w, h2, false, 8, false);
                    y += DESC_FONT.getLineHeight();
                }
                if (uncommonDesc != null) {
                    g2.drawText("(" + Localizer.getInstance().getMessage("lblUncommon", new Object[0]) + ") " + uncommonDesc, DESC_FONT, this.selectedAchievement.earnedUncommon() ? AchievementsScreen.getTextColor() : AchievementsScreen.getNotEarnedColor(), x, y, w, h2, false, 8, false);
                    y += DESC_FONT.getLineHeight();
                }
                if (commonDesc != null) {
                    g2.drawText("(" + Localizer.getInstance().getMessage("lblCommon", new Object[0]) + ") " + commonDesc, DESC_FONT, this.selectedAchievement.earnedCommon() ? AchievementsScreen.getTextColor() : AchievementsScreen.getNotEarnedColor(), x, y, w, h2, false, 8, false);
                }
            }
        }
    }
}

