/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Timer;
import forge.Forge;
import forge.Graphics;
import forge.adventure.scene.ArenaScene;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.animation.ForgeAnimation;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.sound.SoundSystem;
import forge.toolbox.FContainer;
import forge.toolbox.FProgressBar;
import org.apache.commons.lang3.tuple.Pair;

public class TransitionScreen
extends FContainer {
    private BGAnimation bgAnimation;
    private FProgressBar progressBar = new FProgressBar();
    Runnable runnable;
    TextureRegion textureRegion;
    TextureRegion screenUIBackground;
    TextureRegion playerAvatar;
    Texture vsTexture;
    String enemyAtlasPath;
    String playerAvatarName;
    String enemyAvatarName;
    private String message = "";
    private String playerRecord = "";
    private String enemyRecord = "";
    boolean matchTransition;
    boolean isloading;
    boolean isIntro;
    boolean isFadeMusic;
    boolean isArenaScene;
    boolean isAlternate;
    GlyphLayout layout;

    public TransitionScreen(Runnable proc, TextureRegion screen, boolean enterMatch, boolean loading) {
        this(proc, screen, enterMatch, loading, false, false);
    }

    public TransitionScreen(Runnable proc, TextureRegion screen, String message) {
        this(proc, screen, true, false, false, false, false, message, null, "", "", "", "", "");
    }

    public TransitionScreen(Runnable proc, TextureRegion screen, boolean enterMatch, boolean loading, String loadingMessage) {
        this(proc, screen, enterMatch, loading, false, false, loadingMessage, null, "", "", "", "", "");
    }

    public TransitionScreen(Runnable proc, TextureRegion screen, boolean enterMatch, boolean loading, boolean intro, boolean fadeMusic) {
        this(proc, screen, enterMatch, loading, intro, fadeMusic, "", null, "", "", "", "", "");
    }

    public TransitionScreen(Runnable proc, TextureRegion screen, boolean enterMatch, boolean loading, boolean intro, boolean fadeMusic, String loadingMessage, TextureRegion player, String enemyAtlas, String playerName, String enemyName) {
        this(proc, screen, enterMatch, loading, intro, fadeMusic, loadingMessage, player, enemyAtlas, playerName, enemyName, "", "");
    }

    public TransitionScreen(Runnable proc, TextureRegion screen, boolean enterMatch, boolean loading, boolean intro, boolean fadeMusic, String loadingMessage, TextureRegion player, String enemyAtlas, String playerName, String enemyName, String playerRecord, String enemyRecord) {
        this(proc, screen, false, enterMatch, loading, intro, fadeMusic, loadingMessage, player, enemyAtlas, playerName, enemyName, playerRecord, enemyRecord);
    }

    public TransitionScreen(Runnable proc, TextureRegion screen, boolean alternate, boolean enterMatch, boolean loading, boolean intro, boolean fadeMusic, String loadingMessage, TextureRegion player, String enemyAtlas, String playerName, String enemyName, String playerRecord, String enemyRecord) {
        this.progressBar.setMaximum(100);
        this.progressBar.setPercentMode(true);
        this.progressBar.setShowETA(false);
        this.bgAnimation = new BGAnimation();
        this.runnable = proc;
        this.textureRegion = screen;
        this.matchTransition = enterMatch;
        this.isloading = loading;
        this.isIntro = intro;
        this.isFadeMusic = fadeMusic;
        this.isAlternate = alternate;
        this.message = loadingMessage;
        this.playerRecord = playerRecord;
        this.enemyRecord = enemyRecord;
        boolean bl = Forge.advStartup = intro && Forge.selector.equals("Adventure");
        if (Forge.getCurrentScene() instanceof ArenaScene) {
            this.isArenaScene = true;
            this.screenUIBackground = ((ArenaScene)Forge.getCurrentScene()).getUIBackground();
        } else {
            this.isArenaScene = false;
            this.screenUIBackground = null;
        }
        this.playerAvatar = player;
        this.playerAvatarName = playerName;
        this.enemyAvatarName = enemyName;
        this.enemyAtlasPath = enemyAtlas;
        this.vsTexture = Forge.getAssets().fallback_skins().get("vs");
        this.layout = new GlyphLayout();
    }

    public FProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    protected void doLayout(float width, float height) {
    }

    public boolean isMatchTransition() {
        return this.matchTransition;
    }

    public void disableMatchTransition() {
        this.matchTransition = false;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        this.bgAnimation.start();
        this.bgAnimation.drawBackground(g2);
    }

    private class BGAnimation
    extends ForgeAnimation {
        float DURATION;
        private float progress;
        TextureRegion enemyAvatar;
        final boolean[] run;

        private BGAnimation() {
            this.DURATION = TransitionScreen.this.isArenaScene || TransitionScreen.this.isAlternate ? 1.2f : 0.6f;
            this.progress = 0.0f;
            this.run = new boolean[]{false};
        }

        public void drawBackground(Graphics g2) {
            float percentage = this.progress / this.DURATION;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (TransitionScreen.this.isFadeMusic) {
                try {
                    SoundSystem.instance.fadeModifier(1.0f - percentage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (TransitionScreen.this.isAlternate) {
                g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                if (TransitionScreen.this.textureRegion != null) {
                    g2.drawPortalFade(TransitionScreen.this.textureRegion, 0.0f, 0.0f, Forge.getScreenWidth(), Forge.getScreenHeight(), Float.valueOf(Math.min(percentage, 1.0f)), true);
                }
            } else if (TransitionScreen.this.isloading) {
                float ymod;
                FSkinTexture bgTexture;
                g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                FSkinTexture fSkinTexture = bgTexture = Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE;
                if (bgTexture != null) {
                    g2.setAlphaComposite(percentage);
                    g2.drawImage(bgTexture, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                    g2.setAlphaComposite(oldAlpha);
                }
                float xmod = Forge.getScreenHeight() > 2000 ? 1.5f : 1.0f;
                xmod *= 1.0f;
                if (FSkin.getLogo() != null) {
                    ymod = (float)Forge.getScreenHeight() / 2.0f + (float)FSkin.getLogo().getHeight() * xmod / 2.0f;
                    g2.drawImage(FSkin.getLogo(), (float)Forge.getScreenWidth() / 2.0f - (float)FSkin.getLogo().getWidth() * xmod / 2.0f, (float)Forge.getScreenHeight() / 2.0f - (float)FSkin.getLogo().getHeight() * xmod / 2.0f, (float)FSkin.getLogo().getWidth() * xmod, (float)FSkin.getLogo().getHeight() * xmod);
                } else {
                    ymod = (float)Forge.getScreenHeight() / 2.0f + FSkinImage.LOGO.getHeight() * xmod / 1.5f;
                    g2.drawImage(FSkinImage.LOGO, (float)Forge.getScreenWidth() / 2.0f - FSkinImage.LOGO.getWidth() * xmod / 2.0f, (float)Forge.getScreenHeight() / 2.0f - FSkinImage.LOGO.getHeight() * xmod / 1.5f, FSkinImage.LOGO.getWidth() * xmod, FSkinImage.LOGO.getHeight() * xmod);
                }
                if (Forge.isMobileAdventureMode) {
                    float w = Forge.isLandscapeMode() ? (float)Forge.getScreenWidth() / 2.0f : (float)Forge.getScreenHeight() / 2.0f;
                    float h2 = 0.12666667f * (w / 2.0f);
                    float x = ((float)Forge.getScreenWidth() - w) / 2.0f;
                    float y = ymod + 10.0f;
                    int multi = (int)(percentage * 100.0f) < 97 ? (int)(percentage * 100.0f) : 100;
                    TransitionScreen.this.progressBar.setBounds(x, (float)Forge.getScreenHeight() - h2 * 2.0f, w, h2);
                    TransitionScreen.this.progressBar.setValue(multi);
                    if (multi == 100 && !TransitionScreen.this.message.isEmpty()) {
                        TransitionScreen.this.progressBar.setDescription(TransitionScreen.this.message);
                    }
                    g2.draw(TransitionScreen.this.progressBar);
                }
            } else if (TransitionScreen.this.matchTransition) {
                Pair<Integer, Integer> winloss;
                float screenW = Forge.isLandscapeMode() ? (float)Forge.getScreenWidth() : (float)Forge.getScreenHeight();
                float screenH = Forge.isLandscapeMode() ? (float)Forge.getScreenHeight() : (float)Forge.getScreenWidth();
                float scale = screenW / 4.0f;
                float centerX = screenW / 2.0f;
                float centerY = screenH / 2.0f;
                this.enemyAvatar = Config.instance().getAtlas(TransitionScreen.this.enemyAtlasPath).createSprite("Avatar");
                if (this.enemyAvatar != null) {
                    this.enemyAvatar.flip(true, false);
                }
                float fontScale = GuiBase.isAndroid() ? 14.0f : 10.0f;
                BitmapFont font = Controls.getBitmapFont("default", fontScale / (screenW / screenH));
                if (TransitionScreen.this.textureRegion != null) {
                    if (TransitionScreen.this.isArenaScene) {
                        g2.drawImage(TransitionScreen.this.screenUIBackground, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                    } else {
                        g2.drawImage(FSkinTexture.ADV_BG_TEXTURE, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                    }
                    g2.setAlphaComposite(1.0f - percentage);
                    g2.drawImage(TransitionScreen.this.textureRegion, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                    g2.setAlphaComposite(oldAlpha);
                }
                String p1Record = "0 - 0";
                String p2Record = "0 - 0";
                if (TransitionScreen.this.playerRecord.length() > 0 && TransitionScreen.this.enemyRecord.length() > 0) {
                    p1Record = TransitionScreen.this.playerRecord;
                    p2Record = TransitionScreen.this.enemyRecord;
                }
                if ((winloss = Current.player().getStatistic().getWinLossRecord().get(TransitionScreen.this.enemyAvatarName)) != null) {
                    p1Record = winloss.getKey() + " - " + winloss.getValue();
                    p2Record = winloss.getValue() + " - " + winloss.getKey();
                }
                if (Forge.isLandscapeMode()) {
                    float playerAvatarX = (screenW / 4.0f - scale / 2.0f) * percentage;
                    float playerAvatarY = centerY - scale / 2.0f;
                    g2.drawImage(TransitionScreen.this.playerAvatar, playerAvatarX, playerAvatarY, scale, scale);
                    TransitionScreen.this.layout.setText(font, TransitionScreen.this.playerAvatarName);
                    g2.drawText(TransitionScreen.this.playerAvatarName, font, screenW / 4.0f - TransitionScreen.this.layout.width / 2.0f, playerAvatarY - TransitionScreen.this.layout.height, Color.WHITE, percentage);
                    TransitionScreen.this.layout.setText(font, p1Record);
                    g2.drawText(p1Record, font, screenW / 4.0f - TransitionScreen.this.layout.width / 2.0f, playerAvatarY - TransitionScreen.this.layout.height * 2.5f, Color.WHITE, percentage);
                    float enemyAvatarX = screenW - screenW / 4.0f - scale / 2.0f * percentage;
                    float enemyAvatarY = centerY - scale / 2.0f;
                    g2.drawImage(this.enemyAvatar, enemyAvatarX, enemyAvatarY, scale, scale);
                    TransitionScreen.this.layout.setText(font, TransitionScreen.this.enemyAvatarName);
                    g2.drawText(TransitionScreen.this.enemyAvatarName, font, screenW - screenW / 4.0f - TransitionScreen.this.layout.width / 2.0f, enemyAvatarY - TransitionScreen.this.layout.height, Color.WHITE, percentage);
                    TransitionScreen.this.layout.setText(font, p2Record);
                    g2.drawText(p2Record, font, screenW - screenW / 4.0f - TransitionScreen.this.layout.width / 2.0f, enemyAvatarY - TransitionScreen.this.layout.height * 2.5f, Color.WHITE, percentage);
                    float vsScale = screenW / 3.2f;
                    g2.drawHueShift(TransitionScreen.this.vsTexture, centerX - vsScale / 2.0f, centerY - vsScale / 2.0f, vsScale, vsScale, Float.valueOf(percentage * 4.0f));
                } else {
                    float enemyAvatarX = centerY - scale / 2.0f;
                    float enemyAvatarY = scale / 3.0f * percentage;
                    g2.drawImage(this.enemyAvatar, enemyAvatarX, enemyAvatarY, scale, scale);
                    float playerAvatarX = centerY - scale / 2.0f;
                    float playerAvatarY = screenW - scale - percentage * scale / 3.0f;
                    g2.drawImage(TransitionScreen.this.playerAvatar, playerAvatarX, playerAvatarY, scale, scale);
                    float vsScale = screenW / 3.2f;
                    g2.drawHueShift(TransitionScreen.this.vsTexture, centerY - vsScale / 2.0f, centerX - vsScale / 2.0f, vsScale, vsScale, Float.valueOf(percentage * 4.0f));
                    TransitionScreen.this.layout.setText(font, TransitionScreen.this.enemyAvatarName);
                    g2.drawText(TransitionScreen.this.enemyAvatarName, font, centerY - TransitionScreen.this.layout.width / 2.0f, screenW - scale / 4.0f, Color.WHITE, percentage);
                    TransitionScreen.this.layout.setText(font, TransitionScreen.this.playerAvatarName);
                    g2.drawText(TransitionScreen.this.playerAvatarName, font, centerY - TransitionScreen.this.layout.width / 2.0f, 0.0f + scale / 4.0f, Color.WHITE, percentage);
                }
                Controls.getBitmapFont("default");
            } else if (TransitionScreen.this.isIntro) {
                if (TransitionScreen.this.textureRegion != null) {
                    if (Forge.advStartup) {
                        g2.drawGrayTransitionImage(Forge.getAssets().fallback_skins().get("title"), 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight(), false, percentage);
                        g2.setAlphaComposite(1.0f - percentage);
                        g2.drawImage(TransitionScreen.this.textureRegion, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                        g2.setAlphaComposite(oldAlpha);
                    } else {
                        g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                        g2.setAlphaComposite(1.0f - percentage);
                        g2.drawImage(TransitionScreen.this.textureRegion, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
                        g2.setAlphaComposite(oldAlpha);
                    }
                }
            } else if (TransitionScreen.this.textureRegion != null) {
                g2.drawGrayTransitionImage(TransitionScreen.this.textureRegion, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight(), false, percentage);
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < this.DURATION;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            if (TransitionScreen.this.runnable != null) {
                if (TransitionScreen.this.isMatchTransition()) {
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            if (BGAnimation.this.run[0]) {
                                return;
                            }
                            BGAnimation.this.run[0] = true;
                            FThreads.invokeInEdtNowOrLater(TransitionScreen.this.runnable);
                        }
                    }, 2.0f);
                } else {
                    if (this.run[0]) {
                        return;
                    }
                    this.run[0] = true;
                    FThreads.invokeInEdtNowOrLater(TransitionScreen.this.runnable);
                }
            }
        }
    }
}

