/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class TabPageScreen<T extends TabPageScreen<T>>
extends FScreen {
    public static boolean COMPACT_TABS = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_TABS);
    protected final TabHeader<T> tabHeader;
    protected final List<TabPage<T>> tabPages;
    private TabPage<T> selectedPage;

    public TabPageScreen(TabPage<T> ... tabPages0) {
        this(tabPages0, true);
    }

    public TabPageScreen(FEvent.FEventHandler backButton, TabPage<T> ... tabPages0) {
        this(tabPages0, backButton);
    }

    public TabPageScreen(TabPage<T>[] tabPages0, boolean showBackButton) {
        this(new TabHeader<T>(tabPages0, showBackButton));
    }

    public TabPageScreen(TabPage<T>[] tabPages0, FEvent.FEventHandler backButton) {
        this(new TabHeader<T>(tabPages0, backButton));
    }

    public TabPageScreen(TabHeader<T> tabHeader0) {
        super(tabHeader0);
        this.tabHeader = tabHeader0;
        this.tabPages = ((TabHeader)this.tabHeader).tabPages;
        this.initialize();
    }

    public TabPageScreen(String headerCaption, FPopupMenu menu, TabPage<T>[] tabPages0) {
        super(headerCaption, menu);
        this.tabHeader = this.add(new TabHeader<T>(tabPages0, false));
        ((TabHeader)this.tabHeader).showBottomBorder = false;
        this.tabPages = ((TabHeader)this.tabHeader).tabPages;
        this.initialize();
    }

    public TabPageScreen(String headerCaption, FPopupMenu menu, TabPage<T>[] tabPages0, boolean alwaysRenderHorizontal) {
        super(headerCaption, menu);
        this.tabHeader = this.add(new TabHeader<T>(tabPages0, false));
        ((TabHeader)this.tabHeader).showBottomBorder = false;
        ((TabHeader)this.tabHeader).alwaysRenderHorizontal = alwaysRenderHorizontal;
        this.tabPages = ((TabHeader)this.tabHeader).tabPages;
        this.initialize();
    }

    private void initialize() {
        int index = 0;
        for (TabPage<T> tabPage : this.tabPages) {
            ((TabPage)tabPage).index = index++;
            tabPage.parentScreen = this;
            this.add(tabPage);
            tabPage.setVisible(false);
        }
        this.setSelectedPage(this.tabPages.get(0));
    }

    public void addTabPage(TabPage<T> tabPage) {
        this.tabHeader.addTab(tabPage);
        ((TabPage)tabPage).index = this.tabPages.size();
        tabPage.parentScreen = this;
        this.add(tabPage);
        tabPage.setVisible(false);
        this.revalidate();
    }

    public TabPage<T> getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(TabPage<T> tabPage0) {
        if (this.selectedPage == tabPage0) {
            return;
        }
        if (this.selectedPage != null) {
            this.selectedPage.setVisible(false);
        }
        this.selectedPage = tabPage0;
        if (this.selectedPage != null) {
            this.selectedPage.setVisible(true);
            if (this.canActivateTabPage()) {
                this.scrollSelectedTabIntoView();
                this.selectedPage.onActivate();
            }
        }
    }

    protected boolean canActivateTabPage() {
        return Forge.getCurrentScreen() == this;
    }

    protected boolean showCompactTabs() {
        return COMPACT_TABS || this.getHeader() != this.tabHeader;
    }

    @Override
    public void onActivate() {
        if (this.selectedPage != null) {
            this.scrollSelectedTabIntoView();
            this.selectedPage.onActivate();
        }
    }

    private void scrollSelectedTabIntoView() {
        if (((TabHeader)this.tabHeader).isScrollable) {
            ((TabHeader)this.tabHeader).scroller.scrollIntoView(((TabPage)this.selectedPage).tab, ((TabPage)this.selectedPage).tab.getWidth() / 2.0f);
        }
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        if (this.getHeader() != this.tabHeader) {
            float tabHeight = this.tabHeader.getPreferredHeight();
            this.tabHeader.setBounds(0.0f, height - tabHeight, width, tabHeight);
            height -= tabHeight;
        }
        height -= startY;
        for (TabPage<T> tabPage : this.tabPages) {
            tabPage.setBounds(0.0f, startY, width, height);
        }
    }

    public static abstract class TabPage<T extends TabPageScreen<T>>
    extends FContainer {
        private static final FSkinFont TAB_FONT = FSkinFont.get(12);
        protected T parentScreen;
        protected String caption;
        protected FImage icon;
        private int index;
        private final Tab tab;

        private static FSkinColor getSelTabColor() {
            if (Forge.isMobileAdventureMode) {
                return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE);
            }
            return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
        }

        private static FSkinColor getTabForeColor() {
            if (Forge.isMobileAdventureMode) {
                return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
            }
            return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        }

        protected TabPage(String caption0, FImage icon0) {
            this.caption = caption0;
            this.icon = icon0;
            this.tab = new Tab();
        }

        public void showTab() {
            this.tab.setVisible(true);
        }

        public void hideTab() {
            this.tab.setVisible(false);
        }

        public String getCaption() {
            return this.caption;
        }

        public FImage getIcon() {
            return this.icon;
        }

        protected void onActivate() {
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            if (Math.abs(velocityX) > Math.abs(velocityY)) {
                if (velocityX < 0.0f) {
                    if (this.index < ((TabPageScreen)this.parentScreen).tabPages.size() - 1) {
                        ((TabPageScreen)this.parentScreen).setSelectedPage(((TabPageScreen)this.parentScreen).tabPages.get(this.index + 1));
                    }
                } else if (this.index > 0) {
                    ((TabPageScreen)this.parentScreen).setSelectedPage(((TabPageScreen)this.parentScreen).tabPages.get(this.index - 1));
                }
                return true;
            }
            return false;
        }

        protected class Tab
        extends FDisplayObject {
            protected Tab() {
            }

            @Override
            public boolean tap(float x, float y, int count) {
                ((TabPageScreen)TabPage.this.parentScreen).setSelectedPage(TabPage.this);
                return true;
            }

            @Override
            public void setVisible(boolean b0) {
                if (this.isVisible() == b0) {
                    return;
                }
                super.setVisible(b0);
                ((FScreen)TabPage.this.parentScreen).getHeader().revalidate();
                if (!b0 && ((TabPageScreen)TabPage.this.parentScreen).getSelectedPage() == TabPage.this) {
                    int i;
                    for (i = TabPage.this.index + 1; i < ((TabPageScreen)TabPage.this.parentScreen).tabPages.size(); ++i) {
                        if (!((TabPageScreen)TabPage.this.parentScreen).tabPages.get(i).tab.isVisible()) continue;
                        ((TabPageScreen)TabPage.this.parentScreen).setSelectedPage(((TabPageScreen)TabPage.this.parentScreen).tabPages.get(i));
                        return;
                    }
                    for (i = TabPage.this.index - 1; i >= 0; --i) {
                        if (!((TabPageScreen)TabPage.this.parentScreen).tabPages.get(i).tab.isVisible()) continue;
                        ((TabPageScreen)TabPage.this.parentScreen).setSelectedPage(((TabPageScreen)TabPage.this.parentScreen).tabPages.get(i));
                        return;
                    }
                    ((TabPageScreen)TabPage.this.parentScreen).setSelectedPage(null);
                }
            }

            @Override
            public void draw(Graphics g2) {
                float y;
                boolean isLandscapeMode = Forge.isLandscapeMode();
                float w = this.getWidth();
                float h2 = this.getHeight();
                float padding = h2 * 0.1f;
                if (((TabPageScreen)TabPage.this.parentScreen).getSelectedPage() == TabPage.this) {
                    g2.fillRect(TabPage.getSelTabColor(), FScreen.Header.LINE_THICKNESS / 2.0f, 0.0f, w - FScreen.Header.LINE_THICKNESS, h2);
                }
                w -= 2.0f * padding;
                if (((TabPageScreen)TabPage.this.parentScreen).showCompactTabs() && !isLandscapeMode) {
                    h2 -= 2.0f * padding;
                    if (TabPage.this.icon == null) {
                        g2.drawText(TabPage.this.caption, TAB_FONT, TabPage.getTabForeColor(), padding, padding, w, h2, false, 1, true);
                    } else {
                        float iconWidth = h2 * TabPage.this.icon.getWidth() / TabPage.this.icon.getHeight();
                        float iconOffset = iconWidth + padding;
                        float x = padding;
                        float y2 = padding;
                        FSkinFont font = TAB_FONT;
                        while (true) {
                            float dx;
                            if ((dx = (w - iconOffset - font.getMultiLineBounds((CharSequence)TabPage.this.caption).width) / 2.0f) > 0.0f) {
                                x += dx;
                                break;
                            }
                            if (!font.canShrink()) break;
                            font = font.shrink();
                        }
                        g2.drawImage(TabPage.this.icon, x, y2, iconWidth, h2);
                        g2.startClip(x += iconOffset, y2, w -= iconOffset, h2);
                        g2.drawText(TabPage.this.caption, font, TabPage.getTabForeColor(), x, y2, w, h2, false, 8, true);
                        g2.endClip();
                    }
                } else {
                    y = h2 - padding - TAB_FONT.getCapHeight();
                    g2.drawText(TabPage.this.caption, TAB_FONT, TabPage.getTabForeColor(), padding, y - padding, w, h2 - y + padding, false, 1, true);
                    if (TabPage.this.icon != null) {
                        float iconHeight = y - 2.0f * padding;
                        float iconWidth = iconHeight * TabPage.this.icon.getWidth() / TabPage.this.icon.getHeight();
                        if (iconWidth > w) {
                            iconHeight *= w / iconWidth;
                            iconWidth = w;
                        }
                        float mod = this.isHovered() ? iconWidth / 8.0f : 0.0f;
                        g2.drawImage(TabPage.this.icon, padding + (w - iconWidth) / 2.0f - mod / 2.0f, (y - iconHeight) / 2.0f - mod / 2.0f, iconWidth + mod, iconHeight + mod);
                    }
                }
                if (((TabPageScreen)TabPage.this.parentScreen).tabHeader.finalVisibleTab != this || isLandscapeMode) {
                    if (isLandscapeMode) {
                        y = this.getHeight() - FScreen.Header.LINE_THICKNESS / 2.0f;
                        g2.drawLine(FScreen.Header.LINE_THICKNESS, TabHeader.SEPARATOR_COLOR, 0.0f, y, this.getWidth(), y);
                    } else {
                        float x = this.getWidth() - FScreen.Header.LINE_THICKNESS / 2.0f;
                        g2.drawLine(FScreen.Header.LINE_THICKNESS, TabHeader.SEPARATOR_COLOR, x, 0.0f, x, this.getHeight());
                    }
                }
            }
        }
    }

    protected static class TabHeader<T extends TabPageScreen<T>>
    extends FScreen.Header {
        private static final float HEIGHT = Math.round(Utils.AVG_FINGER_HEIGHT * 1.4f);
        private static final float COMPACT_HEIGHT = Math.round(Utils.AVG_FINGER_HEIGHT * 0.8f);
        private static final float BACK_BUTTON_WIDTH = Math.round(HEIGHT / 2.0f);
        private static final FSkinColor SEPARATOR_COLOR = TabHeader.getBackColor().stepColor(-40);
        private final List<TabPage<T>> tabPages = new ArrayList<TabPage<T>>();
        public final FLabel btnBack;
        private boolean isScrollable;
        private FDisplayObject finalVisibleTab;
        private boolean showBottomBorder = true;
        private boolean alwaysRenderHorizontal = false;
        private final FScrollPane scroller = this.add(new FScrollPane(this){
            final /* synthetic */ TabHeader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
                int tabCount = 0;
                for (FDisplayObject fDisplayObject : this.getChildren()) {
                    if (!fDisplayObject.isVisible()) continue;
                    ++tabCount;
                    this.this$0.finalVisibleTab = fDisplayObject;
                }
                if (Forge.isLandscapeMode() && !this.this$0.alwaysRenderHorizontal) {
                    float y = 0.0f;
                    for (FDisplayObject child : this.getChildren()) {
                        if (!child.isVisible()) continue;
                        child.setBounds(0.0f, y, visibleWidth, HEIGHT);
                        y += HEIGHT;
                    }
                    return new FScrollPane.ScrollBounds(visibleWidth, y);
                }
                float x = 0.0f;
                this.this$0.isScrollable = tabCount > 3;
                float f = this.this$0.isScrollable ? visibleWidth / 2.5f : visibleWidth / (float)tabCount;
                for (FDisplayObject child : this.getChildren()) {
                    if (!child.isVisible()) continue;
                    child.setBounds(x, 0.0f, f, visibleHeight);
                    x += f;
                }
                return new FScrollPane.ScrollBounds(this.this$0.isScrollable ? x : visibleWidth, visibleHeight);
            }
        });

        public TabHeader(TabPage<T>[] tabPages, boolean showBackButton) {
            this.btnBack = showBackButton ? this.add(new FLabel.Builder().icon(new FScreen.BackIcon(BACK_BUTTON_WIDTH, BACK_BUTTON_WIDTH)).pressedColor(TabHeader.getBtnPressedColor()).align(1).command(e -> Forge.back()).build()) : null;
            for (TabPage<T> tabPage : tabPages) {
                this.tabPages.add(tabPage);
                this.scroller.add(((TabPage)tabPage).tab);
            }
        }

        public TabHeader(TabPage<T>[] tabPages, FEvent.FEventHandler backButton) {
            this.btnBack = backButton == null ? this.add(new FLabel.Builder().icon(new FScreen.BackIcon(BACK_BUTTON_WIDTH, BACK_BUTTON_WIDTH)).pressedColor(TabHeader.getBtnPressedColor()).align(1).command(e -> Forge.back()).build()) : this.add(new FLabel.Builder().icon(new FScreen.BackIcon(BACK_BUTTON_WIDTH, BACK_BUTTON_WIDTH)).pressedColor(TabHeader.getBtnPressedColor()).align(1).command(backButton).build());
            for (TabPage<T> tabPage : tabPages) {
                this.tabPages.add(tabPage);
                this.scroller.add(((TabPage)tabPage).tab);
            }
        }

        public void addTab(TabPage<T> tabPage) {
            this.tabPages.add(tabPage);
            this.scroller.add(((TabPage)tabPage).tab);
            this.scroller.revalidate();
        }

        protected boolean showBackButtonInLandscapeMode() {
            return this.btnBack != null;
        }

        @Override
        public float getPreferredHeight() {
            return ((TabPageScreen)this.tabPages.get((int)0).parentScreen).showCompactTabs() ? COMPACT_HEIGHT : HEIGHT;
        }

        @Override
        public void drawBackground(Graphics g2) {
            g2.fillRect(TabHeader.getBackColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }

        @Override
        public void drawOverlay(Graphics g2) {
            if (Forge.isLandscapeMode()) {
                g2.drawLine(LINE_THICKNESS, TabHeader.getLineColor(), 0.0f, 0.0f, 0.0f, this.getHeight());
                if (this.showBackButtonInLandscapeMode()) {
                    float y = this.btnBack.getTop() - LINE_THICKNESS / 2.0f;
                    g2.drawLine(LINE_THICKNESS, SEPARATOR_COLOR, 0.0f, y, this.getWidth(), y);
                }
                return;
            }
            if (this.btnBack != null) {
                float x = this.btnBack.getWidth() - LINE_THICKNESS / 2.0f;
                g2.drawLine(LINE_THICKNESS, SEPARATOR_COLOR, x, 0.0f, x, this.getHeight());
            }
            if (this.showBottomBorder) {
                float y = this.getHeight() - LINE_THICKNESS / 2.0f;
                g2.drawLine(LINE_THICKNESS, TabHeader.getLineColor(), 0.0f, y, this.getWidth(), y);
            }
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = 0.0f;
            if (this.btnBack != null) {
                if (Forge.isLandscapeMode()) {
                    if (this.showBackButtonInLandscapeMode()) {
                        float backButtonHeight = HEIGHT * 0.7f;
                        this.btnBack.setBounds(0.0f, height - backButtonHeight, width, backButtonHeight);
                        height -= backButtonHeight;
                    }
                } else {
                    this.btnBack.setIconScaleAuto(((TabPageScreen)this.tabPages.get((int)0).parentScreen).showCompactTabs());
                    this.btnBack.setSize(BACK_BUTTON_WIDTH, height);
                    x += BACK_BUTTON_WIDTH;
                }
            }
            this.scroller.setBounds(x, 0.0f, width - x, height);
        }

        @Override
        public float doLandscapeLayout(float screenWidth, float screenHeight) {
            float width = HEIGHT * 1.25f;
            this.setBounds(screenWidth - width, 0.0f, width, screenHeight);
            return width;
        }
    }
}

