/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import forge.Forge;
import forge.menu.FPopupMenu;
import forge.screens.FScreen;
import forge.screens.match.views.VPrompt;
import forge.toolbox.FContainer;

public abstract class MultiStepWizardScreen<T>
extends FScreen {
    protected final WizardStep<T>[] steps;
    protected final T model;
    private WizardStep<T> currentStep;
    private final VPrompt prompt = this.add(new VPrompt(Forge.getLocalizer().getMessage("lblBack", new Object[0]), Forge.getLocalizer().getMessage("lblNext", new Object[0]), e -> this.advanceStep(-1), e -> this.advanceStep(1)));

    protected MultiStepWizardScreen(String headerCaption, WizardStep<T>[] steps0, T model0) {
        super(headerCaption);
        this.steps = steps0;
        this.model = model0;
        this.initialize();
    }

    protected MultiStepWizardScreen(String headerCaption, FPopupMenu menu, WizardStep<T>[] steps0, T model0) {
        super(headerCaption, menu);
        this.steps = steps0;
        this.model = model0;
        this.initialize();
    }

    protected MultiStepWizardScreen(FScreen.Header header0, WizardStep<T>[] steps0, T model0) {
        super(header0);
        this.steps = steps0;
        this.model = model0;
        this.initialize();
    }

    private void initialize() {
        int index = 0;
        for (WizardStep<T> step : this.steps) {
            ((WizardStep)step).index = index++;
            ((WizardStep)step).parentScreen = this;
            this.add(step);
            step.setVisible(false);
        }
        this.prompt.getBtnCancel().setEnabled(true);
        this.setCurrentStep(0);
    }

    private void advanceStep(int dir) {
        int newIndex = ((WizardStep)this.currentStep).index + dir;
        if (newIndex < 0) {
            return;
        }
        if (dir > 0) {
            if (!this.currentStep.updateModelAndAdvance(this.model)) {
                return;
            }
            if (newIndex >= this.steps.length) {
                this.finish();
                return;
            }
        } else {
            this.currentStep.reset();
        }
        this.setCurrentStep(newIndex);
    }

    private boolean setCurrentStep(int index) {
        if (this.currentStep != null) {
            if (((WizardStep)this.currentStep).index == index) {
                return false;
            }
            this.currentStep.setVisible(false);
            if (((WizardStep)this.currentStep).index == this.steps.length - 1) {
                this.prompt.getBtnCancel().setText(Forge.getLocalizer().getMessage("lblNext", new Object[0]));
            }
        }
        this.currentStep = this.steps[index];
        this.currentStep.setVisible(true);
        this.prompt.getBtnOk().setEnabled(index > 0);
        if (index == this.steps.length - 1) {
            this.prompt.getBtnCancel().setText(Forge.getLocalizer().getMessage("lblFinish", new Object[0]));
        }
        this.prompt.setMessage(this.currentStep.getMessage());
        if (Forge.getCurrentScreen() == this) {
            this.currentStep.onActivate(this.model);
        }
        return true;
    }

    @Override
    public void onActivate() {
        for (WizardStep<T> step : this.steps) {
            step.reset();
        }
        if (!this.setCurrentStep(0)) {
            this.currentStep.onActivate(this.model);
        }
    }

    protected abstract void finish();

    @Override
    protected void doLayout(float startY, float width, float height) {
        float promptHeight = VPrompt.HEIGHT;
        this.prompt.setBounds(0.0f, height - promptHeight, width, promptHeight);
        height -= startY + promptHeight;
        for (WizardStep<T> step : this.steps) {
            step.setBounds(0.0f, startY, width, height);
        }
    }

    public static abstract class WizardStep<T>
    extends FContainer {
        private final String message;
        private int index;
        private MultiStepWizardScreen<T> parentScreen;

        protected WizardStep(String message0) {
            this.message = message0;
        }

        public String getMessage() {
            return this.message;
        }

        protected void advance() {
            ((MultiStepWizardScreen)this.parentScreen).advanceStep(1);
        }

        protected abstract void reset();

        protected abstract void onActivate(T var1);

        protected abstract boolean updateModelAndAdvance(T var1);
    }
}

