/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinTexture;
import forge.gui.GuiBase;
import forge.menu.FPopupMenu;
import forge.screens.home.HomeScreen;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.util.Callback;
import forge.util.Utils;
import java.util.List;

public abstract class FScreen
extends FContainer {
    private final Header header;

    public static FSkinColor getTextureOverlayColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_THEME);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_THEME);
    }

    protected FScreen(String headerCaption) {
        this(headerCaption == null ? null : new DefaultHeader(headerCaption));
    }

    protected FScreen(String headerCaption, FPopupMenu menu) {
        this(new MenuHeader(headerCaption, menu));
    }

    protected FScreen(Header header0) {
        this.header = header0;
        if (this.header != null) {
            this.add(this.header);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeaderCaption(String headerCaption) {
        if (this.header instanceof DefaultHeader) {
            ((DefaultHeader)this.header).lblCaption.setText(headerCaption);
        }
    }

    public Rectangle getDropDownBoundary() {
        return new Rectangle(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public void onActivate() {
    }

    public void onSwitchAway(Callback<Boolean> canSwitchCallback) {
        canSwitchCallback.run(true);
    }

    public void onClose(Callback<Boolean> canCloseCallback) {
        if (canCloseCallback != null) {
            canCloseCallback.run(true);
        }
    }

    public void showMenu() {
        if (this.header instanceof MenuHeader) {
            ((MenuHeader)this.header).btnMenu.trigger();
        } else {
            SettingsScreen.show(false);
        }
    }

    @Override
    protected final void doLayout(float width, float height) {
        if (GuiBase.isAndroid() && Forge.isLandscapeMode() || width > height) {
            this.doLandscapeLayout(width, height);
        } else if (this.header != null) {
            this.header.setBounds(0.0f, 0.0f, width, this.header.getPreferredHeight());
            this.doLayout(this.header.getHeight(), width, height);
        } else {
            this.doLayout(0.0f, width, height);
        }
    }

    protected abstract void doLayout(float var1, float var2, float var3);

    protected float doLandscapeLayout(float width, float height) {
        float startY = 0.0f;
        if (this.header != null) {
            float headerWidth = this.header.doLandscapeLayout(width, height);
            if (headerWidth == 0.0f) {
                this.header.setBounds(0.0f, 0.0f, width, this.header.getPreferredHeight());
                startY += this.header.getHeight();
            } else {
                width -= headerWidth;
            }
        }
        this.doLayout(startY, width, height);
        return width;
    }

    public FScreen getLandscapeBackdropScreen() {
        return HomeScreen.instance;
    }

    @Override
    public void setSize(float width, float height) {
        FScreen backdrop;
        if (Forge.isLandscapeMode() && (backdrop = this.getLandscapeBackdropScreen()) != null) {
            width = backdrop.doLandscapeLayout(width, height);
        }
        if (this.getWidth() == width && this.getHeight() == height) {
            if (this.header != null) {
                this.header.onScreenActivate();
            }
            return;
        }
        super.setSize(width, height);
    }

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        FScreen backdrop;
        if (Forge.isLandscapeMode() && (backdrop = this.getLandscapeBackdropScreen()) != null) {
            backdrop.buildTouchListeners(screenX, screenY, listeners);
        }
        super.buildTouchListeners(screenX, screenY, listeners);
    }

    @Override
    public void draw(Graphics g2) {
        FScreen backdrop;
        if (Forge.isLandscapeMode() && this.getLeft() == 0.0f && (backdrop = this.getLandscapeBackdropScreen()) != null) {
            g2.draw(backdrop);
            this.setLeft((float)Forge.getScreenWidth() - this.getWidth());
            g2.draw(this);
            this.setLeft(0.0f);
            return;
        }
        super.draw(g2);
    }

    @Override
    protected void drawBackground(Graphics g2) {
        if (Forge.isLandscapeMode() && this.getLandscapeBackdropScreen() != null) {
            return;
        }
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, w, h2);
        g2.fillRect(FScreen.getTextureOverlayColor(), 0.0f, 0.0f, w, h2);
    }

    protected boolean allowBackInLandscapeMode() {
        return this.getLandscapeBackdropScreen() != HomeScreen.instance;
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (keyCode == 111 || keyCode == 4) {
            if (Forge.endKeyInput()) {
                return true;
            }
            if (Forge.isLandscapeMode() && !this.allowBackInLandscapeMode()) {
                Forge.exit(false);
                return true;
            }
            Forge.back();
            return true;
        }
        if (keyCode == 135) {
            this.revalidate();
        }
        return super.keyDown(keyCode);
    }

    protected static class MenuIcon
    implements FImage {
        private final float width;
        private final float height;

        private static FSkinColor getColor() {
            if (Forge.isMobileAdventureMode) {
                return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
            }
            return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        }

        public MenuIcon(float width0, float height0) {
            this.width = width0;
            this.height = height0;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public float getHeight() {
            return this.height;
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            float thickness = Math.round(h2 / 5.0f);
            float delta = Math.round(thickness * 1.75f);
            g2.fillRect(MenuIcon.getColor(), x, y += (h2 - 2.0f * delta - thickness) / 2.0f, thickness, thickness);
            g2.fillRect(MenuIcon.getColor(), x, y += delta, thickness, thickness);
            g2.fillRect(MenuIcon.getColor(), x, y += delta, thickness, thickness);
            g2.fillRect(MenuIcon.getColor(), x += delta, y -= 2.0f * delta, w -= delta, thickness);
            g2.fillRect(MenuIcon.getColor(), x, y += delta, w, thickness);
            g2.fillRect(MenuIcon.getColor(), x, y += delta, w, thickness);
        }
    }

    protected static class BackIcon
    implements FImage {
        private static final float THICKNESS = Utils.scale(3.0f);
        private final float width;
        private final float height;

        private static FSkinColor getColor() {
            if (Forge.isMobileAdventureMode) {
                return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
            }
            return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        }

        public BackIcon(float width0, float height0) {
            this.width = width0;
            this.height = height0;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public float getHeight() {
            return this.height;
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            float xMid = x + w * 0.4f;
            float yMid = y + h2 / 2.0f;
            float offsetX = h2 / 8.0f;
            float offsetY = w / 4.0f;
            g2.drawLine(THICKNESS, BackIcon.getColor(), xMid + offsetX, yMid - offsetY, xMid - offsetX, yMid + 1.0f);
            g2.drawLine(THICKNESS, BackIcon.getColor(), xMid - offsetX, yMid - 1.0f, xMid + offsetX, yMid + offsetY);
        }
    }

    protected static class MenuHeader
    extends DefaultHeader {
        private final FLabel btnMenu;
        private final FPopupMenu menu;

        public MenuHeader(String headerCaption, FPopupMenu menu0) {
            super(headerCaption);
            this.menu = menu0;
            this.btnMenu = this.add(new FLabel.Builder().icon(new MenuIcon(HEIGHT, HEIGHT)).pressedColor(MenuHeader.getBtnPressedColor()).align(1).command(new FEvent.FEventHandler(){

                @Override
                public void handleEvent(FEvent e) {
                    menu.show(btnMenu, 0.0f, DefaultHeader.HEIGHT);
                }
            }).build());
        }

        @Override
        public void drawOverlay(Graphics g2) {
            if (Forge.isLandscapeMode() && this.displaySidebarForLandscapeMode()) {
                g2.drawLine(LINE_THICKNESS, MenuHeader.getLineColor(), 0.0f, 0.0f, 0.0f, this.getHeight());
                return;
            }
            super.drawOverlay(g2);
        }

        @Override
        protected void doLayout(float width, float height) {
            super.doLayout(width, height);
            this.menu.hide();
            if (Forge.isLandscapeMode() && this.displaySidebarForLandscapeMode()) {
                this.btnBack.setBounds(0.0f, 0.0f, 0.0f, 0.0f);
                this.lblCaption.setBounds(0.0f, 0.0f, 0.0f, 0.0f);
                this.btnMenu.setBounds(0.0f, 0.0f, 0.0f, 0.0f);
                this.menu.show(this.getLeft(), 0.0f, width, height);
                return;
            }
            this.btnMenu.setBounds(width - height, 0.0f, height, height);
        }

        @Override
        protected void onScreenActivate() {
            if (Forge.isLandscapeMode() && this.displaySidebarForLandscapeMode()) {
                this.menu.hide();
                this.menu.show(this.getLeft(), 0.0f, this.getWidth(), this.getHeight());
            }
        }

        protected boolean displaySidebarForLandscapeMode() {
            return true;
        }

        @Override
        public float doLandscapeLayout(float screenWidth, float screenHeight) {
            if (this.displaySidebarForLandscapeMode()) {
                float width = screenHeight * 0.35f * 0.8f;
                this.setBounds(screenWidth - width, 0.0f, width, screenHeight);
                return width;
            }
            return 0.0f;
        }
    }

    private static class DefaultHeader
    extends Header {
        protected static final float HEIGHT = Math.round(Utils.AVG_FINGER_HEIGHT * 0.8f);
        protected static final FSkinFont FONT = FSkinFont.get(16);
        protected final FLabel btnBack = this.add(new FLabel.Builder().icon(new BackIcon(HEIGHT, HEIGHT)).pressedColor(DefaultHeader.getBtnPressedColor()).align(1).command(e -> Forge.back()).build());
        protected final FLabel lblCaption;

        public DefaultHeader(String headerCaption) {
            this.lblCaption = this.add(new FLabel.Builder().text(headerCaption).font(FONT).align(1).build());
        }

        @Override
        public float getPreferredHeight() {
            return HEIGHT;
        }

        @Override
        public float doLandscapeLayout(float screenWidth, float screenHeight) {
            return 0.0f;
        }

        @Override
        public void drawBackground(Graphics g2) {
            g2.fillRect(DefaultHeader.getBackColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }

        @Override
        public void drawOverlay(Graphics g2) {
            if (Forge.isLandscapeMode() && this.getWidth() < Forge.getCurrentScreen().getWidth()) {
                g2.drawLine(LINE_THICKNESS, DefaultHeader.getLineColor(), 0.0f, 0.0f, 0.0f, this.getHeight());
                return;
            }
            float y = HEIGHT - LINE_THICKNESS / 2.0f;
            g2.drawLine(LINE_THICKNESS, DefaultHeader.getLineColor(), 0.0f, y, this.getWidth(), y);
        }

        @Override
        protected void doLayout(float width, float height) {
            this.btnBack.setBounds(0.0f, 0.0f, height, height);
            this.lblCaption.setBounds(height, 0.0f, width - 2.0f * height, height);
        }
    }

    public static abstract class Header
    extends FContainer {
        public static final float LINE_THICKNESS = Utils.scale(1.0f);

        public static FSkinColor getBtnPressedColor() {
            if (FScreen.getTextureOverlayColor() == null) {
                return FSkinColor.getStandardColor(Color.DARK_GRAY);
            }
            return FScreen.getTextureOverlayColor().alphaColor(1.0f);
        }

        public static FSkinColor getLineColor() {
            return Header.getBtnPressedColor().stepColor(-40);
        }

        public static FSkinColor getBackColor() {
            return Header.getBtnPressedColor().stepColor(-80);
        }

        public abstract float getPreferredHeight();

        protected void onScreenActivate() {
        }

        public abstract float doLandscapeLayout(float var1, float var2);
    }
}

