/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.sound.SoundSystem;
import forge.toolbox.FContainer;
import forge.toolbox.FOverlay;

public class ClosingScreen
extends FContainer {
    private BGAnimation bgAnimation;
    private StaticAnimation staticAnimation;
    private boolean restart = false;
    private boolean drawStatic = false;
    private FileHandle adv_logo = FSkin.getSkinFile("adv_logo.png");
    private FileHandle existingLogo = this.adv_logo.exists() ? this.adv_logo : FSkin.getDefaultSkinFile("adv_logo.png");
    private Texture logo = this.existingLogo.exists() && Forge.advStartup ? Forge.getAssets().getTexture(this.existingLogo, true, false) : FSkin.getLogo();

    public ClosingScreen(boolean restart0) {
        this.bgAnimation = new BGAnimation();
        this.staticAnimation = new StaticAnimation();
        this.restart = restart0;
    }

    @Override
    protected void doLayout(float width, float height) {
    }

    @Override
    protected void drawBackground(Graphics g2) {
        FOverlay.hideAll();
        if (this.drawStatic) {
            this.staticAnimation.start();
            this.staticAnimation.drawBackgroud(g2);
            return;
        }
        this.bgAnimation.start();
        this.bgAnimation.drawBackground(g2);
    }

    private class BGAnimation
    extends ForgeAnimation {
        float DURATION = 0.6f;
        private float progress = 0.0f;

        private BGAnimation() {
        }

        public void drawBackground(Graphics g2) {
            float percentage = this.progress / this.DURATION;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
            g2.setAlphaComposite(percentage);
            g2.drawImage(Forge.isMobileAdventureMode || Forge.advStartup ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
            g2.setAlphaComposite(oldAlpha);
            float xmod = Forge.getScreenHeight() > 2000 ? 1.5f : 1.0f;
            xmod *= 21.0f - 20.0f * percentage;
            if (ClosingScreen.this.logo != null) {
                g2.drawImage(ClosingScreen.this.logo, (float)(Forge.getScreenWidth() / 2) - (float)ClosingScreen.this.logo.getWidth() * xmod / 2.0f, (float)(Forge.getScreenHeight() / 2) - (float)ClosingScreen.this.logo.getHeight() * xmod / 2.0f, (float)ClosingScreen.this.logo.getWidth() * xmod, (float)ClosingScreen.this.logo.getHeight() * xmod);
            } else {
                g2.drawImage(FSkinImage.LOGO, (float)(Forge.getScreenWidth() / 2) - FSkinImage.LOGO.getWidth() * xmod / 2.0f, (float)(Forge.getScreenHeight() / 2) - FSkinImage.LOGO.getHeight() * xmod / 1.5f, FSkinImage.LOGO.getWidth() * xmod, FSkinImage.LOGO.getHeight() * xmod);
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < this.DURATION;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            ClosingScreen.this.drawStatic = true;
        }
    }

    private class StaticAnimation
    extends ForgeAnimation {
        float DURATION = 0.8f;
        private float progress = 0.0f;

        private StaticAnimation() {
        }

        public void drawBackgroud(Graphics g2) {
            float xmod;
            float percentage = this.progress / this.DURATION;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            try {
                SoundSystem.instance.fadeModifier(1.0f - percentage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
            g2.setAlphaComposite(1.0f - percentage);
            g2.drawImage(Forge.isMobileAdventureMode || Forge.advStartup ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
            g2.setAlphaComposite(oldAlpha);
            float f = xmod = Forge.getScreenHeight() > 2000 ? 1.5f : 1.0f;
            if (ClosingScreen.this.logo != null) {
                g2.drawImage(ClosingScreen.this.logo, (float)(Forge.getScreenWidth() / 2) - (float)ClosingScreen.this.logo.getWidth() * xmod / 2.0f, (float)(Forge.getScreenHeight() / 2) - (float)ClosingScreen.this.logo.getHeight() * xmod / 2.0f, (float)ClosingScreen.this.logo.getWidth() * xmod, (float)ClosingScreen.this.logo.getHeight() * xmod);
            } else {
                g2.drawImage(FSkinImage.LOGO, (float)(Forge.getScreenWidth() / 2) - FSkinImage.LOGO.getWidth() * xmod / 2.0f, (float)(Forge.getScreenHeight() / 2) - FSkinImage.LOGO.getHeight() * xmod / 1.5f, FSkinImage.LOGO.getWidth() * xmod, FSkinImage.LOGO.getHeight() * xmod);
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < this.DURATION;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            if (ClosingScreen.this.restart) {
                Forge.getDeviceAdapter().restart();
            } else {
                Forge.getDeviceAdapter().exit();
            }
        }
    }
}

