/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.collect.Iterables;
import forge.ImageKeys;
import forge.card.CardStateName;
import forge.card.mana.ManaCost;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntityView;
import forge.game.GameEntityViewMap;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardView;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostAddMana;
import forge.game.cost.CostAdjustment;
import forge.game.cost.CostCollectEvidence;
import forge.game.cost.CostDamage;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostDraw;
import forge.game.cost.CostEnlist;
import forge.game.cost.CostExert;
import forge.game.cost.CostExile;
import forge.game.cost.CostExileFromStack;
import forge.game.cost.CostFlipCoin;
import forge.game.cost.CostGainControl;
import forge.game.cost.CostGainLife;
import forge.game.cost.CostMill;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.cost.CostPartWithList;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostPayShards;
import forge.game.cost.CostPutCardToLib;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveAnyCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostReturn;
import forge.game.cost.CostReveal;
import forge.game.cost.CostRollDice;
import forge.game.cost.CostSacrifice;
import forge.game.cost.CostTapType;
import forge.game.cost.PaymentDecision;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.mana.ManaRefundService;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.player.PlayerView;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityManaConvert;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputPayManaOfCostPayment;
import forge.gamemodes.match.input.InputSelectCardsFromList;
import forge.gui.FThreads;
import forge.gui.util.SGuiChoose;
import forge.player.HumanCostDecision;
import forge.player.HumanPlaySpellAbility;
import forge.player.PlayerControllerHuman;
import forge.util.Aggregates;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class HumanPlay {
    private HumanPlay() {
    }

    public static final boolean playSpellAbility(PlayerControllerHuman controller, Player p, SpellAbility sa) {
        HumanPlaySpellAbility req;
        FThreads.assertExecutedByEdt(false);
        Card source = sa.getHostCard();
        sa.setActivatingPlayer(p);
        if (sa.isLandAbility()) {
            if (sa.canPlay()) {
                sa.resolve();
            }
            return true;
        }
        boolean isforetold = source.isForetold();
        boolean castFaceDown = sa.isCastFaceDown();
        boolean flippedToCast = sa.isSpell() && source.isFaceDown();
        if ((sa = HumanPlay.chooseOptionalAdditionalCosts(p, sa)) == null) {
            return false;
        }
        CardStateName oldState = source.getCurrentStateName();
        source.setSplitStateToPlayAbility(sa);
        if (sa.isSpell() && !sa.canPlay()) {
            if (source.getCurrentStateName() != oldState) {
                source.setState(oldState, true);
            }
            return false;
        }
        if (flippedToCast && !castFaceDown) {
            source.forceTurnFaceUp();
        }
        if (!(req = new HumanPlaySpellAbility(controller, sa)).playAbility(true, false, false)) {
            if (!controller.getGame().EXPERIMENTAL_RESTORE_SNAPSHOT) {
                Card rollback = p.getGame().getCardState(source);
                if (castFaceDown) {
                    rollback.setFaceDown(false);
                } else if (flippedToCast) {
                    rollback.turnFaceDown(true);
                    rollback.setImageKey(ImageKeys.getTokenKey(isforetold ? "foretell" : "hidden"));
                    if (rollback.isInZone(ZoneType.Exile)) {
                        rollback.addMayLookTemp(p);
                    }
                }
            }
            return false;
        }
        return true;
    }

    static SpellAbility chooseOptionalAdditionalCosts(Player p, SpellAbility original) {
        PlayerController c = p.getController();
        List<SpellAbility> abilities = GameActionUtil.getAdditionalCostSpell(original);
        SpellAbility choosen = c.getAbilityToPlay(original.getHostCard(), abilities);
        List<OptionalCostValue> list = GameActionUtil.getOptionalCostValues(choosen);
        if (!list.isEmpty()) {
            list = c.chooseOptionalCosts(choosen, list);
        }
        return GameActionUtil.addOptionalCosts(choosen, list);
    }

    public static final void playSaWithoutPayingManaCost(PlayerControllerHuman controller, Game game, SpellAbility sa, boolean mayChooseNewTargets) {
        FThreads.assertExecutedByEdt(false);
        Card source = sa.getHostCard();
        source.setSplitStateToPlayAbility(sa);
        HumanPlaySpellAbility req = new HumanPlaySpellAbility(controller, sa);
        req.playAbility(mayChooseNewTargets, true, false);
    }

    public static final boolean playSpellAbilityNoStack(PlayerControllerHuman controller, Player player, SpellAbility sa) {
        return HumanPlay.playSpellAbilityNoStack(controller, player, sa, false);
    }

    public static final boolean playSpellAbilityNoStack(PlayerControllerHuman controller, Player player, SpellAbility sa, boolean useOldTargets) {
        sa.setActivatingPlayer(player);
        HumanPlaySpellAbility req = new HumanPlaySpellAbility(controller, sa);
        return req.playAbility(!useOldTargets, false, true);
    }

    public static boolean payCostDuringAbilityResolve(PlayerControllerHuman controller, Player p, Card source, Cost cost, SpellAbility sourceAbility, String prompt) {
        String orString;
        Card current = null;
        if (sourceAbility.hasParam("ShowCurrentCard")) {
            current = Iterables.getFirst(AbilityUtils.getDefinedCards(source, sourceAbility.getParam("ShowCurrentCard"), sourceAbility), null);
        }
        List<CostPart> parts = cost.getCostParts();
        ArrayList<CostPart> remainingParts = new ArrayList<CostPart>(parts);
        CostPart costPart = null;
        if (!parts.isEmpty()) {
            costPart = parts.get(0);
        }
        if (sourceAbility.hasParam("OrString")) {
            orString = sourceAbility.getParam("OrString");
        } else {
            String string = orString = prompt == null ? sourceAbility.getStackDescription().trim() : "";
        }
        if (!orString.isEmpty()) {
            orString = sourceAbility.hasParam("UnlessSwitched") ? TextUtil.concatWithSpace(" (" + Localizer.getInstance().getMessage("lblIfYouDo", new Object[0]) + ":", orString + ")") : TextUtil.concatWithSpace(" (" + Localizer.getInstance().getMessage("lblOr", new Object[0]) + ":", orString, ")");
        }
        if (parts.isEmpty() || costPart.getAmount().equals("0") && parts.size() < 2) {
            return p.getController().confirmPayment(costPart, Localizer.getInstance().getMessage("lblDoYouWantPay", new Object[0]) + " {0}?" + orString, sourceAbility);
        }
        if (costPart instanceof CostPartMana && parts.size() < 2 && ((CostPartMana)costPart).getMana().isZero()) {
            return p.getController().confirmPayment(costPart, Localizer.getInstance().getMessage("lblDoYouWantPay", new Object[0]) + " {0}?" + orString, sourceAbility);
        }
        HumanCostDecision hcd = new HumanCostDecision(controller, p, sourceAbility, true, source, orString);
        boolean mandatory = cost.isMandatory();
        for (CostPart part : parts) {
            if (!part.canPay(sourceAbility, p, hcd.isEffect())) {
                return false;
            }
            boolean mayRemovePart = true;
            if (part instanceof CostPayLife || part instanceof CostDraw || part instanceof CostGainLife || part instanceof CostFlipCoin || part instanceof CostRollDice || part instanceof CostDamage || part instanceof CostEnlist || part instanceof CostExileFromStack || part instanceof CostPutCounter || part instanceof CostRemoveCounter || part instanceof CostRemoveAnyCounter || part instanceof CostMill || part instanceof CostSacrifice || part instanceof CostCollectEvidence) {
                PaymentDecision pd = part.accept(hcd);
                if (pd == null) {
                    return false;
                }
                part.payAsDecided(p, pd, sourceAbility, hcd.isEffect());
            } else if (part instanceof CostAddMana) {
                String desc = part.toString();
                desc = desc.substring(0, 1).toLowerCase() + desc.substring(1);
                if (!p.getController().confirmPayment(part, Localizer.getInstance().getMessage("lblDoyouWantTo", new Object[0]) + " " + desc + "?" + orString, sourceAbility)) {
                    return false;
                }
                PaymentDecision pd = part.accept(hcd);
                if (pd == null) {
                    return false;
                }
                part.payAsDecided(p, pd, sourceAbility, hcd.isEffect());
            } else if (part instanceof CostExile) {
                CostExile costExile = (CostExile)part;
                if ("All".equals(part.getType())) {
                    ZoneType zone = costExile.getFrom().get(0);
                    String string = prompt = ZoneType.Graveyard.equals((Object)zone) ? "lblDoYouWantExileAllCardYouGraveyard" : "lblDoYouWantExileAllCardHand";
                    if (!p.getController().confirmPayment(part, Localizer.getInstance().getMessage(prompt, new Object[0]), sourceAbility)) {
                        return false;
                    }
                    costExile.payAsDecided(p, PaymentDecision.card(p.getCardsIn(zone)), sourceAbility, hcd.isEffect());
                } else {
                    CardCollection list = new CardCollection();
                    List<ZoneType> fromZones = costExile.getFrom();
                    boolean multiFromZones = fromZones.size() > 1;
                    for (ZoneType from : fromZones) {
                        list.addAll(costExile.zoneRestriction != 1 ? p.getGame().getCardsIn(from) : p.getCardsIn(from));
                    }
                    list = CardLists.getValidCards((Iterable<Card>)list, part.getType().split(";"), p, source, (CardTraitBase)sourceAbility);
                    int nNeeded = part.getAbilityAmount(sourceAbility);
                    if (list.size() < nNeeded) {
                        return false;
                    }
                    if (!multiFromZones && fromZones.get(0).equals((Object)ZoneType.Library)) {
                        if (!p.getController().confirmPayment(part, Localizer.getInstance().getMessage("lblDoYouWantExileNCardsFromYourLibrary", String.valueOf(nNeeded)), sourceAbility)) {
                            return false;
                        }
                        list = list.subList(0, nNeeded);
                        costExile.payAsDecided(p, PaymentDecision.card(list), sourceAbility, hcd.isEffect());
                    } else {
                        CardCollection newList = new CardCollection();
                        GameEntityViewMap gameCacheList = GameEntityView.getMap(list);
                        for (int i = 0; i < nNeeded; ++i) {
                            CardView cv = !multiFromZones ? (mandatory ? (CardView)SGuiChoose.one(Localizer.getInstance().getMessage("lblExileFromZone", fromZones.get(0).getTranslatedName()), gameCacheList.getTrackableKeys()) : (CardView)SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblExileFromZone", fromZones.get(0).getTranslatedName()), gameCacheList.getTrackableKeys())) : (mandatory ? (CardView)SGuiChoose.one("Update this message in HumanPlay", gameCacheList.getTrackableKeys()) : (CardView)SGuiChoose.oneOrNone("Update this message in HumanPlay", gameCacheList.getTrackableKeys()));
                            if (cv == null || !gameCacheList.containsKey(cv)) {
                                return false;
                            }
                            newList.add((Card)gameCacheList.remove(cv));
                        }
                        costExile.payAsDecided(p, PaymentDecision.card(newList), sourceAbility, hcd.isEffect());
                    }
                }
            } else if (part instanceof CostPutCardToLib) {
                int amount = Integer.parseInt(part.getAmount());
                ZoneType from = ((CostPutCardToLib)part).getFrom();
                boolean sameZone = ((CostPutCardToLib)part).isSameZone();
                CardCollectionView listView = sameZone ? p.getGame().getCardsIn(from) : p.getCardsIn(from);
                CardCollection list = CardLists.getValidCards((Iterable<Card>)listView, part.getType().split(";"), p, source, (CardTraitBase)sourceAbility);
                if (sameZone) {
                    PlayerCollection players = p.getGame().getPlayers();
                    ArrayList<Player> payableZone = new ArrayList<Player>();
                    for (Player player : players) {
                        CardCollection enoughType = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(player));
                        if (enoughType.size() < amount) {
                            list.removeAll(enoughType);
                            continue;
                        }
                        payableZone.add(player);
                    }
                    GameEntityViewMap gameCachePlayer = GameEntityView.getMap(payableZone);
                    PlayerView pv = (PlayerView)SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblPutCardFromWhoseZone", from.getTranslatedName()), gameCachePlayer.getTrackableKeys());
                    if (pv == null || !gameCachePlayer.containsKey(pv)) {
                        return false;
                    }
                    Player chosen = (Player)gameCachePlayer.get(pv);
                    CardCollection typeList = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(chosen));
                    GameEntityViewMap gameCacheTypeList = GameEntityView.getMap(typeList);
                    for (int i = 0; i < amount; ++i) {
                        if (gameCacheTypeList.isEmpty()) {
                            return false;
                        }
                        CardView cv = (CardView)SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblPutCardToLibrary", new Object[0]), gameCacheTypeList.getTrackableKeys());
                        if (cv == null || !gameCacheTypeList.containsKey(cv)) {
                            return false;
                        }
                        Card c = (Card)gameCacheTypeList.get(cv);
                        gameCacheTypeList.remove(c);
                        p.getGame().getAction().moveToLibrary(c, Integer.parseInt(((CostPutCardToLib)part).getLibPos()), null);
                    }
                } else {
                    boolean hasPaid = HumanPlay.payCostPart(controller, p, sourceAbility, hcd.isEffect(), (CostPartWithList)part, amount, list, Localizer.getInstance().getMessage("lblPutIntoLibrary", new Object[0]) + orString);
                    if (!hasPaid) {
                        return false;
                    }
                }
            } else if (part instanceof CostGainControl) {
                int amount = Integer.parseInt(part.getAmount());
                CardCollection list = CardLists.getValidCards((Iterable<Card>)p.getGame().getCardsIn(ZoneType.Battlefield), part.getType(), p, source, (CardTraitBase)sourceAbility);
                boolean hasPaid = HumanPlay.payCostPart(controller, p, sourceAbility, hcd.isEffect(), (CostPartWithList)part, amount, list, Localizer.getInstance().getMessage("lblGainControl", new Object[0]) + orString);
                if (!hasPaid) {
                    return false;
                }
            } else if (part instanceof CostReturn) {
                CardCollection list = CardLists.getValidCards((Iterable<Card>)p.getCardsIn(ZoneType.Battlefield), part.getType(), p, source, (CardTraitBase)sourceAbility);
                int amount = part.getAbilityAmount(sourceAbility);
                boolean hasPaid = HumanPlay.payCostPart(controller, p, sourceAbility, hcd.isEffect(), (CostPartWithList)part, amount, list, Localizer.getInstance().getMessage("lblReturnToHand", new Object[0]) + orString);
                if (!hasPaid) {
                    return false;
                }
            } else if (part instanceof CostDiscard) {
                int amount = part.getAbilityAmount(sourceAbility);
                if ("Hand".equals(part.getType())) {
                    if (!p.getController().confirmPayment(part, Localizer.getInstance().getMessage("lblDoYouWantDiscardYourHand", new Object[0]), sourceAbility)) {
                        return false;
                    }
                    ((CostDiscard)part).payAsDecided(p, PaymentDecision.card(p.getCardsIn(ZoneType.Hand)), sourceAbility, true);
                } else if ("Random".equals(part.getType())) {
                    if (!p.getController().confirmPayment(part, Localizer.getInstance().getMessage("lblWouldYouLikeRandomDiscardTargetCard", amount), sourceAbility)) {
                        return false;
                    }
                    ((CostDiscard)part).payAsDecided(p, PaymentDecision.card(Aggregates.random(p.getCardsIn(ZoneType.Hand), amount)), sourceAbility, true);
                } else {
                    CardCollection list = CardLists.getValidCards((Iterable<Card>)p.getCardsIn(ZoneType.Hand), part.getType().split(";"), p, source, (CardTraitBase)sourceAbility);
                    boolean hasPaid = HumanPlay.payCostPart(controller, p, sourceAbility, hcd.isEffect(), (CostPartWithList)part, amount, list, Localizer.getInstance().getMessage("lbldiscard", new Object[0]) + orString);
                    if (!hasPaid) {
                        return false;
                    }
                }
            } else if (part instanceof CostReveal) {
                CostReveal costReveal = (CostReveal)part;
                CardCollection list = CardLists.getValidCards((Iterable<Card>)p.getCardsIn(costReveal.getRevealFrom()), part.getType(), p, source, (CardTraitBase)sourceAbility);
                int amount = part.getAbilityAmount(sourceAbility);
                boolean hasPaid = HumanPlay.payCostPart(controller, p, sourceAbility, hcd.isEffect(), (CostPartWithList)part, amount, list, Localizer.getInstance().getMessage("lblReveal", new Object[0]) + orString);
                if (!hasPaid) {
                    return false;
                }
            } else if (part instanceof CostTapType) {
                CardCollection list = CardLists.getValidCards((Iterable<Card>)p.getCardsIn(ZoneType.Battlefield), part.getType().split(";"), p, source, (CardTraitBase)sourceAbility);
                list = CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.CAN_TAP);
                int amount = part.getAbilityAmount(sourceAbility);
                boolean hasPaid = HumanPlay.payCostPart(controller, p, sourceAbility, hcd.isEffect(), (CostPartWithList)part, amount, list, Localizer.getInstance().getMessage("lblTap", new Object[0]) + orString);
                if (!hasPaid) {
                    return false;
                }
            } else if (part instanceof CostPartMana) {
                if (!((CostPartMana)part).getMana().isZero()) {
                    mayRemovePart = false;
                }
            } else if (part instanceof CostPayEnergy) {
                CounterType counterType = CounterType.get(CounterEnumType.ENERGY);
                int amount = part.getAbilityAmount(sourceAbility);
                if (!mandatory && !p.getController().confirmPayment(part, Localizer.getInstance().getMessage("lblDoYouWantSpendNTargetTypeCounter", String.valueOf(amount), counterType.getName()), sourceAbility)) {
                    return false;
                }
                p.payEnergy(amount, source);
            } else if (part instanceof CostExert) {
                part.payAsDecided(p, PaymentDecision.card(source), sourceAbility, hcd.isEffect());
            } else if (part instanceof CostPayShards) {
                int amount = part.getAbilityAmount(sourceAbility);
                if (!mandatory && !p.getController().confirmPayment(part, Localizer.getInstance().getMessage("lblDoYouWantPay", new Object[0]) + " " + amount + " {M}?", sourceAbility)) {
                    return false;
                }
                p.payShards(amount, source);
            } else {
                throw new RuntimeException("GameActionUtil.payCostDuringAbilityResolve - An unhandled type of cost was met: " + part.getClass());
            }
            if (!mayRemovePart) continue;
            remainingParts.remove(part);
        }
        if (remainingParts.isEmpty()) {
            return true;
        }
        if (remainingParts.size() > 1) {
            throw new RuntimeException("GameActionUtil.payCostDuringAbilityResolve - Too many payment types - " + source);
        }
        costPart = (CostPart)remainingParts.get(0);
        if (!(costPart instanceof CostPartMana)) {
            throw new RuntimeException("GameActionUtil.payCostDuringAbilityResolve - The remaining payment type is not Mana.");
        }
        if (prompt == null) {
            String promptCurrent = current == null ? "" : Localizer.getInstance().getMessage("lblCurrentCard", new Object[0]) + ": " + current;
            prompt = source + "\n" + promptCurrent;
        }
        sourceAbility.clearManaPaid();
        boolean paid = p.getController().payManaCost(cost.getCostMana(), sourceAbility, prompt, null, hcd.isEffect());
        if (!paid) {
            new ManaRefundService(sourceAbility).refundManaPaid();
        }
        return paid;
    }

    private static boolean payCostPart(PlayerControllerHuman controller, Player p, SpellAbility sourceAbility, boolean effect, CostPartWithList cpl, int amount, CardCollectionView list, String actionName) {
        if (list.size() < amount) {
            return false;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(controller, amount, amount, list, sourceAbility);
        String cardDesc = cpl.getDescriptiveType().equalsIgnoreCase("Card") ? "" : cpl.getDescriptiveType();
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectNSpecifyTypeCardsToAction", cardDesc, actionName));
        inp.setCancelAllowed(true);
        inp.showAndWait();
        if (inp.hasCancelled() || inp.getSelected().size() != amount) {
            return false;
        }
        cpl.payAsDecided(p, PaymentDecision.card(inp.getSelected()), sourceAbility, effect);
        return true;
    }

    private static boolean handleOfferingConvokeAndDelve(SpellAbility ability, CardCollection cardsToDelve, boolean manaInputCancelled) {
        Card hostCard = ability.getHostCard();
        Game game = hostCard.getGame();
        CardZoneTable table = new CardZoneTable(game.getLastStateBattlefield(), game.getLastStateGraveyard());
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(params, table);
        if (!manaInputCancelled && !cardsToDelve.isEmpty()) {
            for (Card c : cardsToDelve) {
                hostCard.addDelved(c);
                Card d = game.getAction().exile(c, null, params);
                hostCard.addExiledCard(d);
                d.setExiledWith(hostCard);
                d.setExiledBy(hostCard.getController());
            }
        }
        if (ability.isOffering() && ability.getSacrificedAsOffering() != null) {
            Card offering = ability.getSacrificedAsOffering();
            offering.setUsedToPay(false);
            if (!manaInputCancelled) {
                game.getAction().sacrifice(new CardCollection(offering), ability, false, params);
            }
            ability.resetSacrificedAsOffering();
        }
        if (ability.isEmerge() && ability.getSacrificedAsEmerge() != null) {
            Card emerge = ability.getSacrificedAsEmerge();
            emerge.setUsedToPay(false);
            if (!manaInputCancelled) {
                game.getAction().sacrifice(new CardCollection(emerge), ability, false, params);
                ability.setSacrificedAsEmerge(game.getChangeZoneLKIInfo(emerge));
            } else {
                ability.resetSacrificedAsEmerge();
            }
        }
        if (!table.isEmpty() && !manaInputCancelled) {
            table.triggerChangesZoneAll(game, ability);
        }
        return !manaInputCancelled;
    }

    public static boolean payManaCost(PlayerControllerHuman controller, ManaCost realCost, CostPartMana mc, SpellAbility ability, Player activator, String prompt, ManaConversionMatrix matrix, boolean effect) {
        Card source = ability.getHostCard();
        ManaCostBeingPaid toPay = new ManaCostBeingPaid(realCost);
        String xInCard = ability.getParamOrDefault("XAlternative", ability.getSVar("X"));
        String xColor = ability.getXColor();
        if (source.hasKeyword("Spend only colored mana on X. No more than one mana of each color may be spent this way.")) {
            xColor = "WUBRGX";
        }
        if (mc.getAmountOfX() > 0 && !"Count$xPaid".equals(xInCard)) {
            int xPaid = AbilityUtils.calculateAmount(source, xInCard, ability);
            toPay.setXManaCostPaid(xPaid, xColor);
            ability.setXManaCostPaid(xPaid);
        } else if (ability.getXManaCostPaid() != null) {
            toPay.setXManaCostPaid(ability.getXManaCostPaid(), xColor);
        }
        CardCollection cardsToDelve = new CardCollection();
        if (!effect) {
            CostAdjustment.adjust(toPay, ability, cardsToDelve, false);
        }
        Card offering = null;
        Card emerge = null;
        if (ability.isOffering()) {
            if (ability.getSacrificedAsOffering() == null) {
                System.out.println("Sacrifice input for Offering cancelled");
                return false;
            }
            offering = ability.getSacrificedAsOffering();
        }
        if (ability.isEmerge()) {
            if (ability.getSacrificedAsEmerge() == null) {
                System.out.println("Sacrifice input for Emerge cancelled");
                return false;
            }
            emerge = ability.getSacrificedAsEmerge();
        }
        if (!toPay.isPaid()) {
            if (matrix == null) {
                matrix = new ManaConversionMatrix();
                matrix.restoreColorReplacements();
                StaticAbilityManaConvert.manaConvert(matrix, activator, ability.getHostCard(), null);
            }
            InputPayManaOfCostPayment inpPayment = new InputPayManaOfCostPayment(controller, toPay, ability, activator, matrix, effect);
            inpPayment.setMessagePrefix(prompt);
            inpPayment.showAndWait();
            if (!inpPayment.isPaid()) {
                return HumanPlay.handleOfferingConvokeAndDelve(ability, cardsToDelve, true);
            }
            source.setXManaCostPaidByColor(toPay.getXManaCostPaidByColor());
        }
        if (ability.isOffering() && ability.getSacrificedAsOffering() == null && offering != null) {
            ability.setSacrificedAsOffering(offering);
        }
        if (ability.isEmerge() && ability.getSacrificedAsEmerge() == null && emerge != null) {
            ability.setSacrificedAsEmerge(emerge);
        }
        return HumanPlay.handleOfferingConvokeAndDelve(ability, cardsToDelve, false);
    }
}

