/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.CardType;
import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameEntityView;
import forge.game.GameEntityViewMap;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.CostAddMana;
import forge.game.cost.CostChooseColor;
import forge.game.cost.CostChooseCreatureType;
import forge.game.cost.CostCollectEvidence;
import forge.game.cost.CostDamage;
import forge.game.cost.CostDecisionMakerBase;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostDraw;
import forge.game.cost.CostEnlist;
import forge.game.cost.CostExert;
import forge.game.cost.CostExile;
import forge.game.cost.CostExileFromStack;
import forge.game.cost.CostExiledMoveToGrave;
import forge.game.cost.CostFlipCoin;
import forge.game.cost.CostForage;
import forge.game.cost.CostGainControl;
import forge.game.cost.CostGainLife;
import forge.game.cost.CostMill;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostPayShards;
import forge.game.cost.CostPromiseGift;
import forge.game.cost.CostPutCardToLib;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveAnyCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostReturn;
import forge.game.cost.CostReveal;
import forge.game.cost.CostRevealChosen;
import forge.game.cost.CostRollDice;
import forge.game.cost.CostSacrifice;
import forge.game.cost.CostTap;
import forge.game.cost.CostTapType;
import forge.game.cost.CostUnattach;
import forge.game.cost.CostUntap;
import forge.game.cost.CostUntapType;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputConfirm;
import forge.gamemodes.match.input.InputSelectCardsFromList;
import forge.gamemodes.match.input.InputSelectManyBase;
import forge.gui.GuiBase;
import forge.gui.util.SGuiChoose;
import forge.player.PlayerControllerHuman;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Expressions;
import forge.util.ITriggerEvent;
import forge.util.ImageUtil;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HumanCostDecision
extends CostDecisionMakerBase {
    private final PlayerControllerHuman controller;
    private String orString = null;
    private boolean mandatory;

    public HumanCostDecision(PlayerControllerHuman controller, Player p, SpellAbility sa, boolean effect) {
        this(controller, p, sa, effect, sa.getHostCard(), null);
    }

    public HumanCostDecision(PlayerControllerHuman controller, Player p, SpellAbility sa, boolean effect, Card source, String orString) {
        super(p, effect, sa, source);
        this.controller = controller;
        this.mandatory = sa.getPayCosts().isMandatory();
        this.orString = orString;
    }

    @Override
    public PaymentDecision visit(CostAddMana cost) {
        return PaymentDecision.number(cost.getAbilityAmount(this.ability));
    }

    @Override
    public PaymentDecision visit(CostChooseColor cost) {
        int c = cost.getAbilityAmount(this.ability);
        List<String> choices = this.player.getController().chooseColors(Localizer.getInstance().getMessage("lblChooseAColor", new Object[0]), this.ability, c, c, new ArrayList<String>(MagicColor.Constant.ONLY_COLORS));
        return PaymentDecision.colors(choices);
    }

    @Override
    public PaymentDecision visit(CostChooseCreatureType cost) {
        String choice = this.controller.chooseSomeType(Localizer.getInstance().getMessage("lblCreature", new Object[0]), this.ability, new ArrayList<String>(CardType.Constant.CREATURE_TYPES), new ArrayList<String>(), true);
        if (null == choice) {
            return null;
        }
        return PaymentDecision.type(choice);
    }

    @Override
    public PaymentDecision visit(CostCollectEvidence cost) {
        CardCollection list = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Graveyard), CardPredicates.canExiledBy(this.ability, this.isEffect()));
        int total = AbilityUtils.calculateAmount(this.source, cost.getAmount(), this.ability);
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 0, list.size(), list, this.ability, "CMC", total);
        inp.setMessage(Localizer.getInstance().getMessage("lblCollectEvidence", total));
        inp.setCancelAllowed(true);
        inp.showAndWait();
        if (inp.hasCancelled() || CardLists.getTotalCMC(inp.getSelected()) < total) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostDiscard cost) {
        int c;
        CardCollectionView hand = this.player.getCardsIn(ZoneType.Hand);
        String discardType = cost.getType();
        if (cost.payCostFromSource()) {
            return hand.contains(this.source) ? PaymentDecision.card(this.source) : null;
        }
        if (discardType.equals("Hand")) {
            if (!this.mandatory && !this.confirmAction(cost, Localizer.getInstance().getMessage("lblDoYouWantDiscardYourHand", new Object[0]))) {
                return null;
            }
            if (hand.size() > 1 && this.ability.getActivatingPlayer() != null) {
                hand = this.ability.getActivatingPlayer().getController().orderMoveToZoneList(hand, ZoneType.Graveyard, this.ability);
            }
            return PaymentDecision.card(hand);
        }
        if (discardType.equals("LastDrawn")) {
            Card lastDrawn = this.player.getLastDrawnCard();
            return hand.contains(lastDrawn) ? PaymentDecision.card(lastDrawn) : null;
        }
        if (discardType.equals("Random")) {
            CardCollectionView randomSubset = new CardCollection((Iterable<Card>)Aggregates.random(hand, c));
            if (randomSubset.size() > 1 && this.ability.getActivatingPlayer() != null) {
                randomSubset = this.ability.getActivatingPlayer().getController().orderMoveToZoneList(randomSubset, ZoneType.Graveyard, this.ability);
            }
            return PaymentDecision.card(randomSubset);
        }
        if (discardType.equals("DifferentNames")) {
            CardCollection discarded = new CardCollection();
            for (c = cost.getAbilityAmount(this.ability); c > 0; --c) {
                InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, hand, this.ability);
                inp.setMessage(Localizer.getInstance().getMessage("lblSelectOneDifferentNameCardToDiscardAlreadyChosen", new Object[0]) + discarded);
                inp.setCancelAllowed(true);
                inp.showAndWait();
                if (inp.hasCancelled()) {
                    return null;
                }
                Card first = (Card)inp.getFirstSelected();
                discarded.add(first);
                hand = CardLists.filter((Iterable<Card>)hand, Predicates.not(CardPredicates.sharesNameWith(first)));
            }
            return PaymentDecision.card(discarded);
        }
        if (discardType.contains("+WithSameName")) {
            String type = TextUtil.fastReplace(discardType, "+WithSameName", "");
            CardCollectionView landList2 = hand = CardLists.getValidCards((Iterable<Card>)hand, type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
            hand = CardLists.filter((Iterable<Card>)hand, c1 -> {
                for (Card card : landList2) {
                    if (card.equals(c1) || !card.getName().equals(c1.getName())) continue;
                    return true;
                }
                return false;
            });
            if (c == 0) {
                return PaymentDecision.card(new CardCollection());
            }
            CardCollection discarded = new CardCollection();
            while (c > 0) {
                InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, hand, this.ability);
                inp.setMessage(Localizer.getInstance().getMessage("lblSelectOneSameNameCardToDiscardAlreadyChosen", new Object[0]) + discarded);
                inp.setCancelAllowed(true);
                inp.showAndWait();
                if (inp.hasCancelled()) {
                    return null;
                }
                Card first = (Card)inp.getFirstSelected();
                discarded.add(first);
                CardCollection filteredHand = CardLists.filter((Iterable<Card>)hand, CardPredicates.nameEquals(first.getName()));
                filteredHand.remove(first);
                hand = filteredHand;
                --c;
            }
            return PaymentDecision.card(discarded);
        }
        String type = discardType;
        String[] validType = type.split(";");
        if ((hand = CardLists.getValidCards((Iterable<Card>)hand, validType, this.player, this.source, (CardTraitBase)this.ability)).size() < 1) {
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, c, hand, this.ability);
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectNMoreTargetTypeCardToDiscard", "%d", cost.getDescriptiveType()));
        inp.setCancelAllowed(!this.mandatory);
        inp.showAndWait();
        if (inp.hasCancelled() || inp.getSelected().size() != c) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostDamage cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (this.confirmAction(cost, Localizer.getInstance().getMessage("lblDoYouWantCardDealNDamageToYou", CardTranslation.getTranslatedName(this.source.getName()), String.valueOf(c)))) {
            return PaymentDecision.number(c);
        }
        return null;
    }

    @Override
    public PaymentDecision visit(CostDraw cost) {
        if (!cost.canPay(this.ability, this.player, this.isEffect())) {
            return null;
        }
        int c = cost.getAbilityAmount(this.ability);
        PlayerCollection res = cost.getPotentialPlayers(this.player, this.ability);
        String message = null;
        message = this.orString != null && !this.orString.isEmpty() ? (res.contains(this.player) ? Localizer.getInstance().getMessage("lblDoYouWantLetThatPlayerDrawNCardOrDoAction", String.valueOf(c), this.orString) : Localizer.getInstance().getMessage("lblDoYouWantDrawNCardOrDoAction", String.valueOf(c), this.orString)) : Localizer.getInstance().getMessage("lblDrawNCardsConfirm", String.valueOf(c));
        if (!this.confirmAction(cost, message)) {
            return null;
        }
        PaymentDecision decision = PaymentDecision.players(res);
        decision.c = c;
        return decision;
    }

    @Override
    public PaymentDecision visit(CostExile cost) {
        if (cost.payCostFromSource()) {
            if (!this.source.canExiledBy(this.ability, this.isEffect())) {
                return null;
            }
            return this.source.getZone() == this.player.getZone(cost.from.get(0)) && this.confirmAction(cost, Localizer.getInstance().getMessage("lblExileConfirm", CardTranslation.getTranslatedName(this.source.getName()))) ? PaymentDecision.card(this.source) : null;
        }
        Game game = this.player.getGame();
        String type = cost.getType();
        boolean fromTopGrave = false;
        if (type.contains("FromTopGrave")) {
            type = TextUtil.fastReplace(type, "FromTopGrave", "");
            fromTopGrave = true;
        }
        boolean totalCMC = false;
        boolean totalCMCgreater = false;
        String totalM = "";
        if (type.contains("+withTotalCMCEQ")) {
            totalCMC = true;
            totalM = type.split("withTotalCMCEQ")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalCMCEQ", totalM), "");
        }
        if (type.contains("+withTotalCMCGE")) {
            totalCMC = true;
            totalCMCgreater = true;
            totalM = type.split("withTotalCMCGE")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalCMCGE", totalM), "");
        }
        boolean sharedType = false;
        if (type.contains("+withSharedCardType")) {
            sharedType = true;
            type = TextUtil.fastReplace(type, "+withSharedCardType", "");
        }
        int nTypes = -1;
        if (type.contains("+withTypesGE")) {
            String num = type.split("withTypesGE")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTypesGE", num), "");
            nTypes = Integer.parseInt(num);
        }
        CardCollection list = cost.zoneRestriction != 1 ? new CardCollection(game.getCardsIn(cost.from)) : new CardCollection(this.player.getCardsIn(cost.from));
        if (type.equals("All")) {
            if (this.confirmAction(cost, Localizer.getInstance().getMessage("lblExileNCardsFromYourZone", list.size(), cost.from.get(0).getTranslatedName()))) {
                return PaymentDecision.card(list);
            }
            return null;
        }
        list = CardLists.getValidCards((Iterable<Card>)list, type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
        list = CardLists.filter((Iterable<Card>)list, CardPredicates.canExiledBy(this.ability, this.isEffect()));
        if (totalCMC) {
            int needed = Integer.parseInt(cost.getAmount().split("\\+")[0]);
            int total = AbilityUtils.calculateAmount(this.source, totalM, this.ability);
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, needed, list.size(), list, this.ability, "CMC", total);
            inp.setMessage(Localizer.getInstance().getMessage("lblSelectToExile", Lang.getNumeral(needed)));
            inp.setCancelAllowed(true);
            inp.showAndWait();
            int sum = CardLists.getTotalCMC(inp.getSelected());
            if (inp.hasCancelled() || sum != total && !totalCMCgreater || sum < total && totalCMCgreater) {
                return null;
            }
            return PaymentDecision.card(inp.getSelected());
        }
        if (nTypes > -1) {
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, list.size(), list, this.ability, "Types", nTypes);
            inp.setMessage(cost.getAmount().equals("X") ? Localizer.getInstance().getMessage("lblSelectAnyNumToExile", new Object[0]) : Localizer.getInstance().getMessage("lblSelectToExile", Lang.getNumeral(nTypes)));
            inp.setCancelAllowed(true);
            inp.showAndWait();
            if (inp.hasCancelled() || !Expressions.compare(CardFactoryUtil.getCardTypesFromList(list), "GE", nTypes)) {
                return null;
            }
            return PaymentDecision.card(inp.getSelected());
        }
        int c = cost.getAbilityAmount(this.ability);
        if (list.size() < c) {
            return null;
        }
        if (c == 0) {
            return PaymentDecision.number(c);
        }
        if (cost.from.size() == 1) {
            ZoneType fromZone = cost.from.get(0);
            if (fromZone == ZoneType.Battlefield || fromZone == ZoneType.Hand) {
                InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, c, list, this.ability);
                inp.setMessage(Localizer.getInstance().getMessage("lblExileNCardsFromYourZone", "%d", fromZone.getTranslatedName()));
                inp.setCancelAllowed(!this.mandatory);
                inp.showAndWait();
                return inp.hasCancelled() ? null : PaymentDecision.card(inp.getSelected());
            }
            if (fromZone == ZoneType.Library) {
                return this.exileFromTop(cost, c);
            }
        }
        if (fromTopGrave) {
            return this.exileFromTopGraveType(c, list);
        }
        if (cost.zoneRestriction != 0) {
            return this.exileFromMiscZone(cost, c, list, sharedType);
        }
        PlayerCollection players = game.getPlayers();
        ArrayList<Player> payableZone = new ArrayList<Player>();
        for (Player p : players) {
            CardCollection enoughType = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(p));
            if (enoughType.size() < c) {
                list.removeAll(enoughType);
                continue;
            }
            payableZone.add(p);
        }
        return this.exileFromSame(cost, list, c, payableZone);
    }

    private PaymentDecision exileFromSame(CostExile cost, CardCollectionView list, int nNeeded, List<Player> payableZone) {
        if (nNeeded == 0) {
            return PaymentDecision.number(0);
        }
        GameEntityViewMap gameCachePlayer = GameEntityView.getMap(payableZone);
        PlayerView pv = (PlayerView)this.controller.getGui().oneOrNone(Localizer.getInstance().getMessage("lblExileFromWhoseZone", cost.getFrom().get(0).getTranslatedName()), gameCachePlayer.getTrackableKeys());
        if (pv == null || !gameCachePlayer.containsKey(pv)) {
            return null;
        }
        Player p = (Player)gameCachePlayer.get(pv);
        CardCollection typeList = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(p));
        int count = typeList.size();
        if (count < nNeeded) {
            return null;
        }
        GameEntityViewMap gameCacheExile = GameEntityView.getMap(typeList);
        List views = this.controller.getGui().many(Localizer.getInstance().getMessage("lblExileFromZone", cost.getFrom().get(0).getTranslatedName()), Localizer.getInstance().getMessage("lblToBeExiled", new Object[0]), nNeeded, gameCacheExile.getTrackableKeys(), null);
        ArrayList<Card> result = Lists.newArrayList();
        gameCacheExile.addToList(views, result);
        return PaymentDecision.card(result);
    }

    @Override
    public PaymentDecision visit(CostExileFromStack cost) {
        Game game = this.player.getGame();
        String type = cost.getType();
        ArrayList<SpellAbility> saList = new ArrayList<SpellAbility>();
        ArrayList<String> descList = new ArrayList<String>();
        for (SpellAbilityStackInstance si : game.getStack()) {
            Card stC = si.getSourceCard();
            SpellAbility stSA = si.getSpellAbility().getRootAbility();
            if (!stC.isValid(cost.getType().split(";"), this.ability.getActivatingPlayer(), this.source, (CardTraitBase)this.ability) || !stSA.isSpell()) continue;
            saList.add(stSA);
            if (stC.isCopiedSpell()) {
                descList.add(stSA.getStackDescription() + " (Copied Spell)");
                continue;
            }
            descList.add(stSA.getStackDescription());
        }
        if (type.equals("All")) {
            return PaymentDecision.spellabilities(saList);
        }
        int c = cost.getAbilityAmount(this.ability);
        if (saList.size() < c) {
            return null;
        }
        ArrayList<SpellAbility> exiled = new ArrayList<SpellAbility>();
        for (int i = 0; i < c; ++i) {
            String o = (String)this.controller.getGui().oneOrNone(Localizer.getInstance().getMessage("lblExileFromStack", new Object[0]), descList);
            if (o == null) {
                return null;
            }
            SpellAbility toExile = (SpellAbility)saList.get(descList.indexOf(o));
            saList.remove(toExile);
            descList.remove(o);
            exiled.add(toExile);
        }
        return PaymentDecision.spellabilities(exiled);
    }

    private PaymentDecision exileFromTop(CostExile cost, int nNeeded) {
        CardCollectionView list = this.player.getCardsIn(ZoneType.Library, nNeeded);
        if (!this.confirmAction(cost, Localizer.getInstance().getMessage("lblExileNCardFromYourTopLibraryConfirm", new Object[0]))) {
            return null;
        }
        return PaymentDecision.card(list);
    }

    private PaymentDecision exileFromMiscZone(CostExile cost, int nNeeded, CardCollection typeList, boolean sharedType) {
        if (cost.zoneRestriction == -1 && this.ability.isTrigger() && nNeeded == 1 && typeList.size() == 1) {
            if (this.confirmAction(cost, Localizer.getInstance().getMessage("lblExileConfirm", CardTranslation.getTranslatedName(((Card)typeList.getFirst()).getName())))) {
                return PaymentDecision.card((Card)typeList.getFirst());
            }
            return null;
        }
        ArrayList<ZoneType> origin = Lists.newArrayList(cost.from);
        CardCollection exiled = new CardCollection();
        String required = sharedType ? " (must share a card type)" : "";
        List<Card> chosen = this.controller.chooseCardsForZoneChange(ZoneType.Exile, origin, this.ability, typeList, this.mandatory ? nNeeded : 0, nNeeded, null, cost.toString(nNeeded) + required, null);
        if (sharedType && !chosen.get(1).sharesCardTypeWith(chosen.get(0))) {
            return null;
        }
        exiled.addAll(chosen);
        if (exiled.size() < nNeeded) {
            return null;
        }
        return PaymentDecision.card(exiled);
    }

    private PaymentDecision exileFromTopGraveType(int nNeeded, CardCollection typeList) {
        Collections.reverse(typeList);
        return PaymentDecision.card(Iterables.limit(typeList, nNeeded));
    }

    @Override
    public PaymentDecision visit(CostExiledMoveToGrave cost) {
        int c = cost.getAbilityAmount(this.ability);
        Player activator = this.ability.getActivatingPlayer();
        CardCollection list = CardLists.getValidCards((Iterable<Card>)activator.getGame().getCardsIn(ZoneType.Exile), cost.getType().split(";"), activator, this.source, (CardTraitBase)this.ability);
        if (list.size() < c) {
            return null;
        }
        int min2 = c;
        if (this.ability.isOptionalTrigger()) {
            min2 = 0;
        }
        GameEntityViewMap gameCacheExile = GameEntityView.getMap(list);
        List<CardView> views = this.controller.getGui().many(Localizer.getInstance().getMessage("lblChooseAnExiledCardPutIntoGraveyard", new Object[0]), Localizer.getInstance().getMessage("lblToGraveyard", new Object[0]), min2, c, CardView.getCollection(list), CardView.get(this.source));
        if (views == null || views.size() < c) {
            return null;
        }
        ArrayList<Card> result = Lists.newArrayList();
        gameCacheExile.addToList(views, result);
        return PaymentDecision.card(result);
    }

    @Override
    public PaymentDecision visit(CostExert cost) {
        String type = cost.getType();
        CardCollection list = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if (cost.payCostFromSource()) {
            if (this.source.getController() == this.ability.getActivatingPlayer() && this.source.isInPlay()) {
                return this.confirmAction(cost, Localizer.getInstance().getMessage("lblExertCardConfirm", CardTranslation.getTranslatedName(this.source.getName()))) ? PaymentDecision.card(this.source) : null;
            }
            return null;
        }
        int c = cost.getAbilityAmount(this.ability);
        if (0 == c) {
            return PaymentDecision.number(0);
        }
        if (list.size() < c) {
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, c, list, this.ability);
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectACostToExert", cost.getDescriptiveType(), "%d"));
        inp.setCancelAllowed(true);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostEnlist cost) {
        CardCollection list = CostEnlist.getCardsForEnlisting(this.player);
        if (list.isEmpty()) {
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, list, this.ability);
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectACostToEnlist", cost.getDescriptiveType(), "%d"));
        inp.setCancelAllowed(true);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostFlipCoin cost) {
        Integer c = cost.getAbilityAmount(this.ability);
        if (!this.confirmAction(cost, Localizer.getInstance().getMessage("lblDoYouWantFlipNCoinAction", String.valueOf(c)))) {
            return null;
        }
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostForage cost) {
        CardCollection food = CardLists.filter(this.player.getCardsIn(ZoneType.Battlefield), CardPredicates.isType("Food"), CardPredicates.canBeSacrificedBy(this.ability, this.isEffect()));
        CardCollection exile = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Graveyard), CardPredicates.canExiledBy(this.ability, this.isEffect()));
        if (!food.isEmpty() && this.confirmAction(cost, "Sacrifice Food")) {
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, food, this.ability);
            inp.setMessage(Localizer.getInstance().getMessage("lblSelectATargetToSacrifice", "Food", "%d"));
            inp.setCancelAllowed(!this.mandatory);
            inp.showAndWait();
            if (inp.hasCancelled()) {
                return null;
            }
            return PaymentDecision.card(inp.getSelected());
        }
        if (exile.size() >= 3) {
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 3, 3, exile, this.ability);
            inp.setMessage(Localizer.getInstance().getMessage("lblSelectToExile", 3));
            inp.setCancelAllowed(!this.mandatory);
            inp.showAndWait();
            if (inp.hasCancelled()) {
                return null;
            }
            return PaymentDecision.card(inp.getSelected());
        }
        return null;
    }

    @Override
    public PaymentDecision visit(CostRollDice cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (!this.confirmAction(cost, Localizer.getInstance().getMessage("lblDoYouWantRollNDiceAction", String.valueOf(c), "d" + cost.getType()))) {
            return null;
        }
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostGainControl cost) {
        int c = cost.getAbilityAmount(this.ability);
        CardCollectionView list = this.player.getCardsIn(ZoneType.Battlefield);
        CardCollection validCards = CardLists.getValidCards((Iterable<Card>)list, cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        validCards = CardLists.filter((Iterable<Card>)validCards, crd -> crd.canBeControlledBy(this.player));
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, validCards, this.ability);
        String desc = cost.getTypeDescription() == null ? cost.getType() : cost.getTypeDescription();
        inp.setMessage(Localizer.getInstance().getMessage("lblGainNTargetControl", "%d", desc));
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostGainLife cost) {
        int c = cost.getAbilityAmount(this.ability);
        ArrayList<Player> oppsThatCanGainLife = new ArrayList<Player>();
        for (Player opp : cost.getPotentialTargets(this.player, this.ability)) {
            if (!opp.canGainLife()) continue;
            oppsThatCanGainLife.add(opp);
        }
        if (cost.getCntPlayers() == Integer.MAX_VALUE) {
            return PaymentDecision.players(oppsThatCanGainLife);
        }
        GameEntityViewMap gameCachePlayer = GameEntityView.getMap(oppsThatCanGainLife);
        PlayerView pv = (PlayerView)this.controller.getGui().oneOrNone(Localizer.getInstance().getMessage("lblCardChooseAnOpponentToGainNLife", CardTranslation.getTranslatedName(this.source.getName()), String.valueOf(c)), gameCachePlayer.getTrackableKeys());
        if (pv == null || !gameCachePlayer.containsKey(pv)) {
            return null;
        }
        return PaymentDecision.players(Lists.newArrayList((Player)gameCachePlayer.get(pv)));
    }

    @Override
    public PaymentDecision visit(CostMill cost) {
        Integer c = cost.getAbilityAmount(this.ability);
        String message = null;
        message = this.orString != null && !this.orString.isEmpty() ? Localizer.getInstance().getMessage("lblDoYouWantMillNCardsOrDoAction", String.valueOf(c), this.orString) : Localizer.getInstance().getMessage("lblMillNCardsFromYourLibraryConfirm", String.valueOf(c));
        if (!this.confirmAction(cost, message)) {
            return null;
        }
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostPayLife cost) {
        Integer c = cost.getAbilityAmount(this.ability);
        if (this.mandatory) {
            return PaymentDecision.number(c);
        }
        String message = null;
        message = this.orString != null && !this.orString.isEmpty() ? Localizer.getInstance().getMessage("lblDoYouWantPayNLife", String.valueOf(c), this.orString) : Localizer.getInstance().getMessage("lblPayNLifeConfirm", String.valueOf(c));
        if (this.player.canPayLife(c, this.isEffect(), this.ability) && this.confirmAction(cost, message)) {
            if (!this.player.getGame().EXPERIMENTAL_RESTORE_SNAPSHOT) {
                this.mandatory = true;
            }
            return PaymentDecision.number(c);
        }
        return null;
    }

    @Override
    public PaymentDecision visit(CostPayEnergy cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (this.player.canPayEnergy(c) && this.confirmAction(cost, Localizer.getInstance().getMessage("lblPayEnergyConfirm", cost.toString(), String.valueOf(this.player.getCounters(CounterEnumType.ENERGY)), "{E}"))) {
            return PaymentDecision.number(c);
        }
        return null;
    }

    @Override
    public PaymentDecision visit(CostPayShards cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (this.player.canPayShards(c) && this.confirmAction(cost, Localizer.getInstance().getMessage("lblPayShardsConfirm", cost.toString(), String.valueOf(this.player.getNumManaShards()), "{M} (Mana Shards)"))) {
            return PaymentDecision.number(c);
        }
        return null;
    }

    @Override
    public PaymentDecision visit(CostPartMana cost) {
        return new PaymentDecision(0);
    }

    @Override
    public PaymentDecision visit(CostPromiseGift cost) {
        PlayerCollection opponents = cost.getPotentialPlayers(this.player, this.ability);
        Player giftee = this.controller.chooseSingleEntityForEffect(opponents, null, this.ability, "Choose an opponent to promise a gift", false, null, null);
        if (giftee == null) {
            return null;
        }
        return PaymentDecision.players(Lists.newArrayList(giftee));
    }

    @Override
    public PaymentDecision visit(CostPutCardToLib cost) {
        int c = cost.getAbilityAmount(this.ability);
        CardCollection list = CardLists.getValidCards((Iterable<Card>)(cost.sameZone ? this.player.getGame().getCardsIn(cost.getFrom()) : this.player.getCardsIn(cost.getFrom())), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if (cost.payCostFromSource()) {
            return this.source.getZone() == this.player.getZone(cost.from) && this.confirmAction(cost, Localizer.getInstance().getMessage("lblPutCardToLibraryConfirm", CardTranslation.getTranslatedName(this.source.getName()))) ? PaymentDecision.card(this.source) : null;
        }
        if (cost.from == ZoneType.Hand) {
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, c, list, this.ability);
            inp.setMessage(Localizer.getInstance().getMessage("lblPutNCardsFromYourZone", "%d", cost.from.getTranslatedName()));
            inp.setCancelAllowed(true);
            inp.showAndWait();
            return inp.hasCancelled() ? null : PaymentDecision.card(inp.getSelected());
        }
        if (cost.sameZone) {
            PlayerCollection players = this.player.getGame().getPlayers();
            ArrayList<Player> payableZone = new ArrayList<Player>();
            for (Player p : players) {
                CardCollection enoughType = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(p));
                if (enoughType.size() < c) {
                    list.removeAll(enoughType);
                    continue;
                }
                payableZone.add(p);
            }
            return this.putFromSame(list, c, payableZone, cost.from);
        }
        return this.putFromMiscZone(this.ability, c, list, cost.from);
    }

    private PaymentDecision putFromMiscZone(SpellAbility sa, int nNeeded, CardCollection typeList, ZoneType fromZone) {
        if (typeList.size() < nNeeded) {
            return null;
        }
        CardCollection chosen = new CardCollection();
        GameEntityViewMap gameCacheCard = GameEntityView.getMap(typeList);
        for (int i = 0; i < nNeeded; ++i) {
            CardView cv = (CardView)this.controller.getGui().oneOrNone(Localizer.getInstance().getMessage("lblFromZonePutToLibrary", fromZone.getTranslatedName()), gameCacheCard.getTrackableKeys());
            if (cv == null || !gameCacheCard.containsKey(cv)) {
                return null;
            }
            chosen.add((Card)gameCacheCard.remove(cv));
        }
        return PaymentDecision.card(chosen);
    }

    private PaymentDecision putFromSame(CardCollectionView list, int nNeeded, List<Player> payableZone, ZoneType fromZone) {
        if (nNeeded == 0) {
            return PaymentDecision.number(0);
        }
        GameEntityViewMap gameCachePlayer = GameEntityView.getMap(payableZone);
        PlayerView pv = (PlayerView)SGuiChoose.oneOrNone(TextUtil.concatNoSpace(Localizer.getInstance().getMessage("lblPutCardsFromWhoseZone", new Object[0]), fromZone.getTranslatedName()), gameCachePlayer.getTrackableKeys());
        if (pv == null || !gameCachePlayer.containsKey(pv)) {
            return null;
        }
        Player p = (Player)gameCachePlayer.get(pv);
        CardCollection typeList = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(p));
        if (typeList.size() < nNeeded) {
            return null;
        }
        CardCollection chosen = new CardCollection();
        GameEntityViewMap gameCacheCard = GameEntityView.getMap(typeList);
        for (int i = 0; i < nNeeded; ++i) {
            CardView cv = (CardView)this.controller.getGui().oneOrNone(Localizer.getInstance().getMessage("lblPutZoneCardsToLibrary", fromZone.getTranslatedName()), gameCacheCard.getTrackableKeys());
            if (cv == null || !gameCacheCard.containsKey(cv)) {
                return null;
            }
            chosen.add((Card)gameCacheCard.remove(cv));
        }
        return PaymentDecision.card(chosen);
    }

    @Override
    public PaymentDecision visit(CostPutCounter cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (cost.payCostFromSource()) {
            if (this.ability.hasParam("UnlessCost") && !this.confirmAction(cost, Localizer.getInstance().getMessage("lblPutNTypeCounterOnTarget", String.valueOf(c), cost.getCounter().getName(), this.ability.getHostCard().getName()))) {
                return null;
            }
            cost.setLastPaidAmount(c);
            return PaymentDecision.number(c);
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.source.getGame().getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.ability.getHostCard(), (CardTraitBase)this.ability);
        if ((typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.canReceiveCounters(cost.getCounter()))).isEmpty()) {
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, typeList, this.ability);
        inp.setMessage(Localizer.getInstance().getMessage("lblPutNTypeCounterOnTarget", String.valueOf(c), cost.getCounter().getName(), cost.getDescriptiveType()));
        inp.setCancelAllowed(!this.mandatory);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostReturn cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (cost.payCostFromSource()) {
            Card card = this.ability.getHostCard();
            if (card.getController() == this.player && card.isInPlay()) {
                CardView view = CardView.get(card);
                return this.confirmAction(cost, Localizer.getInstance().getMessage("lblReturnCardToHandConfirm", CardTranslation.getTranslatedName(view.getName()))) ? PaymentDecision.card(card) : null;
            }
        } else {
            CardCollection validCards = CardLists.getValidCards((Iterable<Card>)this.ability.getActivatingPlayer().getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
            if (validCards.size() < c) {
                return null;
            }
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, c, validCards, this.ability);
            inp.setCancelAllowed(!this.mandatory);
            inp.setMessage(Localizer.getInstance().getMessage("lblNTypeCardsToHand", "%d", cost.getDescriptiveType()));
            inp.showAndWait();
            if (inp.hasCancelled()) {
                return null;
            }
            return PaymentDecision.card(inp.getSelected());
        }
        return null;
    }

    @Override
    public PaymentDecision visit(CostReveal cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        if (cost.getType().equals("Hand")) {
            return PaymentDecision.card(this.player.getCardsIn(ZoneType.Hand));
        }
        InputSelectCardsFromList inp = null;
        if (cost.getType().equals("SameColor")) {
            CardCollectionView hand;
            Integer num = cost.getAbilityAmount(this.ability);
            CardCollectionView hand2 = hand = this.player.getCardsIn(cost.getRevealFrom());
            hand = CardLists.filter((Iterable<Card>)hand, c -> {
                for (Card card : hand2) {
                    if (card.equals(c) || !card.sharesColorWith((Card)c)) continue;
                    return true;
                }
                return false;
            });
            if (num == 0) {
                return PaymentDecision.number(0);
            }
            inp = new InputSelectCardsFromList(this.controller, (int)num, (FCollectionView)hand, this.ability){
                private static final long serialVersionUID = 8338626212893374798L;

                @Override
                protected boolean onCardSelected(Card c, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
                    Card firstCard = Iterables.getFirst(this.selected, null);
                    if (firstCard != null && !CardPredicates.sharesColorWith(firstCard).apply(c)) {
                        return false;
                    }
                    return super.onCardSelected(c, otherCardsToSelect, triggerEvent);
                }
            };
            inp.setMessage(Localizer.getInstance().getMessage("lblSelectNCardOfSameColorToReveal", String.valueOf(num)));
        } else {
            int num = cost.getAbilityAmount(this.ability);
            CardCollectionView hand = this.player.getCardsIn(cost.getRevealFrom());
            if ((hand = CardLists.getValidCards((Iterable<Card>)hand, cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability)).size() < num) {
                return null;
            }
            if (num == 0) {
                return PaymentDecision.number(0);
            }
            if (!this.ability.isCastFromPlayEffect() && hand.size() == num) {
                return PaymentDecision.card(hand);
            }
            inp = new InputSelectCardsFromList(this.controller, num, num, hand, this.ability);
            inp.setMessage(Localizer.getInstance().getMessage("lblSelectNMoreTypeCardsTpReveal", "%d", cost.getDescriptiveType()));
        }
        inp.setCancelAllowed(!this.mandatory);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostRevealChosen cost) {
        return PaymentDecision.number(1);
    }

    @Override
    public PaymentDecision visit(CostRemoveAnyCounter cost) {
        int c = cost.getAbilityAmount(this.ability);
        String type = cost.getType();
        CardCollection list = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
        list = CardLists.filter((Iterable<Card>)list, CardPredicates.hasCounters());
        InputSelectCardToRemoveCounter inp = new InputSelectCardToRemoveCounter(this.controller, c, cost, cost.counter, list, this.ability);
        inp.setCancelAllowed(true);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.counters(inp.getCounterTable());
    }

    @Override
    public PaymentDecision visit(CostRemoveCounter cost) {
        String amount = cost.getAmount();
        String type = cost.getType();
        int cntRemoved = 1;
        if (!amount.equals("All")) {
            cntRemoved = cost.getAbilityAmount(this.ability);
        }
        if (cost.payCostFromSource()) {
            int maxCounters = this.source.getCounters(cost.counter);
            if (amount.equals("All")) {
                if (!InputConfirm.confirm(this.controller, this.ability, Localizer.getInstance().getMessage("lblRemoveAllCountersConfirm", new Object[0]))) {
                    return null;
                }
                cntRemoved = maxCounters;
            } else if (this.ability != null && !this.ability.isPwAbility()) {
                if (maxCounters < cntRemoved) {
                    return null;
                }
                if (!this.confirmAction(cost, Localizer.getInstance().getMessage("lblRemoveNTargetCounterFromCardPayCostConfirm", amount, cost.counter.getName().toLowerCase(), CardTranslation.getTranslatedName(this.source.getName())))) {
                    return null;
                }
            }
            if (maxCounters < cntRemoved) {
                return null;
            }
            return PaymentDecision.card(this.source, cntRemoved >= 0 ? cntRemoved : maxCounters);
        }
        if (type.equals("OriginalHost")) {
            int maxCounters = this.ability.getOriginalHost().getCounters(cost.counter);
            if (amount.equals("All")) {
                cntRemoved = maxCounters;
            }
            if (maxCounters < cntRemoved) {
                return null;
            }
            return PaymentDecision.card(this.ability.getOriginalHost(), cntRemoved >= 0 ? cntRemoved : maxCounters);
        }
        CardCollection validCards = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(cost.zone), type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if ((validCards = CardLists.filter((Iterable<Card>)validCards, CardPredicates.hasCounter(cost.counter, cntRemoved))).isEmpty()) {
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, validCards, this.ability);
        inp.setMessage(Localizer.getInstance().getMessage("lblRemoveCountersFromAInZoneCard", Lang.joinHomogenous(cost.zone, ZoneType::getTranslatedName)));
        inp.setCancelAllowed(true);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        Card selected = (Card)inp.getFirstSelected();
        if (selected == null) {
            return null;
        }
        return PaymentDecision.card(selected, cntRemoved);
    }

    @Override
    public PaymentDecision visit(CostSacrifice cost) {
        String amount = cost.getAmount();
        String type = cost.getType();
        if (cost.payCostFromSource()) {
            if (this.source.getController() == this.ability.getActivatingPlayer() && this.source.canBeSacrificedBy(this.ability, this.isEffect())) {
                return this.mandatory || this.confirmAction(cost, Localizer.getInstance().getMessage("lblSacrificeCardConfirm", CardTranslation.getTranslatedName(this.source.getName()))) ? PaymentDecision.card(this.source) : null;
            }
            return null;
        }
        if (type.equals("OriginalHost")) {
            Card host = this.ability.getOriginalHost();
            if (host.getController() == this.ability.getActivatingPlayer() && host.canBeSacrificedBy(this.ability, this.isEffect())) {
                return this.confirmAction(cost, Localizer.getInstance().getMessage("lblSacrificeCardConfirm", CardTranslation.getTranslatedName(host.getName()))) ? PaymentDecision.card(host) : null;
            }
            return null;
        }
        boolean differentNames = false;
        if (type.contains("+WithDifferentNames")) {
            type = type.replace("+WithDifferentNames", "");
            differentNames = true;
        }
        CardCollection list = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), CardPredicates.canBeSacrificedBy(this.ability, this.isEffect()));
        list = CardLists.getValidCards((Iterable<Card>)list, type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if (amount.equals("All")) {
            return PaymentDecision.card(list);
        }
        int c = cost.getAbilityAmount(this.ability);
        if (0 == c) {
            return PaymentDecision.number(0);
        }
        if (differentNames) {
            CardCollection chosen = new CardCollection();
            while (c > 0) {
                InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, list, this.ability);
                inp.setMessage(Localizer.getInstance().getMessage("lblSelectATargetToSacrifice", cost.getDescriptiveType(), c));
                inp.setCancelAllowed(true);
                inp.showAndWait();
                if (inp.hasCancelled()) {
                    return null;
                }
                Card first = (Card)inp.getFirstSelected();
                chosen.add(first);
                list = CardLists.filter((Iterable<Card>)list, Predicates.not(CardPredicates.sharesNameWith(first)));
                --c;
            }
            return PaymentDecision.card(chosen);
        }
        if (list.size() < c) {
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c, c, list, this.ability);
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectATargetToSacrifice", cost.getDescriptiveType(), "%d"));
        inp.setCancelAllowed(!this.mandatory);
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostTap cost) {
        return PaymentDecision.number(1);
    }

    @Override
    public PaymentDecision visit(CostTapType cost) {
        String type = cost.getType();
        String amount = cost.getAmount();
        boolean sameType = false;
        if (type.contains(".sharesCreatureTypeWith")) {
            sameType = true;
            type = TextUtil.fastReplace(type, ".sharesCreatureTypeWith", "");
        }
        boolean totalPower = false;
        String totalP = "";
        if (type.contains("+withTotalPowerGE")) {
            totalPower = true;
            totalP = type.split("withTotalPowerGE")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalPowerGE", totalP), "");
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
        typeList = CardLists.filter((Iterable<Card>)typeList, this.ability.isCrew() ? CardPredicates.Presets.CAN_CREW : CardPredicates.Presets.CAN_TAP);
        Integer c = null;
        if (!amount.equals("Any")) {
            c = cost.getAbilityAmount(this.ability);
        }
        if (c != null && c == 0) {
            return PaymentDecision.number(0);
        }
        if (sameType) {
            CardCollection list2 = typeList;
            typeList = CardLists.filter((Iterable<Card>)typeList, c12 -> {
                for (Card card : list2) {
                    if (card.equals(c12) || !card.sharesCreatureTypeWith((Card)c12)) continue;
                    return true;
                }
                return false;
            });
            CardCollection tapped = new CardCollection();
            while (c > 0) {
                InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 1, 1, typeList, this.ability);
                inp.setMessage(Localizer.getInstance().getMessage("lblSelectOneOfCardsToTapAlreadyChosen", tapped));
                inp.setCancelAllowed(true);
                inp.showAndWait();
                if (inp.hasCancelled()) {
                    return null;
                }
                Card first = (Card)inp.getFirstSelected();
                tapped.add(first);
                typeList = CardLists.filter((Iterable<Card>)typeList, c1 -> c1.sharesCreatureTypeWith(first));
                typeList.remove(first);
                Integer n = c;
                Integer n2 = c = Integer.valueOf(c - 1);
            }
            return PaymentDecision.card(tapped);
        }
        if (totalPower) {
            int i = Integer.parseInt(totalP);
            InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, 0, typeList.size(), typeList, this.ability);
            inp.setMessage(Localizer.getInstance().getMessage("lblSelectACreatureToTap", new Object[0]));
            inp.setCancelAllowed(true);
            inp.showAndWait();
            if (inp.hasCancelled() || CardLists.getTotalPower(inp.getSelected(), true, this.ability.isCrew()) < i) {
                return null;
            }
            return PaymentDecision.card(inp.getSelected());
        }
        if (c > typeList.size()) {
            if (!this.isEffect()) {
                this.controller.getGui().message(Localizer.getInstance().getMessage("lblEnoughValidCardNotToPayTheCost", new Object[0]), Localizer.getInstance().getMessage("lblCostPaymentInvalid", new Object[0]));
            }
            return null;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, (int)c, (int)c, typeList, this.ability);
        inp.setCancelAllowed(!this.mandatory);
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectATargetToTap", cost.getDescriptiveType(), "%d"));
        inp.showAndWait();
        if (inp.hasCancelled()) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostUntapType cost) {
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getGame().getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        typeList = CardLists.filter(typeList, CardPredicates.Presets.TAPPED, c -> c.getCounters(CounterEnumType.STUN) == 0 || c.canRemoveCounters(CounterType.get(CounterEnumType.STUN)));
        if (!cost.canUntapSource) {
            typeList.remove(this.source);
        }
        int c2 = cost.getAbilityAmount(this.ability);
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this.controller, c2, c2, typeList, this.ability);
        inp.setCancelAllowed(true);
        inp.setMessage(Localizer.getInstance().getMessage("lblSelectATargetToUntap", cost.getDescriptiveType(), "%d"));
        inp.showAndWait();
        if (inp.hasCancelled() || inp.getSelected().size() != c2) {
            return null;
        }
        return PaymentDecision.card(inp.getSelected());
    }

    @Override
    public PaymentDecision visit(CostUntap cost) {
        return PaymentDecision.number(1);
    }

    @Override
    public PaymentDecision visit(CostUnattach cost) {
        Card cardToUnattach = cost.findCardToUnattach(this.source, this.player, this.ability);
        if (cardToUnattach != null && this.confirmAction(cost, Localizer.getInstance().getMessage("lblUnattachCardConfirm", CardTranslation.getTranslatedName(cardToUnattach.getName())))) {
            return PaymentDecision.card(cardToUnattach);
        }
        return null;
    }

    @Override
    public boolean paysRightAfterDecision() {
        return true;
    }

    private boolean confirmAction(CostPart costPart, String message) {
        CardView cardView = this.ability.getCardView();
        if (GuiBase.getInterface().isLibgdxPort()) {
            try {
                if (cardView != null && cardView.getImprintedCards() != null && cardView.getImprintedCards().size() == 1) {
                    cardView = CardView.getCardForUi(ImageUtil.getPaperCardFromImageKey(cardView.getImprintedCards().get((CardView)false).getCurrentState().getTrackableImageKey()));
                } else if (this.ability.getTargets() != null && this.ability.getTargets().isTargetingAnyCard() && this.ability.getTargets().size() == 1) {
                    cardView = CardView.get(this.ability.getTargetCard());
                } else if ((cardView.getZone() == null || cardView.getZone().isHidden()) && !cardView.hasAlternateState()) {
                    cardView = CardView.getCardForUi(ImageUtil.getPaperCardFromImageKey(cardView.getCurrentState().getTrackableImageKey()));
                }
            }
            catch (Exception e) {
                cardView = this.ability.getCardView();
            }
            return this.controller.getGui().confirm(cardView, message.replaceAll("\n", " "));
        }
        return this.controller.confirmPayment(costPart, message, this.ability);
    }

    public static final class InputSelectCardToRemoveCounter
    extends InputSelectManyBase<GameEntity> {
        private static final long serialVersionUID = 2685832214519141903L;
        private final CounterType counterType;
        private final CardCollectionView validChoices;
        private final GameEntityCounterTable counterTable = new GameEntityCounterTable();

        public InputSelectCardToRemoveCounter(PlayerControllerHuman controller, int cntCounters, CostPart costPart, CounterType cType, CardCollectionView validCards, SpellAbility sa) {
            super(controller, cntCounters, cntCounters, sa);
            this.validChoices = validCards;
            this.counterType = cType;
            String fromWhat = costPart.getDescriptiveType();
            if (fromWhat.equals("CARDNAME") || fromWhat.equals("NICKNAME")) {
                fromWhat = CardTranslation.getTranslatedName(sa.getHostCard().getName());
            }
            this.setMessage(Localizer.getInstance().getMessage("lblRemoveNTargetCounterFromCardPayCostSelect", "%d", this.counterType == null ? "" : " " + this.counterType.getName().toLowerCase(), fromWhat));
        }

        @Override
        protected boolean onCardSelected(Card c, List<Card> otherCardsToSelect, ITriggerEvent triggerEvent) {
            if (!this.isValidChoice(c)) {
                return false;
            }
            CounterType cType = this.counterType;
            if (cType == null) {
                Map<CounterType, Integer> cmap = this.counterTable.filterToRemove(c);
                String prompt = Localizer.getInstance().getMessage("lblSelectCountersTypeToRemove", new Object[0]);
                cType = this.getController().chooseCounterType(Lists.newArrayList(cmap.keySet()), this.sa, prompt, null);
            }
            if (cType == null || !c.canRemoveCounters(cType)) {
                return false;
            }
            if (c.getCounters(cType) <= this.counterTable.get(null, c, cType)) {
                return false;
            }
            this.counterTable.put(null, c, cType, 1);
            this.onSelectStateChanged(c, true);
            this.refresh();
            return true;
        }

        @Override
        public String getActivateAction(Card c) {
            if (!this.isValidChoice(c)) {
                return null;
            }
            if (this.counterType != null) {
                if (c.getCounters(this.counterType) <= this.counterTable.get(null, c, this.counterType)) {
                    return null;
                }
            } else {
                boolean found = false;
                for (Map.Entry<CounterType, Integer> e : c.getCounters().entrySet()) {
                    if (e.getValue() <= this.counterTable.get(null, c, e.getKey())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
            return Localizer.getInstance().getMessage("lblRemoveCounterFromCard", new Object[0]);
        }

        @Override
        protected boolean hasEnoughTargets() {
            return this.hasAllTargets();
        }

        @Override
        protected boolean hasAllTargets() {
            int sum = this.getDistibutedCounters();
            return sum >= this.max;
        }

        @Override
        protected String getMessage() {
            return this.max == Integer.MAX_VALUE ? String.format(this.message, this.getDistibutedCounters()) : String.format(this.message, this.max - this.getDistibutedCounters());
        }

        private int getDistibutedCounters() {
            return this.counterTable.totalValues();
        }

        protected boolean isValidChoice(GameEntity choice) {
            return this.validChoices.contains(choice);
        }

        public GameEntityCounterTable getCounterTable() {
            return this.counterTable;
        }

        @Override
        public Collection<GameEntity> getSelected() {
            return this.counterTable.columnKeySet();
        }
    }
}

