/*
 * Decompiled with CFR 0.152.
 */
package forge.model;

import com.google.common.base.Predicate;
import forge.gamemodes.limited.CustomLimited;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.IUnOpenedProduct;
import forge.item.generation.UnOpenedProduct;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.model.UnOpenedMeta;
import forge.util.FileUtil;
import java.io.File;
import java.util.List;

public class MetaSet {
    private final MetaSetType type;
    private final String data;
    private final String code;
    private final boolean draftable;

    public MetaSet(String creationString, boolean canDraft) {
        int idxFirstPar = creationString.indexOf(40);
        int idxLastPar = creationString.lastIndexOf(41);
        this.draftable = canDraft;
        this.type = MetaSetType.smartValueOf(creationString.substring(0, idxFirstPar).trim());
        this.data = creationString.substring(idxFirstPar + 1, idxLastPar);
        String description = creationString.substring(idxLastPar + 1);
        this.code = description + "\u00a0(" + this.type.descriptiveName + ")";
    }

    public final String getCode() {
        return this.code;
    }

    public IUnOpenedProduct getBooster() {
        switch (this.type) {
            case Full: {
                return new UnOpenedProduct(SealedTemplate.genericDraftBooster);
            }
            case Booster: {
                return new UnOpenedProduct(FModel.getMagicDb().getBoosters().get(this.data));
            }
            case SpecialBooster: {
                return new UnOpenedProduct(FModel.getMagicDb().getSpecialBoosters().get(this.data));
            }
            case Pack: {
                return new UnOpenedProduct(FModel.getMagicDb().getTournamentPacks().get(this.data));
            }
            case JoinedSet: {
                Predicate<PaperCard> predicate = IPaperCard.Predicates.printedInSets(this.data.split(" "));
                return new UnOpenedProduct(SealedTemplate.genericDraftBooster, predicate);
            }
            case Choose: {
                return UnOpenedMeta.choose(this.data);
            }
            case Random: {
                return UnOpenedMeta.random(this.data);
            }
            case Combo: {
                return UnOpenedMeta.selectAll(this.data);
            }
            case Cube: {
                File dFolder = new File(ForgeConstants.SEALED_DIR);
                if (!dFolder.exists()) {
                    throw new RuntimeException("GenerateSealed : folder not found -- folder is " + dFolder.getAbsolutePath());
                }
                if (!dFolder.isDirectory()) {
                    throw new RuntimeException("GenerateSealed : not a folder -- " + dFolder.getAbsolutePath());
                }
                List<String> dfData = FileUtil.readFile(ForgeConstants.SEALED_DIR + this.data + ".sealed");
                CustomLimited myCube = CustomLimited.parse(dfData, FModel.getDecks().getCubes());
                SealedTemplate fnPick = myCube.getSealedProductTemplate();
                return new UnOpenedProduct(fnPick, myCube.getCardPool());
            }
        }
        return null;
    }

    public String toString() {
        return this.code;
    }

    public boolean isDraftable() {
        return this.draftable;
    }

    private static enum MetaSetType {
        Full("F", "All cards"),
        Cube("C", "Cube"),
        JoinedSet("J", "Joined set"),
        Choose("Select", "Choose from list"),
        Combo("All", "Combined booster"),
        Random("Any", "Randomly selected"),
        Booster("B", "Booster"),
        SpecialBooster("S", "Special Booster"),
        Pack("T", "Tournament/Starter");

        private final String shortHand;
        public final String descriptiveName;

        private MetaSetType(String shortname, String descName) {
            this.shortHand = shortname;
            this.descriptiveName = descName;
        }

        public static MetaSetType smartValueOf(String trim) {
            for (MetaSetType mt : MetaSetType.values()) {
                if (!mt.name().equalsIgnoreCase(trim) && !mt.shortHand.equalsIgnoreCase(trim)) continue;
                return mt;
            }
            throw new IllegalArgumentException(trim + " not recognized as Meta Set");
        }
    }
}

