/*
 * Decompiled with CFR 0.152.
 */
package forge.model;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import forge.CardStorageReader;
import forge.ImageKeys;
import forge.MulliganDefs;
import forge.StaticData;
import forge.ai.AiProfileUtil;
import forge.card.CardRulesPredicates;
import forge.card.CardType;
import forge.deck.CardArchetypeLDAGenerator;
import forge.deck.CardRelationMatrixGenerator;
import forge.deck.io.DeckPreferences;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.game.card.CardUtil;
import forge.game.spellability.Spell;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.limited.GauntletMini;
import forge.gamemodes.limited.ThemedChaosDraft;
import forge.gamemodes.planarconquest.ConquestController;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.tournament.TournamentData;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.card.CardPreferences;
import forge.gui.interfaces.IProgressBar;
import forge.item.PaperCard;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.achievements.AchievementCollection;
import forge.localinstance.achievements.AdventureAchievements;
import forge.localinstance.achievements.ConstructedAchievements;
import forge.localinstance.achievements.DraftAchievements;
import forge.localinstance.achievements.PlanarConquestAchievements;
import forge.localinstance.achievements.PuzzleAchievements;
import forge.localinstance.achievements.QuestAchievements;
import forge.localinstance.achievements.SealedAchievements;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.CardBlock;
import forge.model.CardCollections;
import forge.player.GamePlayerUtil;
import forge.util.CardTranslation;
import forge.util.FileUtil;
import forge.util.ItemPool;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.storage.IStorage;
import forge.util.storage.StorageBase;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FModel {
    private static StaticData magicDb;
    private static QuestPreferences questPreferences;
    private static ConquestPreferences conquestPreferences;
    private static ForgePreferences preferences;
    private static Map<GameType, AchievementCollection> achievements;
    private static TournamentData tournamentData;
    private static GauntletData gauntletData;
    private static GauntletMini gauntlet;
    private static QuestController quest;
    private static ConquestController conquest;
    private static CardCollections decks;
    private static IStorage<CardBlock> blocks;
    private static IStorage<CardBlock> fantasyBlocks;
    private static IStorage<ThemedChaosDraft> themedChaosDrafts;
    private static IStorage<ConquestPlane> planes;
    private static IStorage<QuestWorld> worlds;
    private static GameFormat.Collection formats;
    private static ItemPool<PaperCard> uniqueCardsNoAlt;
    private static ItemPool<PaperCard> allCardsNoAlt;
    private static ItemPool<PaperCard> planechaseCards;
    private static ItemPool<PaperCard> archenemyCards;
    private static ItemPool<PaperCard> brawlCommander;
    private static ItemPool<PaperCard> oathbreakerCommander;
    private static ItemPool<PaperCard> tinyLeadersCommander;
    private static ItemPool<PaperCard> commanderPool;
    private static ItemPool<PaperCard> avatarPool;
    private static ItemPool<PaperCard> conspiracyPool;
    private static ItemPool<PaperCard> dungeonPool;
    private static ItemPool<PaperCard> attractionPool;
    private static boolean deckGenMatrixLoaded;
    private static boolean keywordsLoaded;

    private FModel() {
    }

    public static void initialize(final IProgressBar progressBar, Function<ForgePreferences, Void> adjustPrefs) {
        CardStorageReader customTokenReader;
        CardStorageReader customReader;
        System.out.println("Forge v." + GuiBase.getInterface().getCurrentVersion() + " (" + GuiBase.getInterface() + ")");
        if (GuiBase.isAndroid()) {
            System.out.println(GuiBase.getDeviceName() + " (RAM: " + GuiBase.getDeviceRAM() + "MB, Android " + GuiBase.getAndroidRelease() + " API Level " + GuiBase.getAndroidAPILevel() + ")");
        } else {
            System.out.println(System.getProperty("os.name") + " (" + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")\n" + System.getProperty("java.vendor") + " (Java " + System.getProperty("java.runtime.version") + ", " + System.getProperty("java.vm.name") + ")");
        }
        ImageKeys.initializeDirs(ForgeConstants.CACHE_CARD_PICS_DIR, ForgeConstants.CACHE_CARD_PICS_SUBDIR, ForgeConstants.CACHE_TOKEN_PICS_DIR, ForgeConstants.CACHE_ICON_PICS_DIR, ForgeConstants.CACHE_BOOSTER_PICS_DIR, ForgeConstants.CACHE_FATPACK_PICS_DIR, ForgeConstants.CACHE_BOOSTERBOX_PICS_DIR, ForgeConstants.CACHE_PRECON_PICS_DIR, ForgeConstants.CACHE_TOURNAMENTPACK_PICS_DIR);
        try {
            preferences = GuiBase.getForgePrefs();
            if (adjustPrefs != null) {
                adjustPrefs.apply(preferences);
            }
            GamePlayerUtil.getGuiPlayer().setName(preferences.getPref(ForgePreferences.FPref.PLAYER_NAME));
        }
        catch (Exception exn) {
            throw new RuntimeException(exn);
        }
        Lang.createInstance(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE));
        Localizer.getInstance().initialize(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE), ForgeConstants.LANG_DIR);
        CardStorageReader.ProgressObserver progressBarBridge = progressBar == null ? CardStorageReader.ProgressObserver.emptyObserver : new CardStorageReader.ProgressObserver(){

            @Override
            public void setOperationName(String name, boolean usePercents) {
                FThreads.invokeInEdtLater(() -> {
                    progressBar.setDescription(name);
                    progressBar.setPercentMode(usePercents);
                });
            }

            @Override
            public void report(int current, int total) {
                FThreads.invokeInEdtLater(() -> {
                    progressBar.setMaximum(total);
                    progressBar.setValue(current);
                });
            }
        };
        FModel.loadDynamicGamedata();
        CardStorageReader reader = new CardStorageReader(ForgeConstants.CARD_DATA_DIR, progressBarBridge, false);
        CardStorageReader tokenReader = new CardStorageReader(ForgeConstants.TOKEN_DATA_DIR, progressBarBridge, false);
        try {
            customReader = new CardStorageReader(ForgeConstants.USER_CUSTOM_CARDS_DIR, progressBarBridge, false);
        }
        catch (Exception e) {
            customReader = null;
        }
        try {
            customTokenReader = new CardStorageReader(ForgeConstants.USER_CUSTOM_TOKENS_DIR, progressBarBridge, false);
        }
        catch (Exception e) {
            customTokenReader = null;
        }
        CardTranslation.preloadTranslation(preferences.getPref(ForgePreferences.FPref.UI_LANGUAGE), ForgeConstants.LANG_DIR);
        magicDb = new StaticData(reader, tokenReader, customReader, customTokenReader, ForgeConstants.EDITIONS_DIR, ForgeConstants.USER_CUSTOM_EDITIONS_DIR, ForgeConstants.BLOCK_DATA_DIR, ForgeConstants.SETLOOKUP_DIR, FModel.getPreferences().getPref(ForgePreferences.FPref.UI_PREFERRED_ART), FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LOAD_UNKNOWN_CARDS), FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LOAD_NONLEGAL_CARDS), FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ALLOW_CUSTOM_CARDS_IN_DECKS_CONFORMANCE), FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SMART_CARD_ART));
        for (String dname : ForgeConstants.PROFILE_DIRS) {
            File path = new File(dname);
            if (path.isDirectory() || path.mkdirs()) continue;
            throw new RuntimeException("cannot create profile directory: " + dname);
        }
        ForgePreferences.DEV_MODE = preferences.getPrefBoolean(ForgePreferences.FPref.DEV_MODE_ENABLED);
        ForgePreferences.UPLOAD_DRAFT = ForgePreferences.NET_CONN;
        formats = new GameFormat.Collection(new GameFormat.Reader(new File(ForgeConstants.FORMATS_DATA_DIR), new File(ForgeConstants.USER_FORMATS_DIR), preferences.getPrefBoolean(ForgePreferences.FPref.LOAD_ARCHIVED_FORMATS)));
        magicDb.setStandardPredicate(formats.getStandard().getFilterRules());
        magicDb.setPioneerPredicate(formats.getPioneer().getFilterRules());
        magicDb.setModernPredicate(formats.getModern().getFilterRules());
        magicDb.setCommanderPredicate(((GameFormat)formats.get("Commander")).getFilterRules());
        magicDb.setOathbreakerPredicate(((GameFormat)formats.get("Oathbreaker")).getFilterRules());
        magicDb.setBrawlPredicate(((GameFormat)formats.get("Brawl")).getFilterRules());
        magicDb.setFilteredHandsEnabled(preferences.getPrefBoolean(ForgePreferences.FPref.FILTERED_HANDS));
        try {
            magicDb.setMulliganRule(MulliganDefs.MulliganRule.valueOf(preferences.getPref(ForgePreferences.FPref.MULLIGAN_RULE)));
        }
        catch (Exception e) {
            magicDb.setMulliganRule(MulliganDefs.MulliganRule.London);
        }
        blocks = new StorageBase<CardBlock>("Block definitions", new CardBlock.Reader(ForgeConstants.BLOCK_DATA_DIR + "blocks.txt", magicDb.getEditions()));
        for (CardBlock b : blocks) {
            magicDb.getBlockLands().add(b.getLandSet().getCode());
        }
        questPreferences = new QuestPreferences();
        conquestPreferences = new ConquestPreferences();
        fantasyBlocks = new StorageBase<CardBlock>("Custom blocks", new CardBlock.Reader(ForgeConstants.BLOCK_DATA_DIR + "fantasyblocks.txt", magicDb.getEditions()));
        themedChaosDrafts = new StorageBase<ThemedChaosDraft>("Themed Chaos Drafts", new ThemedChaosDraft.Reader(ForgeConstants.BLOCK_DATA_DIR + "chaosdraftthemes.txt"));
        planes = new StorageBase<ConquestPlane>("Conquest planes", new ConquestPlane.Reader(ForgeConstants.CONQUEST_PLANES_DIR + "planes.txt"));
        Map standardWorlds = new QuestWorld.Reader(ForgeConstants.QUEST_WORLD_DIR + "worlds.txt").readAll();
        Map customWorlds = new QuestWorld.Reader(ForgeConstants.USER_QUEST_WORLD_DIR + "customworlds.txt").readAll();
        for (QuestWorld world : customWorlds.values()) {
            world.setCustom(true);
        }
        standardWorlds.putAll(customWorlds);
        worlds = new StorageBase<QuestWorld>("Quest worlds", null, standardWorlds);
        Spell.setPerformanceMode(preferences.getPrefBoolean(ForgePreferences.FPref.PERFORMANCE_MODE));
        if (progressBar != null) {
            FThreads.invokeInEdtLater(() -> progressBar.setDescription(Localizer.getInstance().getMessage("splash.loading.decks", new Object[0])));
        }
        decks = new CardCollections();
        quest = new QuestController();
        conquest = new ConquestController();
        CardPreferences.load();
        DeckPreferences.load();
        ItemManagerConfig.load();
        ConquestUtil.updateRarityFilterOdds();
        achievements = Maps.newHashMap();
        achievements.put(GameType.Constructed, new ConstructedAchievements());
        achievements.put(GameType.Draft, new DraftAchievements());
        achievements.put(GameType.Sealed, new SealedAchievements());
        achievements.put(GameType.Quest, new QuestAchievements());
        achievements.put(GameType.PlanarConquest, new PlanarConquestAchievements());
        achievements.put(GameType.Puzzle, new PuzzleAchievements());
        achievements.put(GameType.Adventure, new AdventureAchievements());
        AiProfileUtil.loadAllProfiles(ForgeConstants.AI_PROFILE_DIR);
        AiProfileUtil.setAiSideboardingMode(AiProfileUtil.AISideboardingMode.normalizedValueOf(FModel.getPreferences().getPref(ForgePreferences.FPref.MATCH_AI_SIDEBOARDING_MODE)));
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_CARDBASED)) {
            boolean commanderDeckGenMatrixLoaded = CardRelationMatrixGenerator.initialize();
            deckGenMatrixLoaded = CardArchetypeLDAGenerator.initialize();
            if (!commanderDeckGenMatrixLoaded) {
                deckGenMatrixLoaded = false;
            }
        }
        if (GuiBase.getInterface().isLibgdxPort() && GuiBase.getDeviceRAM() < 5000) {
            return;
        }
        allCardsNoAlt = FModel.getAllCardsNoAlt();
        archenemyCards = FModel.getArchenemyCards();
        planechaseCards = FModel.getPlanechaseCards();
        attractionPool = FModel.getAttractionPool();
        if (GuiBase.getInterface().isLibgdxPort()) {
            uniqueCardsNoAlt = FModel.getUniqueCardsNoAlt();
        } else {
            commanderPool = FModel.getCommanderPool();
            brawlCommander = FModel.getBrawlCommander();
            tinyLeadersCommander = FModel.getTinyLeadersCommander();
            avatarPool = FModel.getAvatarPool();
            conspiracyPool = FModel.getConspiracyPool();
        }
    }

    public static boolean isdeckGenMatrixLoaded() {
        return deckGenMatrixLoaded;
    }

    public static QuestController getQuest() {
        return quest;
    }

    public static ConquestController getConquest() {
        return conquest;
    }

    public static ItemPool<PaperCard> getUniqueCardsNoAlt() {
        if (uniqueCardsNoAlt == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getUniqueCardsNoAlt(), PaperCard.class);
        }
        return uniqueCardsNoAlt;
    }

    public static ItemPool<PaperCard> getAllCardsNoAlt() {
        if (allCardsNoAlt == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(), PaperCard.class);
        }
        return allCardsNoAlt;
    }

    public static ItemPool<PaperCard> getArchenemyCards() {
        if (archenemyCards == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_SCHEME, PaperCard::getRules)), PaperCard.class);
        }
        return archenemyCards;
    }

    public static ItemPool<PaperCard> getPlanechaseCards() {
        if (planechaseCards == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_PLANE_OR_PHENOMENON, PaperCard::getRules)), PaperCard.class);
        }
        return planechaseCards;
    }

    public static ItemPool<PaperCard> getBrawlCommander() {
        if (brawlCommander == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(Predicates.and(((GameFormat)FModel.getFormats().get("Brawl")).getFilterPrinted(), Predicates.compose(CardRulesPredicates.Presets.CAN_BE_BRAWL_COMMANDER, PaperCard::getRules))), PaperCard.class);
        }
        return brawlCommander;
    }

    public static ItemPool<PaperCard> getOathbreakerCommander() {
        if (oathbreakerCommander == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(Predicates.compose(Predicates.or(CardRulesPredicates.Presets.CAN_BE_OATHBREAKER, CardRulesPredicates.Presets.CAN_BE_SIGNATURE_SPELL), PaperCard::getRules)), PaperCard.class);
        }
        return oathbreakerCommander;
    }

    public static ItemPool<PaperCard> getTinyLeadersCommander() {
        if (tinyLeadersCommander == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(Predicates.compose(CardRulesPredicates.Presets.CAN_BE_TINY_LEADERS_COMMANDER, PaperCard::getRules)), PaperCard.class);
        }
        return tinyLeadersCommander;
    }

    public static ItemPool<PaperCard> getCommanderPool() {
        if (commanderPool == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(Predicates.compose(CardRulesPredicates.Presets.CAN_BE_COMMANDER, PaperCard::getRules)), PaperCard.class);
        }
        return commanderPool;
    }

    public static ItemPool<PaperCard> getAvatarPool() {
        if (avatarPool == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_VANGUARD, PaperCard::getRules)), PaperCard.class);
        }
        return avatarPool;
    }

    public static ItemPool<PaperCard> getConspiracyPool() {
        if (conspiracyPool == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_CONSPIRACY, PaperCard::getRules)), PaperCard.class);
        }
        return conspiracyPool;
    }

    public static ItemPool<PaperCard> getDungeonPool() {
        if (dungeonPool == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_DUNGEON, PaperCard::getRules)), PaperCard.class);
        }
        return dungeonPool;
    }

    public static ItemPool<PaperCard> getAttractionPool() {
        if (attractionPool == null) {
            return ItemPool.createFrom(FModel.getMagicDb().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_ATTRACTION, PaperCard::getRules)), PaperCard.class);
        }
        return attractionPool;
    }

    public static void loadDynamicGamedata() {
        if (!CardType.Constant.LOADED.isSet()) {
            List<String> typeListFile = FileUtil.readFile(ForgeConstants.TYPE_LIST_FILE);
            Set<String> addTo = null;
            for (String s2 : typeListFile) {
                if (s2.equals("[BasicTypes]")) {
                    addTo = CardType.Constant.BASIC_TYPES;
                    continue;
                }
                if (s2.equals("[LandTypes]")) {
                    addTo = CardType.Constant.LAND_TYPES;
                    continue;
                }
                if (s2.equals("[CreatureTypes]")) {
                    addTo = CardType.Constant.CREATURE_TYPES;
                    continue;
                }
                if (s2.equals("[SpellTypes]")) {
                    addTo = CardType.Constant.SPELL_TYPES;
                    continue;
                }
                if (s2.equals("[EnchantmentTypes]")) {
                    addTo = CardType.Constant.ENCHANTMENT_TYPES;
                    continue;
                }
                if (s2.equals("[ArtifactTypes]")) {
                    addTo = CardType.Constant.ARTIFACT_TYPES;
                    continue;
                }
                if (s2.equals("[WalkerTypes]")) {
                    addTo = CardType.Constant.WALKER_TYPES;
                    continue;
                }
                if (s2.equals("[DungeonTypes]")) {
                    addTo = CardType.Constant.DUNGEON_TYPES;
                    continue;
                }
                if (s2.equals("[BattleTypes]")) {
                    addTo = CardType.Constant.BATTLE_TYPES;
                    continue;
                }
                if (s2.equals("[PlanarTypes]")) {
                    addTo = CardType.Constant.PLANAR_TYPES;
                    continue;
                }
                if (s2.length() <= 1 || addTo == null) continue;
                if (s2.contains(":")) {
                    String[] k = s2.split(":");
                    addTo.add(k[0]);
                    CardType.Constant.pluralTypes.put(k[0], k[1]);
                    if (!k[0].contains(" ")) continue;
                    CardType.Constant.MultiwordTypes.add(k[0]);
                    continue;
                }
                addTo.add(s2);
                if (!s2.contains(" ")) continue;
                CardType.Constant.MultiwordTypes.add(s2);
            }
            CardType.Constant.LOADED.set();
        }
        if (!keywordsLoaded) {
            List<String> nskwListFile = FileUtil.readFile(ForgeConstants.KEYWORD_LIST_FILE);
            if (nskwListFile.size() > 1) {
                for (String s3 : nskwListFile) {
                    if (s3.length() <= 1) continue;
                    CardUtil.NON_STACKING_LIST.add(s3);
                }
            }
            keywordsLoaded = true;
        }
    }

    public static StaticData getMagicDb() {
        return magicDb;
    }

    public static ForgePreferences getPreferences() {
        return preferences;
    }

    public static AchievementCollection getAchievements(GameType gameType) {
        switch (gameType) {
            case Constructed: 
            case Draft: 
            case Sealed: 
            case Quest: 
            case PlanarConquest: 
            case Puzzle: 
            case Adventure: {
                break;
            }
            case AdventureEvent: {
                gameType = GameType.Adventure;
                break;
            }
            case QuestDraft: {
                gameType = GameType.Quest;
                break;
            }
            default: {
                gameType = GameType.Constructed;
            }
        }
        return achievements.get((Object)gameType);
    }

    public static IStorage<CardBlock> getBlocks() {
        return blocks;
    }

    public static QuestPreferences getQuestPreferences() {
        return questPreferences;
    }

    public static ConquestPreferences getConquestPreferences() {
        return conquestPreferences;
    }

    public static GauntletData getGauntletData() {
        return gauntletData;
    }

    public static void setGauntletData(GauntletData data0) {
        gauntletData = data0;
    }

    public static GauntletMini getGauntletMini() {
        if (gauntlet == null) {
            gauntlet = new GauntletMini();
        }
        return gauntlet;
    }

    public static CardCollections getDecks() {
        return decks;
    }

    public static IStorage<ConquestPlane> getPlanes() {
        return planes;
    }

    public static IStorage<QuestWorld> getWorlds() {
        return worlds;
    }

    public static GameFormat.Collection getFormats() {
        return formats;
    }

    public static IStorage<CardBlock> getFantasyBlocks() {
        return fantasyBlocks;
    }

    public static IStorage<ThemedChaosDraft> getThemedChaosDrafts() {
        return themedChaosDrafts;
    }

    public static TournamentData getTournamentData() {
        return tournamentData;
    }

    public static void setTournamentData(TournamentData tournamentData) {
        FModel.tournamentData = tournamentData;
    }

    static {
        deckGenMatrixLoaded = false;
        keywordsLoaded = false;
    }
}

