/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.menu.FDropDown;
import forge.screens.FScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.util.TextBounds;
import forge.util.Utils;

public class FTooltip
extends FDropDown {
    private static final FSkinFont FONT = FSkinFont.get(12);
    private static final float PADDING = Utils.scale(5.0f);
    private FDisplayObject owner;
    private float x;
    private float y;
    private final String text;

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public void show(FDisplayObject owner0, float x0, float y0) {
        this.owner = owner0;
        this.x = this.owner.localToScreenX(x0);
        this.y = this.owner.localToScreenY(y0);
        this.show();
    }

    @Override
    protected void updateSizeAndPosition() {
        FScreen screen = Forge.getCurrentScreen();
        float screenWidth = screen.getWidth();
        float screenHeight = screen.getHeight();
        this.paneSize = this.updateAndGetPaneSize(screenWidth, screenHeight);
        if (this.x + this.paneSize.getWidth() > screenWidth) {
            this.x = screenWidth - this.paneSize.getWidth();
        }
        if (this.y + this.paneSize.getHeight() > screenHeight) {
            this.y = screenHeight - this.paneSize.getHeight();
        }
        this.setBounds(Math.round(this.x), Math.round(this.y), Math.round(this.paneSize.getWidth()), Math.round(this.paneSize.getHeight()));
    }

    public FTooltip(String text0) {
        this.text = text0;
    }

    @Override
    protected boolean autoHide() {
        return true;
    }

    @Override
    protected FDisplayObject getDropDownOwner() {
        return this.owner;
    }

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        TextBounds bounds = FONT.getWrappedBounds(this.text, maxWidth - 2.0f * PADDING);
        return new FScrollPane.ScrollBounds(Math.min(maxWidth, bounds.width + 2.0f * PADDING), bounds.height + 2.0f * PADDING);
    }

    @Override
    public void drawBackground(Graphics g2) {
        super.drawBackground(g2);
        g2.drawText(this.text, FONT, FTooltip.getForeColor(), PADDING - this.getScrollLeft(), PADDING - this.getScrollTop(), this.getScrollWidth() - 2.0f * PADDING, this.getScrollHeight() - 2.0f * PADDING, true, 8, false);
    }
}

