/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.menu.FDropDown;
import forge.menu.FMenuItem;
import forge.menu.FSubMenu;
import forge.toolbox.FScrollPane;
import java.util.ArrayList;
import java.util.List;

public abstract class FDropDownMenu
extends FDropDown {
    protected final List<FMenuItem> items = new ArrayList<FMenuItem>();
    private int selected = -1;

    @Override
    protected boolean autoHide() {
        return true;
    }

    protected abstract void buildMenu();

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        this.clear();
        this.items.clear();
        this.buildMenu();
        boolean allowForIcon = false;
        for (FMenuItem item : this.items) {
            if (!item.hasIcon()) continue;
            allowForIcon = true;
            break;
        }
        for (FMenuItem item : this.items) {
            item.setAllowForIcon(allowForIcon);
        }
        float width = this.determineMenuWidth();
        if (width > maxWidth) {
            width = maxWidth;
        }
        float y = 0.0f;
        for (FMenuItem item : this.items) {
            item.setBounds(0.0f, y, width, FMenuItem.HEIGHT);
            y += FMenuItem.HEIGHT;
        }
        return new FScrollPane.ScrollBounds(width, y);
    }

    protected float determineMenuWidth() {
        float width = 0.0f;
        for (FMenuItem item : this.items) {
            float minWidth = item.getMinWidth();
            if (!(width < minWidth)) continue;
            width = minWidth;
        }
        return width;
    }

    public void addItem(FMenuItem item) {
        if (item.isVisible()) {
            this.items.add(this.add(item));
        }
    }

    @Override
    public boolean tap(float x, float y, int count) {
        super.tap(x, y, count);
        return !(this.getDropDownOwner() instanceof FSubMenu);
    }

    @Override
    public void setNextSelected() {
        ++this.selected;
        this.clearHighlight();
        if (this.selected > this.items.size()) {
            this.selected = 0;
        }
        try {
            this.items.get(this.selected).setHovered(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selected > this.items.size()) {
            this.clearHighlight();
            this.selected = this.items.size();
        }
        super.setNextSelected();
    }

    @Override
    public void setPreviousSelected() {
        --this.selected;
        if (this.selected < 0) {
            this.selected = this.items.size();
        }
        this.clearHighlight();
        try {
            this.items.get(this.selected).setHovered(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selected < 0) {
            this.clearHighlight();
            this.selected = -1;
        }
        super.setPreviousSelected();
    }

    private void clearHighlight() {
        for (FMenuItem item : this.items) {
            item.setHovered(false);
        }
    }

    @Override
    public void hide() {
        this.selected = -1;
        super.hide();
    }
}

