/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.properties;

import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileSection;
import forge.util.FileUtil;
import forge.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeProfileProperties {
    private static String userDir;
    private static String cacheDir;
    private static String cardPicsDir;
    private static Map<String, String> cardPicsSubDirs;
    private static String decksDir;
    private static String decksConstructedDir;
    private static int serverPort;
    private static final String USER_DIR_KEY = "userDir";
    private static final String CACHE_DIR_KEY = "cacheDir";
    private static final String CARD_PICS_DIR_KEY = "cardPicsDir";
    private static final String CARD_PICS_SUB_DIRS_KEY = "cardPicsSubDirs";
    private static final String DECKS_DIR_KEY = "decksDir";
    private static final String DECKS_CONSTRUCTED_DIR_KEY = "decksConstructedDir";
    private static final String SERVER_PORT_KEY = "serverPort";

    private ForgeProfileProperties() {
    }

    public static void load(boolean isUsingAppDirectory) {
        Properties props = new Properties();
        File propFile = new File(ForgeConstants.PROFILE_FILE);
        try {
            if (propFile.canRead() && !isUsingAppDirectory) {
                props.load(Files.newInputStream(propFile.toPath(), new OpenOption[0]));
            }
        }
        catch (IOException e) {
            System.err.println("error while reading from profile properties file");
        }
        Pair<String, String> defaults = ForgeProfileProperties.getDefaultDirs();
        userDir = ForgeProfileProperties.getDir(props, USER_DIR_KEY, defaults.getLeft());
        cacheDir = ForgeProfileProperties.getDir(props, CACHE_DIR_KEY, defaults.getRight());
        cardPicsDir = ForgeProfileProperties.getDir(props, CARD_PICS_DIR_KEY, cacheDir + "pics" + File.separator + "cards" + File.separator);
        cardPicsSubDirs = ForgeProfileProperties.getMap(props, CARD_PICS_SUB_DIRS_KEY);
        decksDir = ForgeProfileProperties.getDir(props, DECKS_DIR_KEY, userDir + "decks" + File.separator);
        decksConstructedDir = ForgeProfileProperties.getDir(props, DECKS_CONSTRUCTED_DIR_KEY, decksDir + "constructed" + File.separator);
        serverPort = ForgeProfileProperties.getInt(props, SERVER_PORT_KEY, 36743);
        FileUtil.ensureDirectoryExists(userDir);
        FileUtil.ensureDirectoryExists(cacheDir);
        FileUtil.ensureDirectoryExists(cardPicsDir);
    }

    public static String getUserDir() {
        return userDir;
    }

    public static void setUserDir(String userDir0) {
        userDir = userDir0;
        ForgeProfileProperties.save();
    }

    public static String getCacheDir() {
        return cacheDir;
    }

    public static void setCacheDir(String cacheDir0) {
        int idx = cardPicsDir.indexOf(cacheDir);
        if (idx != -1) {
            cardPicsDir = cacheDir0 + cardPicsDir.substring(idx + cacheDir.length());
        }
        cacheDir = cacheDir0;
        ForgeProfileProperties.save();
    }

    public static String getCardPicsDir() {
        return cardPicsDir;
    }

    public static void setCardPicsDir(String cardPicsDir0) {
        cardPicsDir = cardPicsDir0;
        ForgeProfileProperties.save();
    }

    public static Map<String, String> getCardPicsSubDirs() {
        return cardPicsSubDirs;
    }

    public static String getDecksDir() {
        return decksDir;
    }

    public static void setDecksDir(String decksDir0) {
        decksDir = decksDir0;
        ForgeProfileProperties.save();
    }

    public static String getDecksConstructedDir() {
        return decksConstructedDir;
    }

    public static void setDecksConstructedDir(String decksConstructedDir0) {
        decksConstructedDir = decksConstructedDir0;
        ForgeProfileProperties.save();
    }

    public static int getServerPort() {
        return serverPort;
    }

    private static Map<String, String> getMap(Properties props, String propertyKey) {
        String strMap = props.getProperty(propertyKey, "").trim();
        return FileSection.parseToMap(strMap, FileSection.ARROW_KV_SEPARATOR);
    }

    private static int getInt(Properties props, String propertyKey, int defaultValue) {
        String strValue = props.getProperty(propertyKey, "").trim();
        if (StringUtils.isNotBlank(strValue) && StringUtils.isNumeric(strValue)) {
            return Integer.parseInt(strValue);
        }
        return defaultValue;
    }

    private static String getDir(Properties props, String propertyKey, String defaultVal) {
        String retDir = props.getProperty(propertyKey, defaultVal).trim();
        if (retDir.isEmpty()) {
            retDir = defaultVal;
        }
        if (File.separatorChar == (retDir = new File(retDir).getAbsolutePath()).charAt(retDir.length() - 1)) {
            return retDir;
        }
        return retDir + File.separatorChar;
    }

    private static Pair<String, String> getDefaultDirs() {
        if (!GuiBase.getInterface().isRunningOnDesktop()) {
            String assetsDir = ForgeConstants.ASSETS_DIR;
            return Pair.of(assetsDir + "data" + File.separator, assetsDir + "cache" + File.separator);
        }
        String osName = System.getProperty("os.name");
        String homeDir = System.getProperty("user.home");
        if (StringUtils.isEmpty(osName) || StringUtils.isEmpty(homeDir)) {
            throw new RuntimeException("cannot determine OS and user home directory");
        }
        String fallbackDataDir = TextUtil.concatNoSpace(homeDir, "/.forge");
        if (StringUtils.containsIgnoreCase(osName, "windows")) {
            String cacheRoot;
            String appRoot = System.getenv().get("APPDATA");
            if (StringUtils.isEmpty(appRoot)) {
                appRoot = fallbackDataDir;
            }
            if (StringUtils.isEmpty(cacheRoot = System.getenv().get("LOCALAPPDATA"))) {
                cacheRoot = appRoot;
            }
            return Pair.of(appRoot + File.separator + "Forge", cacheRoot + File.separator + "Forge" + File.separator + "Cache");
        }
        if (StringUtils.containsIgnoreCase(osName, "mac os x")) {
            return Pair.of(TextUtil.concatNoSpace(homeDir, "/Library/Application Support/Forge"), TextUtil.concatNoSpace(homeDir, "/Library/Caches/Forge"));
        }
        return Pair.of(fallbackDataDir, TextUtil.concatNoSpace(homeDir, "/.cache/forge"));
    }

    private static void save() {
        Pair<String, String> defaults = ForgeProfileProperties.getDefaultDirs();
        String defaultUserDir = defaults.getLeft() + File.separator;
        String defaultDecksDir = defaultUserDir + "decks" + File.separator;
        String defaultCacheDir = defaults.getRight() + File.separator;
        String defaultCardPicsDir = defaultCacheDir + "pics" + File.separator + "cards" + File.separator;
        StringBuilder sb = new StringBuilder();
        if (!userDir.equals(defaultUserDir)) {
            sb.append("userDir=").append(userDir.replace("\\", "\\\\")).append("\n");
        }
        if (!decksDir.equals(defaultDecksDir)) {
            sb.append("decksDir=").append(decksDir.replace("\\", "\\\\")).append("\n");
        }
        if (!cacheDir.equals(defaultCacheDir)) {
            sb.append("cacheDir=").append(cacheDir.replace("\\", "\\\\")).append("\n");
        }
        if (!cardPicsDir.equals(defaultCardPicsDir)) {
            sb.append("cardPicsDir=").append(cardPicsDir.replace("\\", "\\\\")).append("\n");
        }
        if (cardPicsSubDirs.size() > 0) {
            sb.append("cardPicsSubDirs=");
            boolean needDelim = false;
            for (Map.Entry<String, String> entry : cardPicsSubDirs.entrySet()) {
                sb.append(entry.getKey()).append("->").append(entry.getValue());
            }
            sb.append("\n");
        }
        if (serverPort != 0) {
            sb.append("serverPort=").append(serverPort);
        }
        if (sb.length() > 0) {
            FileUtil.writeFile(ForgeConstants.PROFILE_FILE, sb.toString());
        } else {
            try {
                File file = new File(ForgeConstants.PROFILE_FILE);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

