/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.achievements;

import forge.game.Game;
import forge.game.GameType;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.localinstance.achievements.ProgressiveAchievement;
import forge.util.Localizer;
import java.util.HashMap;
import java.util.HashSet;

public class Domain
extends ProgressiveAchievement {
    private HashMap<String, String> basicLandMap = new HashMap<String, String>(){
        {
            this.put("Plains", "Plains");
            this.put("Snow-Covered Plains", "Plains");
            this.put("Island", "Island");
            this.put("Snow-Covered Island", "Island");
            this.put("Forest", "Forest");
            this.put("Snow-Covered Forest", "Forest");
            this.put("Mountain", "Mountain");
            this.put("Snow-Covered Mountain", "Mountain");
            this.put("Swamp", "Swamp");
            this.put("Snow-Covered Swamp", "Swamp");
        }
    };

    public Domain() {
        super("Domain", Localizer.getInstance().getMessage("lblDomain", new Object[0]), Localizer.getInstance().getMessage("lblWinGameWithOneOfEachBasicLandOnTheBattlefield", new Object[0]), Localizer.getInstance().getMessage("lblAbleToCastAnytingNiceBeing", new Object[0]));
    }

    @Override
    protected boolean eval(Player player, Game game) {
        if (game.getRules().hasAppliedVariant(GameType.MomirBasic) || game.getRules().hasAppliedVariant(GameType.MoJhoSto)) {
            return false;
        }
        if (player.getOutcome().hasWon()) {
            HashSet<String> basicLands = new HashSet<String>();
            for (Card c : player.getCardsIn(ZoneType.Battlefield)) {
                String name = c.getName();
                if (!c.isBasicLand() || !this.basicLandMap.containsKey(name)) continue;
                basicLands.add(this.basicLandMap.get(name));
            }
            return basicLands.size() == 5;
        }
        return false;
    }

    @Override
    protected String getNoun() {
        return Localizer.getInstance().getMessage("lblWin", new Object[0]);
    }
}

