/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.assets.FSkin;
import forge.item.InventoryItem;
import forge.item.ItemPredicate;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.ToggleButtonsFilter;
import forge.toolbox.FLabel;
import java.util.HashMap;
import java.util.Map;

public abstract class StatTypeFilter<T extends InventoryItem>
extends ToggleButtonsFilter<T> {
    protected final Map<SItemManagerUtil.StatTypes, FLabel> buttonMap = new HashMap<SItemManagerUtil.StatTypes, FLabel>();

    public StatTypeFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
    }

    protected void addToggleButton(ItemFilter.Widget widget, SItemManagerUtil.StatTypes st) {
        ToggleButtonsFilter.ToggleButton button = this.addToggleButton(widget, FSkin.getImages().get((Object)st.skinProp));
        this.buttonMap.put(st, button);
        button.setLongPressHandler(e -> {
            this.lockFiltering = true;
            SFilterUtil.showOnlyStat(st, button, this.buttonMap);
            this.lockFiltering = false;
            this.applyChange();
        });
    }

    @Override
    protected <U extends InventoryItem> boolean showUnsupportedItem(U item) {
        FLabel btnPackOrDeck = this.buttonMap.get(SItemManagerUtil.StatTypes.PACK_OR_DECK);
        if (btnPackOrDeck != null && btnPackOrDeck.isSelected()) {
            return ItemPredicate.Presets.IS_PACK_OR_DECK.apply(item);
        }
        return false;
    }
}

