/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.deck.DeckProxy;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.ListLabelFilter;
import java.util.HashSet;
import java.util.Set;

public class DeckFolderFilter
extends ListLabelFilter<DeckProxy> {
    protected final Set<String> folders = new HashSet<String>();

    public DeckFolderFilter(ItemManager<? super DeckProxy> itemManager0) {
        super(itemManager0);
    }

    public DeckFolderFilter(ItemManager<? super DeckProxy> itemManager0, String folder0) {
        super(itemManager0);
        this.folders.add(folder0);
    }

    @Override
    public ItemFilter<DeckProxy> createCopy() {
        DeckFolderFilter copy = new DeckFolderFilter(this.itemManager);
        copy.folders.addAll(this.folders);
        return copy;
    }

    @Override
    protected final Predicate<DeckProxy> buildPredicate() {
        return input -> {
            String path = input.getPath();
            for (String folder : this.folders) {
                if (!path.startsWith(folder)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    protected String getCaption() {
        return "Folder";
    }

    @Override
    protected Iterable<String> getList() {
        return this.folders;
    }

    @Override
    protected String getTooltip() {
        return null;
    }

    @Override
    protected int getCount() {
        return this.folders.size();
    }

    @Override
    public void reset() {
        this.folders.clear();
        this.updateLabel();
    }
}

