/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.assets.FSkinFont;
import forge.item.InventoryItem;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.ItemFilter;
import forge.toolbox.FComboBox;
import forge.toolbox.FDisplayObject;

public abstract class ComboBoxFilter<T extends InventoryItem, V>
extends ItemFilter<T> {
    protected V filterValue;
    private boolean preventHandling = false;
    private FComboBox<Object> comboBox = new FComboBox<Object>(){

        @Override
        protected String getDisplayText(Object item) {
            if (item instanceof String) {
                return (String)item;
            }
            return ComboBoxFilter.this.getDisplayText(item);
        }
    };

    protected ComboBoxFilter(String allText, Iterable<V> values, ItemManager<? super T> itemManager0) {
        this(allText, itemManager0);
        for (V value : values) {
            this.comboBox.addItem(value);
        }
    }

    protected ComboBoxFilter(String allText, V[] values, ItemManager<? super T> itemManager0) {
        this(allText, itemManager0);
        for (V value : values) {
            this.comboBox.addItem(value);
        }
    }

    private ComboBoxFilter(String allText, ItemManager<? super T> itemManager0) {
        super(itemManager0);
        this.comboBox.setFont(FSkinFont.get(12));
        this.comboBox.addItem(allText);
        this.comboBox.setChangedHandler(e -> {
            if (this.preventHandling) {
                return;
            }
            int index = this.comboBox.getSelectedIndex();
            if (index != -1) {
                if (index == 0) {
                    this.filterValue = null;
                    this.applyChange();
                } else {
                    this.filterValue = this.comboBox.getSelectedItem();
                    this.applyChange();
                }
            }
        });
    }

    protected String getDisplayText(V value) {
        return value.toString();
    }

    @Override
    public void reset() {
        this.preventHandling = true;
        this.comboBox.setSelectedIndex(0);
        this.preventHandling = false;
        this.filterValue = null;
    }

    @Override
    public FDisplayObject getMainComponent() {
        return this.comboBox;
    }

    @Override
    public boolean isEmpty() {
        return this.filterValue == null;
    }

    @Override
    protected void buildWidget(ItemFilter.Widget widget) {
        widget.add(this.comboBox);
    }

    @Override
    protected void doWidgetLayout(float width, float height) {
        this.comboBox.setSize(width, height);
    }
}

