/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.TextSearchFilter;

public class CardSearchFilter
extends TextSearchFilter<PaperCard> {
    private final boolean inName;
    private final boolean inType;
    private final boolean inText;
    private final boolean inCost;

    public CardSearchFilter(ItemManager<? super PaperCard> itemManager0) {
        this(itemManager0, true, true, true, false);
    }

    public CardSearchFilter(ItemManager<? super PaperCard> itemManager0, boolean inName0, boolean inType0, boolean inText0, boolean inCost0) {
        super(itemManager0);
        this.inName = inName0;
        this.inType = inType0;
        this.inText = inText0;
        this.inCost = inCost0;
    }

    @Override
    public ItemFilter<PaperCard> createCopy() {
        CardSearchFilter copy = new CardSearchFilter(this.itemManager, this.inName, this.inType, this.inText, this.inCost);
        copy.getWidget();
        copy.txtSearch.setText(this.txtSearch.getText());
        return copy;
    }

    @Override
    protected Predicate<PaperCard> buildPredicate() {
        return SFilterUtil.buildTextFilter(this.txtSearch.getText(), false, this.inName, this.inType, this.inText, this.inCost);
    }

    @Override
    protected <U extends InventoryItem> boolean showUnsupportedItem(U item) {
        return SFilterUtil.buildItemTextFilter(this.txtSearch.getText()).apply(item);
    }
}

