/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.game.GameFormat;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FGroupList;
import forge.toolbox.FList;
import forge.util.Callback;
import forge.util.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ArchivedFormatSelect
extends FScreen {
    private GameFormat selectedFormat;
    private final FGroupList<GameFormat> lstFormats = this.add(new FGroupList());
    private final Set<GameFormat.FormatSubType> archivedSubTypes = new HashSet<GameFormat.FormatSubType>(Arrays.asList(GameFormat.FormatSubType.BLOCK, GameFormat.FormatSubType.STANDARD, GameFormat.FormatSubType.EXTENDED, GameFormat.FormatSubType.MODERN, GameFormat.FormatSubType.LEGACY, GameFormat.FormatSubType.VINTAGE));
    private Runnable onCloseCallBack;

    public ArchivedFormatSelect() {
        super(Forge.getLocalizer().getMessage("lblChooseFormat", new Object[0]));
        for (GameFormat.FormatType group : GameFormat.FormatType.values()) {
            if (group == GameFormat.FormatType.ARCHIVED) {
                for (GameFormat.FormatSubType subgroup : GameFormat.FormatSubType.values()) {
                    if (!this.archivedSubTypes.contains((Object)subgroup)) continue;
                    this.lstFormats.addGroup(group.name() + "-" + subgroup.name());
                }
                continue;
            }
            this.lstFormats.addGroup(group.name());
        }
        for (GameFormat format : FModel.getFormats().getOrderedList()) {
            block0 : switch (format.getFormatType()) {
                case SANCTIONED: {
                    this.lstFormats.addItem(format, 0);
                    break;
                }
                case CASUAL: {
                    this.lstFormats.addItem(format, 1);
                    break;
                }
                case ARCHIVED: {
                    switch (format.getFormatSubType()) {
                        case BLOCK: {
                            this.lstFormats.addItem(format, 2);
                            break block0;
                        }
                        case STANDARD: {
                            this.lstFormats.addItem(format, 3);
                            break block0;
                        }
                        case EXTENDED: {
                            this.lstFormats.addItem(format, 4);
                            break block0;
                        }
                        case MODERN: {
                            this.lstFormats.addItem(format, 5);
                            break block0;
                        }
                        case LEGACY: {
                            this.lstFormats.addItem(format, 6);
                            break block0;
                        }
                        case VINTAGE: {
                            this.lstFormats.addItem(format, 7);
                        }
                    }
                    break;
                }
                case DIGITAL: {
                    this.lstFormats.addItem(format, 8);
                    break;
                }
                case CUSTOM: {
                    this.lstFormats.addItem(format, 9);
                }
            }
        }
        this.lstFormats.setListItemRenderer(new FormatRenderer());
    }

    public GameFormat getSelectedFormat() {
        return this.selectedFormat;
    }

    public void setOnCloseCallBack(Runnable onCloseCallBack) {
        this.onCloseCallBack = onCloseCallBack;
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        if (this.selectedFormat != null && this.onCloseCallBack != null) {
            this.onCloseCallBack.run();
        }
        super.onClose(canCloseCallback);
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.lstFormats.setBounds(0.0f, startY, width, height - startY);
    }

    private class FormatRenderer
    extends FList.ListItemRenderer<GameFormat> {
        private FormatRenderer() {
        }

        @Override
        public float getItemHeight() {
            return Utils.AVG_FINGER_HEIGHT;
        }

        @Override
        public boolean tap(Integer index, GameFormat value, float x, float y, int count) {
            ArchivedFormatSelect.this.selectedFormat = value;
            Forge.back();
            return true;
        }

        @Override
        public void drawValue(Graphics g2, Integer index, GameFormat value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
            float offset = SettingsScreen.getInsets(w) - FList.PADDING;
            float textHeight = h2 -= 2.0f * offset;
            g2.drawText(value.toString(), font, foreColor, x += offset, y += offset, (w -= 2.0f * offset) - (h2 *= 0.66f) - FList.PADDING, textHeight, false, 8, true);
            x += w - h2;
            y += (textHeight - h2) / 2.0f;
        }
    }
}

