/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager.filters;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.assets.FSkinImage;
import forge.assets.TextRenderer;
import forge.gui.GuiBase;
import forge.gui.interfaces.IButton;
import forge.item.InventoryItem;
import forge.itemmanager.AdvancedSearch;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.ListLabelFilter;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.menu.FTooltip;
import forge.screens.FScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextField;
import forge.util.Callback;

public class AdvancedSearchFilter<T extends InventoryItem>
extends ItemFilter<T> {
    private final AdvancedSearch.Model<T> model;
    private FiltersLabel label;
    private EditScreen editScreen;
    private final Runnable onFilterChange = new Runnable(){

        @Override
        public void run() {
            AdvancedSearchFilter.this.model.updateExpression();
            AdvancedSearchFilter.this.itemManager.applyNewOrModifiedFilter(AdvancedSearchFilter.this);
        }
    };

    public AdvancedSearchFilter(ItemManager<? super T> itemManager0) {
        super(itemManager0);
        this.model = new AdvancedSearch.Model();
    }

    @Override
    public ItemFilter<T> createCopy() {
        AdvancedSearchFilter<T> copy = new AdvancedSearchFilter<T>(this.itemManager);
        return copy;
    }

    @Override
    protected final Predicate<T> buildPredicate() {
        return this.model.getPredicate();
    }

    public Predicate<? super T> getPredicate() {
        return this.model.getPredicate();
    }

    public void edit() {
        if (this.editScreen == null) {
            this.editScreen = new EditScreen();
        }
        Forge.openScreen(this.editScreen);
    }

    @Override
    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public void reset() {
        this.model.reset();
        this.editScreen = null;
    }

    public void setFilterParts(String[] items, boolean joinAnd) {
        this.reset();
        this.editScreen = new EditScreen();
        EditScreen.Filter currFilter = this.editScreen.getNewestFilter();
        for (int i = 0; i < items.length; ++i) {
            String filterText = items[i];
            AdvancedSearch.Filter filter = AdvancedSearch.getFilter(this.itemManager.getGenericType(), filterText);
            if (filter == null) continue;
            currFilter.setFilter(filter);
            currFilter.getBtnFilter().setText(GuiBase.getInterface().encodeSymbols(filter.toString(), false));
            if (i >= items.length - 1) continue;
            if (joinAnd) {
                currFilter.btnAnd.setSelected(true);
            } else {
                currFilter.btnOr.setSelected(true);
            }
            this.editScreen.addNewFilter(currFilter);
            currFilter = this.editScreen.getNewestFilter();
        }
        this.onFilterChange.run();
    }

    @Override
    protected void buildWidget(ItemFilter.Widget widget) {
        this.label = new FiltersLabel();
        this.model.setLabel(this.label);
        widget.add(this.label);
        widget.setVisible(!this.isEmpty());
    }

    @Override
    protected void doWidgetLayout(float width, float height) {
        this.label.setSize(width, height);
    }

    private class EditScreen
    extends FScreen {
        private FScrollPane scroller;

        private EditScreen() {
            super(Forge.getLocalizer().getMessage("lblAdvancedSearch", new Object[0]));
            this.scroller = this.add(new FScrollPane(){

                @Override
                protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
                    float x = 0.0f;
                    float y = 0.0f;
                    float w = visibleWidth;
                    float h2 = (FTextField.getDefaultHeight() + FList.PADDING) * 3.0f;
                    for (FDisplayObject child : this.getChildren()) {
                        child.setBounds(x, y, w, h2);
                        y += h2;
                    }
                    return new FScrollPane.ScrollBounds(visibleWidth, y);
                }
            });
            Filter filter = new Filter();
            AdvancedSearchFilter.this.model.addFilterControl(filter);
            this.scroller.add(filter);
        }

        @Override
        public void onActivate() {
            super.onActivate();
            if (AdvancedSearchFilter.this.model.isEmpty()) {
                AdvancedSearchFilter.this.model.editFilterControl(Iterables.getFirst(AdvancedSearchFilter.this.model.getControls(), null), AdvancedSearchFilter.this.onFilterChange);
            }
        }

        @Override
        public void onClose(Callback<Boolean> canCloseCallback) {
            AdvancedSearchFilter.this.onFilterChange.run();
            super.onClose(canCloseCallback);
        }

        @Override
        protected void doLayout(float startY, float width, float height) {
            this.scroller.setBounds(0.0f, startY, width, height - startY);
        }

        private forge.itemmanager.filters.AdvancedSearchFilter$EditScreen.Filter getNewestFilter() {
            return (Filter)this.scroller.getChildAt(this.scroller.getChildCount() - 1);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void addNewFilter(Filter fromFilter) {
            if (this.scroller.getChildAt(this.scroller.getChildCount() - 1) == fromFilter) {
                Filter filter = new Filter();
                AdvancedSearchFilter.this.model.addFilterControl(filter);
                this.scroller.add(filter);
                this.scroller.revalidate();
                this.scroller.scrollToBottom();
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void removeNextFilter(Filter fromFilter) {
            int index = this.scroller.indexOf(fromFilter);
            if (index < this.scroller.getChildCount() - 1) {
                Filter nextFilter = (Filter)this.scroller.getChildAt(index + 1);
                AdvancedSearchFilter.this.model.removeFilterControl(nextFilter);
                this.scroller.remove(nextFilter);
                this.scroller.revalidate();
            }
        }

        private class Filter
        extends FContainer
        implements AdvancedSearch.IFilterControl<T> {
            private final FLabel btnNotBeforeParen = this.add(new FLabel.Builder().align(1).text("NOT").selectable().build());
            private final FLabel btnOpenParen = this.add(new FLabel.Builder().align(1).text("(").selectable().build());
            private final FLabel btnNotAfterParen = this.add(new FLabel.Builder().align(1).text("NOT").selectable().build());
            private final FLabel btnFilter = this.add(new FLabel.ButtonBuilder().parseSymbols(true).build());
            private final FLabel btnCloseParen = this.add(new FLabel.Builder().align(1).selectable().text(")").build());
            private final FLabel btnAnd;
            private final FLabel btnOr;
            private AdvancedSearch.Filter<T> filter;

            private Filter() {
                this.btnAnd = this.add(new FLabel.Builder().align(1).text("AND").selectable().command(new FEvent.FEventHandler(){

                    @Override
                    public void handleEvent(FEvent e) {
                        if (Filter.this.btnAnd.isSelected()) {
                            Filter.this.btnOr.setSelected(false);
                            EditScreen.this.addNewFilter(Filter.this);
                        } else {
                            EditScreen.this.removeNextFilter(Filter.this);
                        }
                    }
                }).build());
                this.btnOr = this.add(new FLabel.Builder().align(1).text("OR").selectable().command(new FEvent.FEventHandler(){

                    @Override
                    public void handleEvent(FEvent e) {
                        if (Filter.this.btnOr.isSelected()) {
                            Filter.this.btnAnd.setSelected(false);
                            EditScreen.this.addNewFilter(Filter.this);
                        } else {
                            EditScreen.this.removeNextFilter(Filter.this);
                        }
                    }
                }).build());
            }

            @Override
            protected void doLayout(float width, float height) {
                float padding = FList.PADDING;
                float buttonWidth = (width - padding * 4.0f) / 3.0f;
                float buttonHeight = (height - padding * 3.0f) / 3.0f;
                float x = padding;
                float y = padding;
                float dx = buttonWidth + padding;
                float dy = buttonHeight + padding;
                this.btnNotBeforeParen.setBounds(x, y, buttonWidth, buttonHeight);
                this.btnOpenParen.setBounds(x += dx, y, buttonWidth, buttonHeight);
                this.btnNotAfterParen.setBounds(x += dx, y, buttonWidth, buttonHeight);
                x = padding;
                this.btnFilter.setBounds(x, y += dy, width - 2.0f * padding, buttonHeight);
                this.btnCloseParen.setBounds(x, y += dy, buttonWidth, buttonHeight);
                this.btnAnd.setBounds(x += dx, y, buttonWidth, buttonHeight);
                this.btnOr.setBounds(x += dx, y, buttonWidth, buttonHeight);
            }

            @Override
            public IButton getBtnNotBeforeParen() {
                return this.btnNotBeforeParen;
            }

            @Override
            public IButton getBtnOpenParen() {
                return this.btnOpenParen;
            }

            @Override
            public IButton getBtnNotAfterParen() {
                return this.btnNotAfterParen;
            }

            @Override
            public IButton getBtnFilter() {
                return this.btnFilter;
            }

            @Override
            public IButton getBtnCloseParen() {
                return this.btnCloseParen;
            }

            @Override
            public IButton getBtnAnd() {
                return this.btnAnd;
            }

            @Override
            public IButton getBtnOr() {
                return this.btnOr;
            }

            @Override
            public AdvancedSearch.Filter<T> getFilter() {
                return this.filter;
            }

            @Override
            public void setFilter(AdvancedSearch.Filter<T> filter0) {
                this.filter = filter0;
            }

            @Override
            public Class<? super T> getGenericType() {
                return AdvancedSearchFilter.this.itemManager.getGenericType();
            }
        }
    }

    private class FiltersLabel
    extends FLabel {
        private String toolTipText;

        private FiltersLabel() {
            super(new FLabel.Builder().align(8).parseSymbols(true).font(ListLabelFilter.LABEL_FONT));
        }

        @Override
        public String getToolTipText() {
            return this.toolTipText;
        }

        @Override
        public void setToolTipText(String s0) {
            this.toolTipText = s0;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (count == 1) {
                FPopupMenu menu = new FPopupMenu(){

                    @Override
                    protected void buildMenu() {
                        for (AdvancedSearch.IFilterControl control : AdvancedSearchFilter.this.model.getControls()) {
                            FMenuItem item = new FMenuItem(control.getFilter().toString(), Forge.hdbuttons ? FSkinImage.HDEDIT : FSkinImage.EDIT, e -> AdvancedSearchFilter.this.model.editFilterControl(control, AdvancedSearchFilter.this.onFilterChange));
                            item.setTextRenderer(new TextRenderer());
                            this.addItem(item);
                        }
                        this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblEditExpression", new Object[0]), Forge.hdbuttons ? FSkinImage.HDEDIT : FSkinImage.EDIT, e -> AdvancedSearchFilter.this.edit()));
                        this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblRemoveFilter", new Object[0]), Forge.hdbuttons ? FSkinImage.HDDELETE : FSkinImage.DELETE, e -> {
                            AdvancedSearchFilter.this.reset();
                            AdvancedSearchFilter.this.itemManager.applyNewOrModifiedFilter(AdvancedSearchFilter.this);
                        }));
                    }
                };
                menu.show(this, x, y);
            } else if (count == 2) {
                AdvancedSearchFilter.this.edit();
            }
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            FTooltip tooltip = new FTooltip(this.toolTipText);
            tooltip.show(this, x, this.getHeight());
            return true;
        }
    }
}

