/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.badlogic.gdx.graphics.Texture;
import com.google.common.base.Function;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.ImageCache;
import forge.card.CardRenderer;
import forge.gamemodes.quest.QuestSpellShop;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManager;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.TextSearchFilter;
import forge.toolbox.FList;
import java.util.Map;

public class SpellShopManager
extends ItemManager<InventoryItem> {
    private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnGetPrice;

    public SpellShopManager(boolean isShop0) {
        super(InventoryItem.class, false);
        Function<Map.Entry<? extends InventoryItem, Integer>, Object> function = this.fnGetPrice = isShop0 ? QuestSpellShop.fnPriceGet : QuestSpellShop.fnPriceSellGet;
        if (!isShop0) {
            this.setCaption(Forge.getLocalizer().getMessage("lblCards", new Object[0]));
        }
    }

    @Override
    protected void addDefaultFilters() {
        CardManager.addDefaultFilters(this);
    }

    @Override
    protected TextSearchFilter<? extends InventoryItem> createSearchFilter() {
        return CardManager.createSearchFilter(this);
    }

    @Override
    protected AdvancedSearchFilter<? extends InventoryItem> createAdvancedSearchFilter() {
        return CardManager.createAdvancedSearchFilter(this);
    }

    @Override
    public ItemManager.ItemRenderer getListItemRenderer(final FList.CompactModeHandler compactModeHandler) {
        return new ItemManager.ItemRenderer(){

            @Override
            public float getItemHeight() {
                return CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode());
            }

            public void drawValue(Graphics g2, Map.Entry<InventoryItem, Integer> value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                if (value.getValue() == null) {
                    return;
                }
                float totalHeight = h2 + 2.0f * FList.PADDING;
                float cardArtWidth = totalHeight * 1.302f;
                if (value.getKey() instanceof PaperCard) {
                    CardRenderer.drawCardListItem(g2, font, foreColor, (PaperCard)value.getKey(), (int)value.getValue(), SpellShopManager.this.getItemSuffix(value), x, y, w, h2, compactModeHandler.isCompactMode());
                } else {
                    g2.drawText(value.getValue().toString() + " " + value.getKey().toString(), font, foreColor, x + cardArtWidth, y, w - cardArtWidth, h2, false, 8, true);
                    Texture image = ImageCache.getImage(value.getKey());
                    if (image != null) {
                        float imageHeight = totalHeight;
                        float imageRatio = (float)image.getWidth() / (float)image.getHeight();
                        float imageWidth = imageHeight * imageRatio;
                        if (imageWidth > cardArtWidth) {
                            imageWidth = cardArtWidth;
                            imageHeight = imageWidth / imageRatio;
                        }
                        g2.drawImage(image, x - FList.PADDING + (cardArtWidth - imageWidth) / 2.0f, y - FList.PADDING + (totalHeight - imageHeight) / 2.0f, imageWidth, imageHeight);
                    }
                }
                float priceHeight = font.getLineHeight();
                g2.fillRect(backColor, x - FList.PADDING, y += totalHeight - priceHeight - FList.PADDING, cardArtWidth, priceHeight);
                g2.drawImage(FSkinImage.QUEST_COINSTACK, x, y, priceHeight, priceHeight);
                float offset = priceHeight * 1.1f;
                g2.drawText(SpellShopManager.this.fnGetPrice.apply(value).toString(), font, foreColor, x + offset, y, cardArtWidth - offset - 2.0f * FList.PADDING, priceHeight, false, 8, true);
            }

            public boolean tap(Integer index, Map.Entry<InventoryItem, Integer> value, float x, float y, int count) {
                if (value.getKey() instanceof PaperCard) {
                    return CardRenderer.cardListItemTap(SpellShopManager.this.model.getOrderedList(), index, SpellShopManager.this, x, y, count, compactModeHandler.isCompactMode());
                }
                return false;
            }

            public boolean longPress(Integer index, Map.Entry<InventoryItem, Integer> value, float x, float y) {
                if (value.getKey() instanceof PaperCard && CardRenderer.cardListItemTap(SpellShopManager.this.model.getOrderedList(), index, SpellShopManager.this, x, y, 1, compactModeHandler.isCompactMode())) {
                    return true;
                }
                SpellShopManager.this.toggleMultiSelectMode(index);
                return true;
            }

            public boolean allowPressEffect(FList<Map.Entry<InventoryItem, Integer>> list, float x, float y) {
                Map.Entry<InventoryItem, Integer> value = list.getItemAtPoint(x, y);
                if (value != null && value.getKey() instanceof PaperCard) {
                    return x > CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode()) * 1.302f;
                }
                return true;
            }
        };
    }
}

