/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import forge.item.InventoryItem;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemColumnConfig;
import forge.itemmanager.ItemManagerModel;
import forge.util.ItemPool;
import forge.util.ItemPoolSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class ItemManagerModel<T extends InventoryItem> {
    private static final int maxSortDepth = 3;
    private final ItemPool<T> data;
    private boolean infiniteSupply;
    private final CascadeManager cascadeManager = new CascadeManager();
    private final transient List<Map.Entry<T, Integer>> itemsOrdered = Collections.synchronizedList(new ArrayList());
    protected transient boolean isListInSync = false;

    public ItemManagerModel(Class<T> genericType0) {
        this.data = new ItemPool<T>(genericType0);
    }

    public void clear() {
        this.data.clear();
    }

    public synchronized List<Map.Entry<T, Integer>> getOrderedList() {
        if (!this.isListInSync) {
            this.rebuildOrderedList();
        }
        return this.itemsOrdered;
    }

    private void rebuildOrderedList() {
        this.itemsOrdered.clear();
        if (this.data != null) {
            for (Map.Entry<T, Integer> e : this.data) {
                this.itemsOrdered.add(e);
            }
        }
        this.isListInSync = true;
    }

    public int countDistinct() {
        return this.data.countDistinct();
    }

    public ItemPool<T> getItems() {
        return this.data.getView();
    }

    public void removeItem(T item0, int qty) {
        if (this.data.count(item0) > 0) {
            if (this.isInfinite()) {
                this.data.removeAll(item0);
            } else {
                this.data.remove(item0, qty);
            }
            this.isListInSync = false;
        }
    }

    public void replaceAll(T item0, T replacement0) {
        int count = this.data.count(item0);
        if (count > 0) {
            this.data.removeAll(item0);
            this.data.add(replacement0, count);
            this.isListInSync = false;
        }
    }

    public void addItem(T item0, int qty) {
        this.data.add(item0, qty);
        this.isListInSync = false;
    }

    public void addItems(Iterable<Map.Entry<T, Integer>> items0) {
        this.data.addAll(items0);
        this.isListInSync = false;
    }

    public void setInfinite(boolean infinite) {
        this.infiniteSupply = infinite;
    }

    public boolean isInfinite() {
        return this.infiniteSupply;
    }

    public CascadeManager getCascadeManager() {
        return this.cascadeManager;
    }

    public void refreshSort() {
        List<Map.Entry<T, Integer>> list = this.getOrderedList();
        if (list.isEmpty()) {
            return;
        }
        try {
            list.sort(new MyComparator());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private final class MyComparator
    implements Comparator<Map.Entry<T, Integer>> {
        private MyComparator() {
        }

        @Override
        public int compare(Map.Entry<T, Integer> o1, Map.Entry<T, Integer> o2) {
            return ItemManagerModel.this.cascadeManager.getSorter().compare(o1, o2);
        }
    }

    public final class CascadeManager {
        private final List<ItemColumn> colsToSort = Collections.synchronizedList(new ArrayList(3));
        private forge.itemmanager.ItemManagerModel$CascadeManager.Sorter sorter = null;

        public void add(ItemColumn col0, boolean forSetup) {
            this.sorter = null;
            if (forSetup) {
                this.colsToSort.add(0, col0);
            } else {
                if (this.colsToSort.size() > 0 && this.colsToSort.get(0).equals(col0)) {
                    col0.getConfig().setSortPriority(1);
                    col0.getConfig().setSortState(col0.getConfig().getSortState() == ItemColumnConfig.SortState.ASC ? ItemColumnConfig.SortState.DESC : ItemColumnConfig.SortState.ASC);
                } else {
                    this.colsToSort.remove(col0);
                    col0.getConfig().setSortPriority(1);
                    col0.getConfig().setSortState(col0.getConfig().getDefaultSortState());
                    this.colsToSort.add(0, col0);
                }
                for (int i = 1; i < 3 && this.colsToSort.size() != i; ++i) {
                    if (this.colsToSort.get(i).getConfig().getSortPriority() == 0) continue;
                    this.colsToSort.get(i).getConfig().setSortPriority(i + 1);
                }
            }
            if (this.colsToSort.size() > 3) {
                this.colsToSort.get(3).getConfig().setSortPriority(0);
                this.colsToSort.remove(3);
            }
        }

        public forge.itemmanager.ItemManagerModel$CascadeManager.Sorter getSorter() {
            if (this.sorter == null) {
                this.sorter = this.createSorter();
            }
            return this.sorter;
        }

        public void reset() {
            this.colsToSort.clear();
            this.sorter = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private forge.itemmanager.ItemManagerModel$CascadeManager.Sorter createSorter() {
            ArrayList<ItemPoolSorter<InventoryItem>> oneColSorters = new ArrayList<ItemPoolSorter<InventoryItem>>(3);
            List<ItemColumn> list = this.colsToSort;
            synchronized (list) {
                for (ItemColumn col : this.colsToSort) {
                    oneColSorters.add(new ItemPoolSorter(col.getFnSort(), col.getConfig().getSortState().equals((Object)ItemColumnConfig.SortState.ASC)));
                }
            }
            return new Sorter(oneColSorters);
        }

        public class Sorter
        implements Comparator<Map.Entry<InventoryItem, Integer>> {
            private final List<ItemPoolSorter<InventoryItem>> sorters;
            private final int cntFields;

            public Sorter(List<ItemPoolSorter<InventoryItem>> sorters0) {
                this.sorters = sorters0;
                this.cntFields = sorters0.size();
            }

            @Override
            public final int compare(Map.Entry<InventoryItem, Integer> arg0, Map.Entry<InventoryItem, Integer> arg1) {
                ItemPoolSorter<InventoryItem> sorter;
                int lastCompare = 0;
                int iField = -1;
                while (++iField < this.cntFields && lastCompare == 0 && (sorter = this.sorters.get(iField)) != null) {
                    lastCompare = sorter.compare(arg0, arg1);
                }
                return lastCompare;
            }
        }
    }
}

