/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import forge.itemmanager.ColumnDef;
import forge.itemmanager.GroupDef;
import forge.itemmanager.ItemColumnConfig;
import forge.itemmanager.SColumnUtil;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public enum ItemManagerConfig {
    STRING_ONLY(SColumnUtil.getStringColumn(), false, false, true, null, null, 1, 0),
    CARD_CATALOG(SColumnUtil.getCatalogDefaultColumns(true), true, false, false, null, null, 4, 0),
    DECK_EDITOR(SColumnUtil.getDeckEditorDefaultColumns(), false, false, true, GroupDef.DEFAULT, ColumnDef.CMC, 4, 1),
    DRAFT_PACK(SColumnUtil.getDraftPackDefaultColumns(), false, false, true, null, null, 4, 1),
    DRAFT_POOL(SColumnUtil.getCatalogDefaultColumns(false), false, false, false, GroupDef.DEFAULT, ColumnDef.CMC, 4, 1),
    DRAFT_CONSPIRACY(SColumnUtil.getSpecialCardPoolDefaultColumns(), false, false, true, null, null, 4, 0),
    SEALED_POOL(SColumnUtil.getCatalogDefaultColumns(false), false, false, false, GroupDef.COLOR, ColumnDef.CMC, 4, 1),
    SPELL_SHOP(SColumnUtil.getSpellShopDefaultColumns(), false, false, false, null, null, 4, 0),
    QUEST_INVENTORY(SColumnUtil.getQuestInventoryDefaultColumns(), false, false, false, null, null, 4, 0),
    QUEST_EDITOR_POOL(SColumnUtil.getQuestEditorPoolDefaultColumns(), false, false, false, null, null, 4, 0),
    QUEST_DECK_EDITOR(SColumnUtil.getQuestDeckEditorDefaultColumns(), false, false, false, GroupDef.DEFAULT, ColumnDef.CMC, 4, 1),
    QUEST_DRAFT_DECK_VIEWER(SColumnUtil.getDeckViewerDefaultColumns(), false, false, true, GroupDef.DEFAULT, ColumnDef.CMC, 4, 1),
    CONQUEST_AETHER(SColumnUtil.getConquestAEtherDefaultColumns(), false, false, false, null, null, 4, 0),
    CONQUEST_COMMANDERS(SColumnUtil.getConquestCommandersDefaultColumns(), false, false, false, null, null, 3, 0),
    CONQUEST_COLLECTION(SColumnUtil.getConquestCollectionDefaultColumns(), false, false, false, null, null, 4, 0),
    CONQUEST_DECK_EDITOR(SColumnUtil.getConquestDeckEditorDefaultColumns(), false, false, false, GroupDef.DEFAULT, ColumnDef.CMC, 4, 1),
    AVATAR_POOL(SColumnUtil.getSpecialCardPoolDefaultColumns(), true, false, false, null, null, 4, 0),
    SCHEME_POOL(SColumnUtil.getSpecialCardPoolDefaultColumns(), true, false, true, null, null, 4, 0),
    CONSPIRACY_DECKS(SColumnUtil.getSpecialCardPoolDefaultColumns(), true, false, true, null, null, 4, 0),
    DUNGEON_DECKS(SColumnUtil.getSpecialCardPoolDefaultColumns(), false, false, true, null, null, 4, 0),
    SCHEME_DECK_EDITOR(SColumnUtil.getCatalogDefaultColumns(true), true, false, true, null, null, 4, 0),
    PLANAR_POOL(SColumnUtil.getSpecialCardPoolDefaultColumns(), true, false, true, null, null, 4, 0),
    PLANAR_DECK_EDITOR(SColumnUtil.getCatalogDefaultColumns(true), true, false, true, null, null, 4, 0),
    ATTRACTION_POOL(SColumnUtil.getAttractionPoolDefaultColumns(), false, false, true, null, null, 4, 0),
    ATTRACTION_DECK_EDITOR(SColumnUtil.getCatalogDefaultColumns(true), false, false, true, null, null, 4, 0),
    ATTRACTION_DECK_EDITOR_LIMITED(SColumnUtil.getCatalogDefaultColumns(false), false, false, true, null, null, 4, 0),
    COMMANDER_POOL(SColumnUtil.getCatalogDefaultColumns(true), true, false, false, null, null, 4, 0),
    COMMANDER_SECTION(SColumnUtil.getCatalogDefaultColumns(true), true, false, true, null, null, 1, 1),
    OATHBREAKER_SECTION(SColumnUtil.getCatalogDefaultColumns(true), true, false, true, null, null, 2, 1),
    WORKSHOP_CATALOG(SColumnUtil.getCatalogDefaultColumns(true), true, true, false, null, null, 4, 0),
    DECK_VIEWER(SColumnUtil.getDeckViewerDefaultColumns(), false, false, false, GroupDef.DEFAULT, ColumnDef.CMC, 4, 1),
    CONSTRUCTED_DECKS(SColumnUtil.getDecksDefaultColumns(true, true), false, false, false, null, null, 3, 0),
    COMMANDER_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    PLANAR_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    SCHEME_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    VANGUARDS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, true, null, null, 3, 0),
    DRAFT_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    SEALED_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    WINSTON_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    QUEST_DECKS(SColumnUtil.getDecksDefaultColumns(true, false), false, false, false, null, null, 3, 0),
    PRECON_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    QUEST_EVENT_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_STANDARD_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_PIONEER_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_MODERN_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_PAUPER_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_LEGACY_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_VINTAGE_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    NET_ARCHIVE_BLOCK_DECKS(SColumnUtil.getDecksDefaultColumns(false, false), false, false, false, null, null, 3, 0),
    SIDEBOARD(SColumnUtil.getDeckEditorDefaultColumns(), false, false, true, GroupDef.DEFAULT, ColumnDef.CMC, 3, 0);

    private Map<ColumnDef, ItemColumnConfig> cols;
    private boolean showUniqueCardsOption;
    private Prop<Boolean> uniqueCardsOnly;
    private Prop<Boolean> hideFilters;
    private Prop<Boolean> compactListView;
    private Prop<GroupDef> groupBy;
    private Prop<ColumnDef> pileBy;
    private Prop<Integer> imageColumnCount;
    private Prop<Integer> viewIndex;

    private ItemManagerConfig(Map<ColumnDef, ItemColumnConfig> cols0, boolean showUniqueCardsOption0, boolean uniqueCardsOnly0, boolean hideFilters0, GroupDef groupBy0, ColumnDef pileBy0, int imageColumnCount0, int viewIndex0) {
        this.cols = cols0;
        for (ItemColumnConfig colConfig : this.cols.values()) {
            colConfig.establishDefaults();
        }
        this.showUniqueCardsOption = showUniqueCardsOption0;
        this.uniqueCardsOnly = new Prop(uniqueCardsOnly0);
        this.hideFilters = new Prop(hideFilters0);
        this.compactListView = new Prop(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_LIST_ITEMS));
        this.groupBy = new Prop((Object)groupBy0);
        this.pileBy = new Prop((Object)pileBy0);
        this.imageColumnCount = new Prop(imageColumnCount0);
        this.viewIndex = new Prop(viewIndex0);
    }

    public Map<ColumnDef, ItemColumnConfig> getCols() {
        return this.cols;
    }

    public boolean getShowUniqueCardsOption() {
        return this.showUniqueCardsOption;
    }

    public boolean getUniqueCardsOnly() {
        return (Boolean)((Prop)this.uniqueCardsOnly).getValue();
    }

    public void setUniqueCardsOnly(boolean value0) {
        ((Prop)this.uniqueCardsOnly).setValue(value0);
    }

    public boolean getHideFilters() {
        return (Boolean)((Prop)this.hideFilters).getValue();
    }

    public void setHideFilters(boolean value0) {
        ((Prop)this.hideFilters).setValue(value0);
    }

    public boolean getCompactListView() {
        return (Boolean)((Prop)this.compactListView).getValue();
    }

    public void setCompactListView(boolean value0) {
        ((Prop)this.compactListView).setValue(value0);
    }

    public GroupDef getGroupBy() {
        return (GroupDef)((Object)((Prop)this.groupBy).getValue());
    }

    public void setGroupBy(GroupDef value0) {
        ((Prop)this.groupBy).setValue((Object)value0);
    }

    public ColumnDef getPileBy() {
        return (ColumnDef)((Object)((Prop)this.pileBy).getValue());
    }

    public void setPileBy(ColumnDef value0) {
        ((Prop)this.pileBy).setValue((Object)value0);
    }

    public int getImageColumnCount() {
        return (Integer)((Prop)this.imageColumnCount).getValue();
    }

    public void setImageColumnCount(int value0) {
        ((Prop)this.imageColumnCount).setValue(value0);
    }

    public int getViewIndex() {
        return (Integer)((Prop)this.viewIndex).getValue();
    }

    public void setViewIndex(int value0) {
        ((Prop)this.viewIndex).setValue(value0);
    }

    public static void load() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(ForgeConstants.ITEM_VIEW_PREFS_FILE));
            NodeList configs = document.getElementsByTagName("config");
            for (int i = 0; i < configs.getLength(); ++i) {
                try {
                    String value;
                    Element el = (Element)configs.item(i);
                    ItemManagerConfig config = Enum.valueOf(ItemManagerConfig.class, el.getAttribute("name"));
                    if (el.hasAttribute("uniqueCardsOnly")) {
                        ((Prop)config.uniqueCardsOnly).value = Boolean.parseBoolean(el.getAttribute("uniqueCardsOnly"));
                    }
                    if (el.hasAttribute("hideFilters")) {
                        ((Prop)config.hideFilters).value = Boolean.parseBoolean(el.getAttribute("hideFilters"));
                    }
                    if (el.hasAttribute("compactListView")) {
                        ((Prop)config.compactListView).value = Boolean.parseBoolean(el.getAttribute("compactListView"));
                    }
                    if (el.hasAttribute("groupBy")) {
                        value = el.getAttribute("groupBy");
                        if (value.isEmpty()) {
                            ((Prop)config.groupBy).value = null;
                        } else {
                            ((Prop)config.groupBy).value = (Object)Enum.valueOf(GroupDef.class, value);
                        }
                    }
                    if (el.hasAttribute("pileBy")) {
                        value = el.getAttribute("pileBy");
                        if (value.isEmpty()) {
                            ((Prop)config.pileBy).value = null;
                        } else {
                            ((Prop)config.pileBy).value = (Object)Enum.valueOf(ColumnDef.class, value);
                        }
                    }
                    if (el.hasAttribute("imageColumnCount")) {
                        ((Prop)config.imageColumnCount).value = Integer.parseInt(el.getAttribute("imageColumnCount"));
                    }
                    if (el.hasAttribute("viewIndex")) {
                        ((Prop)config.viewIndex).value = Integer.parseInt(el.getAttribute("viewIndex"));
                    }
                    NodeList cols = el.getElementsByTagName("col");
                    for (int j = 0; j < cols.getLength(); ++j) {
                        try {
                            Element colEl = (Element)cols.item(j);
                            ItemColumnConfig colConfig = config.cols.get((Object)Enum.valueOf(ColumnDef.class, colEl.getAttribute("name")));
                            if (colEl.hasAttribute("width")) {
                                colConfig.setPreferredWidth(Integer.parseInt(colEl.getAttribute("width")));
                            }
                            if (colEl.hasAttribute("sortPriority")) {
                                colConfig.setSortPriority(Integer.parseInt(colEl.getAttribute("sortPriority")));
                            }
                            if (colEl.hasAttribute("sortState")) {
                                colConfig.setSortState(Enum.valueOf(ItemColumnConfig.SortState.class, colEl.getAttribute("sortState")));
                            }
                            if (colEl.hasAttribute("index")) {
                                colConfig.setIndex(Integer.parseInt(colEl.getAttribute("index")));
                            }
                            if (!colEl.hasAttribute("visible")) continue;
                            colConfig.setVisible(Boolean.parseBoolean(colEl.getAttribute("visible")));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException builder) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("preferences");
            root.setAttribute("type", "item_view");
            document.appendChild(root);
            for (ItemManagerConfig config : ItemManagerConfig.values()) {
                Element el = document.createElement("config");
                el.setAttribute("name", config.name());
                ((Prop)config.uniqueCardsOnly).writeValue(el, "uniqueCardsOnly");
                ((Prop)config.hideFilters).writeValue(el, "hideFilters");
                ((Prop)config.compactListView).writeValue(el, "compactListView");
                ((Prop)config.groupBy).writeValue(el, "groupBy");
                ((Prop)config.pileBy).writeValue(el, "pileBy");
                ((Prop)config.imageColumnCount).writeValue(el, "imageColumnCount");
                ((Prop)config.viewIndex).writeValue(el, "viewIndex");
                for (ItemColumnConfig colConfig : config.cols.values()) {
                    Element colEl = document.createElement("col");
                    colEl.setAttribute("name", colConfig.getDef().name());
                    if (colConfig.getPreferredWidth() != colConfig.getDefaults().getPreferredWidth()) {
                        colEl.setAttribute("width", String.valueOf(colConfig.getPreferredWidth()));
                    }
                    if (colConfig.getSortPriority() != colConfig.getDefaults().getSortPriority()) {
                        colEl.setAttribute("sortPriority", String.valueOf(colConfig.getSortPriority()));
                    }
                    if (colConfig.getSortState() != colConfig.getDefaults().getSortState()) {
                        colEl.setAttribute("sortState", String.valueOf((Object)colConfig.getSortState()));
                    }
                    if (colConfig.getIndex() != colConfig.getDefaults().getIndex()) {
                        colEl.setAttribute("index", String.valueOf(colConfig.getIndex()));
                    }
                    if (colConfig.isVisible() != colConfig.getDefaults().isVisible()) {
                        colEl.setAttribute("visible", String.valueOf(colConfig.isVisible()));
                    }
                    el.appendChild(colEl);
                }
                root.appendChild(el);
            }
            XmlUtil.saveDocument(document, ForgeConstants.ITEM_VIEW_PREFS_FILE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Prop<T> {
        private T value;
        private T defaultValue;

        private Prop(T defaultValue0) {
            this.value = defaultValue0;
            this.defaultValue = defaultValue0;
        }

        private T getValue() {
            return this.value;
        }

        private void setValue(T value0) {
            if (this.value == value0) {
                return;
            }
            this.value = value0;
            ItemManagerConfig.save();
        }

        private void writeValue(Element el, String localName) {
            if (this.value == null) {
                if (this.defaultValue != null) {
                    el.setAttribute(localName, "");
                }
            } else if (!this.value.equals(this.defaultValue)) {
                if (this.value instanceof Enum) {
                    el.setAttribute(localName, ((Enum)this.value).name());
                } else {
                    el.setAttribute(localName, String.valueOf(this.value));
                }
            }
        }
    }
}

