/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardZoom;
import forge.gui.FThreads;
import forge.item.InventoryItem;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.IItemManager;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemColumnConfig;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.TextSearchFilter;
import forge.itemmanager.views.ImageView;
import forge.itemmanager.views.ItemListView;
import forge.itemmanager.views.ItemView;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.screens.FScreen;
import forge.toolbox.FComboBox;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.util.ItemPool;
import forge.util.LayoutHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ItemManager<T extends InventoryItem>
extends FContainer
implements IItemManager<T>,
CardZoom.ActivateHandler {
    private ItemPool<T> pool;
    protected final ItemManagerModel<T> model;
    private Predicate<? super T> filterPredicate = null;
    private AdvancedSearchFilter<? extends T> advancedSearchFilter;
    private final List<ItemFilter<? extends T>> filters = new ArrayList<ItemFilter<? extends T>>();
    private boolean hideFilters = false;
    private boolean wantUnique = false;
    private boolean showRanking = false;
    private boolean multiSelectMode = false;
    private FEvent.FEventHandler selectionChangedHandler;
    private FEvent.FEventHandler itemActivateHandler;
    private ContextMenuBuilder<T> contextMenuBuilder;
    private ContextMenu contextMenu;
    private final Class<T> genericType;
    private ItemManagerConfig config;
    private Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnNewGet;
    private boolean viewUpdating;
    private boolean needSecondUpdate;
    private List<ItemColumn> sortCols = new ArrayList<ItemColumn>();
    private final TextSearchFilter<? extends T> searchFilter;
    private final FLabel btnSearch = new FLabel.ButtonBuilder().icon(Forge.hdbuttons ? FSkinImage.HDSEARCH : FSkinImage.SEARCH).iconScaleFactor(0.9f).selectable().build();
    private final FLabel btnView = new FLabel.ButtonBuilder().iconScaleFactor(0.9f).selectable().build();
    private final FLabel btnAdvancedSearchOptions = new FLabel.Builder().selectable(true).align(1).icon(Forge.hdbuttons ? FSkinImage.HDPREFERENCE : FSkinImage.SETTINGS).iconScaleFactor(0.9f).build();
    private final FComboBox<ItemColumn> cbxSortOptions;
    private final List<ItemView<T>> views = new ArrayList<ItemView<T>>();
    private final ItemListView<T> listView;
    private final ImageView<T> imageView;
    private ItemView<T> currentView;
    private boolean initialized;
    protected boolean lockFiltering;

    protected ItemManager(Class<T> genericType0, boolean wantUnique0) {
        this.genericType = genericType0;
        this.wantUnique = wantUnique0;
        this.model = new ItemManagerModel<T>(genericType0);
        this.searchFilter = this.createSearchFilter();
        this.listView = new ItemListView<T>(this, this.model);
        this.imageView = this.createImageView(this.model);
        this.views.add(this.listView);
        this.views.add(this.imageView);
        this.currentView = this.listView;
        this.btnView.setIcon(this.currentView.getIcon());
        this.add(this.searchFilter.getWidget());
        this.add(this.btnSearch);
        this.btnSearch.setEnabled(!Forge.isMobileAdventureMode);
        this.add(this.btnView);
        this.add(this.btnAdvancedSearchOptions);
        this.btnAdvancedSearchOptions.setSelected(!this.hideFilters);
        if (this.allowSortChange()) {
            this.cbxSortOptions = this.add(new FComboBox(Forge.getLocalizer().getMessage("lblSort", new Object[0]) + ": "));
            this.cbxSortOptions.setFont(FSkinFont.get(12));
        } else {
            this.cbxSortOptions = null;
        }
        this.add(this.currentView.getPnlOptions());
        this.add(this.currentView.getScroller());
        this.btnSearch.setCommand(e -> {
            FPopupMenu menu = new FPopupMenu(){

                @Override
                protected void buildMenu() {
                    this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblAdvancedSearch", new Object[0]), Forge.hdbuttons ? FSkinImage.HDSEARCH : FSkinImage.SEARCH, e1 -> {
                        if (ItemManager.this.advancedSearchFilter == null) {
                            ItemManager.this.advancedSearchFilter = ItemManager.this.createAdvancedSearchFilter();
                            ItemManager.this.add(ItemManager.this.advancedSearchFilter.getWidget());
                        }
                        ItemManager.this.advancedSearchFilter.edit();
                    }));
                    this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblResetFilters", new Object[0]), Forge.hdbuttons ? FSkinImage.HDDELETE : FSkinImage.DELETE, e12 -> ItemManager.this.resetFilters()));
                }
            };
            menu.show(this.btnSearch, 0.0f, this.btnSearch.getHeight());
        });
        this.btnView.setCommand(e -> {
            FPopupMenu menu = new FPopupMenu(){

                @Override
                protected void buildMenu() {
                    for (int i = 0; i < ItemManager.this.views.size(); ++i) {
                        int index = i;
                        ItemView view = (ItemView)ItemManager.this.views.get(i);
                        FMenuItem item = new FMenuItem(view.getCaption(), view.getIcon(), e13 -> ItemManager.this.setViewIndex(index));
                        if (ItemManager.this.currentView == view) {
                            item.setSelected(true);
                        }
                        this.addItem(item);
                    }
                }
            };
            menu.show(this.btnView, 0.0f, this.btnView.getHeight());
        });
        this.btnAdvancedSearchOptions.setCommand(e -> this.setHideFilters(!this.hideFilters));
        this.addDefaultFilters();
        this.initialized = true;
        if (!this.applyFilters() && this.pool != null) {
            this.updateView(true, null);
        }
    }

    protected ImageView<T> createImageView(ItemManagerModel<T> model0) {
        return new ImageView<T>(this, model0);
    }

    @Override
    public ItemManagerConfig getConfig() {
        return this.config;
    }

    @Override
    public void setup(ItemManagerConfig config0) {
        this.setup(config0, null);
    }

    /*
     * WARNING - void declaration
     */
    public void setup(ItemManagerConfig config0, Map<ColumnDef, ItemColumn> colOverrides) {
        void var6_12;
        this.config = config0;
        this.setWantUnique(config0.getUniqueCardsOnly());
        LinkedList<ItemColumn> cols = new LinkedList<ItemColumn>();
        for (ItemColumnConfig itemColumnConfig : this.config.getCols().values()) {
            if (colOverrides == null || !colOverrides.containsKey((Object)itemColumnConfig.getDef())) {
                cols.add(new ItemColumn(itemColumnConfig));
                continue;
            }
            cols.add(colOverrides.get((Object)itemColumnConfig.getDef()));
        }
        cols.sort(Comparator.comparingInt(arg0 -> arg0.getConfig().getIndex()));
        this.sortCols.clear();
        if (this.cbxSortOptions != null) {
            this.cbxSortOptions.setDropDownItemTap(null);
            this.cbxSortOptions.removeAllItems();
        }
        int modelIndex = 0;
        for (ItemColumn itemColumn : cols) {
            itemColumn.setIndex(modelIndex++);
            if (!itemColumn.isVisible()) continue;
            this.sortCols.add(itemColumn);
        }
        ItemColumn[] itemColumnArray = new ItemColumn[this.sortCols.size()];
        for (ItemColumn col : this.sortCols) {
            if (this.cbxSortOptions != null) {
                this.cbxSortOptions.addItem(col);
            }
            if (col.getSortPriority() <= 0 || col.getSortPriority() > itemColumnArray.length) continue;
            itemColumnArray[col.getSortPriority() - 1] = col;
        }
        if (this.cbxSortOptions != null) {
            this.cbxSortOptions.setText("(" + Forge.getLocalizer().getMessage("lblNone", new Object[0]) + ")");
        }
        this.model.getCascadeManager().reset();
        int n = itemColumnArray.length - 1;
        while (var6_12 >= 0) {
            ItemColumn col;
            col = itemColumnArray[var6_12];
            if (col != null) {
                this.model.getCascadeManager().add(col, true);
                if (this.cbxSortOptions != null) {
                    this.cbxSortOptions.setSelectedItem(col);
                }
            }
            --var6_12;
        }
        if (this.cbxSortOptions != null) {
            this.cbxSortOptions.setDropDownItemTap(e -> {
                this.model.getCascadeManager().add((ItemColumn)e.getArgs(), false);
                this.model.refreshSort();
                ItemManagerConfig.save();
                this.updateView(true, null);
            });
        }
        for (ItemView<T> view : this.views) {
            view.setup(config0, colOverrides);
        }
        this.setViewIndex(config0.getViewIndex());
        this.setHideFilters(config0.getHideFilters());
        this.fnNewGet = colOverrides == null || !colOverrides.containsKey((Object)ColumnDef.NEW) ? null : colOverrides.get((Object)ColumnDef.NEW).getFnDisplay();
    }

    protected boolean allowSortChange() {
        return true;
    }

    protected String getItemSuffix(Map.Entry<T, Integer> item) {
        String suffix;
        if (this.fnNewGet != null && !(suffix = this.fnNewGet.apply(item).toString()).isEmpty()) {
            return " *" + suffix + "*";
        }
        return null;
    }

    public abstract ItemRenderer getListItemRenderer(FList.CompactModeHandler var1);

    public void setViewIndex(int viewIndex) {
        int backupIndexToSelect;
        if (viewIndex < 0 || viewIndex >= this.views.size()) {
            return;
        }
        ItemView<T> view = this.views.get(viewIndex);
        if (this.currentView == view) {
            return;
        }
        if (this.config != null) {
            this.config.setViewIndex(viewIndex);
        }
        Collection<Object> itemsToSelect = (backupIndexToSelect = this.currentView.getSelectedIndex()) > 0 || this.currentView.getSelectionCount() > 1 ? this.currentView.getSelectedItems() : null;
        this.remove(this.currentView.getPnlOptions());
        this.remove(this.currentView.getScroller());
        this.currentView = view;
        this.btnView.setIcon(view.getIcon());
        view.refresh(itemsToSelect, backupIndexToSelect, 0.0f);
        this.add(view.getPnlOptions());
        this.add(view.getScroller());
        this.revalidate();
    }

    @Override
    public void doLayout(float width, float height) {
        float fieldHeight;
        LayoutHelper helper = new LayoutHelper(this, ItemFilter.PADDING, ItemFilter.PADDING);
        float viewButtonWidth = fieldHeight = this.searchFilter.getMainComponent().getHeight();
        helper.offset(0.0f, ItemFilter.PADDING);
        helper.fillLine(this.searchFilter.getWidget(), fieldHeight, (viewButtonWidth + helper.getGapX()) * 3.0f);
        helper.include((FDisplayObject)this.btnSearch, viewButtonWidth, fieldHeight);
        helper.include((FDisplayObject)this.btnView, viewButtonWidth, fieldHeight);
        helper.include((FDisplayObject)this.btnAdvancedSearchOptions, viewButtonWidth, fieldHeight);
        helper.newLine();
        if (this.advancedSearchFilter != null && this.advancedSearchFilter.getWidget().isVisible()) {
            helper.fillLine(this.advancedSearchFilter.getWidget(), fieldHeight);
        }
        if (!this.hideFilters) {
            for (ItemFilter<T> filter : this.filters) {
                helper.include((FDisplayObject)filter.getWidget(), filter.getPreferredWidth(helper.getRemainingLineWidth(), fieldHeight), fieldHeight);
            }
            if (this.allowSortChange()) {
                helper.fillLine(this.cbxSortOptions, fieldHeight);
            }
            helper.newLine(-ItemFilter.PADDING);
            if (this.currentView.getPnlOptions().getChildCount() > 0) {
                helper.fillLine(this.currentView.getPnlOptions(), fieldHeight + ItemFilter.PADDING);
            } else {
                helper.offset(0.0f, -fieldHeight);
            }
        }
        helper.fill(this.currentView.getScroller());
    }

    @Override
    public Class<T> getGenericType() {
        return this.genericType;
    }

    @Override
    public String getCaption() {
        return this.searchFilter.getCaption();
    }

    @Override
    public void setCaption(String caption0) {
        this.searchFilter.setCaption(caption0);
    }

    @Override
    public ItemPool<T> getPool() {
        return this.pool;
    }

    @Override
    public void setPool(Iterable<T> items) {
        this.setPool(ItemPool.createFrom(items, this.genericType), false);
    }

    @Override
    public void setPool(ItemPool<T> pool0) {
        this.setPool(pool0, false);
    }

    @Override
    public void setPool(ItemPool<T> pool0, boolean infinite) {
        this.pool = pool0;
        this.model.clear();
        this.model.addItems(this.pool);
        this.model.setInfinite(infinite);
        this.updateView(true, null);
    }

    public ItemView<T> getCurrentView() {
        return this.currentView;
    }

    @Override
    public int getItemCount() {
        return this.currentView.getCount();
    }

    @Override
    public int getSelectionCount() {
        return this.currentView.getSelectionCount();
    }

    @Override
    public T getSelectedItem() {
        return this.currentView.getSelectedItem();
    }

    @Override
    public Collection<T> getSelectedItems() {
        return this.currentView.getSelectedItems();
    }

    @Override
    public ItemPool<T> getSelectedItemPool() {
        ItemPool<InventoryItem> selectedItemPool = new ItemPool<InventoryItem>(this.genericType);
        if (this.currentView == this.listView) {
            for (InventoryItem item : this.getSelectedItems()) {
                selectedItemPool.add(item, this.getItemCount(item));
            }
        } else {
            selectedItemPool.addAllFlat(this.getSelectedItems());
        }
        return selectedItemPool;
    }

    @Override
    public boolean setSelectedItem(T item) {
        return this.currentView.setSelectedItem(item);
    }

    @Override
    public boolean setSelectedItems(Iterable<T> items) {
        return this.currentView.setSelectedItems(items);
    }

    @Override
    public T stringToItem(String str) {
        for (Map.Entry<T, Integer> itemEntry : this.pool) {
            if (!((InventoryItem)itemEntry.getKey()).toString().equals(str)) continue;
            return (T)((InventoryItem)itemEntry.getKey());
        }
        return null;
    }

    @Override
    public boolean setSelectedString(String str) {
        T item = this.stringToItem(str);
        if (item != null) {
            return this.setSelectedItem(item);
        }
        return false;
    }

    @Override
    public boolean setSelectedStrings(Iterable<String> strings) {
        ArrayList<T> items = new ArrayList<T>();
        for (String str : strings) {
            T item = this.stringToItem(str);
            if (item == null) continue;
            items.add(item);
        }
        return this.setSelectedItems(items);
    }

    @Override
    public boolean selectItemEntrys(Iterable<Map.Entry<T, Integer>> itemEntrys) {
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        for (Map.Entry<T, Integer> itemEntry : itemEntrys) {
            items.add((InventoryItem)itemEntry.getKey());
        }
        return this.setSelectedItems(items);
    }

    @Override
    public void selectAll() {
        this.currentView.selectAll();
    }

    @Override
    public int getSelectedIndex() {
        return this.currentView.getSelectedIndex();
    }

    @Override
    public Iterable<Integer> getSelectedIndices() {
        return this.currentView.getSelectedIndices();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.currentView.setSelectedIndex(index);
    }

    @Override
    public void setSelectedIndices(Integer[] indices) {
        this.currentView.setSelectedIndices(Arrays.asList(indices));
    }

    @Override
    public void setSelectedIndices(Iterable<Integer> indices) {
        this.currentView.setSelectedIndices(indices);
    }

    @Override
    public void addItem(T item, int qty) {
        if (this.pool == null) {
            return;
        }
        try {
            this.pool.add(item, qty);
            if (this.isUnfiltered()) {
                this.model.addItem(item, qty);
            }
            ArrayList<T> items = new ArrayList<T>();
            items.add(item);
            this.updateView(false, items);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addItems(Iterable<Map.Entry<T, Integer>> itemsToAdd) {
        this.pool.addAll(itemsToAdd);
        if (this.isUnfiltered()) {
            this.model.addItems(itemsToAdd);
        }
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        for (Map.Entry<T, Integer> item : itemsToAdd) {
            items.add((InventoryItem)item.getKey());
        }
        this.updateView(false, items);
    }

    public void addItemsFlat(Iterable<T> itemsToAdd) {
        this.pool.addAllFlat(itemsToAdd);
        if (this.isUnfiltered()) {
            for (InventoryItem item : itemsToAdd) {
                this.model.addItem(item, 1);
            }
        }
        this.updateView(false, itemsToAdd);
    }

    public void setItems(Iterable<Map.Entry<T, Integer>> items) {
        this.pool.clear();
        this.model.clear();
        this.addItems(items);
    }

    @Override
    public void removeItem(T item, int qty) {
        Collection<T> itemsToSelect = this.currentView == this.listView ? this.getSelectedItems() : null;
        this.pool.remove(item, qty);
        if (this.isUnfiltered()) {
            this.model.removeItem(item, qty);
        }
        this.updateView(false, itemsToSelect);
    }

    @Override
    public void removeItems(Iterable<Map.Entry<T, Integer>> itemsToRemove) {
        Collection<T> itemsToSelect = this.currentView == this.listView ? this.getSelectedItems() : null;
        for (Map.Entry<T, Integer> item : itemsToRemove) {
            this.pool.remove((InventoryItem)item.getKey(), item.getValue());
            if (!this.isUnfiltered()) continue;
            this.model.removeItem((InventoryItem)item.getKey(), item.getValue());
        }
        this.updateView(false, itemsToSelect);
    }

    public void removeItemsFlat(Iterable<T> itemsToRemove) {
        Collection<T> itemsToSelect = this.currentView == this.listView ? this.getSelectedItems() : null;
        this.pool.removeAllFlat(itemsToRemove);
        if (this.isUnfiltered()) {
            for (InventoryItem item : itemsToRemove) {
                this.model.removeItem(item, 1);
            }
        }
        this.updateView(false, itemsToSelect);
    }

    @Override
    public void removeAllItems() {
        this.pool.clear();
        this.model.clear();
        this.updateView(false, null);
    }

    public void replaceAll(T item, T replacement) {
        int count = this.pool.count(item);
        if (count == 0) {
            return;
        }
        Collection<T> itemsToSelect = this.currentView == this.listView ? this.getSelectedItems() : null;
        this.pool.removeAll(item);
        this.pool.add(replacement, count);
        if (this.isUnfiltered()) {
            this.model.replaceAll(item, replacement);
        }
        this.updateView(false, itemsToSelect);
    }

    @Override
    public void scrollSelectionIntoView() {
        this.currentView.scrollSelectionIntoView();
    }

    @Override
    public int getItemCount(T item) {
        return this.model.isInfinite() ? Integer.MAX_VALUE : this.pool.count(item);
    }

    @Override
    public ItemPool<T> getFilteredItems() {
        return this.model.getItems();
    }

    protected abstract void addDefaultFilters();

    protected abstract TextSearchFilter<? extends T> createSearchFilter();

    protected abstract AdvancedSearchFilter<? extends T> createAdvancedSearchFilter();

    public void addFilter(ItemFilter<? extends T> filter) {
        this.filters.add(filter);
        this.add(filter.getWidget());
        boolean visible = !this.hideFilters;
        filter.getWidget().setVisible(visible);
        if (visible && this.initialized) {
            this.revalidate();
            this.applyNewOrModifiedFilter(filter);
        }
    }

    public void applyNewOrModifiedFilter(ItemFilter<? extends T> filter) {
        if (this.lockFiltering) {
            return;
        }
        if (filter == this.advancedSearchFilter) {
            boolean empty = filter.isEmpty();
            ItemFilter.Widget widget = filter.getWidget();
            if (widget.isVisible() == empty) {
                widget.setVisible(!empty);
                this.revalidate();
            }
        }
        this.applyFilters();
    }

    public void restoreDefaultFilters() {
        this.lockFiltering = true;
        for (ItemFilter<T> filter : this.filters) {
            this.remove(filter.getWidget());
        }
        this.filters.clear();
        this.addDefaultFilters();
        this.lockFiltering = false;
        this.revalidate();
        this.applyFilters();
    }

    public void resetFilters() {
        this.lockFiltering = true;
        for (ItemFilter<T> filter : this.filters) {
            filter.reset();
        }
        this.searchFilter.reset();
        if (this.advancedSearchFilter != null) {
            this.advancedSearchFilter.reset();
            ItemFilter.Widget widget = this.advancedSearchFilter.getWidget();
            if (widget.isVisible()) {
                widget.setVisible(false);
                this.revalidate();
            }
        }
        this.lockFiltering = false;
        this.applyFilters();
    }

    public void removeFilter(ItemFilter<? extends T> filter) {
        this.filters.remove(filter);
        this.remove(filter.getWidget());
        this.revalidate();
        this.applyFilters();
    }

    @Override
    public boolean applyFilters() {
        Predicate newFilterPredicate;
        if (this.lockFiltering || !this.initialized) {
            return false;
        }
        ArrayList<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
        for (ItemFilter<T> filter : this.filters) {
            if (filter.isEmpty()) continue;
            predicates.add(filter.buildPredicate(this.genericType));
        }
        if (!this.searchFilter.isEmpty()) {
            predicates.add(this.searchFilter.buildPredicate(this.genericType));
        }
        if (this.advancedSearchFilter != null && !this.advancedSearchFilter.isEmpty()) {
            predicates.add(this.advancedSearchFilter.buildPredicate(this.genericType));
        }
        Predicate predicate = newFilterPredicate = predicates.size() == 0 ? null : Predicates.and(predicates);
        if (this.filterPredicate == newFilterPredicate) {
            return false;
        }
        this.filterPredicate = newFilterPredicate;
        if (this.pool != null) {
            if (this.viewUpdating) {
                this.needSecondUpdate = true;
            } else {
                this.viewUpdating = true;
                FThreads.invokeInBackgroundThread(() -> {
                    do {
                        this.needSecondUpdate = false;
                        this.updateView(true, null);
                        Gdx.graphics.requestRendering();
                    } while (this.needSecondUpdate);
                    this.viewUpdating = false;
                });
            }
        }
        return true;
    }

    private boolean isUnfiltered() {
        return this.filterPredicate == null;
    }

    public boolean getHideFilters() {
        return this.hideFilters;
    }

    public void setHideFilters(boolean hideFilters0) {
        if (this.hideFilters == hideFilters0) {
            return;
        }
        this.hideFilters = hideFilters0;
        boolean visible = !hideFilters0;
        for (ItemFilter<T> itemFilter : this.filters) {
            itemFilter.getWidget().setVisible(visible);
        }
        if (this.allowSortChange()) {
            this.cbxSortOptions.setVisible(visible);
        }
        for (ItemView itemView : this.views) {
            itemView.getPnlOptions().setVisible(visible);
        }
        if (this.initialized) {
            this.btnAdvancedSearchOptions.setSelected(visible);
            this.revalidate();
            if (this.config != null) {
                this.config.setHideFilters(hideFilters0);
            }
        }
    }

    public void applyAdvancedSearchFilter(String filterString) {
        this.applyAdvancedSearchFilter(new String[]{filterString}, false);
    }

    public void applyAdvancedSearchFilter(String[] filterStrings, boolean joinAnd) {
        if (this.advancedSearchFilter == null) {
            this.advancedSearchFilter = this.createAdvancedSearchFilter();
            this.add(this.advancedSearchFilter.getWidget());
        }
        this.lockFiltering = true;
        for (ItemFilter<T> filter : this.filters) {
            filter.reset();
        }
        this.searchFilter.reset();
        this.advancedSearchFilter.reset();
        this.advancedSearchFilter.setFilterParts(filterStrings, joinAnd);
        this.lockFiltering = false;
        this.applyFilters();
        this.advancedSearchFilter.refreshWidget();
        this.revalidate();
    }

    public void refresh() {
        this.updateView(true, this.getSelectedItems());
    }

    public void updateView(boolean forceFilter, Iterable<T> itemsToSelect) {
        boolean useFilter;
        boolean bl = useFilter = forceFilter && this.filterPredicate != null || !this.isUnfiltered();
        if (useFilter || forceFilter) {
            this.model.clear();
            Iterable items = this.pool;
            if (useFilter) {
                Predicate pred = Predicates.compose(this.filterPredicate, Map.Entry::getKey);
                items = Iterables.filter(this.pool, pred);
            }
            this.model.addItems(items);
        }
        this.currentView.refresh(itemsToSelect, this.getSelectedIndex(), forceFilter ? 0.0f : this.currentView.getScrollValue());
        ItemPool<T> filteredItems = this.getFilteredItems();
        int filteredCount = filteredItems.countAll();
        int totalCount = useFilter ? this.pool.countAll() : filteredCount;
        this.searchFilter.setRatio("(" + filteredCount + " / " + totalCount + ")");
    }

    public boolean isIncrementalSearchActive() {
        return this.currentView.isIncrementalSearchActive();
    }

    public boolean getWantUnique() {
        return this.wantUnique;
    }

    public boolean getShowRanking() {
        return this.showRanking;
    }

    public void setWantUnique(boolean unique) {
        this.wantUnique = unique;
    }

    public void setShowRanking(boolean showRanking0) {
        this.showRanking = showRanking0;
    }

    public void setSelectionSupport(int minSelections0, int maxSelections0) {
        for (ItemView<T> view : this.views) {
            view.setSelectionSupport(minSelections0, maxSelections0);
        }
    }

    public boolean getMultiSelectMode() {
        return this.multiSelectMode;
    }

    public void toggleMultiSelectMode(int indexToSelect) {
        boolean bl = this.multiSelectMode = !this.multiSelectMode;
        if (this.multiSelectMode) {
            this.setSelectionSupport(0, Integer.MAX_VALUE);
        } else {
            this.setSelectionSupport(0, 1);
        }
        if (this.isContextMenuOpen()) {
            this.contextMenu.hide();
        }
        if (indexToSelect != -1) {
            this.setSelectedIndex(indexToSelect);
        }
    }

    public boolean isInfinite() {
        return this.model.isInfinite();
    }

    public void focusSearch() {
        this.setHideFilters(false);
    }

    public FEvent.FEventHandler getSelectionChangedHandler() {
        return this.selectionChangedHandler;
    }

    public void setSelectionChangedHandler(FEvent.FEventHandler selectionChangedHandler0) {
        this.selectionChangedHandler = selectionChangedHandler0;
    }

    public void setItemActivateHandler(FEvent.FEventHandler itemActivateHandler0) {
        this.itemActivateHandler = itemActivateHandler0;
    }

    public void activateSelectedItems() {
        if (this.itemActivateHandler != null) {
            this.itemActivateHandler.handleEvent(new FEvent(this, FEvent.FEventType.ACTIVATE));
        }
    }

    public void setContextMenuBuilder(ContextMenuBuilder<T> contextMenuBuilder0) {
        this.contextMenuBuilder = contextMenuBuilder0;
    }

    public void showMenu(boolean delay) {
        if (this.contextMenuBuilder != null && this.getSelectionCount() > 0) {
            if (this.contextMenu == null) {
                this.contextMenu = new ContextMenu();
            }
            if (delay) {
                FThreads.delayInEDT(50, () -> {
                    this.contextMenu.show();
                    Gdx.graphics.requestRendering();
                });
            } else {
                this.contextMenu.show();
            }
        }
    }

    public void closeMenu() {
        if (this.isContextMenuOpen()) {
            this.contextMenu.hide();
        }
    }

    public boolean isContextMenuOpen() {
        return this.contextMenu != null && this.contextMenu.isVisible();
    }

    public void selectNextContext() {
        if (this.contextMenu != null) {
            this.contextMenu.setNextSelected();
        }
    }

    public void selectPreviousContext() {
        if (this.contextMenu != null) {
            this.contextMenu.setPreviousSelected();
        }
    }

    public void activateSelectedContext() {
        if (this.contextMenu != null) {
            this.contextMenu.tapChild();
        }
    }

    @Override
    public String getActivateAction(int index) {
        if (this.contextMenuBuilder != null) {
            return Forge.getLocalizer().getMessage("lblSelectCard", new Object[0]);
        }
        return null;
    }

    @Override
    public void activate(int index) {
        this.setSelectedIndex(index);
        this.showMenu(true);
    }

    public float getPileByWidth() {
        if (this.cbxSortOptions != null) {
            return this.cbxSortOptions.getWidth();
        }
        if (this.filters.isEmpty()) {
            return 0.0f;
        }
        return this.filters.get(this.filters.size() - 1).getWidget().getWidth();
    }

    private class ContextMenu
    extends FDropDownMenu {
        private ContextMenu() {
        }

        @Override
        protected void buildMenu() {
            ItemManager.this.contextMenuBuilder.buildMenu(this, ItemManager.this.getSelectedItem());
        }

        @Override
        protected boolean hideBackdropOnPress(float x, float y) {
            Rectangle bounds = ItemManager.this.currentView.getSelectionBounds();
            return bounds != null && !bounds.contains(x, y);
        }

        @Override
        protected boolean preventOwnerHandlingBackupTap(float x, float y, int count) {
            return count == 1;
        }

        @Override
        protected void updateSizeAndPosition() {
            FScreen screen = Forge.getCurrentScreen();
            float screenWidth = screen.getWidth();
            float screenHeight = screen.getHeight();
            this.paneSize = this.updateAndGetPaneSize(screenWidth, screenHeight);
            float w = this.paneSize.getWidth();
            float h2 = this.paneSize.getHeight();
            Rectangle bounds = ItemManager.this.currentView.getSelectionBounds();
            float x = bounds.x + bounds.width;
            float y = bounds.y;
            if (x + w > screenWidth && (x = bounds.x - w) < 0.0f) {
                x = bounds.x;
                if (w < bounds.width) {
                    x += (bounds.width - w) / 2.0f;
                }
                if (x + w > screenWidth) {
                    x = screenWidth - w;
                }
                y += bounds.height;
            }
            if (y + h2 > screenHeight) {
                y = y == bounds.y ? screenHeight - h2 : (y -= bounds.height + h2);
                if (y < 0.0f) {
                    y = 0.0f;
                    if (h2 > bounds.y) {
                        h2 = bounds.y;
                    }
                }
            }
            this.setBounds(Math.round(x), Math.round(y), Math.round(w), Math.round(h2));
        }
    }

    public static abstract class ContextMenuBuilder<T> {
        public abstract void buildMenu(FDropDownMenu var1, T var2);
    }

    public abstract class ItemRenderer {
        public abstract float getItemHeight();

        public abstract boolean allowPressEffect(FList<Map.Entry<T, Integer>> var1, float var2, float var3);

        public abstract boolean tap(Integer var1, Map.Entry<T, Integer> var2, float var3, float var4, int var5);

        public abstract boolean longPress(Integer var1, Map.Entry<T, Integer> var2, float var3, float var4);

        public abstract void drawValue(Graphics var1, Map.Entry<T, Integer> var2, FSkinFont var3, FSkinColor var4, FSkinColor var5, boolean var6, float var7, float var8, float var9, float var10);
    }
}

