/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import forge.card.CardEdition;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.deck.DeckProxy;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.model.FModel;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum GroupDef {
    COLOR("lblColor", GroupDef.getColorGroups(), groupIndex -> null, item -> {
        if (item instanceof PaperCard) {
            return GroupDef.getColorGroup(((PaperCard)item).getRules().getColor());
        }
        if (item instanceof DeckProxy) {
            return GroupDef.getColorGroup(((DeckProxy)item).getColor());
        }
        return -1;
    }),
    COLOR_IDENTITY("lblColorIdentity", GroupDef.getColorGroups(), groupIndex -> null, item -> {
        if (item instanceof PaperCard) {
            return GroupDef.getColorGroup(((PaperCard)item).getRules().getColorIdentity());
        }
        if (item instanceof DeckProxy) {
            return GroupDef.getColorGroup(((DeckProxy)item).getColorIdentity());
        }
        return -1;
    }),
    SET("lblSet", GroupDef.getSetGroups(), groupIndex -> null, item -> {
        if (item instanceof PaperCard) {
            return GroupDef.getSetGroup(((PaperCard)item).getEdition());
        }
        if (item instanceof DeckProxy) {
            return GroupDef.getSetGroup(((DeckProxy)item).getEdition().getCode());
        }
        return -1;
    }),
    DEFAULT("lblDefault", new String[]{"Creatures", "Spells", "Lands"}, groupIndex -> {
        if (groupIndex == 2) {
            return ColumnDef.NAME;
        }
        return null;
    }, item -> {
        if (item instanceof PaperCard) {
            CardType type = ((PaperCard)item).getRules().getType();
            if (type.isCreature()) {
                return 0;
            }
            if (type.isLand()) {
                return 2;
            }
            if (type.isArtifact() || type.isEnchantment() || type.isPlaneswalker() || type.isInstant() || type.isSorcery() || type.isBattle()) {
                return 1;
            }
        }
        return -1;
    }),
    CARD_TYPE("lblType", new String[]{"Planeswalker", "Creature", "Sorcery", "Instant", "Artifact", "Enchantment", "Land", "Battle"}, groupIndex -> {
        if (groupIndex == 6) {
            return ColumnDef.NAME;
        }
        return null;
    }, item -> {
        if (item instanceof PaperCard) {
            CardType type = ((PaperCard)item).getRules().getType();
            if (type.isPlaneswalker()) {
                return 0;
            }
            if (type.isCreature()) {
                return 1;
            }
            if (type.isInstant()) {
                return 3;
            }
            if (type.isSorcery()) {
                return 2;
            }
            if (type.isArtifact()) {
                return 4;
            }
            if (type.isEnchantment()) {
                return 5;
            }
            if (type.isBattle()) {
                return 7;
            }
            if (type.isLand()) {
                return 6;
            }
        }
        return -1;
    }),
    PW_DECK_SORT("lblPlaneswalkerDeckSort", new String[]{"Planeswalker", "Rares", "Creature", "Land", "Other Spells"}, groupIndex -> null, item -> {
        if (item instanceof PaperCard) {
            CardType type = ((PaperCard)item).getRules().getType();
            if (type.isPlaneswalker()) {
                return 0;
            }
            if (((PaperCard)item).getRarity().toString() == "R") {
                return 1;
            }
            if (type.isCreature()) {
                return 2;
            }
            if (type.isLand()) {
                return 3;
            }
            return 4;
        }
        return -1;
    }),
    CARD_RARITY("lblRarity", new String[]{"Mythic Rares", "Rares", "Uncommons", "Commons", "Basic Lands"}, groupIndex -> null, item -> {
        if (item instanceof PaperCard) {
            switch (((PaperCard)item).getRarity()) {
                case MythicRare: {
                    return 0;
                }
                case Rare: {
                    return 1;
                }
                case Uncommon: {
                    return 2;
                }
                case Common: {
                    return 3;
                }
                case BasicLand: {
                    return 4;
                }
            }
            return -1;
        }
        return -1;
    });

    private final String name;
    private final String[] groups;
    private final Function<Integer, ColumnDef> fnGetPileByOverride;
    private final Function<InventoryItem, Integer> fnGroupItem;
    private static Map<String, Integer> setGroupMap;

    private GroupDef(String name0, String[] groups0, Function<Integer, ColumnDef> fnGetPileByOverride0, Function<InventoryItem, Integer> fnGroupItem0) {
        this.name = Localizer.getInstance().getMessage(name0, new Object[0]);
        this.groups = groups0;
        this.fnGetPileByOverride = fnGetPileByOverride0;
        this.fnGroupItem = fnGroupItem0;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public ColumnDef getGroupPileBy(int groupIndex, ColumnDef defaultPileBy) {
        ColumnDef pileBy = this.fnGetPileByOverride.apply(groupIndex);
        if (pileBy == null) {
            return defaultPileBy;
        }
        return pileBy;
    }

    public int getItemGroupIndex(InventoryItem item) {
        return this.fnGroupItem.apply(item);
    }

    private static String[] getColorGroups() {
        return new String[]{"White", "Blue", "Black", "Red", "Green", "Multicolor", "Colorless"};
    }

    private static Integer getColorGroup(ColorSet color) {
        if (color == null) {
            return -1;
        }
        if (color.isColorless()) {
            return 6;
        }
        if (color.isMulticolor()) {
            return 5;
        }
        if (color.hasWhite()) {
            return 0;
        }
        if (color.hasBlue()) {
            return 1;
        }
        if (color.hasBlack()) {
            return 2;
        }
        if (color.hasRed()) {
            return 3;
        }
        if (color.hasGreen()) {
            return 4;
        }
        return -1;
    }

    private static String[] getSetGroups() {
        setGroupMap = new HashMap<String, Integer>();
        ArrayList<CardEdition> sortedSets = Lists.newArrayList(FModel.getMagicDb().getEditions());
        Collections.sort(sortedSets);
        Collections.reverse(sortedSets);
        int groupNum = 0;
        String[] setGroups = new String[sortedSets.size()];
        for (CardEdition set : sortedSets) {
            setGroups[groupNum] = set.getName();
            setGroupMap.put(set.getCode(), groupNum);
            ++groupNum;
        }
        return setGroups;
    }

    private static Integer getSetGroup(String set) {
        Integer groupNum = setGroupMap.get(set);
        if (groupNum == null) {
            groupNum = -1;
        }
        return groupNum;
    }
}

