/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardFaceSymbols;
import forge.card.CardRenderer;
import forge.card.ColorSet;
import forge.deck.DeckProxy;
import forge.deck.FDeckViewer;
import forge.deck.io.DeckPreferences;
import forge.game.GameType;
import forge.game.IHasGameType;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.DeckColorFilter;
import forge.itemmanager.filters.DeckFormatFilter;
import forge.itemmanager.filters.TextSearchFilter;
import forge.toolbox.FList;
import forge.util.Utils;
import java.util.Map;

public final class DeckManager
extends ItemManager<DeckProxy>
implements IHasGameType {
    private final GameType gameType;
    private static final float IMAGE_SIZE = CardRenderer.MANA_SYMBOL_SIZE;

    public DeckManager(GameType gt) {
        super(DeckProxy.class, true);
        this.gameType = gt;
        this.setCaption(Forge.getLocalizer().getMessage("lblDecks", new Object[0]));
    }

    @Override
    public GameType getGameType() {
        return this.gameType;
    }

    @Override
    public void setup(ItemManagerConfig config0) {
        boolean wasStringOnly = this.getConfig() == ItemManagerConfig.STRING_ONLY;
        boolean isStringOnly = config0 == ItemManagerConfig.STRING_ONLY;
        super.setup(config0, null);
        if (isStringOnly != wasStringOnly) {
            this.restoreDefaultFilters();
        }
    }

    @Override
    protected void addDefaultFilters() {
        if (this.getConfig() == ItemManagerConfig.STRING_ONLY) {
            return;
        }
        this.addFilter(new DeckColorFilter(this));
        if (!Forge.isMobileAdventureMode) {
            this.addFilter(new DeckFormatFilter(this));
        }
    }

    @Override
    protected TextSearchFilter<DeckProxy> createSearchFilter() {
        return new TextSearchFilter<DeckProxy>(this);
    }

    @Override
    protected AdvancedSearchFilter<DeckProxy> createAdvancedSearchFilter() {
        return new AdvancedSearchFilter<DeckProxy>(this);
    }

    @Override
    protected boolean allowSortChange() {
        return false;
    }

    @Override
    public ItemManager.ItemRenderer getListItemRenderer(final FList.CompactModeHandler compactModeHandler) {
        return new ItemManager.ItemRenderer(){

            @Override
            public float getItemHeight() {
                if (DeckManager.this.getConfig().getCols().size() == 1) {
                    return Utils.AVG_FINGER_HEIGHT;
                }
                return CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode());
            }

            public boolean tap(Integer index, Map.Entry<DeckProxy, Integer> value, float x, float y, int count) {
                float bottomRight = IMAGE_SIZE + 2.0f * FList.PADDING;
                if (x <= bottomRight && y <= bottomRight) {
                    DeckPreferences prefs = DeckPreferences.getPrefs(value.getKey());
                    prefs.setStarCount((prefs.getStarCount() + 1) % 2);
                    return true;
                }
                return false;
            }

            public boolean longPress(Integer index, Map.Entry<DeckProxy, Integer> value, float x, float y) {
                FDeckViewer.show(value.getKey().getDeck());
                return true;
            }

            public void drawValue(Graphics g2, Map.Entry<DeckProxy, Integer> value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                int sideSize;
                DeckProxy deck = value.getKey();
                if (DeckManager.this.getConfig().getCols().size() == 1) {
                    g2.drawText(deck.toString(), font, foreColor, x, y, w, h2, false, 8, true);
                    return;
                }
                if (Forge.hdbuttons) {
                    g2.drawImage(DeckPreferences.getPrefs(deck).getStarCount() > 0 ? FSkinImage.HDSTAR_FILLED : FSkinImage.HDSTAR_OUTLINE, x, y, IMAGE_SIZE, IMAGE_SIZE);
                } else {
                    g2.drawImage(DeckPreferences.getPrefs(deck).getStarCount() > 0 ? FSkinImage.STAR_FILLED : FSkinImage.STAR_OUTLINE, x, y, IMAGE_SIZE, IMAGE_SIZE);
                }
                g2.drawImage(deck.getAI().inMainDeck == 0 ? FSkinImage.AI_ACTIVE : FSkinImage.AI_INACTIVE, x += IMAGE_SIZE + FList.PADDING, y, IMAGE_SIZE, IMAGE_SIZE);
                x += IMAGE_SIZE + FList.PADDING;
                ColorSet deckColor = deck.getColor();
                float availableNameWidth = w - CardFaceSymbols.getWidth(deckColor, IMAGE_SIZE) - IMAGE_SIZE - 2.0f * FList.PADDING;
                availableNameWidth -= IMAGE_SIZE + FList.PADDING;
                String name = deck.getName();
                if (!deck.getPath().isEmpty()) {
                    name = name + " (" + deck.getPath().substring(1) + ")";
                }
                g2.drawText(name, font, foreColor, x, y, availableNameWidth, IMAGE_SIZE, false, 8, true);
                CardFaceSymbols.drawColorSet(g2, deckColor, x += availableNameWidth + FList.PADDING, y, IMAGE_SIZE);
                if (compactModeHandler.isCompactMode()) {
                    return;
                }
                font = FSkinFont.get(12);
                float lineHeight = font.getLineHeight();
                x = FList.PADDING;
                y += IMAGE_SIZE + FList.PADDING + CardRenderer.SET_BOX_MARGIN;
                String set = "";
                if (deck != null & deck.getEdition() != null) {
                    set = deck.getEdition().getCode();
                }
                float setWidth = CardRenderer.getSetWidth(font, set);
                float availableFormatWidth = w - setWidth + CardRenderer.SET_BOX_MARGIN;
                int mainSize = deck.getMainSize();
                if (mainSize < 0) {
                    mainSize = 0;
                }
                if ((sideSize = deck.getSideSize()) < 0) {
                    sideSize = 0;
                }
                g2.drawText(deck.getFormatsString() + " (" + mainSize + " / " + sideSize + ")", font, foreColor, x, y, availableFormatWidth, lineHeight, false, 8, true);
                CardRenderer.drawSetLabel(g2, font, set, deck.getHighestRarity(), x += availableFormatWidth + CardRenderer.SET_BOX_MARGIN, y -= CardRenderer.SET_BOX_MARGIN, setWidth, lineHeight + 2.0f * CardRenderer.SET_BOX_MARGIN);
            }

            public boolean allowPressEffect(FList<Map.Entry<DeckProxy, Integer>> list, float x, float y) {
                return true;
            }
        };
    }
}

