/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.itemmanager.StringTokenizer;
import forge.util.PredicateString;
import java.util.ArrayList;
import java.util.Stack;

public class BooleanExpression {
    private Stack<Operator> operators = new Stack();
    private Stack<Predicate<CardRules>> operands = new Stack();
    private StringTokenizer expression;
    private boolean inName;
    private boolean inType;
    private boolean inText;
    private boolean inCost;

    public BooleanExpression(String expression, boolean inName, boolean inType, boolean inText, boolean inCost) {
        this.expression = new StringTokenizer(expression);
        this.inName = inName;
        this.inType = inType;
        this.inText = inText;
        this.inCost = inCost;
    }

    public Predicate<CardRules> evaluate() {
        StringBuilder currentValue = new StringBuilder();
        boolean escapeNext = false;
        while (this.expression.hasNext()) {
            String token = this.expression.next();
            Operator operator = null;
            if (token.equals(Operator.AND.token)) {
                operator = Operator.AND;
            } else if (token.equals(Operator.OR.token)) {
                operator = Operator.OR;
            } else if (token.equals(Operator.OPEN_PAREN.token)) {
                operator = Operator.OPEN_PAREN;
            } else if (token.equals(Operator.CLOSE_PAREN.token)) {
                operator = Operator.CLOSE_PAREN;
            } else if (token.equals(Operator.NOT.token) && currentValue.toString().trim().isEmpty()) {
                operator = Operator.NOT;
            } else if (token.equals(Operator.ESCAPE.token)) {
                escapeNext = true;
                continue;
            }
            if (operator == null) {
                currentValue.append(token);
                continue;
            }
            if (escapeNext) {
                escapeNext = false;
                currentValue.append(token);
                continue;
            }
            if (!currentValue.toString().trim().isEmpty()) {
                this.operands.push(this.valueOf(currentValue.toString().trim()));
            }
            currentValue = new StringBuilder();
            if (!this.operators.isEmpty() && operator.precedence < this.operators.peek().precedence) {
                this.resolve(true);
            } else if (!this.operators.isEmpty() && operator == Operator.CLOSE_PAREN) {
                while (!this.operators.isEmpty() && this.operators.peek() != Operator.OPEN_PAREN) {
                    this.resolve(true);
                }
            }
            this.operators.push(operator);
        }
        if (!currentValue.toString().trim().isEmpty()) {
            this.operands.push(this.valueOf(currentValue.toString().trim()));
        }
        while (!this.operators.isEmpty()) {
            this.resolve(true);
        }
        return (Predicate)this.operands.get(0);
    }

    private void resolve(boolean alwaysPopOperator) {
        switch (this.operators.peek()) {
            case AND: {
                this.operators.pop();
                Predicate<CardRules> right = this.operands.pop();
                Predicate<CardRules> left = this.operands.pop();
                this.operands.push(Predicates.and(left, right));
                break;
            }
            case OR: {
                this.operators.pop();
                Predicate<CardRules> right = this.operands.pop();
                Predicate<CardRules> left = this.operands.pop();
                this.operands.push(Predicates.or(left, right));
                break;
            }
            case NOT: {
                this.operators.pop();
                Predicate<CardRules> left = this.operands.pop();
                this.operands.push(Predicates.not(left));
                break;
            }
            default: {
                if (!alwaysPopOperator) break;
                this.operators.pop();
            }
        }
    }

    private Predicate<CardRules> valueOf(String value) {
        ArrayList<Predicate<CardRules>> predicates = new ArrayList<Predicate<CardRules>>();
        if (this.inName) {
            predicates.add(CardRulesPredicates.name(PredicateString.StringOp.CONTAINS_IC, value));
        }
        if (this.inType) {
            predicates.add(CardRulesPredicates.joinedType(PredicateString.StringOp.CONTAINS_IC, value));
        }
        if (this.inText) {
            predicates.add(CardRulesPredicates.rules(PredicateString.StringOp.CONTAINS_IC, value));
        }
        if (this.inCost) {
            predicates.add(CardRulesPredicates.cost(PredicateString.StringOp.CONTAINS_IC, value));
        }
        if (!predicates.isEmpty()) {
            return Predicates.or(predicates);
        }
        return Predicates.alwaysTrue();
    }

    public static boolean isExpression(String string) {
        return string.contains(Operator.AND.token) || string.contains(Operator.OR.token) || string.trim().startsWith(Operator.NOT.token);
    }

    public static enum Operator {
        AND("&", 0),
        OR("|", 0),
        NOT("!", 1),
        OPEN_PAREN("(", 2),
        CLOSE_PAREN(")", 2),
        ESCAPE("\\", -1);

        private final String token;
        private final int precedence;

        private Operator(String token, int precedence) {
            this.token = token;
            this.precedence = precedence;
        }

        public String toString() {
            return this.token;
        }
    }
}

