/*
 * Decompiled with CFR 0.152.
 */
package forge.itemmanager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.CardType;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckSection;
import forge.game.GameFormat;
import forge.game.keyword.Keyword;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestRegion;
import forge.gamemodes.quest.QuestSpellShop;
import forge.gamemodes.quest.QuestWorld;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.interfaces.IButton;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.item.SealedProduct;
import forge.model.FModel;
import forge.util.CardTranslation;
import forge.util.Localizer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AdvancedSearch {
    public static <T extends InventoryItem> Filter<T> getFilter(Class<? super T> type, Filter<T> editFilter, boolean reselectOption) {
        Filter filter;
        FilterOperator operator;
        FilterOption option;
        FilterOption defaultOption;
        FilterOption filterOption = defaultOption = editFilter == null ? null : ((Filter)editFilter).option;
        if (defaultOption == null || reselectOption) {
            ArrayList<FilterOption> options = new ArrayList<FilterOption>();
            if (editFilter != null) {
                options.add(FilterOption.NONE);
            }
            for (FilterOption opt : FilterOption.values()) {
                if (opt.type != type) continue;
                options.add(opt);
            }
            option = SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblSelectAFilterType", new Object[0]), options, defaultOption, null);
            if (option == null) {
                return editFilter;
            }
        } else {
            option = defaultOption;
        }
        if (option == FilterOption.NONE) {
            return null;
        }
        if (option.operatorOptions.length > 1) {
            FilterOperator defaultOperator = option == defaultOption ? ((Filter)editFilter).operator : null;
            operator = SGuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblSelectOperatorFor", option.name), option.operatorOptions, defaultOperator, null);
            if (operator == null) {
                return editFilter;
            }
        } else {
            operator = option.operatorOptions[0];
        }
        if ((filter = option.evaluator.createFilter(option, operator)) == null) {
            filter = editFilter;
        }
        return filter;
    }

    public static <T extends InventoryItem> Filter<T> getFilter(Class<? super T> type, String filterText) {
        FilterOperator operator;
        FilterOption option;
        String[] words = filterText.split(" ", 3);
        if (words.length < 2) {
            System.out.printf("Unable to generate filter from expression '%s'%n", filterText);
            return null;
        }
        String filterValue = words.length > 2 ? words[2] : "";
        try {
            option = FilterOption.valueOf(words[0]);
        }
        catch (IllegalArgumentException e) {
            System.out.printf("Unable to generate filter from FilterOption '%s'%n", words[0]);
            return null;
        }
        if (option.type != type) {
            System.out.printf("Unable to generate filter from FilterOption '%s' - filter type '%s' != option type '%s' %n", words[0], type, option.type);
            return null;
        }
        try {
            operator = FilterOperator.valueOf(words[1]);
        }
        catch (IllegalArgumentException e) {
            System.out.printf("Unable to generate filter from FilterOption '%s' - no matching operator '%s'%n", words[0], words[1]);
            return null;
        }
        return option.evaluator.createFilter(option, operator, filterValue);
    }

    public static class Model<T extends InventoryItem> {
        private static final String EMPTY_FILTER_TEXT = Localizer.getInstance().getMessage("lblSelectingFilter", new Object[0]);
        private final List<Object> expression = new ArrayList<Object>();
        private final List<IFilterControl<T>> controls = new ArrayList<IFilterControl<T>>();
        private IButton label;

        public Predicate<T> getPredicate() {
            if (this.isEmpty()) {
                return Predicates.alwaysTrue();
            }
            return this.getPredicatePiece(new ExpressionIterator());
        }

        /*
         * Unable to fully structure code
         */
        private Predicate<T> getPredicatePiece(ExpressionIterator iterator) {
            pred = null;
            predPiece = null;
            operator = null;
            applyNot = false;
            while (ExpressionIterator.access$1400(iterator)) {
                block14: {
                    piece = ExpressionIterator.access$1600(iterator);
                    if (!piece.equals((Object)Operator.OPEN_PAREN)) break block14;
                    predPiece = this.getPredicatePiece(ExpressionIterator.access$1500(iterator));
                    ** GOTO lbl23
                }
                if (piece.equals((Object)Operator.CLOSE_PAREN)) {
                    return pred;
                }
                if (piece.equals((Object)Operator.AND)) {
                    operator = Operator.AND;
                } else if (piece.equals((Object)Operator.OR)) {
                    operator = Operator.OR;
                } else if (piece.equals((Object)Operator.NOT)) {
                    applyNot = applyNot == false;
                } else {
                    predPiece = ((Filter)piece).getPredicate();
lbl23:
                    // 2 sources

                    if (applyNot) {
                        predPiece = Predicates.not(predPiece);
                        applyNot = false;
                    }
                    if (pred == null) {
                        pred = predPiece;
                    } else if (operator == Operator.AND) {
                        pred = Predicates.and(pred, predPiece);
                    } else if (operator == Operator.OR) {
                        pred = Predicates.or(pred, predPiece);
                    }
                    operator = null;
                }
                ExpressionIterator.access$1500(iterator);
            }
            return pred;
        }

        public boolean isEmpty() {
            return this.expression.isEmpty();
        }

        public void reset() {
            this.expression.clear();
            this.controls.clear();
            this.updateLabel();
        }

        public void addFilterControl(IFilterControl<T> control) {
            control.getBtnFilter().setText(EMPTY_FILTER_TEXT);
            control.getBtnFilter().setCommand(() -> this.editFilterControl(control, null));
            this.controls.add(control);
        }

        public void removeFilterControl(IFilterControl<T> control) {
            int index = this.controls.indexOf(control);
            if (index > 0) {
                IFilterControl<T> prevControl = this.controls.get(index - 1);
                prevControl.getBtnAnd().setSelected(control.getBtnAnd().isSelected());
                prevControl.getBtnOr().setSelected(control.getBtnOr().isSelected());
            }
            this.controls.remove(index);
        }

        public void editFilterControl(IFilterControl<T> control, Runnable onChange) {
            FThreads.invokeInBackgroundThread(() -> {
                Filter filter = AdvancedSearch.getFilter(control.getGenericType(), control.getFilter(), onChange == null);
                if (control.getFilter() != filter) {
                    FThreads.invokeInEdtLater(() -> {
                        control.setFilter(filter);
                        if (filter != null) {
                            Runnable preloadTask;
                            control.getBtnFilter().setText(GuiBase.getInterface().encodeSymbols(filter.toString(), false));
                            if (filter.getOption() == FilterOption.CARD_KEYWORDS && (preloadTask = Keyword.getPreloadTask()) != null) {
                                GuiBase.getInterface().runBackgroundTask(Localizer.getInstance().getMessage("lblLoadingKeywords", new Object[0]), preloadTask);
                            }
                        } else {
                            control.getBtnFilter().setText(EMPTY_FILTER_TEXT);
                        }
                        if (onChange != null) {
                            onChange.run();
                        }
                    });
                }
            });
        }

        public Iterable<IFilterControl<T>> getControls() {
            return this.controls;
        }

        public void setLabel(IButton label0) {
            this.label = label0;
            this.updateLabel();
        }

        public void updateLabel() {
            if (this.label == null) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Filter: ");
            if (this.expression.isEmpty()) {
                builder.append("(none)");
            } else {
                int prevFilterEndIdx = -1;
                Filter prevFilter = null;
                for (Object piece : this.expression) {
                    if (piece instanceof Filter) {
                        Filter filter = (Filter)piece;
                        if (filter.canMergeCaptionWith(prevFilter)) {
                            builder.replace(prevFilterEndIdx, builder.length(), builder.substring(prevFilterEndIdx).toLowerCase());
                            builder.append(filter.extractValuesFromCaption());
                        } else {
                            builder.append(filter);
                        }
                        prevFilter = filter;
                        prevFilterEndIdx = builder.length();
                        continue;
                    }
                    if (piece.equals((Object)Operator.OPEN_PAREN) || piece.equals((Object)Operator.CLOSE_PAREN)) {
                        prevFilter = null;
                    }
                    builder.append(piece);
                }
            }
            this.label.setText(GuiBase.getInterface().encodeSymbols(builder.toString(), false));
            this.label.setToolTipText(this.getTooltip());
        }

        public String getTooltip() {
            if (this.expression.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Filter:\n");
            StringBuilder indent = new StringBuilder();
            for (Object piece : this.expression) {
                if (piece.equals((Object)Operator.CLOSE_PAREN) && indent.length() > 0) {
                    indent = new StringBuilder(indent.substring(2));
                }
                builder.append("\n").append((CharSequence)indent).append(piece.toString().trim());
                if (!piece.equals((Object)Operator.OPEN_PAREN)) continue;
                indent.append("  ");
            }
            return GuiBase.getInterface().encodeSymbols(builder.toString(), false);
        }

        public void updateExpression() {
            this.expression.clear();
            for (IFilterControl<T> control : this.controls) {
                if (control.getFilter() == null) continue;
                if (control.getBtnNotBeforeParen().isSelected()) {
                    this.expression.add((Object)Operator.NOT);
                }
                if (control.getBtnOpenParen().isSelected()) {
                    this.expression.add((Object)Operator.OPEN_PAREN);
                }
                if (control.getBtnNotAfterParen().isSelected()) {
                    this.expression.add((Object)Operator.NOT);
                }
                this.expression.add(control.getFilter());
                if (control.getBtnCloseParen().isSelected()) {
                    this.expression.add((Object)Operator.CLOSE_PAREN);
                }
                if (control.getBtnAnd().isSelected()) {
                    this.expression.add((Object)Operator.AND);
                    continue;
                }
                if (!control.getBtnOr().isSelected()) continue;
                this.expression.add((Object)Operator.OR);
            }
            this.updateLabel();
        }

        private static enum Operator {
            AND(" AND "),
            OR(" OR "),
            NOT("NOT "),
            OPEN_PAREN("("),
            CLOSE_PAREN(")");

            private final String token;

            private Operator(String token0) {
                this.token = token0;
            }

            public String toString() {
                return this.token;
            }
        }

        private class ExpressionIterator {
            private int index;

            private ExpressionIterator() {
            }

            private boolean hasNext() {
                return this.index < Model.this.expression.size();
            }

            private ExpressionIterator next() {
                ++this.index;
                return this;
            }

            private Object get() {
                return Model.this.expression.get(this.index);
            }

            static /* synthetic */ boolean access$1400(ExpressionIterator x0) {
                return x0.hasNext();
            }

            static /* synthetic */ ExpressionIterator access$1500(ExpressionIterator x0) {
                return x0.next();
            }

            static /* synthetic */ Object access$1600(ExpressionIterator x0) {
                return x0.get();
            }
        }
    }

    public static interface IFilterControl<T extends InventoryItem> {
        public IButton getBtnNotBeforeParen();

        public IButton getBtnOpenParen();

        public IButton getBtnNotAfterParen();

        public IButton getBtnFilter();

        public IButton getBtnCloseParen();

        public IButton getBtnAnd();

        public IButton getBtnOr();

        public Filter<T> getFilter();

        public void setFilter(Filter<T> var1);

        public Class<? super T> getGenericType();
    }

    public static class Filter<T extends InventoryItem> {
        private final FilterOption option;
        private final FilterOperator operator;
        private final String caption;
        private final Predicate<T> predicate;

        private Filter(FilterOption option0, FilterOperator operator0, String caption0, Predicate<T> predicate0) {
            this.option = option0;
            this.operator = operator0;
            this.caption = caption0;
            this.predicate = predicate0;
        }

        public boolean canMergeCaptionWith(Filter<T> filter) {
            return filter != null && this.option == filter.option && this.operator == filter.operator;
        }

        public String extractValuesFromCaption() {
            String emptyCaption = this.operator.formatStr.replace("%1$s", this.option.name);
            emptyCaption = emptyCaption.replaceAll("'?%\\d\\$[sd]'?", "");
            return this.caption.substring(emptyCaption.length());
        }

        public FilterOption getOption() {
            return this.option;
        }

        public FilterOperator getOperator() {
            return this.operator;
        }

        public Predicate<T> getPredicate() {
            return this.predicate;
        }

        public String toString() {
            return this.caption;
        }
    }

    private static abstract class DeckContentEvaluator<T extends InventoryItem>
    extends FilterEvaluator<T, Map<String, Integer>> {
        @Override
        protected List<Map<String, Integer>> getValues(FilterOption option, FilterOperator operator) {
            String message = option.name + " " + operator.caption + " ?";
            PaperCard card = SGuiChoose.oneOrNone(message, FModel.getMagicDb().getCommonCards().getUniqueCards());
            if (card == null) {
                return null;
            }
            Integer amount = -1;
            if (operator == FilterOperator.CONTAINS_X_COPIES_OF_CARD && (amount = SGuiChoose.getInteger(Localizer.getInstance().getMessage("lblHowManyCopiesOfN", CardTranslation.getTranslatedName(card.getName())), 0, 4)) == null) {
                return null;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(card.getName(), amount);
            ArrayList<Map<String, Integer>> values = new ArrayList<Map<String, Integer>>();
            values.add(map);
            return values;
        }

        @Override
        protected List<Map<String, Integer>> getValuesFromString(String valueText, FilterOption option, FilterOperator operator) {
            String cardName;
            int amount = -1;
            if (operator == FilterOperator.CONTAINS_X_COPIES_OF_CARD) {
                String[] split = valueText.split(" ", 2);
                amount = Integer.parseInt(split[0]);
                cardName = split[1];
            } else {
                cardName = valueText;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(cardName, amount);
            ArrayList<Map<String, Integer>> values = new ArrayList<Map<String, Integer>>();
            values.add(map);
            return values;
        }

        @Override
        protected String getCaption(List<Map<String, Integer>> values, FilterOption option, FilterOperator operator) {
            Map.Entry<String, Integer> entry = values.get(0).entrySet().iterator().next();
            if (operator == FilterOperator.CONTAINS_X_COPIES_OF_CARD) {
                return String.format(operator.formatStr, option.name, entry.getKey(), entry.getValue());
            }
            return String.format(operator.formatStr, option.name, entry.getKey());
        }
    }

    private static abstract class ColorEvaluator<T extends InventoryItem>
    extends CustomListEvaluator<T, MagicColor.Color> {
        public ColorEvaluator() {
            super(Arrays.asList(MagicColor.Color.values()), MagicColor.Color::getSymbol);
        }

        @Override
        protected String getCaption(List<MagicColor.Color> values, FilterOption option, FilterOperator operator) {
            if (operator == FilterOperator.IS_EXACTLY) {
                return String.format(operator.formatStr, option.name, this.formatValues(values, "", ""));
            }
            return super.getCaption(values, option, operator);
        }
    }

    private static abstract class CustomListEvaluator<T extends InventoryItem, V>
    extends FilterEvaluator<T, V> {
        private final Collection<V> choices;
        private final Function<V, String> toShortString;
        private final Function<V, String> toLongString;

        public CustomListEvaluator(Collection<V> choices0) {
            this(choices0, null, null);
        }

        public CustomListEvaluator(Collection<V> choices0, Function<V, String> toShortString0) {
            this(choices0, toShortString0, null);
        }

        public CustomListEvaluator(Collection<V> choices0, Function<V, String> toShortString0, Function<V, String> toLongString0) {
            this.choices = choices0;
            this.toShortString = toShortString0;
            this.toLongString = toLongString0;
        }

        @Override
        protected List<V> getValues(FilterOption option, FilterOperator operator) {
            int max = this.choices.size();
            String message = option.name + " " + operator.caption + " ?";
            return SGuiChoose.getChoices(message, 0, max, this.choices, null, this.toLongString);
        }

        @Override
        protected List<V> getValuesFromString(String valueText, FilterOption option, FilterOperator operator) {
            String[] values = valueText.split(";");
            return this.choices.stream().filter(choice -> Arrays.stream(values).anyMatch(name -> this.eitherStringMatches((V)choice, (String)name))).collect(Collectors.toList());
        }

        private boolean eitherStringMatches(V choice, String name) {
            if (this.toLongString != null && name.equals(this.toLongString.apply(choice))) {
                return true;
            }
            if (this.toShortString != null) {
                return name.equals(this.toShortString.apply(choice));
            }
            return name.equals(choice.toString());
        }

        @Override
        protected String getCaption(List<V> values, FilterOption option, FilterOperator operator) {
            String valuesStr;
            switch (operator.valueCount) {
                case MANY: {
                    valuesStr = this.formatValues(values, " ", " ");
                    break;
                }
                case MANY_OR: {
                    valuesStr = this.formatValues(values, ", ", " or ");
                    break;
                }
                default: {
                    valuesStr = this.formatValues(values, ", ", " and ");
                }
            }
            return String.format(operator.formatStr, option.name, valuesStr);
        }

        protected String formatValues(List<V> values, String delim, String finalDelim) {
            int valueCount = values.size();
            switch (valueCount) {
                case 1: {
                    return this.formatValue(values.get(0));
                }
                case 2: {
                    return this.formatValue(values.get(0)) + finalDelim + this.formatValue(values.get(1));
                }
            }
            int lastValueIdx = valueCount - 1;
            StringBuilder result = new StringBuilder(this.formatValue(values.get(0)));
            for (int i = 1; i < lastValueIdx; ++i) {
                result.append(delim).append(this.formatValue(values.get(i)));
            }
            result.append(delim.trim()).append(finalDelim).append(this.formatValue(values.get(lastValueIdx)));
            return result.toString();
        }

        protected String formatValue(V value) {
            if (this.toShortString == null) {
                return value.toString();
            }
            return this.toShortString.apply(value);
        }
    }

    private static abstract class StringEvaluator<T extends InventoryItem>
    extends FilterEvaluator<T, String> {
        private String initialInput = "";

        @Override
        protected List<String> getValues(FilterOption option, FilterOperator operator) {
            String message = option.name + " " + operator.caption + " ?";
            String value = SOptionPane.showInputDialog("", message, null, this.initialInput);
            if (value == null) {
                return null;
            }
            this.initialInput = value;
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            return values;
        }

        @Override
        protected List<String> getValuesFromString(String valueText, FilterOption option, FilterOperator operator) {
            return Lists.newArrayList(valueText);
        }

        @Override
        protected String getCaption(List<String> values, FilterOption option, FilterOperator operator) {
            return String.format(operator.formatStr, option.name, values.get(0));
        }
    }

    private static abstract class NumericEvaluator<T extends InventoryItem>
    extends FilterEvaluator<T, Integer> {
        private final int min;
        private final int max;

        public NumericEvaluator(int min0, int max0) {
            this.min = min0;
            this.max = max0;
        }

        @Override
        protected List<Integer> getValues(FilterOption option, FilterOperator operator) {
            String message = operator.valueCount == FilterValueCount.ONE ? option.name + " " + operator.caption + " ?" : "? " + operator.caption.replace("|", " " + option.name + " ");
            Integer lowerBound = SGuiChoose.getInteger(message, this.min, this.max);
            if (lowerBound == null) {
                return null;
            }
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(lowerBound);
            if (operator.valueCount == FilterValueCount.TWO) {
                Integer upperBound;
                message = lowerBound + message.substring(1) + " ?";
                int upperBoundMin = lowerBound;
                if (operator == FilterOperator.BETWEEN_EXCLUSIVE) {
                    upperBoundMin += 2;
                }
                if ((upperBound = SGuiChoose.getInteger(message, upperBoundMin, this.max)) == null) {
                    return null;
                }
                values.add(upperBound);
            }
            return values;
        }

        @Override
        protected List<Integer> getValuesFromString(String valueText, FilterOption option, FilterOperator operator) {
            return Arrays.stream(valueText.split(";")).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
        }

        @Override
        protected String getCaption(List<Integer> values, FilterOption option, FilterOperator operator) {
            if (operator.valueCount == FilterValueCount.TWO) {
                return String.format(operator.formatStr, option.name, values.get(0), values.get(1));
            }
            return String.format(operator.formatStr, option.name, values.get(0));
        }
    }

    private static abstract class BooleanEvaluator<T extends InventoryItem>
    extends FilterEvaluator<T, Boolean> {
        @Override
        protected List<Boolean> getValues(FilterOption option, FilterOperator operator) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            values.add(operator == FilterOperator.IS_TRUE);
            return values;
        }

        @Override
        protected List<Boolean> getValuesFromString(String valueText, FilterOption option, FilterOperator operator) {
            return this.getValues(option, operator);
        }

        @Override
        protected String getCaption(List<Boolean> values, FilterOption option, FilterOperator operator) {
            return String.format(operator.formatStr, option.name);
        }
    }

    private static abstract class FilterEvaluator<T extends InventoryItem, V> {
        private FilterEvaluator() {
        }

        public final Filter<T> createFilter(FilterOption option, FilterOperator operator, List<V> values) {
            FilterOperator[][] manyValueOperators;
            if (values == null || values.isEmpty()) {
                return null;
            }
            String caption = this.getCaption(values, option, operator);
            OperatorEvaluator evaluator = operator.evaluator;
            Predicate predicate = input -> evaluator.apply(this.getItemValue(input), values);
            for (FilterOperator[] oper : manyValueOperators = new FilterOperator[][]{FilterOperator.MULTI_LIST_OPS, FilterOperator.COMBINATION_OPS, FilterOperator.COLLECTION_OPS, FilterOperator.STRINGS_OPS}) {
                if (option.operatorOptions != oper) continue;
                predicate = input -> evaluator.apply(this.getItemValues(input), values);
                break;
            }
            return new Filter(option, operator, caption, predicate);
        }

        public final Filter<T> createFilter(FilterOption option, FilterOperator operator) {
            List<V> values = this.getValues(option, operator);
            return this.createFilter(option, operator, values);
        }

        public final Filter<T> createFilter(FilterOption option, FilterOperator operator, String initialValueText) {
            List<V> values;
            try {
                values = this.getValuesFromString(initialValueText, option, operator);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            return this.createFilter(option, operator, values);
        }

        protected abstract List<V> getValues(FilterOption var1, FilterOperator var2);

        protected abstract List<V> getValuesFromString(String var1, FilterOption var2, FilterOperator var3);

        protected abstract String getCaption(List<V> var1, FilterOption var2, FilterOperator var3);

        protected abstract V getItemValue(T var1);

        protected Set<V> getItemValues(T input) {
            return null;
        }
    }

    private static abstract class OperatorEvaluator<V> {
        private OperatorEvaluator() {
        }

        protected abstract boolean apply(V var1, List<V> var2);

        protected boolean apply(Set<V> inputs, List<V> values) {
            return false;
        }
    }

    private static enum FilterValueCount {
        ZERO,
        ONE,
        TWO,
        MANY,
        MANY_OR,
        MANY_AND;

    }

    public static enum FilterOperator {
        IS_TRUE("lblIsTrue", "%1$s is true", FilterValueCount.ZERO, new OperatorEvaluator<Boolean>(){

            @Override
            public boolean apply(Boolean input, List<Boolean> values) {
                if (input != null) {
                    return input;
                }
                return false;
            }
        }),
        IS_FALSE("lblIsFalse", "%1$s is false", FilterValueCount.ZERO, new OperatorEvaluator<Boolean>(){

            @Override
            public boolean apply(Boolean input, List<Boolean> values) {
                if (input != null) {
                    return input == false;
                }
                return false;
            }
        }),
        EQUALS("lblEqual", "%1$s = %2$d", FilterValueCount.ONE, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return input.intValue() == values.get(0).intValue();
                }
                return false;
            }
        }),
        NOT_EQUALS("lblNotEqual", "%1$s <> %2$d", FilterValueCount.ONE, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return input.intValue() != values.get(0).intValue();
                }
                return true;
            }
        }),
        GREATER_THAN("lblGreaterThan", "%1$s > %2$d", FilterValueCount.ONE, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return input > values.get(0);
                }
                return false;
            }
        }),
        LESS_THAN("lblLessThan", "%1$s < %2$d", FilterValueCount.ONE, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return input < values.get(0);
                }
                return false;
            }
        }),
        GT_OR_EQUAL("lblGreaterThanOrEqual", "%1$s >= %2$d", FilterValueCount.ONE, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return input >= values.get(0);
                }
                return false;
            }
        }),
        LT_OR_EQUAL("lblLessThanOrEqual", "%1$s <= %2$d", FilterValueCount.ONE, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return input <= values.get(0);
                }
                return false;
            }
        }),
        BETWEEN_INCLUSIVE("lblBetweenInclusive", "%2$d <= %1$s <= %3$d", FilterValueCount.TWO, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return values.get(0) <= input && input <= values.get(1);
                }
                return false;
            }
        }),
        BETWEEN_EXCLUSIVE("lblBetweenExclusive", "%2$d < %1$s < %3$d", FilterValueCount.TWO, new OperatorEvaluator<Integer>(){

            @Override
            public boolean apply(Integer input, List<Integer> values) {
                if (input != null) {
                    return values.get(0) < input && input < values.get(1);
                }
                return false;
            }
        }),
        CONTAINS("lblContains", "%1$s contains '%2$s'", FilterValueCount.ONE, new OperatorEvaluator<String>(){

            @Override
            public boolean apply(String input, List<String> values) {
                if (input != null) {
                    return input.toLowerCase().contains(values.get(0).toLowerCase());
                }
                return false;
            }

            @Override
            public boolean apply(Set<String> inputs, List<String> values) {
                if (inputs != null && !inputs.isEmpty() && !values.isEmpty()) {
                    for (String input : inputs) {
                        if (!this.apply(input, values)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }),
        STARTS_WITH("lblStartsWith", "%1$s starts with '%2$s'", FilterValueCount.ONE, new OperatorEvaluator<String>(){

            @Override
            public boolean apply(String input, List<String> values) {
                if (input != null) {
                    return input.toLowerCase().startsWith(values.get(0).toLowerCase());
                }
                return false;
            }

            @Override
            public boolean apply(Set<String> inputs, List<String> values) {
                if (inputs != null && !inputs.isEmpty() && !values.isEmpty()) {
                    for (String input : inputs) {
                        if (!this.apply(input, values)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }),
        ENDS_WITH("lblEndsWith", "%1$s ends with '%2$s'", FilterValueCount.ONE, new OperatorEvaluator<String>(){

            @Override
            public boolean apply(String input, List<String> values) {
                if (input != null) {
                    return input.toLowerCase().endsWith(values.get(0).toLowerCase());
                }
                return false;
            }

            @Override
            public boolean apply(Set<String> inputs, List<String> values) {
                if (inputs != null && !inputs.isEmpty() && !values.isEmpty()) {
                    for (String input : inputs) {
                        if (!this.apply(input, values)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }),
        IS_EXACTLY("lblIsExactly", "%1$s is %2$s", FilterValueCount.MANY, new OperatorEvaluator<Object>(){

            @Override
            public boolean apply(Object input, List<Object> values) {
                if (input != null && values.size() == 1) {
                    return input.equals(values.get(0));
                }
                return false;
            }

            @Override
            public boolean apply(Set<Object> inputs, List<Object> values) {
                if (inputs != null && inputs.size() == values.size()) {
                    for (Object value : values) {
                        if (inputs.contains(value)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }),
        IS_ANY("lblIsAnyOf", "%1$s is %2$s", FilterValueCount.MANY_OR, new OperatorEvaluator<Object>(){

            @Override
            public boolean apply(Object input, List<Object> values) {
                if (input != null) {
                    for (Object value : values) {
                        if (!input.equals(value)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean apply(Set<Object> inputs, List<Object> values) {
                if (inputs != null) {
                    for (Object value : values) {
                        if (!inputs.contains(value)) continue;
                        return true;
                    }
                }
                return false;
            }
        }),
        CONTAINS_ANY("lblContainsAnyOf", "%1$s contains %2$s", FilterValueCount.MANY_OR, new OperatorEvaluator<Object>(){

            @Override
            public boolean apply(Object input, List<Object> values) {
                if (input != null) {
                    for (Object value : values) {
                        if (!input.equals(value)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean apply(Set<Object> inputs, List<Object> values) {
                if (inputs != null) {
                    for (Object value : values) {
                        if (!inputs.contains(value)) continue;
                        return true;
                    }
                }
                return false;
            }
        }),
        CONTAINS_ALL("lblContainsAllOf", "%1$s contains %2$s", FilterValueCount.MANY_AND, new OperatorEvaluator<Object>(){

            @Override
            public boolean apply(Object input, List<Object> values) {
                if (input != null && values.size() == 1) {
                    return input.equals(values.get(0));
                }
                return false;
            }

            @Override
            public boolean apply(Set<Object> inputs, List<Object> values) {
                if (inputs != null) {
                    for (Object value : values) {
                        if (inputs.contains(value)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }),
        CONTAIN_ANY("lblContainAnyOf", "%1$s contain %2$s", FilterValueCount.MANY_OR, new OperatorEvaluator<Object>(){

            @Override
            public boolean apply(Object input, List<Object> values) {
                throw new RuntimeException("shouldn't be called with a single input");
            }

            @Override
            public boolean apply(Set<Object> inputs, List<Object> values) {
                if (inputs != null) {
                    for (Object value : values) {
                        if (!inputs.contains(value)) continue;
                        return true;
                    }
                }
                return false;
            }
        }),
        CONTAIN_ALL("lblContainAllOf", "%1$s contain %2$s", FilterValueCount.MANY_AND, new OperatorEvaluator<Object>(){

            @Override
            public boolean apply(Object input, List<Object> values) {
                throw new RuntimeException("shouldn't be called with a single input");
            }

            @Override
            public boolean apply(Set<Object> inputs, List<Object> values) {
                if (inputs != null) {
                    for (Object value : values) {
                        if (inputs.contains(value)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }),
        CONTAINS_CARD("lblContainsCard", "%1$s contains %2$s", FilterValueCount.ONE, new OperatorEvaluator<Map<PaperCard, Integer>>(){

            @Override
            public boolean apply(Map<PaperCard, Integer> input, List<Map<PaperCard, Integer>> values) {
                if (input != null) {
                    Map.Entry<PaperCard, Integer> entry = values.get(0).entrySet().iterator().next();
                    return input.containsKey(entry.getKey());
                }
                return false;
            }
        }),
        CONTAINS_X_COPIES_OF_CARD("lblContainsXCopiesCard", "%1$s contains %3$d %2$s", FilterValueCount.TWO, new OperatorEvaluator<Map<PaperCard, Integer>>(){

            @Override
            public boolean apply(Map<PaperCard, Integer> input, List<Map<PaperCard, Integer>> values) {
                if (input != null) {
                    Map.Entry<PaperCard, Integer> entry = values.get(0).entrySet().iterator().next();
                    return input.get(entry.getKey()) == entry.getValue();
                }
                return false;
            }
        });

        public static final FilterOperator[] BOOLEAN_OPS;
        public static final FilterOperator[] NUMBER_OPS;
        public static final FilterOperator[] STRING_OPS;
        public static final FilterOperator[] STRINGS_OPS;
        public static final FilterOperator[] SINGLE_LIST_OPS;
        public static final FilterOperator[] MULTI_LIST_OPS;
        public static final FilterOperator[] COMBINATION_OPS;
        public static final FilterOperator[] COLLECTION_OPS;
        public static final FilterOperator[] DECK_CONTENT_OPS;
        private final String caption;
        private final String formatStr;
        private final FilterValueCount valueCount;
        private final OperatorEvaluator<?> evaluator;

        private FilterOperator(String caption0, String formatStr0, FilterValueCount valueCount0, OperatorEvaluator<?> evaluator0) {
            this.caption = Localizer.getInstance().getMessage(caption0, new Object[0]);
            this.formatStr = formatStr0;
            this.valueCount = valueCount0;
            this.evaluator = evaluator0;
        }

        public String toString() {
            return this.caption;
        }

        static {
            BOOLEAN_OPS = new FilterOperator[]{IS_TRUE, IS_FALSE};
            NUMBER_OPS = new FilterOperator[]{EQUALS, NOT_EQUALS, GREATER_THAN, LESS_THAN, GT_OR_EQUAL, LT_OR_EQUAL, BETWEEN_INCLUSIVE, BETWEEN_EXCLUSIVE};
            STRING_OPS = new FilterOperator[]{CONTAINS, STARTS_WITH, ENDS_WITH};
            STRINGS_OPS = new FilterOperator[]{CONTAINS, STARTS_WITH, ENDS_WITH};
            SINGLE_LIST_OPS = new FilterOperator[]{IS_ANY};
            MULTI_LIST_OPS = new FilterOperator[]{IS_ANY};
            COMBINATION_OPS = new FilterOperator[]{IS_EXACTLY, CONTAINS_ANY, CONTAINS_ALL};
            COLLECTION_OPS = new FilterOperator[]{CONTAIN_ANY, CONTAIN_ALL};
            DECK_CONTENT_OPS = new FilterOperator[]{CONTAINS_CARD, CONTAINS_X_COPIES_OF_CARD};
        }
    }

    public static enum FilterOption {
        NONE("lblNone", null, null, null),
        CARD_NAME("lblName", PaperCard.class, FilterOperator.STRINGS_OPS, new StringEvaluator<PaperCard>(){

            @Override
            protected String getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<String> getItemValues(PaperCard input) {
                HashSet<String> names = new HashSet<String>();
                names.add(input.getName());
                names.add(CardTranslation.getTranslatedName(input.getName()));
                CardSplitType cardSplitType = input.getRules().getSplitType();
                if (cardSplitType != CardSplitType.None && cardSplitType != CardSplitType.Split && input.getRules().getOtherPart() != null) {
                    names.add(input.getRules().getOtherPart().getName());
                    names.add(CardTranslation.getTranslatedName(input.getRules().getOtherPart().getName()));
                }
                return names;
            }
        }),
        CARD_RULES_TEXT("lblRulesText", PaperCard.class, FilterOperator.STRINGS_OPS, new StringEvaluator<PaperCard>(){

            @Override
            protected String getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<String> getItemValues(PaperCard input) {
                HashSet<String> names = new HashSet<String>();
                names.add(input.getRules().getOracleText());
                names.add(CardTranslation.getTranslatedOracle(input));
                CardSplitType cardSplitType = input.getRules().getSplitType();
                if (cardSplitType != CardSplitType.None && cardSplitType != CardSplitType.Split && input.getRules().getOtherPart() != null) {
                    names.add(input.getRules().getOtherPart().getOracleText());
                    names.add(CardTranslation.getTranslatedOracle(input.getRules().getOtherPart().getName()));
                }
                return names;
            }
        }),
        CARD_KEYWORDS("lblKeywords", PaperCard.class, FilterOperator.COLLECTION_OPS, new CustomListEvaluator<PaperCard, Keyword>(Keyword.getAllKeywords()){

            @Override
            protected Keyword getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<Keyword> getItemValues(PaperCard input) {
                CardSplitType cardSplitType = input.getRules().getSplitType();
                if (cardSplitType != CardSplitType.None && cardSplitType != CardSplitType.Split) {
                    PaperCard otherPart;
                    HashSet<Keyword> keywords = new HashSet<Keyword>();
                    if (input.getRules().getOtherPart() != null && (otherPart = FModel.getMagicDb().getCommonCards().getCard(input.getRules().getOtherPart().getName())) != null) {
                        keywords.addAll(Keyword.getKeywordSet(otherPart));
                        keywords.addAll(Keyword.getKeywordSet(input));
                    }
                    return keywords;
                }
                return Keyword.getKeywordSet(input);
            }
        }),
        CARD_SET("lblSet", PaperCard.class, FilterOperator.SINGLE_LIST_OPS, new CustomListEvaluator<PaperCard, CardEdition>(FModel.getMagicDb().getSortedEditions(), CardEdition::getCode){

            @Override
            protected CardEdition getItemValue(PaperCard input) {
                return FModel.getMagicDb().getCardEdition(input.getEdition());
            }
        }),
        CARD_FORMAT("lblFormat", PaperCard.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<PaperCard, GameFormat>((Collection)((List)FModel.getFormats().getFilterList())){

            @Override
            protected GameFormat getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<GameFormat> getItemValues(PaperCard input) {
                return FModel.getFormats().getAllFormatsOfCard(input);
            }
        }),
        CARD_PLANE("lblPlane", PaperCard.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<PaperCard, ConquestPlane>(ImmutableList.copyOf(FModel.getPlanes())){

            @Override
            protected ConquestPlane getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<ConquestPlane> getItemValues(PaperCard input) {
                return ConquestPlane.getAllPlanesOfCard(input);
            }
        }),
        CARD_REGION("lblRegion", PaperCard.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<PaperCard, ConquestRegion>(ConquestRegion.getAllRegions()){

            @Override
            protected ConquestRegion getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<ConquestRegion> getItemValues(PaperCard input) {
                return ConquestRegion.getAllRegionsOfCard(input);
            }
        }),
        CARD_QUEST_WORLD("lblQuestWorld", PaperCard.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<PaperCard, QuestWorld>(ImmutableList.copyOf(FModel.getWorlds())){

            @Override
            protected QuestWorld getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<QuestWorld> getItemValues(PaperCard input) {
                return QuestWorld.getAllQuestWorldsOfCard(input);
            }
        }),
        CARD_COLOR("lblColor", PaperCard.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<PaperCard>(){

            @Override
            protected MagicColor.Color getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(PaperCard input) {
                return input.getRules().getColor().toEnumSet();
            }
        }),
        CARD_COLOR_IDENTITY("lblColorIdentity", PaperCard.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<PaperCard>(){

            @Override
            protected MagicColor.Color getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(PaperCard input) {
                return input.getRules().getColorIdentity().toEnumSet();
            }
        }),
        CARD_COLOR_COUNT("lblColorCount", PaperCard.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<PaperCard>(0, 5){

            @Override
            protected Integer getItemValue(PaperCard input) {
                return input.getRules().getColor().countColors();
            }
        }),
        CARD_TYPE("lblType", PaperCard.class, FilterOperator.COMBINATION_OPS, new CustomListEvaluator<PaperCard, String>(CardType.getCombinedSuperAndCoreTypes()){

            @Override
            protected String getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<String> getItemValues(PaperCard input) {
                CardType type = input.getRules().getType();
                HashSet<String> types = new HashSet<String>();
                CardSplitType cardSplitType = input.getRules().getSplitType();
                if (cardSplitType != CardSplitType.None && cardSplitType != CardSplitType.Split && input.getRules().getOtherPart() != null) {
                    for (CardType.Supertype supertype : input.getRules().getOtherPart().getType().getSupertypes()) {
                        types.add(supertype.name());
                    }
                    for (CardType.CoreType coreType : input.getRules().getOtherPart().getType().getCoreTypes()) {
                        types.add(coreType.name());
                    }
                    for (CardType.Supertype supertype : input.getRules().getMainPart().getType().getSupertypes()) {
                        types.add(supertype.name());
                    }
                    for (CardType.CoreType coreType : input.getRules().getMainPart().getType().getCoreTypes()) {
                        types.add(coreType.name());
                    }
                    return types;
                }
                for (CardType.Supertype supertype : type.getSupertypes()) {
                    types.add(supertype.name());
                }
                for (CardType.CoreType coreType : type.getCoreTypes()) {
                    types.add(coreType.name());
                }
                return types;
            }
        }),
        CARD_SUB_TYPE("lblSubtype", PaperCard.class, FilterOperator.COMBINATION_OPS, new CustomListEvaluator<PaperCard, String>(CardType.getSortedSubTypes()){

            @Override
            protected String getItemValue(PaperCard input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<String> getItemValues(PaperCard input) {
                CardSplitType cardSplitType = input.getRules().getSplitType();
                if (cardSplitType != CardSplitType.None && cardSplitType != CardSplitType.Split && input.getRules().getOtherPart() != null) {
                    HashSet<String> subtypes = new HashSet<String>();
                    for (String subs : input.getRules().getOtherPart().getType().getSubtypes()) {
                        subtypes.add(subs);
                    }
                    for (String subs : input.getRules().getMainPart().getType().getSubtypes()) {
                        subtypes.add(subs);
                    }
                    return subtypes;
                }
                return (Set)input.getRules().getType().getSubtypes();
            }
        }),
        CARD_CMC("lblCMC", PaperCard.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<PaperCard>(0, 20){

            @Override
            protected Integer getItemValue(PaperCard input) {
                return input.getRules().getManaCost().getCMC();
            }
        }),
        CARD_GENERIC_COST("lblGenericCost", PaperCard.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<PaperCard>(0, 20){

            @Override
            protected Integer getItemValue(PaperCard input) {
                return input.getRules().getManaCost().getGenericCost();
            }
        }),
        CARD_POWER("lblPower", PaperCard.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<PaperCard>(0, 20){

            @Override
            protected Integer getItemValue(PaperCard input) {
                CardRules rules = input.getRules();
                if (rules.getType().isCreature()) {
                    return rules.getIntPower();
                }
                return null;
            }
        }),
        CARD_TOUGHNESS("lblToughness", PaperCard.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<PaperCard>(0, 20){

            @Override
            protected Integer getItemValue(PaperCard input) {
                CardRules rules = input.getRules();
                if (rules.getType().isCreature()) {
                    return rules.getIntToughness();
                }
                return null;
            }
        }),
        CARD_MANA_COST("lblManaCost", PaperCard.class, FilterOperator.STRING_OPS, new StringEvaluator<PaperCard>(){

            @Override
            protected String getItemValue(PaperCard input) {
                return input.getRules().getManaCost().toString();
            }
        }),
        CARD_RARITY("lblRarity", PaperCard.class, FilterOperator.SINGLE_LIST_OPS, new CustomListEvaluator<PaperCard, CardRarity>(Arrays.asList(CardRarity.FILTER_OPTIONS), CardRarity::getLongName, CardRarity::getLongName){

            @Override
            protected CardRarity getItemValue(PaperCard input) {
                return input.getRarity();
            }
        }),
        CARD_FIRST_PRINTING("lblFirstPrinting", PaperCard.class, FilterOperator.BOOLEAN_OPS, new BooleanEvaluator<PaperCard>(){

            @Override
            protected Boolean getItemValue(PaperCard input) {
                Collection cards = FModel.getMagicDb().getCommonCards().getAllCards(input.getName());
                if (cards.size() <= 1) {
                    return true;
                }
                cards.sort(FModel.getMagicDb().getEditions().CARD_EDITION_COMPARATOR);
                return cards.get(0) == input;
            }
        }),
        CARD_ARTIST("lblArtist", PaperCard.class, FilterOperator.STRING_OPS, new StringEvaluator<PaperCard>(){

            @Override
            protected String getItemValue(PaperCard input) {
                return input.getArtist();
            }
        }),
        INVITEM_NAME("lblName", InventoryItem.class, FilterOperator.STRING_OPS, new StringEvaluator<InventoryItem>(){

            @Override
            protected String getItemValue(InventoryItem input) {
                return input.getName();
            }
        }),
        INVITEM_RULES_TEXT("lblRulesText", InventoryItem.class, FilterOperator.STRING_OPS, new StringEvaluator<InventoryItem>(){

            @Override
            protected String getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return "";
                }
                return ((PaperCard)input).getRules().getOracleText();
            }
        }),
        INVITEM_KEYWORDS("lblKeywords", InventoryItem.class, FilterOperator.COLLECTION_OPS, new CustomListEvaluator<InventoryItem, Keyword>(Keyword.getAllKeywords()){

            @Override
            protected Keyword getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<Keyword> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<Keyword>();
                }
                return Keyword.getKeywordSet((PaperCard)input);
            }
        }),
        INVITEM_SET("lblSet", InventoryItem.class, FilterOperator.SINGLE_LIST_OPS, new CustomListEvaluator<InventoryItem, CardEdition>(FModel.getMagicDb().getSortedEditions(), CardEdition::getCode){

            @Override
            protected CardEdition getItemValue(InventoryItem input) {
                if (input instanceof PaperCard) {
                    CardEdition set = FModel.getMagicDb().getEditions().get(((PaperCard)input).getEdition());
                    return set;
                }
                if (input instanceof SealedProduct) {
                    return FModel.getMagicDb().getEditions().get(((SealedProduct)input).getEdition());
                }
                return CardEdition.UNKNOWN;
            }
        }),
        INVITEM_FORMAT("lblFormat", InventoryItem.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<InventoryItem, GameFormat>((Collection)((List)FModel.getFormats().getFilterList())){

            @Override
            protected GameFormat getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<GameFormat> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<GameFormat>();
                }
                return FModel.getFormats().getAllFormatsOfCard((PaperCard)input);
            }
        }),
        INVITEM_PLANE("lblPlane", InventoryItem.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<InventoryItem, ConquestPlane>(ImmutableList.copyOf(FModel.getPlanes())){

            @Override
            protected ConquestPlane getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<ConquestPlane> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<ConquestPlane>();
                }
                return ConquestPlane.getAllPlanesOfCard((PaperCard)input);
            }
        }),
        INVITEM_REGION("lblRegion", InventoryItem.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<InventoryItem, ConquestRegion>(ConquestRegion.getAllRegions()){

            @Override
            protected ConquestRegion getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<ConquestRegion> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<ConquestRegion>();
                }
                return ConquestRegion.getAllRegionsOfCard((PaperCard)input);
            }
        }),
        INVITEM_QUEST_WORLD("lblQuestWorld", InventoryItem.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<InventoryItem, QuestWorld>(ImmutableList.copyOf(FModel.getWorlds())){

            @Override
            protected QuestWorld getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<QuestWorld> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<QuestWorld>();
                }
                return QuestWorld.getAllQuestWorldsOfCard((PaperCard)input);
            }
        }),
        INVITEM_COLOR("lblColor", InventoryItem.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<InventoryItem>(){

            @Override
            protected MagicColor.Color getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<MagicColor.Color>();
                }
                return ((PaperCard)input).getRules().getColor().toEnumSet();
            }
        }),
        INVITEM_COLOR_IDENTITY("lblColorIdentity", InventoryItem.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<InventoryItem>(){

            @Override
            protected MagicColor.Color getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<MagicColor.Color>();
                }
                return ((PaperCard)input).getRules().getColorIdentity().toEnumSet();
            }
        }),
        INVITEM_COLOR_COUNT("lblColorCount", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 5){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return 0;
                }
                return ((PaperCard)input).getRules().getColor().countColors();
            }
        }),
        INVITEM_TYPE("lblType", InventoryItem.class, FilterOperator.COMBINATION_OPS, new CustomListEvaluator<InventoryItem, String>(CardType.getCombinedSuperAndCoreTypes()){

            @Override
            protected String getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<String> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<String>();
                }
                CardType type = ((PaperCard)input).getRules().getType();
                HashSet<String> types = new HashSet<String>();
                for (CardType.Supertype supertype : type.getSupertypes()) {
                    types.add(supertype.name());
                }
                for (CardType.CoreType coreType : type.getCoreTypes()) {
                    types.add(coreType.name());
                }
                return types;
            }
        }),
        INVITEM_SUB_TYPE("lblSubtype", InventoryItem.class, FilterOperator.COMBINATION_OPS, new CustomListEvaluator<InventoryItem, String>(CardType.getSortedSubTypes()){

            @Override
            protected String getItemValue(InventoryItem input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<String> getItemValues(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return new HashSet<String>();
                }
                return (Set)((PaperCard)input).getRules().getType().getSubtypes();
            }
        }),
        INVITEM_CMC("lblCMC", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 20){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return 0;
                }
                return ((PaperCard)input).getRules().getManaCost().getCMC();
            }
        }),
        INVITEM_GENERIC_COST("lblGenericCost", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 20){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return 0;
                }
                return ((PaperCard)input).getRules().getManaCost().getGenericCost();
            }
        }),
        INVITEM_POWER("lblPower", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 20){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return null;
                }
                CardRules rules = ((PaperCard)input).getRules();
                if (rules.getType().isCreature()) {
                    return rules.getIntPower();
                }
                return null;
            }
        }),
        INVITEM_TOUGHNESS("lblToughness", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 20){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return null;
                }
                CardRules rules = ((PaperCard)input).getRules();
                if (rules.getType().isCreature()) {
                    return rules.getIntToughness();
                }
                return null;
            }
        }),
        INVITEM_MANA_COST("lblManaCost", InventoryItem.class, FilterOperator.STRING_OPS, new StringEvaluator<InventoryItem>(){

            @Override
            protected String getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return "";
                }
                return ((PaperCard)input).getRules().getManaCost().toString();
            }
        }),
        INVITEM_FIRST_PRINTING("lblFirstPrinting", InventoryItem.class, FilterOperator.BOOLEAN_OPS, new BooleanEvaluator<InventoryItem>(){

            @Override
            protected Boolean getItemValue(InventoryItem input) {
                Collection cards = FModel.getMagicDb().getCommonCards().getAllCards(input.getName());
                if (cards.size() <= 1) {
                    return true;
                }
                cards.sort(FModel.getMagicDb().getEditions().CARD_EDITION_COMPARATOR);
                return cards.get(0) == input;
            }
        }),
        INVITEM_RARITY("lblRarity", InventoryItem.class, FilterOperator.SINGLE_LIST_OPS, new CustomListEvaluator<InventoryItem, CardRarity>(Arrays.asList(CardRarity.FILTER_OPTIONS), CardRarity::getLongName, CardRarity::getLongName){

            @Override
            protected CardRarity getItemValue(InventoryItem input) {
                if (!(input instanceof PaperCard)) {
                    return CardRarity.Special;
                }
                return ((PaperCard)input).getRarity();
            }
        }),
        INVITEM_BUY_PRICE("lblBuyPrice", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 10000000){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                return (Integer)QuestSpellShop.fnPriceGet.apply(new AbstractMap.SimpleEntry<InventoryItem, Integer>(input, 1));
            }
        }),
        INVITEM_SELL_PRICE("lblSellPrice", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 10000000){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                return (Integer)QuestSpellShop.fnPriceSellGet.apply(new AbstractMap.SimpleEntry<InventoryItem, Integer>(input, 1));
            }
        }),
        INVITEM_USED_IN_QUEST_DECKS("lblUsedInQuestDecks", InventoryItem.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<InventoryItem>(0, 100){

            @Override
            protected Integer getItemValue(InventoryItem input) {
                return Integer.parseInt((String)QuestSpellShop.fnDeckGet.apply(new AbstractMap.SimpleEntry<InventoryItem, Integer>(input, 1)));
            }
        }),
        DECK_NAME("lblName", DeckProxy.class, FilterOperator.STRING_OPS, new StringEvaluator<DeckProxy>(){

            @Override
            protected String getItemValue(DeckProxy input) {
                return input.getName();
            }
        }),
        DECK_FOLDER("lblFolder", DeckProxy.class, FilterOperator.STRING_OPS, new StringEvaluator<DeckProxy>(){

            @Override
            protected String getItemValue(DeckProxy input) {
                return input.getPath();
            }
        }),
        DECK_FAVORITE("ttFavorite", DeckProxy.class, FilterOperator.BOOLEAN_OPS, new BooleanEvaluator<DeckProxy>(){

            @Override
            protected Boolean getItemValue(DeckProxy input) {
                return input.isFavoriteDeck();
            }
        }),
        DECK_FORMAT("lblFormat", DeckProxy.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<DeckProxy, GameFormat>((Collection)((List)FModel.getFormats().getFilterList())){

            @Override
            protected GameFormat getItemValue(DeckProxy input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<GameFormat> getItemValues(DeckProxy input) {
                return input.getExhaustiveFormats();
            }
        }),
        DECK_QUEST_WORLD("lblQuestWorld", DeckProxy.class, FilterOperator.MULTI_LIST_OPS, new CustomListEvaluator<DeckProxy, QuestWorld>(ImmutableList.copyOf(FModel.getWorlds())){

            @Override
            protected QuestWorld getItemValue(DeckProxy input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<QuestWorld> getItemValues(DeckProxy input) {
                return QuestWorld.getAllQuestWorldsOfDeck(input.getDeck());
            }
        }),
        DECK_COLOR("lblColor", DeckProxy.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<DeckProxy>(){

            @Override
            protected MagicColor.Color getItemValue(DeckProxy input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(DeckProxy input) {
                return input.getColor().toEnumSet();
            }
        }),
        DECK_COLOR_IDENTITY("lblColorIdentity", DeckProxy.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<DeckProxy>(){

            @Override
            protected MagicColor.Color getItemValue(DeckProxy input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(DeckProxy input) {
                return input.getColorIdentity().toEnumSet();
            }
        }),
        DECK_COLOR_COUNT("lblColorCount", DeckProxy.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<DeckProxy>(0, 5){

            @Override
            protected Integer getItemValue(DeckProxy input) {
                return input.getColor().countColors();
            }
        }),
        DECK_AVERAGE_CMC("lblAverageCMC", DeckProxy.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<DeckProxy>(0, 20){

            @Override
            protected Integer getItemValue(DeckProxy input) {
                return input.getAverageCMC();
            }
        }),
        DECK_MAIN("lblMainDeck", DeckProxy.class, FilterOperator.DECK_CONTENT_OPS, new DeckContentEvaluator<DeckProxy>(){

            @Override
            protected Map<String, Integer> getItemValue(DeckProxy input) {
                return input.getDeck().getMain().toNameLookup();
            }
        }),
        DECK_SIDEBOARD("lblSideboard", DeckProxy.class, FilterOperator.DECK_CONTENT_OPS, new DeckContentEvaluator<DeckProxy>(){

            @Override
            protected Map<String, Integer> getItemValue(DeckProxy input) {
                CardPool sideboard = input.getDeck().get(DeckSection.Sideboard);
                if (sideboard != null) {
                    return sideboard.toNameLookup();
                }
                return null;
            }
        }),
        DECK_MAIN_SIZE("lblMainDeckSize", DeckProxy.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<DeckProxy>(40, 250){

            @Override
            protected Integer getItemValue(DeckProxy input) {
                return input.getMainSize();
            }
        }),
        DECK_SIDE_SIZE("lblSideboardSize", DeckProxy.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<DeckProxy>(0, 15){

            @Override
            protected Integer getItemValue(DeckProxy input) {
                return Math.max(input.getSideSize(), 0);
            }
        }),
        COMMANDER_NAME("lblName", ConquestCommander.class, FilterOperator.STRING_OPS, new StringEvaluator<ConquestCommander>(){

            @Override
            protected String getItemValue(ConquestCommander input) {
                return input.getName();
            }
        }),
        COMMANDER_ORIGIN("lblOrigin", ConquestCommander.class, FilterOperator.SINGLE_LIST_OPS, new CustomListEvaluator<ConquestCommander, ConquestPlane>(ImmutableList.copyOf(FModel.getPlanes())){

            @Override
            protected ConquestPlane getItemValue(ConquestCommander input) {
                return input.getOriginPlane();
            }
        }),
        COMMANDER_COLOR("lblColor", ConquestCommander.class, FilterOperator.COMBINATION_OPS, new ColorEvaluator<ConquestCommander>(){

            @Override
            protected MagicColor.Color getItemValue(ConquestCommander input) {
                throw new RuntimeException("getItemValues should be called instead");
            }

            @Override
            protected Set<MagicColor.Color> getItemValues(ConquestCommander input) {
                return input.getCard().getRules().getColorIdentity().toEnumSet();
            }
        }),
        COMMANDER_COLOR_COUNT("lblColorCount", ConquestCommander.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<ConquestCommander>(0, 5){

            @Override
            protected Integer getItemValue(ConquestCommander input) {
                return input.getCard().getRules().getColorIdentity().countColors();
            }
        }),
        COMMANDER_DECK_AVERAGE_CMC("lblDeckAverageCMC", ConquestCommander.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<ConquestCommander>(0, 20){

            @Override
            protected Integer getItemValue(ConquestCommander input) {
                return Deck.getAverageCMC(input.getDeck());
            }
        }),
        COMMANDER_DECK_CONTENTS("lblDeckContents", ConquestCommander.class, FilterOperator.DECK_CONTENT_OPS, new DeckContentEvaluator<ConquestCommander>(){

            @Override
            protected Map<String, Integer> getItemValue(ConquestCommander input) {
                return input.getDeck().getMain().toNameLookup();
            }
        }),
        COMMANDER_DECK_SIZE("lblDeckSize", DeckProxy.class, FilterOperator.NUMBER_OPS, new NumericEvaluator<DeckProxy>(40, 250){

            @Override
            protected Integer getItemValue(DeckProxy input) {
                return input.getMainSize();
            }
        });

        private final String name;
        private final Class<? extends InventoryItem> type;
        private final FilterOperator[] operatorOptions;
        private final FilterEvaluator<? extends InventoryItem, ?> evaluator;

        private FilterOption(String name0, Class<? extends InventoryItem> type0, FilterOperator[] operatorOptions0, FilterEvaluator<? extends InventoryItem, ?> evaluator0) {
            this.name = Localizer.getInstance().getMessage(name0, new Object[0]);
            this.type = type0;
            this.operatorOptions = operatorOptions0;
            this.evaluator = evaluator0;
        }

        public String toString() {
            return this.name;
        }
    }
}

