/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import com.google.common.collect.Lists;
import forge.util.TextUtil;
import forge.util.storage.StorageReaderFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SealedTemplate {
    public static final SealedTemplate genericDraftBooster = new SealedTemplate(null, Lists.newArrayList(Pair.of("Common", 10), Pair.of("Uncommon", 3), Pair.of("RareMythic", 1), Pair.of("BasicLand", 1)));
    protected final List<Pair<String, Integer>> slots;
    protected final String name;

    public final String getName() {
        return this.name;
    }

    public final List<Pair<String, Integer>> getSlots() {
        return this.slots;
    }

    public boolean hasSlot(String s2) {
        for (Pair<String, Integer> slot : this.getSlots()) {
            String slotName = slot.getLeft();
            if (!slotName.split("[ :!]")[0].equals(s2)) continue;
            return true;
        }
        return false;
    }

    public final String getEdition() {
        return this.name;
    }

    public SealedTemplate(Iterable<Pair<String, Integer>> itrSlots) {
        this(null, itrSlots);
    }

    public SealedTemplate(String name0, Iterable<Pair<String, Integer>> itrSlots) {
        this.slots = Lists.newArrayList(itrSlots);
        this.name = name0;
    }

    public SealedTemplate(String code, String boosterDesc) {
        this(code, Reader.parseSlots(boosterDesc));
    }

    public int getNumberOfCardsExpected() {
        int sum = 0;
        for (Pair<String, Integer> p : this.slots) {
            sum += p.getRight().intValue();
        }
        return sum;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("consisting of ");
        for (Pair<String, Integer> p : this.slots) {
            s2.append(p.getRight()).append(" ").append(p.getLeft()).append(", ");
        }
        s2.replace(s2.length() - 2, s2.length(), "");
        int lastCommaIdx = s2.lastIndexOf(",");
        if (0 < lastCommaIdx) {
            s2.replace(lastCommaIdx + 1, lastCommaIdx + 1, " and");
        }
        return s2.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SealedTemplate template = (SealedTemplate)o;
        return this.slots.equals(template.slots) && this.name.equals(template.name);
    }

    public int hashCode() {
        int result = this.slots.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public static final class Reader
    extends StorageReaderFile<SealedTemplate> {
        public Reader(File file) {
            super(file, SealedTemplate::getName);
        }

        public static List<Pair<String, Integer>> parseSlots(String data) {
            String[] dataz = TextUtil.splitWithParenthesis(data, ',');
            ArrayList<Pair<String, Integer>> slots = new ArrayList<Pair<String, Integer>>();
            for (String slotDesc : dataz) {
                String[] kv = TextUtil.splitWithParenthesis(slotDesc, ' ', 2);
                slots.add(ImmutablePair.of(kv[1].replace(";", ","), Integer.parseInt(kv[0])));
            }
            return slots;
        }

        @Override
        protected SealedTemplate read(String line, int i) {
            String[] headAndData = TextUtil.split(line, ':', 2);
            return new SealedTemplate(headAndData[0], Reader.parseSlots(headAndData[1]));
        }
    }
}

