/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.ICardFace;
import forge.item.IPaperCard;
import forge.item.InventoryItemFromSet;
import forge.util.CardTranslation;
import forge.util.ImageUtil;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.lang3.StringUtils;

public class PaperCard
implements Comparable<IPaperCard>,
InventoryItemFromSet,
IPaperCard {
    private static final long serialVersionUID = 2942081982620691205L;
    private transient CardRules rules;
    private final String name;
    private final String edition;
    private String collectorNumber;
    private String artist;
    private final int artIndex;
    private final boolean foil;
    private Boolean hasImage;
    private String sortableName;
    private final String functionalVariant;
    private transient CardRarity rarity;
    private transient PaperCard foiledVersion;
    public static PaperCard FAKE_CARD = new PaperCard(CardRules.getUnsupportedCardNamed("Fake Card"), "Fake Edition", CardRarity.Common);
    private String sortableCNKey = null;
    private String cardImageKey = null;
    private String cardAltImageKey = null;
    private String cardWSpecImageKey = null;
    private String cardUSpecImageKey = null;
    private String cardBSpecImageKey = null;
    private String cardRSpecImageKey = null;
    private String cardGSpecImageKey = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEdition() {
        return this.edition;
    }

    @Override
    public String getCollectorNumber() {
        if (this.collectorNumber == null) {
            this.collectorNumber = "N.A.";
        }
        return this.collectorNumber;
    }

    @Override
    public String getFunctionalVariant() {
        return this.functionalVariant;
    }

    @Override
    public int getArtIndex() {
        return this.artIndex;
    }

    @Override
    public boolean isFoil() {
        return this.foil;
    }

    @Override
    public boolean isToken() {
        return false;
    }

    @Override
    public CardRules getRules() {
        return this.rules;
    }

    @Override
    public CardRarity getRarity() {
        return this.rarity;
    }

    @Override
    public String getArtist() {
        if (this.artist == null) {
            this.artist = "";
        }
        return this.artist;
    }

    public PaperCard getFoiled() {
        if (this.foil) {
            return this;
        }
        if (this.foiledVersion == null) {
            this.foiledVersion = new PaperCard(this.rules, this.edition, this.rarity, this.artIndex, true, String.valueOf(this.collectorNumber), this.artist, this.functionalVariant);
        }
        return this.foiledVersion;
    }

    public PaperCard getUnFoiled() {
        if (!this.foil) {
            return this;
        }
        PaperCard unFoiledVersion = new PaperCard(this.rules, this.edition, this.rarity, this.artIndex, false, String.valueOf(this.collectorNumber), this.artist, this.functionalVariant);
        return unFoiledVersion;
    }

    @Override
    public String getItemType() {
        Localizer localizer = Localizer.getInstance();
        return localizer.getMessage("lblCard", new Object[0]);
    }

    public boolean hasImage() {
        return this.hasImage(false);
    }

    public boolean hasImage(boolean update) {
        if (this.hasImage == null || update) {
            this.hasImage = ImageKeys.hasImage(this, update);
        }
        return this.hasImage;
    }

    public PaperCard(CardRules rules0, String edition0, CardRarity rarity0) {
        this(rules0, edition0, rarity0, 1, false, "N.A.", "", "");
    }

    public PaperCard(CardRules rules0, String edition0, CardRarity rarity0, int artIndex0, boolean foil0, String collectorNumber0, String artist0, String functionalVariant) {
        if (rules0 == null || edition0 == null || rarity0 == null) {
            throw new IllegalArgumentException("Cannot create card without rules, edition or rarity");
        }
        this.rules = rules0;
        this.name = rules0.getName();
        this.edition = edition0;
        this.artIndex = Math.max(artIndex0, 1);
        this.foil = foil0;
        this.rarity = rarity0;
        this.artist = TextUtil.normalizeText(artist0);
        this.collectorNumber = collectorNumber0 != null && collectorNumber0.length() > 0 ? collectorNumber0 : "N.A.";
        this.sortableName = TextUtil.toSortableName(CardTranslation.getTranslatedName(rules0.getName()));
        this.functionalVariant = functionalVariant != null ? functionalVariant : "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaperCard other = (PaperCard)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.edition.equals(other.edition)) {
            return false;
        }
        if (!this.getCollectorNumber().equals(other.getCollectorNumber())) {
            return false;
        }
        return other.foil == this.foil && other.artIndex == this.artIndex;
    }

    public int hashCode() {
        int code = this.name.hashCode() * 11 + this.edition.hashCode() * 59 + this.artIndex * 2 + this.getCollectorNumber().hashCode() * 383;
        if (this.foil) {
            return code + 1;
        }
        return code;
    }

    public String toString() {
        return CardTranslation.getTranslatedName(this.name);
    }

    public String getCardName() {
        return this.name;
    }

    private static String makeCollectorNumberSortingKey(String collectorNumber0) {
        String collectorNumber = collectorNumber0;
        if (collectorNumber.equals("N.A.")) {
            collectorNumber = null;
        }
        return CardEdition.CardInSet.getSortableCollectorNumber(collectorNumber);
    }

    public String getCollectorNumberSortingKey() {
        if (this.sortableCNKey == null) {
            this.sortableCNKey = PaperCard.makeCollectorNumberSortingKey(this.getCollectorNumber());
        }
        return this.sortableCNKey;
    }

    @Override
    public int compareTo(IPaperCard o) {
        String othrCollNrKey;
        int nameCmp = this.name.compareToIgnoreCase(o.getName());
        if (0 != nameCmp) {
            return nameCmp;
        }
        int setDiff = this.edition.compareTo(o.getEdition());
        if (0 != setDiff) {
            return setDiff;
        }
        String thisCollNrKey = this.getCollectorNumberSortingKey();
        int collNrCmp = thisCollNrKey.compareTo(othrCollNrKey = PaperCard.makeCollectorNumberSortingKey(o.getCollectorNumber()));
        if (0 != collNrCmp) {
            return collNrCmp;
        }
        return Integer.compare(this.artIndex, o.getArtIndex());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        PaperCard pc = StaticData.instance().getCommonCards().getCard(this.name, this.edition, this.artIndex);
        if (pc == null && (pc = StaticData.instance().getVariantCards().getCard(this.name, this.edition, this.artIndex)) == null) {
            throw new IOException(TextUtil.concatWithSpace("Card", this.name, "not found"));
        }
        this.rules = pc.getRules();
        this.rarity = pc.getRarity();
    }

    @Override
    public String getImageKey(boolean altState) {
        String noramlizedName = StringUtils.stripAccents(this.name);
        String imageKey = "c:" + noramlizedName + '|' + this.edition + '|' + this.artIndex;
        if (altState) {
            imageKey = imageKey + "$alt";
        }
        return imageKey;
    }

    @Override
    public String getCardImageKey() {
        if (this.cardImageKey == null) {
            this.cardImageKey = ImageUtil.getImageKey(this, "", true);
        }
        return this.cardImageKey;
    }

    @Override
    public String getCardAltImageKey() {
        if (this.cardAltImageKey == null) {
            this.cardAltImageKey = this.hasBackFace() ? ImageUtil.getImageKey(this, "back", true) : ImageUtil.getImageKey(this, "", true);
        }
        return this.cardAltImageKey;
    }

    @Override
    public String getCardWSpecImageKey() {
        if (this.cardWSpecImageKey == null) {
            this.cardWSpecImageKey = this.rules.getSplitType() == CardSplitType.Specialize ? ImageUtil.getImageKey(this, "white", true) : ImageUtil.getImageKey(this, "", true);
        }
        return this.cardWSpecImageKey;
    }

    @Override
    public String getCardUSpecImageKey() {
        if (this.cardUSpecImageKey == null) {
            this.cardUSpecImageKey = this.rules.getSplitType() == CardSplitType.Specialize ? ImageUtil.getImageKey(this, "blue", true) : ImageUtil.getImageKey(this, "", true);
        }
        return this.cardUSpecImageKey;
    }

    @Override
    public String getCardBSpecImageKey() {
        if (this.cardBSpecImageKey == null) {
            this.cardBSpecImageKey = this.rules.getSplitType() == CardSplitType.Specialize ? ImageUtil.getImageKey(this, "black", true) : ImageUtil.getImageKey(this, "", true);
        }
        return this.cardBSpecImageKey;
    }

    @Override
    public String getCardRSpecImageKey() {
        if (this.cardRSpecImageKey == null) {
            this.cardRSpecImageKey = this.rules.getSplitType() == CardSplitType.Specialize ? ImageUtil.getImageKey(this, "red", true) : ImageUtil.getImageKey(this, "", true);
        }
        return this.cardRSpecImageKey;
    }

    @Override
    public String getCardGSpecImageKey() {
        if (this.cardGSpecImageKey == null) {
            this.cardGSpecImageKey = this.rules.getSplitType() == CardSplitType.Specialize ? ImageUtil.getImageKey(this, "green", true) : ImageUtil.getImageKey(this, "", true);
        }
        return this.cardGSpecImageKey;
    }

    @Override
    public boolean hasBackFace() {
        CardSplitType cst = this.rules.getSplitType();
        return cst == CardSplitType.Transform || cst == CardSplitType.Flip || cst == CardSplitType.Meld || cst == CardSplitType.Modal;
    }

    @Override
    public ICardFace getMainFace() {
        ICardFace face = this.rules.getMainPart();
        return this.getVariantForFace(face);
    }

    @Override
    public ICardFace getOtherFace() {
        ICardFace face = this.rules.getOtherPart();
        return this.getVariantForFace(face);
    }

    private ICardFace getVariantForFace(ICardFace face) {
        if (!face.hasFunctionalVariants() || this.functionalVariant.equals("")) {
            return face;
        }
        ICardFace variant = face.getFunctionalVariant(this.functionalVariant);
        if (variant == null) {
            System.err.printf("Tried to apply unknown or unsupported variant - Card: \"%s\"; Variant: %s\n", face.getName(), this.functionalVariant);
            return face;
        }
        return variant;
    }

    public boolean isVeryBasicLand() {
        return this.getName().equals("Swamp") || this.getName().equals("Plains") || this.getName().equals("Island") || this.getName().equals("Forest") || this.getName().equals("Mountain");
    }

    public String getSortableName() {
        return this.sortableName;
    }

    public boolean isUnRebalanced() {
        return StaticData.instance().isRebalanced("A-" + this.name);
    }

    @Override
    public boolean isRebalanced() {
        return StaticData.instance().isRebalanced(this.name);
    }
}

