/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardType;
import forge.card.ICardFace;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.util.PredicateCard;
import forge.util.PredicateString;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface IPaperCard
extends InventoryItem,
Serializable {
    public static final String NO_COLLECTOR_NUMBER = "N.A.";
    public static final int DEFAULT_ART_INDEX = 1;
    public static final int NO_ART_INDEX = -1;
    public static final String NO_ARTIST_NAME = "";
    public static final String NO_FUNCTIONAL_VARIANT = "";

    @Override
    public String getName();

    public String getEdition();

    public String getCollectorNumber();

    public String getFunctionalVariant();

    public int getArtIndex();

    public boolean isFoil();

    public boolean isToken();

    public CardRules getRules();

    public CardRarity getRarity();

    public String getArtist();

    @Override
    public String getItemType();

    public boolean hasBackFace();

    public ICardFace getMainFace();

    public ICardFace getOtherFace();

    public String getCardImageKey();

    public String getCardAltImageKey();

    public String getCardWSpecImageKey();

    public String getCardUSpecImageKey();

    public String getCardBSpecImageKey();

    public String getCardRSpecImageKey();

    public String getCardGSpecImageKey();

    public boolean isRebalanced();

    @Override
    default public String getTranslationKey() {
        if (!"".equals(this.getFunctionalVariant())) {
            return this.getName() + " $" + this.getFunctionalVariant();
        }
        return this.getName();
    }

    @Override
    default public String getUntranslatedType() {
        return this.getRules().getType().toString();
    }

    @Override
    default public String getUntranslatedOracle() {
        return this.getRules().getOracleText();
    }

    public static abstract class Predicates {
        public static Predicate<PaperCard> rarity(boolean isEqual, CardRarity value) {
            return new PredicateRarity(value, isEqual);
        }

        public static Predicate<PaperCard> color(boolean isEqual, boolean noColor, byte value) {
            return new PredicateColor(value, noColor, isEqual);
        }

        public static Predicate<PaperCard> printedInSets(String[] sets) {
            return Predicates.printedInSets(Lists.newArrayList(sets), true);
        }

        public static Predicate<PaperCard> printedInSets(List<String> value, boolean shouldContain) {
            if (value == null || value.isEmpty()) {
                return com.google.common.base.Predicates.alwaysTrue();
            }
            return new PredicateSets(value, shouldContain);
        }

        public static Predicate<PaperCard> printedInSet(String value) {
            if (StringUtils.isEmpty(value)) {
                return com.google.common.base.Predicates.alwaysTrue();
            }
            return new PredicateSets(Lists.newArrayList(value), true);
        }

        public static Predicate<PaperCard> name(String what) {
            return new PredicateName(PredicateString.StringOp.EQUALS_IC, what);
        }

        public static Predicate<PaperCard> name(PredicateString.StringOp op, String what) {
            return new PredicateName(op, what);
        }

        public static Predicate<PaperCard> names(List<String> what) {
            return new PredicateNames(what);
        }

        public static PredicateCards cards(List<PaperCard> what) {
            return new PredicateCards(what);
        }

        public static abstract class Presets {
            public static final Predicate<PaperCard> IS_COMMON = Predicates.rarity(true, CardRarity.Common);
            public static final Predicate<PaperCard> IS_UNCOMMON = Predicates.rarity(true, CardRarity.Uncommon);
            public static final Predicate<PaperCard> IS_RARE = Predicates.rarity(true, CardRarity.Rare);
            public static final Predicate<PaperCard> IS_MYTHIC_RARE = Predicates.rarity(true, CardRarity.MythicRare);
            public static final Predicate<PaperCard> IS_RARE_OR_MYTHIC = com.google.common.base.Predicates.or(IS_RARE, IS_MYTHIC_RARE);
            public static final Predicate<PaperCard> IS_SPECIAL = Predicates.rarity(true, CardRarity.Special);
            public static final Predicate<PaperCard> IS_BASIC_LAND = Predicates.rarity(true, CardRarity.BasicLand);
            public static final Predicate<PaperCard> IS_BLACK = Predicates.color(true, false, (byte)4);
            public static final Predicate<PaperCard> IS_BLUE = Predicates.color(true, false, (byte)2);
            public static final Predicate<PaperCard> IS_GREEN = Predicates.color(true, false, (byte)16);
            public static final Predicate<PaperCard> IS_RED = Predicates.color(true, false, (byte)8);
            public static final Predicate<PaperCard> IS_WHITE = Predicates.color(true, false, (byte)1);
            public static final Predicate<PaperCard> IS_COLORLESS = Predicates.color(true, true, (byte)0);
            public static final Predicate<PaperCard> IS_UNREBALANCED = PaperCard::isUnRebalanced;
            public static final Predicate<PaperCard> IS_REBALANCED = PaperCard::isRebalanced;
        }

        private static final class PredicateCards
        extends PredicateCard<PaperCard> {
            private final List<PaperCard> operand;

            @Override
            public boolean apply(PaperCard card) {
                for (PaperCard element : this.operand) {
                    if (!this.op(card, element)) continue;
                    return true;
                }
                return false;
            }

            private PredicateCards(List<PaperCard> operand) {
                super(PredicateCard.StringOp.EQUALS);
                this.operand = operand;
            }
        }

        private static final class PredicateNames
        extends PredicateString<PaperCard> {
            private final List<String> operand;

            @Override
            public boolean apply(PaperCard card) {
                String cardName = card.getName();
                for (String element : this.operand) {
                    if (!this.op(cardName, element)) continue;
                    return true;
                }
                return false;
            }

            private PredicateNames(List<String> operand) {
                super(PredicateString.StringOp.EQUALS);
                this.operand = operand;
            }
        }

        private static final class PredicateName
        extends PredicateString<PaperCard> {
            private final String operand;

            @Override
            public boolean apply(PaperCard card) {
                return this.op(card.getName(), this.operand);
            }

            private PredicateName(PredicateString.StringOp operator, String operand) {
                super(operator);
                this.operand = operand;
            }
        }

        private static final class PredicateSets
        implements Predicate<PaperCard> {
            private final Set<String> sets;
            private final boolean mustContain;

            @Override
            public boolean apply(PaperCard card) {
                return this.sets.contains(card.getEdition()) == this.mustContain;
            }

            private PredicateSets(List<String> wantSets, boolean shouldContain) {
                this.sets = new HashSet<String>(wantSets);
                this.mustContain = shouldContain;
            }
        }

        private static final class PredicateRarity
        implements Predicate<PaperCard> {
            private final CardRarity operand;
            private final boolean shouldBeEqual;

            @Override
            public boolean apply(PaperCard card) {
                return card.getRarity() == this.operand == this.shouldBeEqual;
            }

            private PredicateRarity(CardRarity type, boolean wantEqual) {
                this.operand = type;
                this.shouldBeEqual = wantEqual;
            }
        }

        private static final class PredicateColor
        implements Predicate<PaperCard> {
            private final byte operand;
            private final boolean noColor;
            private final boolean shouldBeEqual;

            private PredicateColor(byte color, boolean noColor, boolean wantEqual) {
                this.operand = color;
                this.noColor = noColor;
                this.shouldBeEqual = wantEqual;
            }

            @Override
            public boolean apply(PaperCard card) {
                boolean colorFound = false;
                if (this.noColor) {
                    return card.getRules().getColor().isColorless() == this.shouldBeEqual;
                }
                for (byte color : card.getRules().getColor()) {
                    if (color != this.operand) continue;
                    colorFound = true;
                    break;
                }
                if (card.getRules().getType().hasType(CardType.CoreType.Land)) {
                    for (byte color : card.getRules().getColorIdentity()) {
                        if (color != this.operand) continue;
                        colorFound = true;
                        break;
                    }
                }
                return colorFound == this.shouldBeEqual;
            }
        }
    }
}

