/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import forge.item.PaperCard;
import forge.item.SealedProduct;
import forge.item.SealedTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BoxedProduct
extends SealedProduct {
    private List<List<PaperCard>> boosterPacks = new ArrayList<List<PaperCard>>();
    private int currentPack;
    private int numberOfPacks;

    public BoxedProduct(String name0, SealedTemplate boosterData, int numberOfPacks) {
        super(name0, boosterData);
        this.numberOfPacks = numberOfPacks;
    }

    public int boosterPacksRemaining() {
        return this.numberOfPacks - this.currentPack;
    }

    public final List<PaperCard> getNextBoosterPack() {
        if (this.boosterPacks.size() == 0) {
            this.cards = new ArrayList();
            for (int i = 0; i < this.numberOfPacks; ++i) {
                this.boosterPacks.add(this.generate());
                this.cards.addAll((Collection)this.boosterPacks.get(i));
            }
        }
        return this.boosterPacks.get(this.currentPack++);
    }

    @Override
    public List<PaperCard> getCards() {
        if (this.boosterPacks.size() == 0) {
            this.cards = new ArrayList();
            for (int i = 0; i < this.numberOfPacks; ++i) {
                this.boosterPacks.add(this.generate());
                this.cards.addAll((Collection)this.boosterPacks.get(i));
            }
        }
        this.cards.addAll(this.getExtraCards());
        return this.cards;
    }

    public List<PaperCard> getExtraCards() {
        return new ArrayList<PaperCard>();
    }

    @Override
    public int getTotalCards() {
        return this.contents.getNumberOfCardsExpected() * this.numberOfPacks;
    }
}

