/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import com.google.common.collect.ImmutableList;
import forge.StaticData;
import forge.card.CardEdition;
import forge.item.SealedProduct;
import forge.item.SealedTemplate;
import forge.util.MyRandom;
import org.apache.commons.lang3.tuple.Pair;

public class BoosterPack
extends SealedProduct {
    private final int artIndex;
    private final int hash;

    public static BoosterPack fromSet(CardEdition edition) {
        String boosterKind = edition.getRandomBoosterKind();
        if (boosterKind == null) {
            return null;
        }
        SealedTemplate d = edition.getBoosterTemplate(boosterKind);
        StringBuilder sb = new StringBuilder(edition.getName());
        sb.append(" ").append(boosterKind);
        return new BoosterPack(sb.toString(), d);
    }

    public static BoosterPack fromColor(String color) {
        return new BoosterPack(color, new SealedTemplate("?", ImmutableList.of(Pair.of("Common:color(\"" + color + "\"):!" + "Land", 11), Pair.of("Uncommon:color(\"" + color + "\"):!" + "Land", 3), Pair.of("RareMythic:color(\"" + color + "\"):!" + "Land", 1), Pair.of("Land:color(\"" + color + "\")", 1))));
    }

    public BoosterPack(String name0, SealedTemplate boosterData) {
        super(name0, boosterData);
        if (specialSets.contains(boosterData.getEdition()) || boosterData.getEdition().equals("?")) {
            this.artIndex = 1;
        } else {
            int maxIdx = StaticData.instance().getEditions().get(boosterData.getEdition()).getCntBoosterPictures();
            this.artIndex = MyRandom.getRandom().nextInt(maxIdx) + 1;
        }
        this.hash = super.hashCode() ^ this.artIndex;
    }

    public final int getArtIndex() {
        return this.artIndex;
    }

    @Override
    public final String getItemType() {
        return "Booster Pack";
    }

    @Override
    public String getDescription() {
        if (specialSets.contains(this.getEdition()) || this.getEdition().equals("?")) {
            String color = this.getName().substring(0, this.getName().indexOf(this.getItemType()) - 1).toLowerCase();
            return "11 " + color + " commons, 3 " + color + " uncommons, 1 " + color + " rare, and 1 " + color + " land.";
        }
        return super.getDescription();
    }

    public final Object clone() {
        return new BoosterPack(this.name, this.contents);
    }

    public SealedTemplate getBoosterData() {
        return this.contents;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BoosterPack other = (BoosterPack)o;
        return this.artIndex == other.artIndex;
    }

    @Override
    public final int hashCode() {
        return this.hash;
    }

    @Override
    public String getImageKey(boolean altState) {
        String edition = this.getEdition();
        if (SealedProduct.specialSets.contains(edition) || edition.equals("?")) {
            return "b:" + this.getName().substring(0, this.getName().indexOf(this.getItemType()) - 1);
        }
        int cntPics = StaticData.instance().getEditions().get(edition).getCntBoosterPictures();
        String suffix = 1 >= cntPics ? "" : "_" + this.artIndex;
        return "b:" + edition + suffix;
    }
}

