/*
 * Decompiled with CFR 0.152.
 */
package forge.item;

import forge.StaticData;
import forge.card.CardEdition;
import forge.item.BoxedProduct;
import forge.item.SealedTemplate;
import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;

public class BoosterBox
extends BoxedProduct {
    private final Template fpData;

    public static BoosterBox fromSet(CardEdition edition) {
        if (edition.getBoosterBoxCount() <= 0) {
            return null;
        }
        Template d = new Template(edition);
        return new BoosterBox(edition.getName(), d, d.cntBoosters);
    }

    public BoosterBox(String name0, Template fpData0, int boosterCount) {
        super(name0, StaticData.instance().getBoosters().get(fpData0.getEdition()), boosterCount);
        this.fpData = fpData0;
    }

    @Override
    public String getDescription() {
        return this.fpData.toString() + this.contents.toString();
    }

    @Override
    public final String getItemType() {
        return "Booster Box";
    }

    public final Object clone() {
        return new BoosterBox(this.name, this.fpData, this.fpData.cntBoosters);
    }

    @Override
    public int getTotalCards() {
        return super.getTotalCards() * this.fpData.getCntBoosters() + this.fpData.getNumberOfCardsExpected();
    }

    @Override
    public String getImageKey(boolean altState) {
        return "x:" + this.getEdition();
    }

    public static class Template
    extends SealedTemplate {
        private final int cntBoosters;

        public int getCntBoosters() {
            return this.cntBoosters;
        }

        private Template(CardEdition edition) {
            super(edition.getCode(), new ArrayList<Pair<String, Integer>>());
            this.cntBoosters = edition.getBoosterBoxCount();
        }

        @Override
        public String toString() {
            if (0 >= this.cntBoosters) {
                return "no cards";
            }
            StringBuilder s2 = new StringBuilder();
            for (Pair p : this.slots) {
                s2.append(p.getRight()).append(" ").append((String)p.getLeft()).append(", ");
            }
            if (s2.length() > 0) {
                s2.replace(s2.length() - 2, s2.length(), "");
            }
            if (0 < this.cntBoosters) {
                if (s2.length() > 0) {
                    s2.append(" and ");
                }
                s2.append(this.cntBoosters).append(" booster packs ");
            }
            return s2.toString();
        }
    }
}

