/*
 * Decompiled with CFR 0.152.
 */
package forge.gui.util;

import com.google.common.collect.ImmutableList;
import forge.gui.GuiBase;
import forge.localinstance.skin.FSkinProp;
import forge.util.Localizer;
import java.util.List;

public class SOptionPane {
    public static final FSkinProp QUESTION_ICON = FSkinProp.ICO_QUESTION;
    public static final FSkinProp INFORMATION_ICON = FSkinProp.ICO_INFORMATION;
    public static final FSkinProp WARNING_ICON = FSkinProp.ICO_WARNING;
    public static final FSkinProp ERROR_ICON = FSkinProp.ICO_ERROR;

    public static void showMessageDialog(String message) {
        SOptionPane.showMessageDialog(message, "Forge", INFORMATION_ICON);
    }

    public static void showMessageDialog(String message, String title) {
        SOptionPane.showMessageDialog(message, title, INFORMATION_ICON);
    }

    public static void showErrorDialog(String message) {
        SOptionPane.showMessageDialog(message, "Forge", ERROR_ICON);
    }

    public static void showErrorDialog(String message, String title) {
        SOptionPane.showMessageDialog(message, title, ERROR_ICON);
    }

    public static void showMessageDialog(String message, String title, FSkinProp icon) {
        SOptionPane.showOptionDialog(message, title, icon, ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0])), 0);
    }

    public static boolean showConfirmDialog(String message) {
        return SOptionPane.showConfirmDialog(message, "Forge");
    }

    public static boolean showConfirmDialog(String message, String title) {
        return SOptionPane.showConfirmDialog(message, title, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), true);
    }

    public static boolean showConfirmDialog(String message, String title, boolean defaultYes) {
        return SOptionPane.showConfirmDialog(message, title, Localizer.getInstance().getMessage("lblYes", new Object[0]), Localizer.getInstance().getMessage("lblNo", new Object[0]), defaultYes);
    }

    public static boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText) {
        return SOptionPane.showConfirmDialog(message, title, yesButtonText, noButtonText, true);
    }

    public static boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes) {
        return SOptionPane.showConfirmDialog(message, title, yesButtonText, noButtonText, defaultYes, false);
    }

    public static boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes, boolean noicon) {
        ImmutableList<String> options = ImmutableList.of(yesButtonText, noButtonText);
        int reply = SOptionPane.showOptionDialog(message, title, noicon ? null : QUESTION_ICON, options, defaultYes ? 0 : 1);
        return reply == 0;
    }

    public static int showOptionDialog(String message, String title, FSkinProp icon, List<String> options) {
        return SOptionPane.showOptionDialog(message, title, icon, options, 0);
    }

    public static int showOptionDialog(String message, String title, FSkinProp icon, List<String> options, int defaultOption) {
        return GuiBase.getInterface().showOptionDialog(message, title, icon, options, defaultOption);
    }

    public static String showInputDialog(String message, String title) {
        return SOptionPane.showInputDialog(message, title, null, "", null, false);
    }

    public static String showInputDialog(String message, String title, FSkinProp icon) {
        return SOptionPane.showInputDialog(message, title, icon, "", null, false);
    }

    public static String showInputDialog(String message, String title, FSkinProp icon, String initialInput) {
        return SOptionPane.showInputDialog(message, title, icon, initialInput, null, false);
    }

    public static String showInputDialog(String message, String title, FSkinProp icon, String initialInput, List<String> inputOptions, boolean isNumeric) {
        return GuiBase.getInterface().showInputDialog(message, title, icon, initialInput, inputOptions, isNumeric);
    }

    private SOptionPane() {
    }
}

